/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.accessibility;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.element.SliderElement;
import iskallia.vault.client.gui.framework.element.ToggleButtonElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutStrategy;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.overlay.VaultMapOverlay;
import iskallia.vault.client.gui.screen.accessibility.MinimapPositionEditScreen;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.util.GuiHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class MapOptionsSubmenu
extends AbstractElementScreen {
    private final Screen lastScreen;
    private final IVaultOptions options;
    private final GuiHelper guiHelper;

    public MapOptionsSubmenu(Screen lastScreen) {
        super((Component)new TextComponent("Map Options"), ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        Window window = Minecraft.m_91087_().m_91268_();
        this.setGuiSize(Spatials.size(window.m_85445_(), window.m_85446_()));
        this.lastScreen = lastScreen;
        this.options = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        this.guiHelper = new GuiHelper(this);
        this.initializeElements();
    }

    private void initializeElements() {
        int padding = 4;
        int widgetWidth = 150;
        int widgetHeight = 20;
        int startX = 0;
        int startY = 0;
        int x = startX;
        int y = startY;
        this.addElement((ToggleButtonElement)this.guiHelper.createToggleButton(x, y, widgetWidth, widgetHeight, "Mini Map", () -> this.options.getMapVisibilityOption().getSerializedNameUpper(), this.options::cycleMapVisibilityOption).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)this.guiHelper.createToggleButton(x += widgetWidth + padding, y, widgetWidth, widgetHeight, "Overlay Style", () -> this.options.isToggleMapOverlay() ? "Toggle" : "Hold", () -> {
            this.options.setToggleMapOverlay(!this.options.isToggleMapOverlay());
            VaultMapOverlay.showLargeOverlay = false;
        }).layout(this.translateWorldSpatial()));
        x = startX;
        y += widgetHeight + padding;
        this.addElement((SliderElement)new SliderElement(Spatials.positionXY(x, y).size(widgetWidth, widgetHeight), () -> new TextComponent("Overlay Opacity"), this.options::getMapOverlayOpacity, this.options::setMapOverlayOpacity).layout(this.translateWorldSpatial()));
        this.addElement(this.guiHelper.createSimpleButton(x += widgetWidth + padding, y, widgetWidth, widgetHeight, "Map Positions", () -> Minecraft.m_91087_().m_91152_((Screen)new MinimapPositionEditScreen(this)), null, null, null, this.translateWorldSpatial()));
        x = startX;
        this.addElement((SliderElement)new SliderElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), () -> new TextComponent(String.format("Minimap Scale: %d%%", (int)(this.options.getMapScale() * 100.0f))), () -> Float.valueOf((this.options.getMapScale() - 0.25f) / 1.75f), val -> this.options.setMapScale(0.25f + val.floatValue() * 1.75f)).hidePercentage(true).layout(this.translateWorldSpatial()));
        SliderElement sliderElement = this.addElement((SliderElement)new SliderElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), () -> new TextComponent(String.format("Map Zoom: %d%%", (int)(this.options.getMapZoom() * 100.0f))), () -> Float.valueOf((this.options.getMapZoom() - 0.75f) / 1.25f), val -> this.options.setMapZoom(0.75f + val.floatValue() * 1.25f)).hidePercentage(true).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)this.guiHelper.createToggleButton(x, y += widgetHeight + padding, widgetWidth, widgetHeight, "Map Overlay Scale", () -> this.options.getMapOverlayScale().getSerializedName(), this.options::cycleMapOverlayScale).layout(this.translateWorldSpatial()));
        x = startX + widgetWidth / 2;
        this.addElement(this.guiHelper.createSimpleButton(x, y += widgetHeight + padding, widgetWidth, widgetHeight, "Back", () -> this.f_96541_.m_91152_(this.lastScreen), null, null, null, this.translateWorldSpatial()));
    }

    @Override
    @NotNull
    protected ILayoutStrategy translateWorldSpatial() {
        return (screen, gui, parent, world) -> world.translateXY(screen.width() / 2 - 150, 36);
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            this.m_7333_(poseStack);
        } else {
            this.m_96626_(0);
        }
        MapOptionsSubmenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderBackgroundFill(@NotNull PoseStack poseStack) {
    }

    public void m_96626_(int pVOffset) {
        super.m_96626_(pVOffset);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93096_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_5483_(0.0, (double)this.f_96544_ - 32.0, 0.0).m_7421_(0.0f, (float)this.f_96544_ / 32.0f + (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)this.f_96544_ - 32.0, 0.0).m_7421_((float)this.f_96543_ / 32.0f, (float)this.f_96544_ / 32.0f + (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 32.0, 0.0).m_7421_((float)this.f_96543_ / 32.0f, (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, 32.0, 0.0).m_7421_(0.0f, (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_5483_(0.0, 36.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 36.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 32.0, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, 32.0, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, (double)(this.f_96544_ - 32), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)(this.f_96544_ - 32), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)(this.f_96544_ - 36), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_(0.0, (double)(this.f_96544_ - 36), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        tesselator.m_85914_();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }
}

