/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.accessibility;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.render.HudPosition;
import iskallia.vault.client.render.IVaultOptions;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class MinimapPositionEditScreen
extends Screen {
    private final Screen parent;
    private IVaultOptions vaultOptions;
    private int offsetX;
    private int offsetY;
    private int overlayOffsetX;
    private int overlayOffsetY;
    private NineSliceElement<?> minimapBg;
    private String dragging = null;

    public MinimapPositionEditScreen(Screen parent) {
        super(Component.m_130674_((String)"Edit Minimap Position"));
        this.parent = parent;
        this.minimapBg = new NineSliceElement(Spatials.positionXY(0, 0).size(62, 62), ScreenTextures.INSET_DARK_GREY_BACKGROUND);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.vaultOptions = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 160, 10, 50, 20, Component.m_130674_((String)"Done"), btn -> Minecraft.m_91087_().m_91152_(this.parent)));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 120, 10, 50, 20, Component.m_130674_((String)"Reset"), btn -> {
            this.vaultOptions.setMinimapPosition(this.computeDefaultMinimapPosition());
            this.vaultOptions.setMapOverlayPosition(this.computeDefaultOverlayPosition());
        }));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        HudPosition saved = this.vaultOptions.getMinimapPosition();
        poseStack.m_85836_();
        poseStack.m_85837_((double)saved.getScaledX(this.f_96543_), (double)saved.getScaledY(this.f_96544_), 0.0);
        this.minimapBg.render(ScreenRenderers.getImmediate(), poseStack, mouseX, mouseY, partialTicks);
        poseStack.m_85849_();
        HudPosition overlayPos = this.vaultOptions.mapOverlayPosition();
        this.renderOverlayButton(poseStack, overlayPos.getScaledX(this.f_96543_), overlayPos.getScaledY(this.f_96544_));
    }

    private void renderOverlayButton(PoseStack poseStack, int x, int y) {
        int width = 48;
        int height = 16;
        int buttonX = x - width / 2;
        int buttonY = y - height / 2;
        MinimapPositionEditScreen.m_93172_((PoseStack)poseStack, (int)(buttonX - 1), (int)(buttonY - 1), (int)(buttonX + width + 1), (int)(buttonY + height + 1), (int)-16777216);
        MinimapPositionEditScreen.m_93172_((PoseStack)poseStack, (int)buttonX, (int)buttonY, (int)(buttonX + width), (int)(buttonY + height), (int)-11890524);
        Font font = Minecraft.m_91087_().f_91062_;
        String text = "Overlay";
        int textWidth = font.m_92895_(text);
        int textX = buttonX + (width - textWidth) / 2;
        Objects.requireNonNull(font);
        int textY = buttonY + (height - 9) / 2 + 1;
        font.m_92750_(poseStack, text, (float)textX, (float)textY, -1);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        HudPosition pos = this.vaultOptions.getMinimapPosition();
        int posX = pos.getScaledX(this.f_96543_);
        int posY = pos.getScaledY(this.f_96544_);
        if (mouseX >= (double)posX && mouseX < (double)(posX + 62) && mouseY >= (double)posY && mouseY < (double)(posY + 62)) {
            this.offsetX = (int)mouseX - posX;
            this.offsetY = (int)mouseY - posY;
            this.dragging = "minimap";
            return true;
        }
        HudPosition overlayPos = this.vaultOptions.mapOverlayPosition();
        int buttonWidth = 48;
        int buttonHeight = 16;
        int overlayX = overlayPos.getScaledX(this.f_96543_);
        int overlayY = overlayPos.getScaledY(this.f_96544_);
        int buttonX = overlayX - buttonWidth / 2;
        int buttonY = overlayY - buttonHeight / 2;
        if (mouseX >= (double)buttonX && mouseX < (double)(buttonX + buttonWidth) && mouseY >= (double)buttonY && mouseY < (double)(buttonY + buttonHeight)) {
            this.overlayOffsetX = (int)mouseX - overlayX;
            this.overlayOffsetY = (int)mouseY - overlayY;
            this.dragging = "overlay";
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (Objects.equals(this.dragging, "minimap")) {
            int newX = (int)(mouseX - (double)this.offsetX);
            int newY = (int)(mouseY - (double)this.offsetY);
            this.vaultOptions.setMinimapPosition(HudPosition.fromPixels(newX, newY, this.f_96543_, this.f_96544_));
            return true;
        }
        if (Objects.equals(this.dragging, "overlay")) {
            int newX = (int)(mouseX - (double)this.overlayOffsetX);
            int newY = (int)(mouseY - (double)this.overlayOffsetY);
            this.vaultOptions.setMapOverlayPosition(HudPosition.fromPixels(newX, newY, this.f_96543_, this.f_96544_));
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.dragging = null;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private HudPosition computeDefaultMinimapPosition() {
        return HudPosition.fromPixels(10, 10, this.f_96543_, this.f_96544_);
    }

    private HudPosition computeDefaultOverlayPosition() {
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        return HudPosition.fromPixels(screenWidth / 2, screenHeight / 2, screenWidth, screenHeight);
    }

    public boolean m_7043_() {
        return false;
    }
}

