/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.accessibility;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ColorPickerElement;
import iskallia.vault.client.gui.framework.element.NineSliceButtonElement;
import iskallia.vault.client.gui.framework.element.ToggleButtonElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutStrategy;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.screen.accessibility.DamageParticleOptionsSubmenu;
import iskallia.vault.client.gui.screen.accessibility.HealthbarOptionsSubmenu;
import iskallia.vault.client.gui.screen.accessibility.HunterOptionsSubmenu;
import iskallia.vault.client.gui.screen.accessibility.InventoryHudSettingsScreen;
import iskallia.vault.client.gui.screen.accessibility.MapOptionsSubmenu;
import iskallia.vault.client.gui.screen.accessibility.VaultGenericOptionsScreen;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.util.GuiHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class VaultAccessibilityScreen
extends AbstractElementScreen {
    private final Screen lastScreen;
    private final IVaultOptions options;
    private final GuiHelper guiHelper;
    private ColorPickerElement colorPickerElement;
    private NineSliceButtonElement<?> defaultColorButton;
    private ToggleButtonElement hunterTargetButton;

    public VaultAccessibilityScreen(Screen lastScreen) {
        super((Component)new TextComponent("Vault Hunters Accessibility Options"), ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        Window window = Minecraft.m_91087_().m_91268_();
        this.setGuiSize(Spatials.size(window.m_85445_(), window.m_85446_()));
        this.lastScreen = lastScreen;
        this.options = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        this.guiHelper = new GuiHelper(this);
        this.initializeElements();
    }

    private void initializeElements() {
        int padding = 4;
        int widgetWidth = 150;
        int widgetHeight = 20;
        int startX = 0;
        int startY = 16;
        int x = startX;
        int y = startY;
        this.addElement(this.guiHelper.createSimpleButton(x, y, widgetWidth, widgetHeight, "Generic Accessibility", () -> this.f_96541_.m_91152_((Screen)new VaultGenericOptionsScreen(this)), GuiHelper.Tooltips.create("Configure visual and gameplay preferences"), null, ScreenTextures.TAB_ICON_STATISTICS, GuiHelper.Layouts.centeredWithOffset(0, 36 + padding)));
        this.addElement(this.guiHelper.createSimpleButton(x, y += widgetHeight + padding, "Damage Particles", () -> this.f_96541_.m_91152_((Screen)new DamageParticleOptionsSubmenu(this)), null, null, null, GuiHelper.Layouts.centeredWithOffset(0, 36 + padding)));
        this.addElement(this.guiHelper.createSimpleButton(x, y += widgetHeight + padding, "Healthbar", () -> this.f_96541_.m_91152_((Screen)new HealthbarOptionsSubmenu(this)), null, null, null, GuiHelper.Layouts.centeredWithOffset(0, 36 + padding)));
        this.addElement(this.guiHelper.createSimpleButton(x, y += widgetHeight + padding, "Hunter", () -> this.f_96541_.m_91152_((Screen)new HunterOptionsSubmenu(this)), null, null, null, GuiHelper.Layouts.centeredWithOffset(0, 36 + padding)));
        this.addElement(this.guiHelper.createSimpleButton(x, y += widgetHeight + padding, "HUD Settings", () -> this.f_96541_.m_91152_((Screen)new InventoryHudSettingsScreen(this)), null, null, null, GuiHelper.Layouts.centeredWithOffset(0, 36 + padding)));
        this.addElement(this.guiHelper.createSimpleButton(x, y += widgetHeight + padding, "Vault Map", () -> this.f_96541_.m_91152_((Screen)new MapOptionsSubmenu(this)), null, null, ScreenTextures.MAP_ROOM_OMEGA, GuiHelper.Layouts.centeredWithOffset(0, 36 + padding)));
        this.addElement(this.guiHelper.createSimpleButton(x, y += (widgetHeight + padding) * 2, "Done", this::saveAndClose, null, null, null, GuiHelper.Layouts.centeredWithOffset(0, 36 + padding)));
    }

    private void saveAndClose() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    @Override
    @NotNull
    protected ILayoutStrategy translateWorldSpatial() {
        return (screen, gui, parent, world) -> world.translateXY(screen.width() / 2 - 150, 36);
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            this.m_7333_(poseStack);
        } else {
            this.m_96626_(0);
        }
        VaultAccessibilityScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderBackgroundFill(@NotNull PoseStack poseStack) {
    }

    public void m_96626_(int pVOffset) {
        super.m_96626_(pVOffset);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93096_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_5483_(0.0, (double)this.f_96544_ - 32.0, 0.0).m_7421_(0.0f, (float)this.f_96544_ / 32.0f + (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)this.f_96544_ - 32.0, 0.0).m_7421_((float)this.f_96543_ / 32.0f, (float)this.f_96544_ / 32.0f + (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 32.0, 0.0).m_7421_((float)this.f_96543_ / 32.0f, (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, 32.0, 0.0).m_7421_(0.0f, (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_5483_(0.0, 36.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 36.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 32.0, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, 32.0, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, (double)(this.f_96544_ - 32), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)(this.f_96544_ - 32), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)(this.f_96544_ - 36), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_(0.0, (double)(this.f_96544_ - 36), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        tesselator.m_85914_();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }
}

