/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.accessibility;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.element.SliderElement;
import iskallia.vault.client.gui.framework.element.ToggleButtonElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutStrategy;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.init.ModOptions;
import iskallia.vault.util.GuiHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class VaultGenericOptionsScreen
extends AbstractElementScreen {
    private final Screen lastScreen;
    private final IVaultOptions options;
    private final GuiHelper guiHelper;

    public VaultGenericOptionsScreen(Screen lastScreen) {
        super((Component)new TextComponent("Generic Options"), ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        Window window = Minecraft.m_91087_().m_91268_();
        this.setGuiSize(Spatials.size(window.m_85445_(), window.m_85446_()));
        this.lastScreen = lastScreen;
        this.options = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        this.guiHelper = new GuiHelper(this);
        this.initializeElements();
    }

    private void initializeElements() {
        int padding = 4;
        int widgetWidth = 150;
        int widgetHeight = 20;
        int startX = 0;
        int startY = 0;
        int x = startX;
        int y = startY;
        this.addElement((ToggleButtonElement)this.guiHelper.createToggleButton(x, y, widgetWidth, widgetHeight, "Vault Potion Effects", () -> this.options.doVanillaPotionDamageEffects() ? "OFF" : "ON", () -> this.options.setVanillaPotionDamageEffects(!this.options.doVanillaPotionDamageEffects())).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)this.guiHelper.createToggleButton(x += widgetWidth + padding, y, "Show Rarity Names", () -> this.options.showRarityNames() ? "ON" : "OFF", () -> this.options.setShowRarityNames(!this.options.showRarityNames()), GuiHelper.Tooltips.create("Display item rarity names in tooltips")).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)this.guiHelper.createToggleButton(x, y += widgetHeight + padding, widgetWidth, widgetHeight, "Ability Scrolling", () -> this.options.isAbilityScrollingEnabled() ? "ON" : "OFF", () -> this.options.setAbilityScrollingEnabled(!this.options.isAbilityScrollingEnabled())).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)this.guiHelper.createToggleButton(x += widgetWidth + padding, y, widgetWidth, widgetHeight, "Hide Vault Level Bar", () -> this.options.isVaultLevelBarHidden() ? "ON" : "OFF", () -> this.options.setVaultLevelBarHidden(!this.options.isVaultLevelBarHidden())).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((SliderElement)new SliderElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), () -> new TextComponent(String.format("Objective Scale: %d%%", (int)(this.options.getObjectiveScale() * 100.0f))), () -> Float.valueOf((this.options.getObjectiveScale() - 0.5f) / 1.5f), val -> this.options.setObjectiveScale(0.5f + val.floatValue() * 1.5f)).hidePercentage(true).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)this.guiHelper.createToggleButton(x += widgetWidth + padding, y, widgetWidth, widgetHeight, "Show Point Messages", () -> this.options.showPointMessages() ? "ON" : "OFF", () -> this.options.setShowPointMessages(!this.options.showPointMessages())).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)this.guiHelper.createToggleButton(x, y += widgetHeight + padding, widgetWidth, widgetHeight, "Treasure Door Names", () -> this.options.isTreasureDoorNamesEnabled() ? "ON" : "OFF", () -> this.options.setTreasureDoorNamesEnabled(!this.options.isTreasureDoorNamesEnabled())).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)this.guiHelper.createToggleButton(x += widgetWidth + padding, y, widgetWidth, widgetHeight, "Rarity Highlighter", () -> this.options.isHighlightRarityEnabled() ? "Shifting" : "Always on", () -> this.options.setHighlightRarityEnabled(!this.options.isHighlightRarityEnabled())).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)this.guiHelper.createToggleButton(x, y += widgetHeight + padding, "Use Items Overlay", () -> this.options.getShowUsesAsStackSize() ? "ON" : "OFF", this.options::toggleShowUsesAsStackSize).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)this.guiHelper.createToggleButton(x += widgetWidth + padding, y, "Keyring Contents", () -> this.options.getShowKeyringContents() ? "ON" : "OFF", this.options::toggleShowKeyringContents, GuiHelper.Tooltips.create("Display the total number of keys in keyring as stack count")).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)this.guiHelper.createToggleButton(x, y += widgetHeight + padding, widgetWidth, widgetHeight, "Companion Name", () -> this.options.getCompanionNametagMode().getSerializedNameUpper(), this.options::cycleCompanionNametagMode).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)this.guiHelper.createToggleButton(x += widgetWidth + padding, y, widgetWidth, widgetHeight, "Color Blind Mode", () -> String.valueOf((Object)ModOptions.COLOR_BLIND_MODE.getValue()), () -> ModOptions.COLOR_BLIND_MODE.setValue(ModOptions.COLOR_BLIND_MODE.getValue().next())).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)this.guiHelper.createToggleButton(x, y += widgetHeight + padding, "Totem Particles", () -> ModOptions.TOTEM_PARTICLES.getValue() != false ? "ON" : "OFF", () -> ModOptions.TOTEM_PARTICLES.setValue(ModOptions.TOTEM_PARTICLES.getValue() == false), GuiHelper.Tooltips.create("Disable Totem ability particle effects")).layout(this.translateWorldSpatial()));
        x = startX + widgetWidth / 2;
        this.addElement(this.guiHelper.createSimpleButton(x, y += widgetHeight + padding * 2, widgetWidth, widgetHeight, "Done", this::saveAndClose, null, null, null, this.translateWorldSpatial()));
    }

    private void saveAndClose() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    @Override
    @NotNull
    protected ILayoutStrategy translateWorldSpatial() {
        return (screen, gui, parent, world) -> world.translateXY(screen.width() / 2 - 150, 36);
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            this.m_7333_(poseStack);
        } else {
            this.m_96626_(0);
        }
        VaultGenericOptionsScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderBackgroundFill(@NotNull PoseStack poseStack) {
    }

    public void m_96626_(int pVOffset) {
        super.m_96626_(pVOffset);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93096_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_5483_(0.0, (double)this.f_96544_ - 32.0, 0.0).m_7421_(0.0f, (float)this.f_96544_ / 32.0f + (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)this.f_96544_ - 32.0, 0.0).m_7421_((float)this.f_96543_ / 32.0f, (float)this.f_96544_ / 32.0f + (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 32.0, 0.0).m_7421_((float)this.f_96543_ / 32.0f, (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, 32.0, 0.0).m_7421_(0.0f, (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_5483_(0.0, 36.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 36.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 32.0, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, 32.0, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, (double)(this.f_96544_ - 32), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)(this.f_96544_ - 32), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)(this.f_96544_ - 36), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_(0.0, (double)(this.f_96544_ - 36), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        tesselator.m_85914_();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }
}

