/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.accessibility;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.VaultMod;
import iskallia.vault.client.VaultSoundOptions;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceButtonElement;
import iskallia.vault.client.gui.framework.element.SliderElement;
import iskallia.vault.client.gui.framework.element.TextInputElement;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutStrategy;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.init.ModSounds;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.NotNull;

public class VaultSoundOptionsScreen
extends AbstractElementScreen {
    private static final int DEFAULT_ENTRIES_PER_PAGE = 9;
    private final Screen lastScreen;
    private final VaultSoundOptions soundOptions;
    private final List<SoundEntryInfo> allSoundEntries;
    private List<SoundEntryInfo> filteredSoundEntries;
    private TextInputElement<?> searchBox;
    private int currentPage = 0;
    private int totalPages = 1;
    private int entriesPerPage;
    private int controlWidth;
    private int sliderWidth;
    private int entryHeight;
    private int searchBoxHeight;
    private int buttonWidth;
    private int buttonHeight;
    private int padding;

    public VaultSoundOptionsScreen(Screen lastScreen) {
        super((Component)new TextComponent("Vault Sound Options"), ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        Window window = Minecraft.m_91087_().m_91268_();
        this.setGuiSize(Spatials.size(window.m_85445_(), window.m_85446_()));
        this.lastScreen = lastScreen;
        this.soundOptions = VaultSoundOptions.getInstance();
        this.allSoundEntries = this.collectSoundEntries();
        this.filteredSoundEntries = new ArrayList<SoundEntryInfo>(this.allSoundEntries);
        this.calculateSizes();
        this.initializeElements();
    }

    private void calculateSizes() {
        int screenWidth = this.f_96543_;
        int screenHeight = this.f_96544_;
        this.padding = 10;
        this.controlWidth = 280;
        this.sliderWidth = 120;
        this.entryHeight = 24;
        this.searchBoxHeight = 20;
        this.buttonWidth = 80;
        this.buttonHeight = 20;
        Window window = Minecraft.m_91087_().m_91268_();
        double guiScale = window.m_85449_();
        int titleAndSearchHeight = 36 + this.searchBoxHeight + this.padding;
        int paginationAndButtonsHeight = this.buttonHeight * 2 + this.padding * 2;
        int availableHeight = screenHeight - titleAndSearchHeight - paginationAndButtonsHeight - 50;
        this.entriesPerPage = Math.max(9, availableHeight / this.entryHeight);
        if (guiScale > 3.0) {
            this.entriesPerPage = Math.max(5, availableHeight / this.entryHeight);
        }
    }

    private List<SoundEntryInfo> collectSoundEntries() {
        ArrayList<SoundEntryInfo> entries = new ArrayList<SoundEntryInfo>();
        try {
            for (Field field : ModSounds.class.getDeclaredFields()) {
                if (!SoundEvent.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                SoundEvent soundEvent = (SoundEvent)field.get(null);
                if (soundEvent == null || soundEvent.m_11660_().equals((Object)ModSounds.BOSS_FIGHT_1.m_11660_()) || soundEvent.m_11660_().equals((Object)ModSounds.BOSS_FIGHT_2.m_11660_()) || soundEvent.m_11660_().equals((Object)ModSounds.BOSS_FIGHT_3.m_11660_()) || soundEvent.m_11660_().equals((Object)ModSounds.BOSS_FIGHT_4.m_11660_())) continue;
                String displayName = this.formatSoundName(field.getName());
                float volume = this.soundOptions.getVolume(soundEvent);
                entries.add(new SoundEntryInfo(soundEvent, displayName, volume));
            }
        }
        catch (Exception e) {
            VaultMod.LOGGER.error("Failed to get sound entries", (Throwable)e);
        }
        entries.sort(Comparator.comparing(SoundEntryInfo::displayName));
        return entries;
    }

    private String formatSoundName(String fieldName) {
        String[] words = fieldName.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.equals("sfx")) {
                result.append("SFX ");
                continue;
            }
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        this.calculateSizes();
        this.elementStore.removeAllElements();
        this.initializeElements();
    }

    private void initializeElements() {
        int titleHeight;
        int y = titleHeight = 36;
        this.searchBox = (TextInputElement)this.addElement(new TextInputElement(Spatials.positionXY(this.imageWidth / 2 - 100, y).size(200, this.searchBoxHeight), Minecraft.m_91087_().f_91062_).adjustEditBox(editBox -> {
            editBox.m_94199_(50);
            editBox.m_94182_(true);
            editBox.m_94190_(true);
        }));
        this.searchBox.onTextChanged(text -> {
            this.filterSounds((String)text);
            this.refreshControls();
        });
        int paginationY = (y += this.searchBoxHeight + this.padding) + this.entryHeight * this.entriesPerPage + this.padding;
        this.addElement((NineSliceButtonElement)((AbstractSpatialElement)new NineSliceButtonElement(Spatials.positionXY(-50, paginationY).size(this.buttonWidth, this.buttonHeight), ScreenTextures.BUTTON_EMPTY_TEXTURES, this::previousPage).label(() -> new TextComponent("Previous"), LabelTextStyle.shadow().center())).layout(this.translateWorldSpatial()));
        this.addElement((NineSliceButtonElement)((AbstractSpatialElement)new NineSliceButtonElement(Spatials.positionXY(0, paginationY).size(this.buttonWidth, this.buttonHeight), ScreenTextures.BUTTON_EMPTY_TEXTURES, this::nextPage).label(() -> new TextComponent("Next"), LabelTextStyle.shadow().center())).layout(this.getStandardLayout(this.controlWidth / 2 - this.buttonWidth)));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(0, paginationY + 5), () -> new TextComponent("Page " + (this.currentPage + 1) + " of " + this.totalPages), LabelTextStyle.shadow().center()).layout(this.getStandardLayout(0)));
        int controlY = paginationY + this.buttonHeight + this.padding;
        this.addElement((NineSliceButtonElement)((AbstractSpatialElement)new NineSliceButtonElement(Spatials.positionXY(-(this.buttonWidth / 2), controlY).size(this.buttonWidth * 2, this.buttonHeight), ScreenTextures.BUTTON_EMPTY_TEXTURES, this::saveAndClose).label(() -> new TextComponent("Done"), LabelTextStyle.shadow().center())).layout(this.getStandardLayout(0)));
        this.refreshControls();
    }

    private void refreshControls() {
        this.elementStore.removeAllElements();
        this.addElement(this.searchBox);
        this.totalPages = Math.max(1, (int)Math.ceil((double)this.filteredSoundEntries.size() / (double)this.entriesPerPage));
        this.currentPage = Math.min(this.currentPage, this.totalPages - 1);
        int titleHeight = 36;
        int y = titleHeight + this.searchBoxHeight + this.padding;
        int startIndex = this.currentPage * this.entriesPerPage;
        int endIndex = Math.min(startIndex + this.entriesPerPage, this.filteredSoundEntries.size());
        for (int i = startIndex; i < endIndex; ++i) {
            SoundEntryInfo entry = this.filteredSoundEntries.get(i);
            int labelY = y + (i - startIndex) * this.entryHeight;
            this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(-this.controlWidth / 2 + 5, labelY + this.entryHeight / 2 - 4), (Component)new TextComponent(entry.displayName()), LabelTextStyle.shadow().left()).layout(this.getStandardLayout(0)));
            SliderElement slider = new SliderElement(Spatials.positionXY(this.controlWidth / 2 - this.sliderWidth, labelY + 2).size(this.sliderWidth, this.entryHeight - 4), () -> new TextComponent((int)(entry.volume * 100.0f) + "%"), () -> Float.valueOf(entry.volume), volume -> {
                entry.volume = volume.floatValue();
                this.soundOptions.setVolume(entry.soundEvent, volume.floatValue());
            }).hidePercentage(true);
            this.addElement((SliderElement)slider.layout(this.getStandardLayout(0)));
        }
        int paginationY = y + this.entryHeight * this.entriesPerPage + this.padding;
        this.addElement((NineSliceButtonElement)((AbstractSpatialElement)new NineSliceButtonElement(Spatials.positionXY(this.getGuiSpatial().width() / 2 - this.controlWidth / 2 - this.buttonWidth / 2, paginationY).size(this.buttonWidth, this.buttonHeight), ScreenTextures.BUTTON_EMPTY_TEXTURES, this::previousPage).label(() -> new TextComponent("Previous"), LabelTextStyle.shadow().center())).layout(this.translateWorldSpatial()));
        this.addElement((NineSliceButtonElement)((AbstractSpatialElement)new NineSliceButtonElement(Spatials.positionXY(0, paginationY).size(this.buttonWidth, this.buttonHeight), ScreenTextures.BUTTON_EMPTY_TEXTURES, this::nextPage).label(() -> new TextComponent("Next"), LabelTextStyle.shadow().center())).layout(this.getStandardLayout(this.controlWidth / 2 - this.buttonWidth / 2)));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(0, paginationY + 5), () -> new TextComponent("Page " + (this.currentPage + 1) + " of " + this.totalPages), LabelTextStyle.shadow().center()).layout(this.getStandardLayout(0)));
        int controlY = paginationY + this.buttonHeight + this.padding;
        this.addElement((NineSliceButtonElement)((AbstractSpatialElement)new NineSliceButtonElement(Spatials.positionXY(0, controlY).size(this.buttonWidth * 2, this.buttonHeight), ScreenTextures.BUTTON_EMPTY_TEXTURES, this::saveAndClose).label(() -> new TextComponent("Done"), LabelTextStyle.shadow().center())).layout(this.getStandardLayout(-(this.buttonWidth * 2 / 2))));
    }

    private void filterSounds(String filter) {
        if (filter == null || filter.trim().isEmpty()) {
            this.filteredSoundEntries = new ArrayList<SoundEntryInfo>(this.allSoundEntries);
            return;
        }
        String normalizedFilter = filter.toLowerCase().trim();
        this.filteredSoundEntries = this.allSoundEntries.stream().filter(entry -> entry.displayName().toLowerCase().contains(normalizedFilter)).collect(Collectors.toList());
        this.currentPage = 0;
    }

    private void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.refreshControls();
        }
    }

    private void nextPage() {
        if (this.currentPage < this.totalPages - 1) {
            ++this.currentPage;
            this.refreshControls();
        }
    }

    private void playSound(SoundEvent soundEvent) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)soundEvent, (float)1.0f, (float)1.0f));
    }

    private void resetAllVolumes() {
        for (SoundEntryInfo entry : this.allSoundEntries) {
            entry.volume = 1.0f;
            this.soundOptions.setVolume(entry.soundEvent, 1.0f);
        }
        this.refreshControls();
    }

    private void saveAndClose() {
        this.soundOptions.save();
        this.f_96541_.m_91152_(this.lastScreen);
    }

    @NotNull
    private ILayoutStrategy getStandardLayout(int xOffset) {
        return (screen, gui, parent, world) -> world.translateXY(screen.width() / 2 + xOffset, 0);
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            this.m_7333_(poseStack);
        } else {
            this.m_96626_(0);
        }
        VaultSoundOptionsScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        this.searchBox.tickEditBox();
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderBackgroundFill(@NotNull PoseStack poseStack) {
    }

    public void m_96626_(int pVOffset) {
        super.m_96626_(pVOffset);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93096_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_5483_(0.0, (double)this.f_96544_ - 32.0, 0.0).m_7421_(0.0f, (float)this.f_96544_ / 32.0f + (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)this.f_96544_ - 32.0, 0.0).m_7421_((float)this.f_96543_ / 32.0f, (float)this.f_96544_ / 32.0f + (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 32.0, 0.0).m_7421_((float)this.f_96543_ / 32.0f, (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, 32.0, 0.0).m_7421_(0.0f, (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_5483_(0.0, 36.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 36.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 32.0, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, 32.0, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, (double)(this.f_96544_ - 32), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)(this.f_96544_ - 32), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)(this.f_96544_ - 36), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_(0.0, (double)(this.f_96544_ - 36), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        tesselator.m_85914_();
    }

    public void m_7379_() {
        this.soundOptions.save();
        this.f_96541_.m_91152_(this.lastScreen);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    private static class SoundEntryInfo {
        final SoundEvent soundEvent;
        final String displayName;
        float volume;

        SoundEntryInfo(SoundEvent soundEvent, String displayName, float volume) {
            this.soundEvent = soundEvent;
            this.displayName = displayName;
            this.volume = volume;
        }

        public String displayName() {
            return this.displayName;
        }
    }
}

