/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.AlchemyCraftSelectorElement;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.TextInputElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.config.AlchemyTableConfig;
import iskallia.vault.container.AlchemyTableContainer;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.bottle.BottleEffect;
import iskallia.vault.item.bottle.BottleItem;
import iskallia.vault.network.message.AlchemyTableEffectCraftMessage;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.util.function.ObservableSupplier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class AlchemyTableScreen
extends AbstractElementContainerScreen<AlchemyTableContainer> {
    private final Inventory playerInventory;
    private final AlchemyCraftSelectorElement<?, ?> selectorElement;
    private final TextInputElement<?> searchInput;
    private AlchemyCraftSelectorElement.CraftingOption selectedOption;

    public AlchemyTableScreen(AlchemyTableContainer container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.playerInventory = inventory;
        this.setGuiSize(Spatials.size(176, 221));
        this.addElement((NineSliceElement)new NineSliceElement(this.getGuiSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).size(Spatials.copy(gui))));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 7), (Component)((AlchemyTableContainer)this.m_6262_()).getTileEntity().m_5446_().m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        MutableComponent inventoryName = inventory.m_5446_().m_6881_();
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 129), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((SlotsElement)new SlotsElement((MenuAccess<?>)this).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        this.searchInput = (TextInputElement)new TextInputElement(Spatials.positionXY(108, 5).size(60, 12), Minecraft.m_91087_().f_91062_).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        this.addElement(this.searchInput);
        this.selectorElement = (AlchemyCraftSelectorElement)new AlchemyCraftSelectorElement((ISpatial)Spatials.positionXY(7, 19).height(97), ObservableSupplier.ofIdentity(() -> ((AlchemyTableContainer)this.m_6262_()).getInput()), this.searchInput::getInput).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        this.addElement(this.selectorElement);
        ButtonElement craftButton = (ButtonElement)new ButtonElement(Spatials.positionXY(131, 118), ScreenTextures.BUTTON_ALCHEMY_CRAFT_TEXTURES, this::tryCraft).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        this.addElement(craftButton);
        craftButton.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
            if (this.selectedOption == null) {
                return false;
            }
            ItemStack bottle = ((AlchemyTableContainer)this.m_6262_()).getInput();
            if (bottle.m_41619_()) {
                return false;
            }
            List<ItemStack> inputs = this.selectedOption.getCraftingCost(bottle);
            List<ItemStack> missing = InventoryUtil.getMissingInputs(inputs, this.playerInventory);
            if (missing.isEmpty()) {
                ArrayList<Component> tooltip = new ArrayList<Component>();
                tooltip.add(bottle.m_41786_());
                BottleItem.getEffect(bottle).ifPresent(BottleEffect::getTooltip);
                tooltipRenderer.renderComponentTooltip(poseStack, tooltip, mouseX, mouseY, TooltipDirection.RIGHT);
                return true;
            }
            MutableComponent cmp = new TranslatableComponent("the_vault.gear_workbench.missing_inputs").m_130940_(ChatFormatting.RED);
            tooltipRenderer.renderTooltip(poseStack, (Component)cmp, mouseX, mouseY, TooltipDirection.RIGHT);
            return true;
        });
        craftButton.setDisabled(() -> {
            ItemStack potion = ((AlchemyTableContainer)this.m_6262_()).getInput();
            if (potion.m_41619_()) {
                return true;
            }
            if (this.selectedOption != null) {
                List<ItemStack> inputs = this.selectedOption.getCraftingCost(potion);
                List<ItemStack> missing = InventoryUtil.getMissingInputs(inputs, this.playerInventory);
                return !missing.isEmpty();
            }
            return true;
        });
        this.selectorElement.onSelect(option -> {
            this.selectedOption = option;
        });
        this.searchInput.onTextChanged(text -> this.selectorElement.refreshElements());
    }

    private void tryCraft() {
        if (this.selectedOption == null) {
            return;
        }
        ItemStack potion = ((AlchemyTableContainer)this.m_6262_()).getInput();
        if (potion.m_41619_()) {
            return;
        }
        AlchemyTableConfig.CraftableEffectConfig cfg = this.selectedOption.cfg();
        List<ItemStack> inputs = this.selectedOption.getCraftingCost(potion);
        List<ItemStack> missing = InventoryUtil.getMissingInputs(inputs, this.playerInventory);
        if (!missing.isEmpty()) {
            return;
        }
        String craftId = cfg == null ? null : cfg.getEffectId();
        ModNetwork.CHANNEL.sendToServer((Object)new AlchemyTableEffectCraftMessage(((AlchemyTableContainer)this.m_6262_()).getTilePos(), craftId));
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        this.searchInput.tickEditBox();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.searchInput.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            if (!this.searchInput.isFocused()) {
                this.m_7379_();
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchInput.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }
}

