/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.block.entity.CardEssenceExtractorTileEntity;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.ProgressElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextWrap;
import iskallia.vault.config.CardEssenceExtractorConfig;
import iskallia.vault.container.inventory.CardEssenceExtractorContainer;
import iskallia.vault.core.card.Card;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.CardItem;
import iskallia.vault.network.message.CardEssenceExtractorUpgradeCardMessage;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CardEssenceExtractorScreen
extends AbstractElementContainerScreen<CardEssenceExtractorContainer> {
    private final Inventory playerInventory;
    private final LabelTextStyle textStyle;

    public CardEssenceExtractorScreen(CardEssenceExtractorContainer container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.playerInventory = inventory;
        this.setGuiSize(Spatials.size(176, 166));
        this.textStyle = LabelTextStyle.defaultStyle().right().wrap(TextWrap.overflow()).build();
        this.addElement((TextureAtlasElement)new TextureAtlasElement(this.getGuiSpatial(), ScreenTextures.CARD_ESSENCE_EXTRACTOR_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).size(Spatials.copy(gui))));
        this.addElement((TextureAtlasElement)new TextureAtlasElement(Spatials.positionXY(16, 33), ScreenTextures.CARD_ESSENCE_EXTRACTOR_SLOT_HINT).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((TextureAtlasElement)new TextureAtlasElement(Spatials.positionXY(106, 28), ScreenTextures.CARD_ESSENCE_EXTRACTOR_SLOT_HINT).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 5), (Component)((CardEssenceExtractorContainer)this.m_6262_()).getTileEntity().m_58900_().m_60734_().m_49954_().m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 74), (Component)inventory.m_5446_().m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((ProgressElement)new ProgressElement((IPosition)Spatials.positionXY(38, 53), ScreenTextures.CARD_ESSENCE_EXTRACTOR_PROGRESS_INPUT, () -> Float.valueOf(((CardEssenceExtractorContainer)this.m_6262_()).getTileEntity().getExtractProgress())).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        ButtonElement upgradeBtn = this.addElement((ButtonElement)new ButtonElement(Spatials.positionXY(105, 48), ScreenTextures.CARD_ESSENCE_EXTRACTOR_BUTTON_UPGRADE, this::attemptUpgradeCard).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        upgradeBtn.setDisabled(() -> !this.canUpgrade());
        upgradeBtn.tooltip(this::upgradeCardTooltip);
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(106, 53), (ISize)Spatials.size(54, 9), (Component)new TextComponent("Upgrade").m_130940_(ChatFormatting.WHITE).m_130940_(ChatFormatting.BOLD), LabelTextStyle.defaultStyle().center()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
    }

    private boolean upgradeCardTooltip(ITooltipRenderer tooltipRenderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, TooltipFlag tooltipFlag) {
        CardEssenceExtractorTileEntity tile = ((CardEssenceExtractorContainer)this.m_6262_()).getTileEntity();
        if (tile == null || tile.m_58901_()) {
            return false;
        }
        ItemStack upgradeable = tile.getCardUpgradeStack();
        if (upgradeable.m_41619_() || !(upgradeable.m_41720_() instanceof CardItem)) {
            return false;
        }
        Card card = CardItem.getCard(upgradeable);
        int tier = card.getTier();
        CardEssenceExtractorConfig.TierConfig cfg = ModConfigs.CARD_ESSENCE_EXTRACTOR.getConfig(tier).orElse(null);
        if (cfg == null) {
            return false;
        }
        ArrayList<Object> tooltip = new ArrayList<Object>();
        if (card.canUpgrade()) {
            tooltip.add(new TextComponent("Required Essence: ").m_130940_(ChatFormatting.RED).m_7220_((Component)new TextComponent(String.valueOf(cfg.getEssencePerUpgrade())).m_130940_(ChatFormatting.WHITE)));
            tooltip.add(TextComponent.f_131282_);
            ItemStack nextTierCard = new ItemStack((ItemLike)ModItems.CARD);
            Card nextTier = CardItem.getCard(upgradeable);
            nextTier.onUpgrade();
            CardItem.setCard(nextTierCard, nextTier);
            tooltip.addAll(nextTierCard.m_41651_(null, (TooltipFlag)TooltipFlag.Default.NORMAL));
        } else {
            tooltip.add(new TextComponent("Maximum Card tier reached").m_130940_(ChatFormatting.RED));
        }
        return Tooltips.multi(() -> tooltip).onHoverTooltip(tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag);
    }

    private void attemptUpgradeCard() {
        if (!this.canUpgrade()) {
            return;
        }
        ModNetwork.CHANNEL.sendToServer((Object)CardEssenceExtractorUpgradeCardMessage.INSTANCE);
    }

    private boolean canUpgrade() {
        if (!((CardEssenceExtractorContainer)this.m_6262_()).m_6875_(this.playerInventory.f_35978_)) {
            return false;
        }
        CardEssenceExtractorTileEntity tile = ((CardEssenceExtractorContainer)this.m_6262_()).getTileEntity();
        if (tile == null || tile.m_58901_()) {
            return false;
        }
        ItemStack upgradeable = tile.getCardUpgradeStack();
        if (upgradeable.m_41619_() || !(upgradeable.m_41720_() instanceof CardItem)) {
            return false;
        }
        Card card = CardItem.getCard(upgradeable);
        int tier = card.getTier();
        CardEssenceExtractorConfig.TierConfig cfg = ModConfigs.CARD_ESSENCE_EXTRACTOR.getConfig(tier).orElse(null);
        return cfg != null && tile.getEssence() >= cfg.getEssencePerUpgrade() && tile.getCardUpgradeOutputStack().m_41619_() && card.canUpgrade();
    }

    @Override
    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        MutableComponent essenceComponent = new TextComponent(String.valueOf(((CardEssenceExtractorContainer)this.m_6262_()).getTileEntity().getEssence())).m_130940_(ChatFormatting.BLACK);
        int boxWidth = 36;
        int width = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)essenceComponent);
        float scale = Math.min(1.0f, (float)boxWidth / (float)width);
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.getGuiSpatial().x(), (double)this.getGuiSpatial().y(), (double)this.getGuiSpatial().z());
        poseStack.m_85837_((double)(62 + boxWidth), 41.0, 0.0);
        poseStack.m_85841_(scale, 1.0f, 1.0f);
        this.elementRenderer.begin();
        this.textStyle.textBorder().render(this.elementRenderer, poseStack, (Component)essenceComponent, this.textStyle.textWrap(), this.textStyle.textAlign(), 0, 0, 0, 0);
        this.elementRenderer.end();
        poseStack.m_85849_();
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (pKeyCode == 256 || Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }
}

