/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ClickableItemSlotElement;
import iskallia.vault.client.gui.framework.element.CrystalWorkbenchButtonElement;
import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.ToolItemSlotElement;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderFunction;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.screen.block.TooltipContainerElement;
import iskallia.vault.container.CrystalWorkbenchContainer;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.crystal.recipe.AnvilExecutor;
import iskallia.vault.network.message.CrystalWorkbenchMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class CrystalWorkbenchScreen
extends AbstractElementContainerScreen<CrystalWorkbenchContainer> {
    private final Inventory playerInventory;
    ToolItemSlotElement<?> stackElement;
    ScrollableClickableItemStackSelectorElement<?, ?> ingredientsElement;
    NineSliceElement<?> jewelsBackgroundElement;
    TooltipContainerElement tooltipContainerElement;
    boolean skipRelease = false;

    public CrystalWorkbenchScreen(CrystalWorkbenchContainer container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.playerInventory = inventory;
        this.setGuiSize(Spatials.size(300, 172));
        this.addElement((NineSliceElement)new NineSliceElement(this.getGuiSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).translateX(50).translateY(100).height(90).width(176)));
        this.addElement((SlotsElement)new SlotsElement((MenuAccess<?>)this).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        LabelElement titleElement = this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(139 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)((CrystalWorkbenchContainer)this.m_6262_()).getEntity().m_5446_().m_6881_()) / 2, -24), (Component)((CrystalWorkbenchContainer)this.m_6262_()).getEntity().m_5446_().m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.left()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        if (container.getEntity() != null) {
            this.stackElement = (ToolItemSlotElement)new ToolItemSlotElement(Spatials.positionXY(122, 28), () -> container.getEntity().getInput().m_8020_(0), () -> false, 32, 32).setLabelStackCount().layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
            this.addElement(this.stackElement);
        }
        this.ingredientsElement = (ScrollableClickableItemStackSelectorElement)new ScrollableClickableItemStackSelectorElement(Spatials.positionXY(-12, -2).height(92), 5, new ScrollableClickableItemStackSelectorElement.SelectorModel<ScrollableClickableItemStackSelectorElement.ItemSelectorEntry>(){

            @Override
            public List<ScrollableClickableItemStackSelectorElement.ItemSelectorEntry> getEntries() {
                return ((CrystalWorkbenchContainer)CrystalWorkbenchScreen.this.m_6262_()).getEntity().getIngredients().getContents().stream().map(ItemSelectorWithTooltipEntry::new).collect(Collectors.toList());
            }
        }).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        this.addElement(this.ingredientsElement);
        this.jewelsBackgroundElement = (NineSliceElement)new NineSliceElement(this.ingredientsElement.getWorldSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).translateX(-5).translateY(-5).translateZ(-10).width(this.ingredientsElement.width() + 10).height(this.ingredientsElement.height() + 10));
        this.addElement(this.jewelsBackgroundElement);
        Slot slot = ((CrystalWorkbenchContainer)this.m_6262_()).m_38853_(36);
        IMutableSpatial btnPosition = Spatials.positionXY(slot.f_40220_ - 1, slot.f_40221_ - 1).translateX(20);
        CrystalWorkbenchButtonElement button = (CrystalWorkbenchButtonElement)new CrystalWorkbenchButtonElement((IPosition)btnPosition, () -> ModNetwork.CHANNEL.sendToServer((Object)new CrystalWorkbenchMessage()), this).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        button.setDisabled(() -> {
            ItemStack input = container.getEntity().getInput().m_8020_(0);
            if (input.m_41619_()) {
                return true;
            }
            AnvilExecutor.Result clientExecutor = container.getEntity().getClientExecutor();
            if (clientExecutor == null) {
                return true;
            }
            return ItemStack.m_41728_((ItemStack)input, (ItemStack)clientExecutor.getOutput());
        });
        this.addElement(button);
        this.tooltipContainerElement = this.addElement((TooltipContainerElement)new TooltipContainerElement((ISpatial)Spatials.positionXY(181, -2).height(92).width(107), container.getEntity().getInput().m_8020_(0)).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXYZ(gui)));
        this.addElement((NineSliceElement)new NineSliceElement(this.tooltipContainerElement.getWorldSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).translateX(-5).translateY(-5).translateZ(-10).width(this.tooltipContainerElement.width() + 10).height(this.tooltipContainerElement.height() + 10)));
        this.addElement((NineSliceElement)new NineSliceElement(this.stackElement.getWorldSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).translateZ(-1).translateX(-5).translateY(-5).width(this.stackElement.width() + 10).height(this.stackElement.height() + 10)));
        this.addElement((NineSliceElement)new NineSliceElement(titleElement.getWorldSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).translateZ(-1).translateX(-6).translateY(-6).translateZ(-10).width(titleElement.width() + 10).height(titleElement.height() + 10)));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXY(slot.f_40220_ - 1, slot.f_40221_ - 1).height(18).width(38), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).translateZ(-1).translateX(-5).translateY(-5).translateZ(-10).width(48).height(28)));
        Slot firstUniqueSlot = ((CrystalWorkbenchContainer)this.m_6262_()).m_38853_(97);
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(firstUniqueSlot.f_40220_ - 6, firstUniqueSlot.f_40221_ - 6, -1).height(28).width(64), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            ((CrystalWorkbenchContainer)this.f_97732_).getEntity().onOpen((Player)player);
        }
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (this.skipRelease || this.jewelsBackgroundElement.contains(pMouseX, pMouseY)) {
            this.skipRelease = false;
            this.f_97719_ = true;
            this.f_97738_ = false;
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public void mouseClicked(int buttonIndex, int slotClicked) {
        InputConstants.Key mouseKey = InputConstants.Type.MOUSE.m_84895_(buttonIndex);
        Slot slot = ((CrystalWorkbenchContainer)this.f_97732_).m_38853_(slotClicked);
        this.skipRelease = false;
        int l = slot.f_40219_;
        if (l != -1 && !this.f_97738_) {
            if (((CrystalWorkbenchContainer)this.f_97732_).m_142621_().m_41619_()) {
                if (this.f_96541_ != null && this.f_96541_.f_91066_.f_92097_.isActiveAndMatches(mouseKey)) {
                    this.m_6597_(slot, l, buttonIndex, ClickType.CLONE);
                } else {
                    boolean flag2 = l != -999 && (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344));
                    ClickType clicktype = ClickType.PICKUP;
                    if (flag2) {
                        clicktype = ClickType.QUICK_MOVE;
                    } else if (l == -999) {
                        clicktype = ClickType.THROW;
                    }
                    this.m_6597_(slot, l, buttonIndex, clicktype);
                }
            } else if (this.f_96541_ == null || !this.f_96541_.f_91066_.f_92097_.isActiveAndMatches(mouseKey)) {
                boolean flag2 = l != -999 && (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344));
                ClickType clicktype = ClickType.PICKUP;
                if (flag2) {
                    clicktype = ClickType.QUICK_MOVE;
                }
                this.m_6597_(slot, l, buttonIndex, clicktype);
            }
            this.skipRelease = true;
        }
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        if (((CrystalWorkbenchContainer)this.f_97732_).getEntity() != null) {
            ItemStack output = ((CrystalWorkbenchContainer)this.f_97732_).getEntity().getClientExecutor().getOutput();
            this.stackElement.setItemStack(() -> output);
            if (!output.m_41619_()) {
                this.stackElement.tooltip(Tooltips.shift(Tooltips.multi(() -> this.stackElement.getDisplayStack().m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL)), Tooltips.multi(() -> this.stackElement.getDisplayStack().m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.ADVANCED))));
            } else {
                this.stackElement.tooltip(ITooltipRenderFunction.NONE);
            }
            this.ingredientsElement.refreshElements((CrystalWorkbenchContainer)this.m_6262_());
            this.tooltipContainerElement.refresh(output);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (keyCode == 256 || Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public class ScrollableClickableItemStackSelectorElement<E extends ScrollableClickableItemStackSelectorElement<E, S>, S extends ItemSelectorEntry>
    extends VerticalScrollClipContainer<E> {
        private final int slotColumns;
        protected final SelectorModel<S> selectorModel;
        protected final TextureAtlasRegion slotTexture;
        protected final TextureAtlasRegion disabledSlotTexture;
        private final SelectorContainer<?> elementCt;

        public ScrollableClickableItemStackSelectorElement(ISpatial spatial, int slotColumns, SelectorModel<S> selectorModel) {
            this(spatial, slotColumns, selectorModel, ScreenTextures.INSET_ITEM_SLOT_BACKGROUND, ScreenTextures.INSET_DISABLED_ITEM_SLOT_BACKGROUND);
        }

        public ScrollableClickableItemStackSelectorElement(ISpatial spatial, int slotColumns, SelectorModel<S> selectorModel, TextureAtlasRegion slotTexture, TextureAtlasRegion disabledSlotTexture) {
            super(Spatials.copy(spatial).width(slotColumns * slotTexture.width() + 17));
            this.slotColumns = slotColumns;
            this.selectorModel = selectorModel;
            this.slotTexture = slotTexture;
            this.disabledSlotTexture = disabledSlotTexture;
            this.elementCt = new SelectorContainer(spatial.width());
            this.addElement(this.elementCt);
        }

        public void refreshElements(CrystalWorkbenchContainer container) {
            this.elementCt.refresh(container);
        }

        protected SelectorModel<S> getSelectorModel() {
            return this.selectorModel;
        }

        protected List<ClickableItemSlotElement<?>> getSelectorElements() {
            return Collections.unmodifiableList(this.elementCt.slots);
        }

        protected ClickableItemSlotElement<?> makeElementSlot(final int index, ISpatial spatial, Supplier<ItemStack> itemStack, TextureAtlasRegion slotTexture, TextureAtlasRegion disabledSlotTexture, Supplier<Boolean> disabled) {
            return new ClickableItemSlotElement(spatial, itemStack, disabled, slotTexture, disabledSlotTexture){

                @Override
                public boolean containsMouse(double x, double y) {
                    if (!CrystalWorkbenchScreen.this.ingredientsElement.contains(x, y)) {
                        return false;
                    }
                    return x < (double)this.right() && x >= (double)this.left() && y >= (double)this.top() && y < (double)this.bottom();
                }

                @Override
                public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
                    for (IRenderedElement element : this.elementStore.getRenderedElementList()) {
                        if (!element.isVisible()) continue;
                        element.render(renderer, poseStack, mouseX, mouseY, partialTick);
                    }
                    if (this.isDisabled()) {
                        renderer.render(this.disabledSlotTexture, poseStack, (IPosition)this.worldSpatial);
                    } else {
                        renderer.render(this.slotTexture, poseStack, (IPosition)this.worldSpatial);
                    }
                    RenderSystem.m_69482_();
                    if (!this.getDisplayStack().m_41619_() && index >= ((CrystalWorkbenchContainer)CrystalWorkbenchScreen.this.m_6262_()).getFirstCursedIngredient()) {
                        1.renderSlotHighlight(poseStack, this.worldSpatial.x() + 1, this.worldSpatial.y() + 1, 20, -1670497536);
                    }
                    this.renderItemStack(this.getDisplayStack(), this.worldSpatial.x() + 1, this.worldSpatial.y() + 1, this.isDisabled());
                    this.renderLabel(this.getDisplayStack(), poseStack);
                    if (this.containsMouse(mouseX, mouseY)) {
                        1.renderSlotHighlight(poseStack, this.worldSpatial.x() + 1, this.worldSpatial.y() + 1, 20, -2130706433);
                    }
                    if (!this.getDisplayStack().m_41619_() && index >= ((CrystalWorkbenchContainer)CrystalWorkbenchScreen.this.m_6262_()).getFirstCursedIngredient()) {
                        poseStack.m_85836_();
                        poseStack.m_85837_(0.0, 0.0, 400.0);
                        CrystalWorkbenchScreen.this.f_96547_.m_92883_(poseStack, "\u2620", (float)(this.worldSpatial.x() + 9), (float)(this.worldSpatial.y() + 9), -16777216);
                        poseStack.m_85849_();
                    }
                }
            };
        }

        public static abstract class SelectorModel<E extends ItemSelectorEntry> {
            private Consumer<ClickableItemSlotElement<?>> onSlotSelect = slot -> {};
            private E selectedElement = null;

            protected void onSlotSelect(Consumer<ClickableItemSlotElement<?>> onSlotSelect) {
                this.onSlotSelect = onSlotSelect;
            }

            public abstract List<E> getEntries();

            public void onSelect(ClickableItemSlotElement<?> slot, E entry) {
                this.selectedElement = entry;
                this.onSlotSelect.accept(slot);
            }

            @Nullable
            public E getSelectedElement() {
                return this.selectedElement;
            }
        }

        private class SelectorContainer<T extends SelectorContainer<T>>
        extends ElasticContainerElement<T> {
            private final List<ClickableItemSlotElement<?>> slots;

            private SelectorContainer(int inheritedWidth) {
                super(Spatials.positionXY(0, 0).width(inheritedWidth));
                this.slots = new ArrayList();
                this.buildElements();
            }

            public void refresh(CrystalWorkbenchContainer container) {
                for (int i = 0; i < this.slots.size(); ++i) {
                    int finalI = i;
                    this.slots.get(i).setItemStack(() -> container.getEntity().getIngredients().m_8020_(finalI));
                    if (!this.slots.get(finalI).getDisplayStack().m_41619_()) {
                        this.slots.get(i).tooltip(this.slots.get(finalI).getDisplayStack().m_41619_() ? ITooltipRenderFunction.NONE : Tooltips.shift(Tooltips.multi(() -> this.slots.get(finalI).getDisplayStack().m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL)), Tooltips.multi(() -> this.slots.get(finalI).getDisplayStack().m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.ADVANCED))));
                        continue;
                    }
                    this.slots.get(i).tooltip(ITooltipRenderFunction.NONE);
                }
            }

            private void buildElements() {
                this.slots.clear();
                List entries = ScrollableClickableItemStackSelectorElement.this.selectorModel.getEntries();
                for (int i = 0; i < entries.size(); ++i) {
                    ItemSelectorEntry entry = (ItemSelectorEntry)entries.get(i);
                    int column = i % ScrollableClickableItemStackSelectorElement.this.slotColumns;
                    int row = i / ScrollableClickableItemStackSelectorElement.this.slotColumns;
                    ItemStack stack = entry.getDisplayStack();
                    boolean disabled = entry.isDisabled();
                    ClickableItemSlotElement<?> clickableSlot = ScrollableClickableItemStackSelectorElement.this.makeElementSlot(i, Spatials.positionXY(0, 0).translateX(column * ScrollableClickableItemStackSelectorElement.this.slotTexture.width()).translateY(row * ScrollableClickableItemStackSelectorElement.this.slotTexture.height()), () -> stack, ScrollableClickableItemStackSelectorElement.this.slotTexture, ScrollableClickableItemStackSelectorElement.this.disabledSlotTexture, () -> disabled);
                    clickableSlot.whenClicked(new MouseClickRunnable(37 + i));
                    entry.adjustSlot(clickableSlot);
                    this.addElement(clickableSlot);
                    this.slots.add(clickableSlot);
                }
            }
        }

        public static class ItemSelectorEntry {
            private final ItemStack displayStack;
            private final boolean isDisabled;

            public ItemSelectorEntry(ItemStack displayStack, boolean isDisabled) {
                this.displayStack = displayStack;
                this.isDisabled = isDisabled;
            }

            public ItemStack getDisplayStack() {
                return this.displayStack;
            }

            public boolean isDisabled() {
                return this.isDisabled;
            }

            public void adjustSlot(ClickableItemSlotElement<?> slot) {
            }
        }
    }

    public class MouseClickRunnable
    implements Runnable {
        int type = 0;
        int slot = 0;

        public MouseClickRunnable(int s) {
            this.slot = s;
        }

        public void setType(int type) {
            this.type = type;
        }

        @Override
        public void run() {
            CrystalWorkbenchScreen.this.mouseClicked(this.type, this.slot);
        }
    }

    private static class ItemSelectorWithTooltipEntry
    extends ScrollableClickableItemStackSelectorElement.ItemSelectorEntry {
        public ItemSelectorWithTooltipEntry(ItemStack displayStack) {
            super(displayStack, false);
        }

        @Override
        public void adjustSlot(ClickableItemSlotElement<?> slot) {
            slot.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
                if (!this.getDisplayStack().m_41619_()) {
                    tooltipRenderer.renderTooltip(poseStack, this.getDisplayStack(), mouseX, mouseY, TooltipDirection.RIGHT);
                }
                return true;
            });
            slot.setLabelStackCount();
        }
    }
}

