/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.TextInputElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.config.gear.VaultEtchingConfig;
import iskallia.vault.container.EtchingApplicationTableContainer;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.EtchingApplicationTableCraftMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class EtchingApplicationTableScreen
extends AbstractElementContainerScreen<EtchingApplicationTableContainer> {
    private final TextInputElement<?> nameInput;
    private ItemStack lastGear = ItemStack.f_41583_;
    private ItemStack lastEtching = ItemStack.f_41583_;
    private String lastName = "";

    public EtchingApplicationTableScreen(EtchingApplicationTableContainer container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.setGuiSize(Spatials.size(176, 206));
        this.addElement((NineSliceElement)new NineSliceElement(this.getGuiSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).size(Spatials.copy(gui))));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 7), (Component)container.getTileEntity().m_5446_().m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize s, ISpatial g, ISpatial p, IMutableSpatial w) -> w.translateXY(g)));
        MutableComponent invName = inventory.m_5446_().m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 112), (Component)invName, LabelTextStyle.defaultStyle()).layout((ISize s, ISpatial g, ISpatial p, IMutableSpatial w) -> w.translateXY(g)));
        this.addElement((SlotsElement)new SlotsElement((MenuAccess<?>)this).layout((ISize s, ISpatial g, ISpatial p, IMutableSpatial w) -> w.positionXY(g)));
        this.nameInput = this.addElement((TextInputElement)new TextInputElement(Spatials.positionXY(10, 20).size(120, 12), Minecraft.m_91087_().f_91062_).layout((ISize s, ISpatial g, ISpatial p, IMutableSpatial w) -> w.translateXY(g)));
        ButtonElement craftButton = this.addElement((ButtonElement)new ButtonElement(Spatials.positionXY(116, 57), ScreenTextures.BUTTON_CRAFT_TEXTURES, () -> ModNetwork.CHANNEL.sendToServer((Object)new EtchingApplicationTableCraftMessage(container.getPos(), this.nameInput.getInput()))).layout((ISize s, ISpatial g, ISpatial p, IMutableSpatial w) -> w.translateXY(g)));
        craftButton.setDisabled(() -> container.getTileEntity() == null || container.getTileEntity().getInventory().m_8020_(0).m_41619_() || container.getTileEntity().getInventory().m_8020_(1).m_41619_() || !container.getTileEntity().getInventory().m_8020_(2).m_41619_());
        this.updateSuggestedName();
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        this.nameInput.tickEditBox();
        this.updateSuggestedName();
    }

    private void updateSuggestedName() {
        if (((EtchingApplicationTableContainer)this.m_6262_()).getTileEntity() == null) {
            return;
        }
        ItemStack gear = ((EtchingApplicationTableContainer)this.m_6262_()).getTileEntity().getInventory().m_8020_(0);
        ItemStack etching = ((EtchingApplicationTableContainer)this.m_6262_()).getTileEntity().getInventory().m_8020_(1);
        boolean changed = !ItemStack.m_150942_((ItemStack)gear, (ItemStack)this.lastGear) | !ItemStack.m_150942_((ItemStack)etching, (ItemStack)this.lastEtching);
        if (!changed) {
            return;
        }
        this.lastGear = gear.m_41777_();
        this.lastEtching = etching.m_41777_();
        Object suggested = "";
        if (!gear.m_41619_()) {
            String baseName = gear.m_41786_().getString();
            if (!etching.m_41619_()) {
                ResourceLocation id = VaultGearData.read(etching).getFirstValue(ModGearAttributes.ETCHING).orElse(null);
                VaultEtchingConfig.EtchingEntry entry = id == null ? null : ModConfigs.ETCHINGS.getEtchingConfig(id);
                String etchingName = entry != null ? entry.getName() : etching.m_41786_().getString();
                suggested = etchingName + " " + baseName;
            } else {
                suggested = baseName;
            }
        }
        if (this.nameInput.getInput().isEmpty() || this.nameInput.getInput().equals(this.lastName)) {
            this.nameInput.setInput((String)suggested);
        }
        this.lastName = suggested;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.nameInput.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            if (!this.nameInput.isFocused()) {
                this.m_7379_();
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.nameInput.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }
}

