/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.ItemStackDisplayElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.TextInputElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.element.WorkbenchCraftSelectorElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.client.gui.screen.block.VaultArtisanStationScreen;
import iskallia.vault.config.gear.VaultGearWorkbenchConfig;
import iskallia.vault.container.ModifierWorkbenchContainer;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.crafting.ModifierWorkbenchHelper;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.tooltip.GearTooltip;
import iskallia.vault.gear.tooltip.VaultGearTooltipItem;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.CoinPouchItem;
import iskallia.vault.network.message.ModifierWorkbenchCraftMessage;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.util.function.ObservableSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ModifierWorkbenchScreen
extends AbstractElementContainerScreen<ModifierWorkbenchContainer> {
    private final Inventory playerInventory;
    private final WorkbenchCraftSelectorElement<?, ?> selectorElement;
    private final TextInputElement<?> searchInput;
    private ModifierWorkbenchHelper.CraftingOption selectedOption;

    public ModifierWorkbenchScreen(ModifierWorkbenchContainer container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.playerInventory = inventory;
        this.setGuiSize(Spatials.size(176, 212));
        this.addElement((NineSliceElement)new NineSliceElement(this.getGuiSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).size(Spatials.copy(gui))));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 7), (Component)((ModifierWorkbenchContainer)this.m_6262_()).getTileEntity().m_5446_().m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        MutableComponent inventoryName = inventory.m_5446_().m_6881_();
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 120), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((SlotsElement)new SlotsElement((MenuAccess<?>)this).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        this.searchInput = (TextInputElement)new TextInputElement(Spatials.positionXY(110, 5).size(60, 12), Minecraft.m_91087_().f_91062_).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        this.addElement(this.searchInput);
        this.selectorElement = (WorkbenchCraftSelectorElement)new WorkbenchCraftSelectorElement((ISpatial)Spatials.positionXY(8, 19).height(97), ObservableSupplier.ofIdentity(() -> ((ModifierWorkbenchContainer)this.m_6262_()).getInput()), this.searchInput::getInput).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        this.addElement(this.selectorElement);
        ButtonElement craftButton = (ButtonElement)new ButtonElement(Spatials.positionXY(142, 48), ScreenTextures.BUTTON_CRAFT_TEXTURES, this::tryCraft).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        this.addElement(craftButton);
        craftButton.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
            if (this.selectedOption == null) {
                return false;
            }
            ItemStack gear = ((ModifierWorkbenchContainer)this.m_6262_()).getInput();
            if (gear.m_41619_()) {
                return false;
            }
            if (AttributeGearData.hasData(gear) && !((AttributeGearData)AttributeGearData.read(gear)).isModifiable()) {
                MutableComponent cmp = new TranslatableComponent("the_vault.gear_modification.unmodifiable").m_130940_(ChatFormatting.RED);
                tooltipRenderer.renderTooltip(poseStack, (Component)cmp, mouseX, mouseY, TooltipDirection.RIGHT);
                return true;
            }
            List<ItemStack> inputs = this.selectedOption.getCraftingCost(gear);
            List<ItemStack> missing = InventoryUtil.getMissingInputs(inputs, this.playerInventory);
            if (missing.isEmpty()) {
                ArrayList<Component> tooltip = new ArrayList<Component>();
                tooltip.add(gear.m_41786_());
                Item patt5813$temp = gear.m_41720_();
                if (patt5813$temp instanceof VaultGearTooltipItem) {
                    VaultGearTooltipItem gearTooltipItem = (VaultGearTooltipItem)patt5813$temp;
                    tooltip.addAll(gearTooltipItem.createTooltip(gear, GearTooltip.craftingView()));
                }
                tooltipRenderer.renderComponentTooltip(poseStack, tooltip, mouseX, mouseY, TooltipDirection.RIGHT);
                return true;
            }
            MutableComponent cmp = new TranslatableComponent("the_vault.gear_workbench.missing_inputs").m_130940_(ChatFormatting.RED);
            tooltipRenderer.renderTooltip(poseStack, (Component)cmp, mouseX, mouseY, TooltipDirection.RIGHT);
            return true;
        });
        craftButton.setDisabled(() -> {
            ItemStack gear = ((ModifierWorkbenchContainer)this.m_6262_()).getInput();
            if (gear.m_41619_()) {
                return true;
            }
            if (this.selectedOption != null) {
                List<ItemStack> inputs = this.selectedOption.getCraftingCost(gear);
                List<ItemStack> missing = InventoryUtil.getMissingInputs(inputs, this.playerInventory);
                return !missing.isEmpty();
            }
            return true;
        });
        this.selectorElement.onSelect(option -> {
            this.selectedOption = option;
        });
        this.searchInput.onTextChanged(text -> this.selectorElement.refreshElements());
        IMutableSpatial iMutableSpatial = Spatials.positionXYZ(20, -10, 200);
        Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
        this.addElement((VaultArtisanStationScreen.CoinCountElement)new VaultArtisanStationScreen.CoinCountElement((IPosition)iMutableSpatial, (ISize)Spatials.size(100, 9), () -> CoinPouchItem.getGoldAmount(Minecraft.m_91087_().f_91074_.m_150109_()), LabelTextStyle.shadow()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui.x(), gui.y())));
        this.addElement((TextureAtlasElement)((TextureAtlasElement)new TextureAtlasElement(Spatials.positionXY(0, -ScreenTextures.TAB_SOULSHARD_BACKGROUND.height()), ScreenTextures.TAB_SOULSHARD_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui))).tooltip(Tooltips.multi(() -> List.of(new TextComponent("Vault Gold")))));
        ItemStackDisplayElement itemStackDisplayElement = (ItemStackDisplayElement)new ItemStackDisplayElement(Spatials.positionXY(5, -ScreenTextures.TAB_COUNTDOWN_BACKGROUND.height() + 3), new ItemStack((ItemLike)ModBlocks.VAULT_GOLD, 64)).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        itemStackDisplayElement.setScale(0.72f);
        this.addElement(itemStackDisplayElement);
    }

    private void tryCraft() {
        List<ItemStack> inputs;
        List<ItemStack> missing;
        if (this.selectedOption == null) {
            return;
        }
        ItemStack gear = ((ModifierWorkbenchContainer)this.m_6262_()).getInput();
        if (gear.m_41619_()) {
            return;
        }
        ItemStack gearCopy = gear.m_41777_();
        VaultGearWorkbenchConfig.CraftableModifierConfig cfg = this.selectedOption.cfg();
        if (cfg != null) {
            if (VaultGearData.read(gearCopy).getItemLevel() < cfg.getMinLevel()) {
                return;
            }
            VaultGearModifier modifier = cfg.createModifier().orElse(null);
            if (modifier != null) {
                if (ModifierWorkbenchHelper.hasCraftedModifier(gearCopy) && !ModifierWorkbenchHelper.removeCraftedModifiers(gearCopy)) {
                    return;
                }
                VaultGearData data = VaultGearData.read(gearCopy);
                Set<String> modGroups = data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS);
                if (modGroups.contains(modifier.getModifierGroup())) {
                    return;
                }
            }
        }
        if (!(missing = InventoryUtil.getMissingInputs(inputs = this.selectedOption.getCraftingCost(gear), this.playerInventory)).isEmpty()) {
            return;
        }
        ResourceLocation craftKey = cfg == null ? null : cfg.getWorkbenchCraftIdentifier();
        ModNetwork.CHANNEL.sendToServer((Object)new ModifierWorkbenchCraftMessage(((ModifierWorkbenchContainer)this.m_6262_()).getTilePos(), craftKey));
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        this.searchInput.tickEditBox();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.searchInput.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            if (!this.searchInput.isFocused()) {
                this.m_7379_();
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchInput.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }
}

