/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.block.entity.PersonalVaultTileEntity;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.OutputSlotElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.TabElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.screen.block.PersonalVaultScreen;
import iskallia.vault.container.PersonalVaultCraftingContainer;
import iskallia.vault.container.slot.RecipeOutputSlot;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.PersonalVaultRequestCraftMessage;
import iskallia.vault.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PersonalVaultCraftingScreen
extends AbstractElementContainerScreen<PersonalVaultCraftingContainer> {
    protected final ButtonElement<?> craftButton;
    protected final Inventory playerInventory;

    public PersonalVaultCraftingScreen(PersonalVaultCraftingContainer menu, Inventory inv, Component title) {
        super(menu, inv, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.playerInventory = inv;
        PersonalVaultTileEntity tileEntity = ((PersonalVaultCraftingContainer)this.m_6262_()).getTileEntity();
        if (tileEntity == null) {
            this.craftButton = null;
            return;
        }
        this.f_97726_ = 176;
        this.f_97727_ = 242;
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(0, 0, -1).size(this.f_97726_, this.f_97727_), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout(this.translateWorldSpatial()));
        MutableComponent inventoryName = inv.m_5446_().m_6881_();
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXYZ(8, ((PersonalVaultCraftingContainer)this.m_6262_()).m_38853_((int)3).f_40221_ - 12, 2), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout(this.translateWorldSpatial()));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 6), (Component)new TextComponent("Personal Vault | Crafting").m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout(this.translateWorldSpatial()));
        NonNullList allSlots = ((PersonalVaultCraftingContainer)this.m_6262_()).f_38839_;
        List<Slot> normalSlots = allSlots.stream().filter(slot -> !(slot instanceof RecipeOutputSlot)).toList();
        this.addElement((SlotsElement)new SlotsElement((IPosition)Spatials.zero(), normalSlots, ScreenTextures.INSET_ITEM_SLOT_BACKGROUND).layout(this.translateWorldSpatial()));
        allSlots.forEach(slot -> {
            if (slot instanceof RecipeOutputSlot) {
                this.addElement((OutputSlotElement)new OutputSlotElement(Spatials.zero(), (Slot)slot, ScreenTextures.INSET_CRAFTING_RESULT_SLOT_BACKGROUND).layout(this.translateWorldSpatial()));
            }
        });
        int offsetX = 75;
        int offsetY = 50;
        this.craftButton = (ButtonElement)((ButtonElement)new ButtonElement(Spatials.positionXY(this.f_97726_ / 2 - 9, 59), ScreenTextures.BUTTON_CRAFT_TEXTURES, this::onCraftClick).setDisabled(() -> !this.getMissingRecipeInputs(PersonalVaultCraftingContainer.getRecipe(inv.f_35978_)).isEmpty()).tooltip(Tooltips.multi(() -> {
            List<ItemStack> recipe = PersonalVaultCraftingContainer.getRecipe(inv.f_35978_);
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(new TextComponent("Craft Personal Vault Rock"));
            List<ItemStack> missingItems = this.getMissingRecipeInputs(recipe);
            for (ItemStack stack : recipe) {
                if (stack.m_41619_()) continue;
                boolean missing = missingItems.stream().anyMatch(missingStack -> missingStack.m_41656_(stack));
                tooltip.add(new TextComponent(stack.m_41613_() + "x ").m_130946_(stack.m_41786_().getString()).m_130948_(Style.f_131099_.m_178520_(missing ? -65536 : -16711936)));
            }
            return tooltip;
        }))).layout(this.translateWorldSpatial());
        this.addElement(this.craftButton);
        this.addElement((TabElement)new TabElement(Spatials.positionXY(-24, 10), new TextureAtlasElement(ScreenTextures.TAB_BACKGROUND_LEFT), new TextureAtlasElement(Spatials.positionXY(5, 6), ScreenTextures.TAB_ICON_INSCRIPTION), () -> PersonalVaultScreen.changeTab(1, ((PersonalVaultCraftingContainer)this.m_6262_()).getBlockPos())).layout(this.translateWorldSpatial()));
        this.addElement((TabElement)new TabElement(Spatials.positionXY(-24, 40), new TextureAtlasElement(ScreenTextures.TAB_BACKGROUND_LEFT), new TextureAtlasElement(Spatials.positionXY(6, 6), ScreenTextures.TAB_ICON_CATALYST), () -> PersonalVaultScreen.changeTab(2, ((PersonalVaultCraftingContainer)this.m_6262_()).getBlockPos())).layout(this.translateWorldSpatial()));
        this.addElement((TabElement)new TabElement(Spatials.positionXY(-28, 70), new TextureAtlasElement(ScreenTextures.TAB_BACKGROUND_LEFT_SELECTED), new TextureAtlasElement(Spatials.positionXY(8, 6), ScreenTextures.TAB_ICON_CRYSTAL), () -> PersonalVaultScreen.changeTab(3, ((PersonalVaultCraftingContainer)this.m_6262_()).getBlockPos())).layout(this.translateWorldSpatial()));
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        this.craftButton.setDisabled(!this.getMissingRecipeInputs(PersonalVaultCraftingContainer.getRecipe(((PersonalVaultCraftingContainer)this.f_97732_).getPlayer())).isEmpty());
    }

    private void onCraftClick() {
        ModNetwork.CHANNEL.sendToServer((Object)new PersonalVaultRequestCraftMessage(Screen.m_96638_()));
    }

    protected List<ItemStack> getMissingRecipeInputs(List<ItemStack> inputs) {
        PersonalVaultTileEntity tile = ((PersonalVaultCraftingContainer)this.f_97732_).getTileEntity();
        if (tile == null) {
            return inputs;
        }
        return InventoryUtil.getMissingInputs(inputs, this.playerInventory, tile.getInventory());
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (pKeyCode == 256 || Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }
}

