/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.screen.layout.ScreenLayout;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class PersonalVaultListElement<E extends PersonalVaultListElement<E>>
extends ElasticContainerElement<E> {
    private static final int LABEL_HEIGHT = 11;
    private List<LabelElement<?>> labels = new ArrayList();

    public PersonalVaultListElement(ISpatial spatial, List<? extends Component> stack) {
        super(spatial);
        this.refresh(stack);
    }

    public void refresh(List<? extends Component> labels) {
        for (LabelElement<?> label : this.labels) {
            this.removeElement(label);
        }
        this.labels.clear();
        if (!labels.isEmpty()) {
            int lines = 0;
            int iterations = 0;
            for (Component component : labels) {
                int finalLines = lines;
                int finalIterations = iterations;
                this.labels.add(this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(this.fixedSpatial.left(), this.fixedSpatial.top()).size(this.getWorldSpatial().width(), finalIterations == 0 ? 11 : 9), component, LabelTextStyle.defaultStyle()).layout((screen, gui, parent, world) -> world.translateY(finalLines * 9 + (finalIterations == 0 ? 0 : 2)).translateZ(1).width(parent))));
                int fontWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
                double width = (double)fontWidth / (double)this.getWorldSpatial().width();
                lines = width == 0.0 ? ++lines : (lines += (int)Math.ceil(width));
                ++iterations;
            }
        }
        ScreenLayout.requestLayout();
    }
}

