/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ItemStackDisplayElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.TabElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.block.PersonalVaultListContainerElement;
import iskallia.vault.client.gui.screen.block.VaultArtisanStationScreen;
import iskallia.vault.config.PersonalVaultConfig;
import iskallia.vault.container.PersonalVaultContainer;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.CoinPouchItem;
import iskallia.vault.item.InfusedCatalystItem;
import iskallia.vault.item.data.InscriptionData;
import iskallia.vault.network.message.ServerBoundPersonalVaultUnlockMessage;
import iskallia.vault.network.message.ServerboundPersonalVaultTabMessage;
import iskallia.vault.world.data.PersonalVaultData;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class PersonalVaultScreen
extends AbstractElementContainerScreen<PersonalVaultContainer> {
    private final PersonalVaultListContainerElement listContainerElement;
    private static final int VISIBLE_ROWS = 7;
    private float scrollOffs = 0.4f;

    public PersonalVaultScreen(PersonalVaultContainer menu, Inventory inv, Component title) {
        super(menu, inv, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        menu.centerOnSlot(40);
        this.f_97726_ = 176;
        this.f_97727_ = 242;
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(0, 0, -1).size(this.f_97726_, this.f_97727_), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout(this.translateWorldSpatial()));
        MutableComponent inventoryName = inv.m_5446_().m_6881_();
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXYZ(8, ((PersonalVaultContainer)this.m_6262_()).m_38853_((int)81).f_40221_ - 12, 2), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout(this.translateWorldSpatial()));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 6), (Component)new TextComponent("Personal Vault | Builder").m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout(this.translateWorldSpatial()));
        this.addElement((SlotsElement)new SlotsElement((IPosition)Spatials.zero(), (List<Slot>)menu.f_38839_, slot -> {
            PersonalVaultContainer.DataSlot dataSlot;
            if (slot instanceof PersonalVaultContainer.DataSlot && (dataSlot = (PersonalVaultContainer.DataSlot)slot).getSlotStatus() == PersonalVaultData.Entry.SlotStatus.LOCKED) {
                return ScreenTextures.INSET_DISABLED_ITEM_SLOT_BACKGROUND;
            }
            return ScreenTextures.INSET_ITEM_SLOT_BACKGROUND;
        }).layout(this.translateWorldSpatial()));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(this.f_97726_ - 3, 12, -2).size(150, this.f_97727_ - 24), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout(this.translateWorldSpatial()));
        this.listContainerElement = this.addElement((PersonalVaultListContainerElement)new PersonalVaultListContainerElement((ISpatial)Spatials.positionXY(this.f_97726_ + 1, 16).size(142, this.f_97727_ - 8 - 24), PersonalVaultScreen.getListText()).layout(this.translateWorldSpatial()));
        this.addElement((TabElement)new TabElement(Spatials.positionXY(-28, 10), new TextureAtlasElement(ScreenTextures.TAB_BACKGROUND_LEFT_SELECTED), new TextureAtlasElement(Spatials.positionXY(8, 6), ScreenTextures.TAB_ICON_INSCRIPTION), () -> PersonalVaultScreen.changeTab(1, ((PersonalVaultContainer)this.m_6262_()).getBlockPos())).layout(this.translateWorldSpatial()));
        this.addElement((TabElement)new TabElement(Spatials.positionXY(-24, 40), new TextureAtlasElement(ScreenTextures.TAB_BACKGROUND_LEFT), new TextureAtlasElement(Spatials.positionXY(5, 6), ScreenTextures.TAB_ICON_CATALYST), () -> PersonalVaultScreen.changeTab(2, ((PersonalVaultContainer)this.m_6262_()).getBlockPos())).layout(this.translateWorldSpatial()));
        this.addElement((TabElement)new TabElement(Spatials.positionXY(-24, 70), new TextureAtlasElement(ScreenTextures.TAB_BACKGROUND_LEFT), new TextureAtlasElement(Spatials.positionXY(5, 6), ScreenTextures.TAB_ICON_CRYSTAL), () -> PersonalVaultScreen.changeTab(3, ((PersonalVaultContainer)this.m_6262_()).getBlockPos())).layout(this.translateWorldSpatial()));
        IMutableSpatial iMutableSpatial = Spatials.positionXYZ(20, -10, 200);
        Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
        this.addElement((VaultArtisanStationScreen.CoinCountElement)new VaultArtisanStationScreen.CoinCountElement((IPosition)iMutableSpatial, (ISize)Spatials.size(100, 9), () -> CoinPouchItem.getGoldAmount(Minecraft.m_91087_().f_91074_.m_150109_()), LabelTextStyle.shadow()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui.x(), gui.y())));
        this.addElement((TextureAtlasElement)((TextureAtlasElement)new TextureAtlasElement(Spatials.positionXY(0, -ScreenTextures.TAB_SOULSHARD_BACKGROUND.height()), ScreenTextures.TAB_SOULSHARD_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui))).tooltip(Tooltips.multi(() -> List.of(new TextComponent("Vault Gold")))));
        ItemStackDisplayElement itemStackDisplayElement = (ItemStackDisplayElement)new ItemStackDisplayElement(Spatials.positionXY(5, -ScreenTextures.TAB_COUNTDOWN_BACKGROUND.height() + 3), new ItemStack((ItemLike)ModBlocks.VAULT_GOLD, 64)).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        itemStackDisplayElement.setScale(0.72f);
        this.addElement(itemStackDisplayElement);
    }

    public static List<? extends Component> getListText() {
        PersonalVaultData.Entry entry = PersonalVaultData.CLIENT.getOrCreate(Minecraft.m_91087_().f_91074_.m_142081_());
        HashMap<ResourceLocation, Integer> modifiers = new HashMap<ResourceLocation, Integer>();
        for (ItemStack catalyst : entry.getInfusedCatalysts()) {
            if (catalyst.m_41619_()) continue;
            for (ResourceLocation id : InfusedCatalystItem.getModifiers(catalyst)) {
                modifiers.put(id, modifiers.getOrDefault(id, 0) + 1);
            }
        }
        for (ItemStack inscription : entry.getSlotItems().values()) {
            if (inscription.m_41619_()) continue;
            InscriptionData data = InscriptionData.from(inscription);
            for (ResourceLocation id : data.getModifiers()) {
                modifiers.put(id, modifiers.getOrDefault(id, 0) + 1);
            }
        }
        return modifiers.entrySet().stream().sorted((e1, e2) -> Integer.compare((Integer)e2.getValue(), (Integer)e1.getValue())).map(modEntry -> {
            ResourceLocation modifierId = (ResourceLocation)modEntry.getKey();
            int count = (Integer)modEntry.getValue();
            return VaultModifierRegistry.getOpt(modifierId).map(vaultModifier -> new TextComponent("\u2022 " + count + "x " + vaultModifier.getDisplayName()).m_130948_(Style.f_131099_.m_131148_(vaultModifier.getDisplayTextColor()))).orElse(new TextComponent("\u2022 " + count + "x " + modifierId.toString()).m_130948_(Style.f_131099_.m_178520_(-12632257)));
        }).toList();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        PersonalVaultContainer.DataSlot dataSlot;
        Slot slot = this.f_97734_;
        if (slot instanceof PersonalVaultContainer.DataSlot && (dataSlot = (PersonalVaultContainer.DataSlot)slot).getSlotStatus() == PersonalVaultData.Entry.SlotStatus.LOCKED) {
            PersonalVaultConfig config;
            PersonalVaultConfig.RingCost ringCost;
            int slotIndex = dataSlot.pvSlot;
            int ring = PersonalVaultData.Entry.getRing(slotIndex);
            if (!PersonalVaultData.CLIENT.getOrCreate(Minecraft.m_91087_().f_91074_.m_142081_()).canUnlockSlot(slotIndex)) {
                return false;
            }
            if (ring > 0 && (ringCost = (config = ModConfigs.PERSONAL_VAULT).getRingCost(ring)) != null) {
                int prestigePoints = ringCost.getPrestigePointCost();
                int vaultGold = ringCost.getVaultGoldCost();
                boolean hasEnoughPoints = VaultBarOverlay.unspentSkillPoints >= prestigePoints;
                boolean hasEnoughGold = true;
                if (vaultGold > 0) {
                    int userGold = CoinPouchItem.getGoldAmount(Minecraft.m_91087_().f_91074_.m_150109_());
                    boolean bl = hasEnoughGold = userGold >= vaultGold;
                }
                if (hasEnoughPoints && hasEnoughGold) {
                    ModNetwork.CHANNEL.sendToServer((Object)new ServerBoundPersonalVaultUnlockMessage(slotIndex, ((PersonalVaultContainer)this.m_6262_()).getBlockPos()));
                    return true;
                }
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int gridX = this.getGuiLeft() + 8;
        int gridY = this.getGuiTop() + 18;
        int gridW = 162;
        int gridH = 126;
        if (!(mouseX >= (double)gridX && mouseX < (double)(gridX + gridW) && mouseY >= (double)gridY && mouseY < (double)(gridY + gridH))) {
            return super.m_6050_(mouseX, mouseY, delta);
        }
        int rowsRange = 2;
        if (rowsRange <= 0) {
            return super.m_6050_(mouseX, mouseY, delta);
        }
        this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - (float)delta / (float)rowsRange), (float)0.0f, (float)1.0f);
        ((PersonalVaultContainer)this.f_97732_).scrollTo((int)(this.scrollOffs * (float)rowsRange + 0.5f));
        return true;
    }

    protected static void changeTab(int index, BlockPos pos) {
        switch (index) {
            case 1: {
                ModNetwork.CHANNEL.sendToServer((Object)new ServerboundPersonalVaultTabMessage(ServerboundPersonalVaultTabMessage.Action.INSCRIPTION, pos));
                break;
            }
            case 2: {
                ModNetwork.CHANNEL.sendToServer((Object)new ServerboundPersonalVaultTabMessage(ServerboundPersonalVaultTabMessage.Action.CATALYST, pos));
                break;
            }
            case 3: {
                ModNetwork.CHANNEL.sendToServer((Object)new ServerboundPersonalVaultTabMessage(ServerboundPersonalVaultTabMessage.Action.CRAFT, pos));
            }
        }
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.listContainerElement != null) {
            this.listContainerElement.refresh(PersonalVaultScreen.getListText());
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 1.0);
        int scrollbarHeight = 128;
        int scrollbarWidth = 4;
        int scrollbarX = this.getGuiLeft() + this.f_97726_ - scrollbarWidth - 3;
        int scrollbarY = this.getGuiTop() + 16;
        this.m_93179_(poseStack, scrollbarX, scrollbarY, scrollbarX + scrollbarWidth, scrollbarY + scrollbarHeight, -2013265920, -2013265920);
        int thumbHeight = Math.max(20, scrollbarHeight * 7 / 9);
        int thumbY = (int)Math.floor((float)scrollbarY + this.scrollOffs * (float)(scrollbarHeight - thumbHeight));
        this.m_93179_(poseStack, scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, -16777216, -16777216);
        poseStack.m_85849_();
        this.renderTooltips(poseStack, mouseX, mouseY);
    }

    @Override
    protected boolean renderHoveredSlotTooltips(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
        Slot slot = this.f_97734_;
        if (slot instanceof PersonalVaultContainer.DataSlot) {
            PersonalVaultContainer.DataSlot dataSlot = (PersonalVaultContainer.DataSlot)slot;
            if (dataSlot.getSlotStatus() == PersonalVaultData.Entry.SlotStatus.LOCKED) {
                this.m_169388_(poseStack, dataSlot.getTooltip(), Optional.empty(), mouseX, mouseY);
                return true;
            }
            if (dataSlot.getSlotStatus() == PersonalVaultData.Entry.SlotStatus.ROCK) {
                return false;
            }
        }
        if (this.f_97734_ != null && this.f_97734_.m_6657_()) {
            this.m_6057_(poseStack, this.f_97734_.m_7993_(), mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (pKeyCode == 256 || Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }
}

