/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.client.ClientAbilityData;
import iskallia.vault.client.ClientTalentData;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.TabElement;
import iskallia.vault.client.gui.framework.element.TextInputElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.NineSlice;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Padding;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.screen.player.legacy.widget.AbilityNodeTextures;
import iskallia.vault.client.gui.screen.player.legacy.widget.NodeState;
import iskallia.vault.config.entry.SkillStyle;
import iskallia.vault.container.SkillAltarContainer;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.world.data.SkillAltarData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SkillAltarScreen<C extends SkillAltarContainer>
extends AbstractElementContainerScreen<C> {
    private static final int MAX_TABS = 5;

    protected SkillAltarScreen(C container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        this.setGuiSize(Spatials.size(176, 216));
        this.addTabs();
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXY(0, 0).size(0, 10), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).size(gui)));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 6), (Component)title.m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
    }

    public static TextureAtlasRegion getSkillIcon(SkillAltarData.SkillIcon icon) {
        if (icon.isTalent()) {
            SkillStyle skillStyle = ModConfigs.TALENTS_GUI.getStyles().get(icon.key());
            if (skillStyle != null) {
                return TextureAtlasRegion.of(ModTextureAtlases.SKILLS, skillStyle.icon);
            }
        } else {
            ResourceLocation i = ModConfigs.ABILITIES_GUI.getIcon(icon.key());
            if (i != null) {
                return TextureAtlasRegion.of(ModTextureAtlases.ABILITIES, i);
            }
        }
        return ScreenTextures.TAB_ICON_ABILITIES;
    }

    private void addTabs() {
        AtomicInteger i = new AtomicInteger(0);
        while (i.get() < Math.min(5, ((SkillAltarContainer)this.m_6262_()).getSkillIcons().size() + 1)) {
            int templateIndex = i.get();
            if (templateIndex == ((SkillAltarContainer)this.m_6262_()).getTemplateIndex()) {
                this.addSelectedTab();
            } else if (templateIndex < ((SkillAltarContainer)this.m_6262_()).getSkillIcons().size()) {
                SkillAltarData.SkillIcon icon = ((SkillAltarContainer)this.m_6262_()).getSkillIcons().get(templateIndex);
                this.addElement(SkillAltarScreen.createTab(false, SkillAltarScreen.getSkillIcon(icon), 4 + templateIndex * 31, () -> this.openTab(templateIndex)));
            } else {
                this.addElement(SkillAltarScreen.createTab(false, ScreenTextures.TAB_ICON_ABILITIES, 4 + templateIndex * 31, () -> this.openTab(templateIndex)));
            }
            i.incrementAndGet();
        }
    }

    private void openTab(int templateIndex) {
        if (this instanceof Default) {
            ((SkillAltarContainer)this.m_6262_()).openTab(templateIndex);
        } else {
            ((SkillAltarContainer)this.m_6262_()).openImportScreen(templateIndex);
        }
    }

    private void addSelectedTab() {
        SkillAltarData.SkillTemplate template = ((SkillAltarContainer)this.m_6262_()).getTemplate();
        TextureAtlasRegion icon = ScreenTextures.TAB_ICON_ABILITIES;
        if (template != null && !template.getIcon().key().isEmpty()) {
            icon = SkillAltarScreen.getSkillIcon(template.getIcon());
        }
        this.addElement(SkillAltarScreen.createTab(true, icon, 4 + ((SkillAltarContainer)this.m_6262_()).getTemplateIndex() * 31, () -> {}));
    }

    private static TabElement<?> createTab(boolean selected, TextureAtlasRegion icon, int x, Runnable onClick) {
        return (TabElement)new TabElement(Spatials.positionXYZ(x, selected ? -28 : -24, 1), new TextureAtlasElement(selected ? ScreenTextures.TAB_BACKGROUND_TOP_SELECTED : ScreenTextures.TAB_BACKGROUND_TOP), new TextureAtlasElement(Spatials.positionXYZ(6, selected ? 9 : 5, 10), icon), onClick).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
    }

    protected List<Component> getSkillDifferencesTooltip(List<TieredSkill> abilitiesA, List<TieredSkill> abilitiesB, List<TieredSkill> talentsA, List<TieredSkill> talentsB) {
        List<Component> talentDifferencesTooltip;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        List<Component> abilityDifferencesTooltip = this.getSkillDifferencesTooltip(abilitiesA, abilitiesB, Skill::getName, TieredSkill::getUnmodifiedTier, Style.f_131099_.m_178520_(-9916953));
        if (!abilityDifferencesTooltip.isEmpty()) {
            tooltip.add(TextComponent.f_131282_);
            tooltip.add((Component)new TranslatableComponent("screen.the_vault.skill_altar.tooltip.abilities").m_130940_(ChatFormatting.GRAY));
            tooltip.addAll(abilityDifferencesTooltip);
        }
        if (!(talentDifferencesTooltip = this.getSkillDifferencesTooltip(talentsA, talentsB, Skill::getName, TieredSkill::getUnmodifiedTier, Style.f_131099_.m_178520_(-6981964))).isEmpty()) {
            tooltip.add(TextComponent.f_131282_);
            tooltip.add((Component)new TranslatableComponent("screen.the_vault.skill_altar.tooltip.talents").m_130940_(ChatFormatting.GRAY));
            tooltip.addAll(talentDifferencesTooltip);
        }
        return tooltip;
    }

    private <T> List<Component> getSkillDifferencesTooltip(List<T> nodesA, List<T> nodesB, Function<T, String> nameFunction, ToIntFunction<T> levelFunction, Style nameStyle) {
        TreeMap abilityDifferences = new TreeMap();
        Map<String, Object> nodesBMap = nodesB.stream().collect(Collectors.toMap(nameFunction, a -> a));
        Set nodesANames = nodesA.stream().map(nameFunction).collect(Collectors.toSet());
        nodesA.forEach(nodeA -> {
            String parentName = (String)nameFunction.apply(nodeA);
            int levelDifference = (nodesBMap.containsKey(parentName) ? levelFunction.applyAsInt(nodesBMap.get(parentName)) : 0) - levelFunction.applyAsInt(nodeA);
            if (levelDifference > 0) {
                abilityDifferences.put(parentName, this.getPositiveLevelDifference(parentName, levelDifference, nameStyle));
            } else if (levelDifference < 0) {
                abilityDifferences.put(parentName, this.getNegativeLevelDifference(parentName, levelDifference, nameStyle));
            }
        });
        nodesBMap.values().forEach(nodeB -> {
            String parentName = (String)nameFunction.apply(nodeB);
            if (!nodesANames.contains(parentName)) {
                abilityDifferences.put(parentName, this.getPositiveLevelDifference(parentName, levelFunction.applyAsInt(nodeB), nameStyle));
            }
        });
        return new ArrayList<Component>(abilityDifferences.values());
    }

    private MutableComponent getNegativeLevelDifference(String name, int levelDifference, Style nameStyle) {
        return new TextComponent("-" + Math.abs(levelDifference) + " ").m_130940_(ChatFormatting.RED).m_7220_((Component)new TextComponent(name).m_130948_(nameStyle));
    }

    private MutableComponent getPositiveLevelDifference(String name, int levelDifference, Style nameStyle) {
        return new TextComponent("+" + levelDifference + " ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)new TextComponent(name).m_130948_(nameStyle));
    }

    protected List<TieredSkill> getTemplateTalents() {
        SkillAltarData.SkillTemplate template = ((SkillAltarContainer)this.m_6262_()).getTemplate();
        if (template == null) {
            return Collections.emptyList();
        }
        return this.getTemplateTalents(template);
    }

    protected List<TieredSkill> getTemplateTalents(SkillAltarData.SkillTemplate template) {
        return template.getTalents().getAll(TieredSkill.class, TieredSkill::isUnlocked);
    }

    protected List<TieredSkill> getTemplateAbilities() {
        SkillAltarData.SkillTemplate template = ((SkillAltarContainer)this.m_6262_()).getTemplate();
        if (template == null) {
            return Collections.emptyList();
        }
        return this.getTemplateAbilities(template);
    }

    protected List<TieredSkill> getTemplateAbilities(SkillAltarData.SkillTemplate template) {
        return template.getAbilities().getAll(SpecializedSkill.class, SpecializedSkill::isUnlocked).stream().map(SpecializedSkill::getSpecialization).map(TieredSkill.class::cast).toList();
    }

    protected boolean areSkillsEqual(List<TieredSkill> skillsA, List<TieredSkill> skillsB) {
        if (skillsA.size() != skillsB.size()) {
            return false;
        }
        List<TieredSkill> sortedByNameA = skillsA.stream().sorted(Comparator.comparing(Skill::getId)).toList();
        List<TieredSkill> sortedByNameB = skillsB.stream().sorted(Comparator.comparing(Skill::getId)).toList();
        for (int i = 0; i < sortedByNameA.size(); ++i) {
            TieredSkill skillA = sortedByNameA.get(i);
            TieredSkill skillB = sortedByNameB.get(i);
            if (skillA.getId().equals(skillB.getId()) && skillA.getUnmodifiedTier() == skillB.getUnmodifiedTier()) continue;
            return false;
        }
        return true;
    }

    public static class Default
    extends SkillAltarScreen<SkillAltarContainer.Default> {
        private final ButtonElement<?> loadButton;
        private final ButtonElement<?> saveButton;
        private final SkillView skillView;
        private boolean isSaveLocked = true;
        @Nullable
        private List<Component> loadTooltip = null;
        @Nullable
        private List<Component> saveTooltip = null;
        private final boolean abilitiesTalentsEqual;
        private final int numberOfOrbsRequired;
        private String overlayMessageString;
        private int overlayMessageTime;

        public Default(SkillAltarContainer.Default container, Inventory inventory, Component title) {
            super(container, inventory, title);
            MutableComponent inventoryName = inventory.m_5446_().m_6881_();
            inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
            this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, ((SkillAltarContainer.Default)this.m_6262_()).m_38853_((int)0).f_40221_ - 12), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
            this.abilitiesTalentsEqual = this.areAbilitiesAndTalentsEqual();
            this.numberOfOrbsRequired = ((SkillAltarContainer.Default)this.m_6262_()).getNumberOfRegretOrbsRequired();
            this.skillView = this.createSkillView();
            this.addElement(this.skillView);
            this.addElement((SlotsElement)new SlotsElement((MenuAccess<?>)this).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
            ButtonElement.ButtonTextures buttonTextures = ScreenTextures.BUTTON_SKILL_ALTAR_SAVE_TEXTURES;
            this.saveButton = this.addElement((ButtonElement)new ButtonElement(Spatials.positionXY(this.f_97726_ / 4 - buttonTextures.button().width() / 2, 99), buttonTextures, ((SkillAltarContainer.Default)this.m_6262_())::saveTemplate).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
            this.saveButton.setDisabled(() -> this.playerHasNoAbilitiesAndTalents() || !((SkillAltarContainer.Default)this.m_6262_()).isEmptyTemplate() && this.isSaveLocked || this.abilitiesTalentsEqual || ((SkillAltarContainer.Default)this.m_6262_()).isOpenedByNonOwner());
            this.saveButton.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
                tooltipRenderer.renderComponentTooltip(poseStack, this.getSaveButtonTooltip(), mouseX, mouseY, TooltipDirection.RIGHT);
                return true;
            });
            if (!((SkillAltarContainer.Default)this.m_6262_()).isEmptyTemplate()) {
                this.addElement((LockButton)new LockButton(Spatials.positionX(-10).translateXY(this.saveButton), () -> {
                    this.isSaveLocked = !this.isSaveLocked;
                }).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
            }
            buttonTextures = ScreenTextures.BUTTON_SKILL_ALTAR_LOAD_TEXTURES;
            this.loadButton = this.addElement((ButtonElement)new ButtonElement(Spatials.positionXY(3 * (this.f_97726_ / 4) - buttonTextures.button().width() / 2, 99), buttonTextures, () -> ((SkillAltarContainer.Default)this.m_6262_()).setPlayerAbilitiesAndTalentsFromTemplate()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
            this.loadButton.setDisabled(() -> ((SkillAltarContainer.Default)this.m_6262_()).isEmptyTemplate() || this.abilitiesTalentsEqual || ((SkillAltarContainer.Default)this.m_6262_()).isOpenedByNonOwner() || ((SkillAltarContainer.Default)this.m_6262_()).getNumberOfMissingRegretOrbs() > 0 || ((SkillAltarContainer.Default)this.m_6262_()).getMissingSkillPointsClient() > 0);
            this.loadButton.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
                tooltipRenderer.renderComponentTooltip(poseStack, this.getLoadButtonTooltip(), mouseX, mouseY, TooltipDirection.RIGHT);
                return true;
            });
            buttonTextures = ScreenTextures.BUTTON_SKILL_ALTAR_SHARE_TEXTURES;
            ((ButtonElement)this.addElement((ButtonElement)new ButtonElement(Spatials.positionXY(this.f_97726_ + 2, 7), buttonTextures, () -> {
                ((SkillAltarContainer.Default)this.m_6262_()).shareInChat();
                this.overlayMessageString = "Shared in chat";
                this.overlayMessageTime = 80;
            }).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui))).tooltip(() -> new TextComponent("Share in chat"))).setDisabled(((SkillAltarContainer.Default)this.m_6262_()).isEmptyTemplate() || ((SkillAltarContainer.Default)this.m_6262_()).isOpenedByNonOwner());
            buttonTextures = ScreenTextures.BUTTON_SKILL_ALTAR_COPY_TEXTURES;
            ((ButtonElement)this.addElement((ButtonElement)new ButtonElement(Spatials.positionXY(this.f_97726_ + 2, 29), buttonTextures, () -> {
                ((SkillAltarContainer.Default)this.m_6262_()).copyToClipboard();
                this.overlayMessageString = "Copied to clipboard";
                this.overlayMessageTime = 80;
            }).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui))).tooltip(() -> new TextComponent("Copy to clipboard"))).setDisabled(((SkillAltarContainer.Default)this.m_6262_()).isEmptyTemplate() || ((SkillAltarContainer.Default)this.m_6262_()).isOpenedByNonOwner());
            buttonTextures = ScreenTextures.BUTTON_SKILL_ALTAR_IMPORT_TEXTURES;
            ((ButtonElement)this.addElement((ButtonElement)new ButtonElement(Spatials.positionXY(this.f_97726_ + 2, 51), buttonTextures, () -> ((SkillAltarContainer.Default)this.m_6262_()).openImportScreen(((SkillAltarContainer.Default)this.m_6262_()).getTemplateIndex())).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui))).tooltip(() -> new TextComponent("Import"))).setDisabled(((SkillAltarContainer.Default)this.m_6262_()).isOpenedByNonOwner());
        }

        private SkillView createSkillView() {
            return (SkillView)new SkillView((ISpatial)Spatials.positionXY(7, 16).size(177, 81), ((SkillAltarContainer.Default)this.m_6262_()).getTemplate(), icon -> ((SkillAltarContainer.Default)this.m_6262_()).updateTemplateIcon((SkillAltarData.SkillIcon)icon)).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        }

        private boolean playerHasNoAbilitiesAndTalents() {
            return this.getPlayerAbilities().isEmpty() && this.getPlayerTalents().isEmpty();
        }

        private List<TieredSkill> getPlayerAbilities() {
            return ClientAbilityData.getLearnedAbilities();
        }

        private List<TieredSkill> getPlayerTalents() {
            return ClientTalentData.getLearnedTalentNodes();
        }

        private List<Component> getLoadButtonTooltip() {
            if (this.loadTooltip != null) {
                return this.loadTooltip;
            }
            this.loadTooltip = new ArrayList<Component>();
            if (((SkillAltarContainer.Default)this.m_6262_()).isOpenedByNonOwner()) {
                this.loadTooltip.add((Component)new TranslatableComponent("screen.the_vault.skill_altar.tooltip.load.not_owner").m_130940_(ChatFormatting.RED));
            } else {
                if (((SkillAltarContainer.Default)this.m_6262_()).isEmptyTemplate()) {
                    this.loadTooltip = List.of(new TranslatableComponent("screen.the_vault.skill_altar.tooltip.load.no_abilities_talents").m_130940_(ChatFormatting.RED));
                    return this.loadTooltip;
                }
                if (this.abilitiesTalentsEqual) {
                    this.loadTooltip = List.of(new TranslatableComponent("screen.the_vault.skill_altar.tooltip.load.same_abilities_talents").m_130940_(ChatFormatting.YELLOW));
                    return this.loadTooltip;
                }
                if (((SkillAltarContainer.Default)this.m_6262_()).getNumberOfMissingRegretOrbs() > 0) {
                    this.loadTooltip.add((Component)new TranslatableComponent("screen.the_vault.skill_altar.tooltip.load.missing_orbs", new Object[]{((SkillAltarContainer.Default)this.m_6262_()).getNumberOfMissingRegretOrbs()}).m_130940_(ChatFormatting.RED));
                } else if (((SkillAltarContainer.Default)this.m_6262_()).getMissingSkillPointsClient() > 0) {
                    this.loadTooltip.add((Component)new TranslatableComponent("screen.the_vault.skill_altar.tooltip.load.missing_skill_points", new Object[]{((SkillAltarContainer.Default)this.m_6262_()).getMissingSkillPointsClient()}).m_130940_(ChatFormatting.RED));
                } else {
                    this.loadTooltip.add((Component)new TranslatableComponent("screen.the_vault.skill_altar.tooltip.load"));
                    this.loadTooltip.add((Component)new TranslatableComponent("screen.the_vault.skill_altar.tooltip.load.cost", new Object[]{this.numberOfOrbsRequired}).m_130940_(ChatFormatting.DARK_GRAY));
                }
            }
            if (((SkillAltarContainer.Default)this.m_6262_()).isEmptyTemplate()) {
                return this.loadTooltip;
            }
            this.loadTooltip.addAll(this.getSkillDifferencesTooltip(this.getPlayerAbilities(), this.getTemplateAbilities(), this.getPlayerTalents(), this.getTemplateTalents()));
            return this.loadTooltip;
        }

        private List<Component> getSaveButtonTooltip() {
            if (this.saveTooltip != null) {
                return this.saveTooltip;
            }
            this.saveTooltip = new ArrayList<Component>();
            if (((SkillAltarContainer.Default)this.m_6262_()).isOpenedByNonOwner()) {
                this.saveTooltip.add((Component)new TranslatableComponent("screen.the_vault.skill_altar.tooltip.save.not_owner").m_130940_(ChatFormatting.RED));
            } else {
                if (this.playerHasNoAbilitiesAndTalents()) {
                    this.saveTooltip = List.of(new TranslatableComponent("screen.the_vault.skill_altar.tooltip.save.no_abilities_talents").m_130940_(ChatFormatting.RED));
                    return this.saveTooltip;
                }
                if (this.abilitiesTalentsEqual) {
                    this.saveTooltip = List.of(new TranslatableComponent("screen.the_vault.skill_altar.tooltip.save.same_abilities_talents").m_130940_(ChatFormatting.YELLOW));
                    return this.saveTooltip;
                }
                if (!((SkillAltarContainer.Default)this.m_6262_()).isEmptyTemplate() && this.isSaveLocked) {
                    this.saveTooltip = List.of(new TranslatableComponent("screen.the_vault.skill_altar.tooltip.save.unlock_required").m_130940_(ChatFormatting.RED));
                    return this.saveTooltip;
                }
                this.saveTooltip.add((Component)new TranslatableComponent("screen.the_vault.skill_altar.tooltip.save"));
            }
            List<TieredSkill> templateAbilities = ((SkillAltarContainer.Default)this.m_6262_()).getTemplate() != null ? this.getTemplateAbilities() : Collections.emptyList();
            List<TieredSkill> templateTalents = ((SkillAltarContainer.Default)this.m_6262_()).getTemplate() != null ? this.getTemplateTalents() : Collections.emptyList();
            this.saveTooltip.addAll(this.getSkillDifferencesTooltip(templateAbilities, this.getPlayerAbilities(), templateTalents, this.getPlayerTalents()));
            return this.saveTooltip;
        }

        @Override
        public void m_94757_(double mouseX, double mouseY) {
            super.m_94757_(mouseX, mouseY);
            if (this.loadTooltip != null && !this.loadButton.m_5953_(mouseX, mouseY)) {
                this.loadTooltip = null;
            } else if (this.saveTooltip != null && !this.saveButton.m_5953_(mouseX, mouseY)) {
                this.saveTooltip = null;
            }
        }

        public boolean areAbilitiesAndTalentsEqual() {
            SkillAltarData.SkillTemplate template = ((SkillAltarContainer.Default)this.m_6262_()).getTemplate();
            if (template == null) {
                return false;
            }
            return this.areSkillsEqual(this.getPlayerAbilities(), this.getTemplateAbilities()) && this.areSkillsEqual(this.getPlayerTalents(), this.getTemplateTalents());
        }

        protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType clickType) {
            super.m_6597_(slot, slotId, mouseButton, clickType);
            this.loadTooltip = null;
        }

        public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
            this.skillView.stopDragging();
            return super.m_6348_(pMouseX, pMouseY, pButton);
        }

        @Override
        public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super.m_6305_(poseStack, mouseX, mouseY, partialTick);
            this.showOverlayMessage(poseStack, (float)this.skillView.x() + (float)this.skillView.width() / 2.0f - 8.0f, (float)this.skillView.y() + (float)this.skillView.height() / 2.0f, partialTick);
        }

        private void showOverlayMessage(PoseStack poseStack, double x, double y, float partialTicks) {
            if (this.overlayMessageString != null && this.overlayMessageTime > 0) {
                float time = (float)this.overlayMessageTime - partialTicks;
                int opacity = (int)(time * 255.0f / 20.0f);
                if (opacity > 255) {
                    opacity = 255;
                }
                if (opacity > 8) {
                    poseStack.m_85836_();
                    poseStack.m_85837_(x, y, 0.0);
                    RenderSystem.m_69478_();
                    RenderSystem.m_69453_();
                    int k1 = 0xFFFFFF;
                    int k = opacity << 24 & 0xFF000000;
                    int width = this.f_96547_.m_92895_(this.overlayMessageString);
                    int i = -1157627904;
                    if (i != 0) {
                        int j = -width / 2;
                        int padding = 4;
                        Default.m_93172_((PoseStack)poseStack, (int)(j - padding - 1), (int)(-5 - padding), (int)(j + width + padding), (int)(5 + padding), (int)FastColor.ARGB32.m_13657_((int)i, (int)(0xFFFFFF | k)));
                    }
                    this.f_96547_.m_92883_(poseStack, this.overlayMessageString, (float)(-width) / 2.0f, -4.0f, k1 | k);
                    RenderSystem.m_69461_();
                    poseStack.m_85849_();
                }
            }
            if (this.overlayMessageTime > 0) {
                --this.overlayMessageTime;
            } else if (this.overlayMessageString != null) {
                this.overlayMessageString = null;
            }
        }

        private class LockButton
        extends ButtonElement<LockButton> {
            public LockButton(IPosition position, Runnable onClick) {
                super(position, ScreenTextures.BUTTON_TOGGLE_OFF_TEXTURES, onClick);
            }

            @Override
            public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
                ButtonElement.ButtonTextures textures = Default.this.isSaveLocked ? ScreenTextures.BUTTON_TOGGLE_OFF_TEXTURES : ScreenTextures.BUTTON_TOGGLE_ON_TEXTURES;
                TextureAtlasRegion texture = textures.selectTexture(this.isDisabled(), this.containsMouse(mouseX, mouseY), false);
                renderer.render(texture, poseStack, (IPosition)this.worldSpatial);
            }
        }
    }

    public static class Import
    extends SkillAltarScreen<SkillAltarContainer.Import> {
        private final ButtonElement<?> importButton;
        private final TextInputElement<?> templateInput;
        private final LabelElement<?> validationError;
        private List<Component> importTooltip;
        private SkillAltarData.DeserializationResult<SkillAltarData.SkillTemplate> templateDeserializationResult;

        public Import(SkillAltarContainer.Import container, Inventory inventory, Component title) {
            super(container, inventory, title);
            int usableWidth = this.getGuiSpatial().width() - 14;
            this.validationError = this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(10, 50), Spatials.width(usableWidth - 10), LabelTextStyle.defaultStyle().wrap().shadow()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
            this.validationError.setVisible(false);
            this.templateInput = this.addElement(new TextInputElement(Spatials.positionXY(7, 18).size(Spatials.size(usableWidth, 12)), Minecraft.m_91087_().f_91062_));
            this.templateInput.setMaxLength(2000);
            this.templateInput.layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
            this.templateInput.onTextChanged(this::onInputChange);
            ButtonElement.ButtonTextures buttonTextures = ScreenTextures.BUTTON_SKILL_ALTAR_IMPORT_TEXTURES;
            this.importButton = this.addElement((ButtonElement)new ButtonElement(Spatials.positionXY(this.f_97726_ - 7 - 18, 34), buttonTextures, () -> ((SkillAltarContainer.Import)this.m_6262_()).importTemplate(this.templateInput.getInput())).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
            this.importButton.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
                tooltipRenderer.renderComponentTooltip(poseStack, this.getImportTooltip(), mouseX, mouseY, TooltipDirection.RIGHT);
                return true;
            });
            this.importButton.setDisabled(true);
            this.addElement((ButtonElement)new ButtonElement(Spatials.positionXY(this.f_97726_ + 2, 51), ScreenTextures.BUTTON_SKILL_ALTAR_BACK_TEXTURES, () -> ((SkillAltarContainer.Import)this.m_6262_()).openTab(((SkillAltarContainer.Import)this.m_6262_()).getTemplateIndex())).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui))).tooltip(() -> new TextComponent("Back"));
        }

        private void onInputChange(String text) {
            boolean displayValidationError;
            this.importTooltip = null;
            this.templateDeserializationResult = SkillAltarData.SkillTemplate.fromString(text);
            boolean bl = displayValidationError = !text.trim().isEmpty() && !this.templateDeserializationResult.valid();
            if (displayValidationError) {
                this.validationError.set((Component)new TextComponent(this.templateDeserializationResult.message()).m_130940_(ChatFormatting.RED));
            }
            this.validationError.setVisible(displayValidationError);
            this.importButton.setDisabled(!this.templateDeserializationResult.valid() || ((SkillAltarContainer.Import)this.m_6262_()).getTemplate() != null && this.areSkillsEqual(this.getTemplateAbilities(), this.getTemplateAbilities(this.templateDeserializationResult.deserializedValue())) && this.areSkillsEqual(this.getTemplateTalents(), this.getTemplateTalents(this.templateDeserializationResult.deserializedValue())));
        }

        private List<Component> getImportTooltip() {
            if (this.importTooltip == null) {
                this.importTooltip = new ArrayList<Component>();
                this.importTooltip.add((Component)new TextComponent("Import abilities and talents"));
                if (this.templateDeserializationResult != null && this.templateDeserializationResult.valid()) {
                    if (this.areSkillsEqual(this.getTemplateAbilities(), this.getTemplateAbilities(this.templateDeserializationResult.deserializedValue())) && this.areSkillsEqual(this.getTemplateTalents(), this.getTemplateTalents(this.templateDeserializationResult.deserializedValue()))) {
                        this.importTooltip.add((Component)new TextComponent("Abilities and Talents match the saved template").m_130940_(ChatFormatting.RED));
                    } else {
                        this.importTooltip.addAll(this.getSkillDifferencesTooltip(this.getTemplateAbilities(), this.getTemplateAbilities(this.templateDeserializationResult.deserializedValue()), this.getTemplateTalents(), this.getTemplateTalents(this.templateDeserializationResult.deserializedValue())));
                    }
                } else {
                    this.importTooltip.add((Component)new TextComponent("Invalid data in input field").m_130940_(ChatFormatting.RED));
                }
            }
            return this.importTooltip;
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 256) {
                ((SkillAltarContainer.Import)this.m_6262_()).openTab(((SkillAltarContainer.Import)this.m_6262_()).getTemplateIndex());
                return true;
            }
            return this.m_7222_() != null && this.m_7222_().m_7933_(keyCode, scanCode, modifiers);
        }
    }

    private static class TalentElement
    extends AbstractSpatialElement<TalentElement>
    implements IRenderedElement,
    IGuiEventElement {
        private static final int MAX_PIPS_IN_COLUMN = 3;
        private static final TextureAtlasRegion PIP = TextureAtlasRegion.of(ModTextureAtlases.SCREEN, VaultMod.id("gui/screen/skill_altar/talent_pip"));
        private final Map<NodeState, TextureAtlasRegion> background;
        private boolean visible = true;
        private final TextureAtlasRegion icon;
        private final int tier;

        public TalentElement(ISpatial spatial, String skillId, int tier) {
            super(spatial);
            SkillStyle skillStyle = ModConfigs.TALENTS_GUI.getStyles().get(skillId);
            this.icon = TextureAtlasRegion.of(ModTextureAtlases.SKILLS, skillStyle.icon);
            this.background = AbilityNodeTextures.SECONDARY_NODE;
            this.tier = tier;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            this.renderIcon(renderer, poseStack);
        }

        public void renderIcon(IElementRenderer renderer, PoseStack poseStack) {
            this.background.get((Object)NodeState.DEFAULT).blit(poseStack, this.worldSpatial.x() + 24, this.worldSpatial.y());
            this.icon.blit(poseStack, this.worldSpatial.x() + 24 + 3, this.worldSpatial.y() + 3);
            this.renderPips(renderer, poseStack);
        }

        public void renderPips(IElementRenderer renderer, PoseStack poseStack) {
            int columnCount = (int)Math.ceil((double)this.tier / 3.0);
            int remainingPips = this.tier;
            for (int column = 0; column < columnCount && remainingPips > 0; ++column) {
                for (int row = 0; row < 3 && remainingPips > 0; --remainingPips, ++row) {
                    renderer.render(PIP, poseStack, Spatials.positionXY(18 - column * 6, 14 - row * 6).translateXY(this.worldSpatial), Spatials.size(6, 6));
                }
            }
        }

        @Override
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }
    }

    private static class AbilityElement
    extends AbstractSpatialElement<AbilityElement>
    implements IRenderedElement,
    IGuiEventElement {
        private final int tier;
        private final Map<NodeState, TextureAtlasRegion> background;
        private final TextureAtlasRegion icon;
        private final TextureAtlasRegion levelBackground;
        private boolean visible = true;

        public AbilityElement(ISpatial spatial, int tier, Map<NodeState, TextureAtlasRegion> background, TextureAtlasRegion icon) {
            super(spatial);
            this.tier = tier;
            this.background = background;
            this.icon = icon;
            this.levelBackground = AbilityNodeTextures.NODE_BACKGROUND_LEVEL;
        }

        @Override
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            if (!this.visible) {
                return;
            }
            this.renderLevel(poseStack);
            this.background.get((Object)NodeState.DEFAULT).blit(poseStack, this.worldSpatial.x() + this.levelBackground.width() - 4, this.worldSpatial.y());
            this.icon.blit(poseStack, this.worldSpatial.x() + this.levelBackground.width() - 4 + 3, this.worldSpatial.y() + 3);
        }

        private void renderLevel(PoseStack poseStack) {
            if (this.tier == 0) {
                return;
            }
            poseStack.m_85836_();
            this.levelBackground.blit(poseStack, this.worldSpatial.x(), this.worldSpatial.y() + this.height() / 2 - this.levelBackground.height() / 2);
            Font font = Minecraft.m_91087_().f_91062_;
            String text = String.valueOf(this.tier);
            float f = (float)this.left() + (float)this.levelBackground.width() / 2.0f - (float)font.m_92895_(text) / 2.0f;
            float f2 = (float)this.top() + (float)this.height() / 2.0f;
            Objects.requireNonNull(font);
            font.m_92883_(poseStack, text, f, f2 - 9.0f / 2.0f + 1.0f, -1);
            RenderSystem.m_69482_();
        }
    }

    private static class SkillView
    extends VerticalScrollClipContainer<SkillView> {
        private static final NineSlice.TextureRegion SKILL_ALTAR_SCROLL_BACKGROUND = NineSlice.region(ModTextureAtlases.SCREEN, VaultMod.id("gui/screen/skill_altar/scroll_background"), NineSlice.slice(1, 1, 1, 1), NineSlice.CenterDrawMode.Tiled);
        private static final double SCROLL_SENSITIVITY = 0.5;
        private double mouseDragY = 0.0;
        private boolean dragging = false;

        public SkillView(ISpatial spatial, @Nullable SkillAltarData.SkillTemplate template, final Consumer<SkillAltarData.SkillIcon> onIconClicked) {
            super(spatial, Padding.ZERO, SKILL_ALTAR_SCROLL_BACKGROUND);
            this.verticalScrollBarElement.setVisible(false);
            this.verticalScrollBarElement.setEnabled(false);
            if (template == null) {
                return;
            }
            int i = 0;
            List<SpecializedSkill> templateAbilities = template.getAbilities().getAll(SpecializedSkill.class, SpecializedSkill::isUnlocked).stream().sorted(SkillAltarData.SPECIALIZED_SKILL_HIGHEST_LEVEL_COMPARATOR).toList();
            for (final SpecializedSkill ability : templateAbilities) {
                if (!ModConfigs.ABILITIES_GUI.getStyles().containsKey(ability.getId())) continue;
                int n = i / 2 * 24;
                int abilityX = i % 2 * 44;
                this.addElement(new AbilityElement(Spatials.positionXY(abilityX, n).size(32, 22), ((TieredSkill)ability.getSpecialization()).getUnmodifiedTier(), AbilityNodeTextures.SECONDARY_NODE, TextureAtlasRegion.of(ModTextureAtlases.ABILITIES, ModConfigs.ABILITIES_GUI.getIcon(ability.getSpecialization().getId()))){

                    @Override
                    public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
                        onIconClicked.accept(new SkillAltarData.SkillIcon(ability.getSpecialization().getId(), false));
                        return true;
                    }
                });
                ++i;
            }
            List<? super TieredSkill> templateTalents = template.getTalents().getAll(TieredSkill.class, TieredSkill::isUnlocked).stream().sorted(SkillAltarData.TIERED_SKILL_HIGHEST_LEVEL_COMPARATOR).toList();
            i = 0;
            for (final TieredSkill tieredSkill : templateTalents) {
                if (!ModConfigs.TALENTS_GUI.getStyles().containsKey(tieredSkill.getId())) continue;
                this.addElement(new TalentElement(Spatials.positionXY(79 + i % 2 * 36, i / 2 * 24).size(45, 22), tieredSkill.getId(), tieredSkill.getUnmodifiedTier()){

                    @Override
                    public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
                        onIconClicked.accept(new SkillAltarData.SkillIcon(tieredSkill.getId(), true));
                        return true;
                    }
                });
                ++i;
            }
        }

        @Override
        public boolean m_5953_(double mouseX, double mouseY) {
            return !this.verticalScrollBarElement.m_5953_(mouseX, mouseY) && super.m_5953_(mouseX, mouseY);
        }

        @Override
        public boolean containsMouse(double x, double y) {
            return !this.verticalScrollBarElement.containsMouse(x, y) && this.worldSpatial.contains(x, y);
        }

        @Override
        public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
            if (this.verticalScrollBarElement.m_5953_(mouseX, mouseY)) {
                return false;
            }
            double heightDiff = Math.max(this.innerContainerElement.height() - this.clipContainerElement.height(), 0);
            if (heightDiff == 0.0) {
                return false;
            }
            double change = Math.min(heightDiff, 10.0) / heightDiff * delta;
            this.verticalScrollBarElement.setValue((float)Mth.m_14008_((double)((double)this.verticalScrollBarElement.getValue() - change), (double)0.0, (double)1.0));
            this.onScrollbarValueChanged(this.verticalScrollBarElement.getValue());
            return true;
        }

        @Override
        public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
            if (this.verticalScrollBarElement.m_5953_(mouseX, mouseY)) {
                return false;
            }
            this.mouseDragY = mouseY;
            this.dragging = true;
            super.onMouseClicked(mouseX, mouseY, buttonIndex);
            return true;
        }

        @Override
        public void onMouseMoved(double mouseX, double mouseY) {
            if (this.dragging) {
                int diffHeight = this.innerContainerElement.height() - this.clipContainerElement.height();
                double change = (this.mouseDragY - mouseY) / (double)diffHeight;
                this.mouseDragY = mouseY;
                this.verticalScrollBarElement.setValue((float)Mth.m_14008_((double)(change + (double)this.verticalScrollBarElement.getValue()), (double)0.0, (double)1.0));
                this.onScrollbarValueChanged(this.verticalScrollBarElement.getValue());
            }
            super.onMouseMoved(mouseX, mouseY);
        }

        @Override
        public boolean onMouseReleased(double mouseX, double mouseY, int buttonIndex) {
            this.dragging = false;
            return super.onMouseReleased(mouseX, mouseY, buttonIndex);
        }

        public void stopDragging() {
            this.dragging = false;
        }
    }
}

