/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.block.entity.SpiritExtractorTileEntity;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.FakeItemSlotElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.ScrollableItemStackSelectorElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.container.SpiritExtractorContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SpiritExtractorScreen
extends AbstractElementContainerScreen<SpiritExtractorContainer> {
    public SpiritExtractorScreen(SpiritExtractorContainer container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        this.setGuiSize(Spatials.size(176, 182));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXY(0, -10).size(0, 10), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).size(Spatials.copy(gui).add(Spatials.size(0, 10)))));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(7, -4), (Component)new TextComponent("Spirit Extractor").m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((ScrollableItemStackSelectorElement)new ScrollableItemStackSelectorElement((ISpatial)Spatials.positionXY(7, 6).height(54), 8, new ScrollableItemStackSelectorElement.SelectorModel<ScrollableItemStackSelectorElement.ItemSelectorEntry>(){

            @Override
            public List<ScrollableItemStackSelectorElement.ItemSelectorEntry> getEntries() {
                return ((SpiritExtractorContainer)SpiritExtractorScreen.this.m_6262_()).getStoredItems().stream().map(ItemSelectorWithTooltipEntry::new).collect(Collectors.toList());
            }
        }).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        MutableComponent inventoryName = inventory.m_5446_().m_6881_();
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, ((SpiritExtractorContainer)this.m_6262_()).m_38853_((int)0).f_40221_ - 12), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((SlotsElement)new SlotsElement((MenuAccess<?>)this).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(-36, -10, -10).size(41, 27), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        ButtonElement recycleButton = (ButtonElement)new ButtonElement(Spatials.positionXY(-31, -6), ScreenTextures.BUTTON_BUTTON_REROLL_TEXTURES, () -> ((SpiritExtractorContainer)this.m_6262_()).recycle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        recycleButton.setDisabled(() -> !((SpiritExtractorContainer)this.m_6262_()).isRecycleUnlocked() || !((SpiritExtractorContainer)this.m_6262_()).hasSpirit() || ((SpiritExtractorContainer)this.m_6262_()).isSpewingItems());
        recycleButton.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
            tooltipRenderer.renderComponentTooltip(poseStack, this.getRecycleButtonTooltipLines(), mouseX, mouseY, TooltipDirection.RIGHT);
            return true;
        });
        this.addElement(recycleButton);
        ButtonElement recycleLockButton = (ButtonElement)new RecycleLockButton(Spatials.positionXY(-12, -6), () -> ((SpiritExtractorContainer)this.m_6262_()).toggleRecycleLock()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        this.addElement(recycleLockButton);
        this.addElement((DynamicLabel)new DynamicLabel(Spatials.positionXY(26, 74), () -> new TranslatableComponent("screen.the_vault.spirit_extractor.debt", new Object[]{((SpiritExtractorContainer)this.m_6262_()).getDebt()}).m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle(), new TextComponent("")).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        ButtonElement purchaseButton = (ButtonElement)new ButtonElement(Spatials.positionXY(150, 69), ScreenTextures.BUTTON_PAY_TEXTURES, () -> ((SpiritExtractorContainer)this.m_6262_()).startSpewingItems()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        purchaseButton.setDisabled(() -> !((SpiritExtractorContainer)this.m_6262_()).hasSpirit() || ((SpiritExtractorContainer)this.m_6262_()).isSpewingItems() || !((SpiritExtractorContainer)this.m_6262_()).coinsCoverTotalCost((Player)this.f_96541_.f_91074_));
        purchaseButton.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
            tooltipRenderer.renderComponentTooltip(poseStack, this.getPurchaseButtonTooltipLines(), mouseX, mouseY, TooltipDirection.RIGHT);
            return true;
        });
        this.addElement(purchaseButton);
        ButtonElement placeholderButton = (ButtonElement)new ButtonElement(Spatials.positionXY(5, 69), ScreenTextures.BUTTON_DEBT_TEXTURES, () -> {
            if (((SpiritExtractorContainer)this.m_6262_()).hasSpirit()) {
                ((SpiritExtractorContainer)this.m_6262_()).startDebtRevive();
            } else {
                ((SpiritExtractorContainer)this.m_6262_()).payDebt();
            }
        }).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        placeholderButton.setDisabled(() -> {
            if (!((SpiritExtractorContainer)this.m_6262_()).isLockerEnabled()) {
                return true;
            }
            if (((SpiritExtractorContainer)this.m_6262_()).hasSpirit()) {
                return ((SpiritExtractorContainer)this.m_6262_()).coinsCoverTotalCost((Player)this.f_96541_.f_91074_) || ((SpiritExtractorContainer)this.m_6262_()).isSpewingItems();
            }
            return ((SpiritExtractorContainer)this.m_6262_()).getDebt() <= 0 || !((SpiritExtractorContainer)this.m_6262_()).coinsCoverDebt((Player)this.f_96541_.f_91074_);
        });
        placeholderButton.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
            tooltipRenderer.renderComponentTooltip(poseStack, this.getDebtButtonTooltipLines(), mouseX, mouseY, TooltipDirection.RIGHT);
            return true;
        });
        this.addElement(placeholderButton);
    }

    private List<Component> getRecycleButtonTooltipLines() {
        if (!((SpiritExtractorContainer)this.m_6262_()).hasSpirit()) {
            return Collections.emptyList();
        }
        ArrayList<Component> ret = new ArrayList<Component>();
        ret.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.recycle").m_130940_(ChatFormatting.WHITE));
        ret.add(TextComponent.f_131282_);
        if (!((SpiritExtractorContainer)this.m_6262_()).isRecyclable()) {
            ret.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.not_recyclable").m_130940_(ChatFormatting.RED));
            ret.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.not_recyclable_will_delete").m_130940_(ChatFormatting.RED));
        } else if (((SpiritExtractorContainer)this.m_6262_()).isRecycleUnlocked()) {
            ret.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.recycle_unlocked").m_130940_(ChatFormatting.GRAY));
            ret.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.recycle_warning").m_130940_(ChatFormatting.RED));
        } else {
            ret.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.recycle_locked").m_130940_(ChatFormatting.GRAY));
        }
        return ret;
    }

    @NotNull
    private List<Component> getPurchaseButtonTooltipLines() {
        ArrayList<Component> purchaseButtonTooltips = new ArrayList<Component>();
        SpiritExtractorTileEntity.RecoveryCost recoveryCost = ((SpiritExtractorContainer)this.m_6262_()).getRecoveryCost();
        ItemStack totalCost = recoveryCost.getTotalCost();
        if (totalCost.m_41613_() > 0) {
            float rescuedBonus;
            if (((SpiritExtractorContainer)this.m_6262_()).hasSpirit()) {
                purchaseButtonTooltips.add((Component)new TextComponent("Cost for recovering items"));
                int availableGold = ((SpiritExtractorContainer)this.m_6262_()).getPlayerInventoryGold((Player)this.f_96541_.f_91074_);
                ChatFormatting textColor = availableGold < totalCost.m_41613_() ? ChatFormatting.RED : ChatFormatting.YELLOW;
                purchaseButtonTooltips.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.total_cost", new Object[]{availableGold, totalCost.m_41720_().m_7626_(totalCost).getString(), totalCost.m_41613_()}).m_130940_(textColor));
            } else {
                purchaseButtonTooltips.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.would_be_cost", new Object[]{totalCost.m_41613_(), totalCost.m_41720_().m_7626_(totalCost).getString()}).m_130940_(ChatFormatting.GREEN));
            }
            purchaseButtonTooltips.add(TextComponent.f_131282_);
            float baseCostCount = recoveryCost.getBaseCount();
            int levels = Math.max(1, ((SpiritExtractorContainer)this.m_6262_()).getPlayerLevel());
            purchaseButtonTooltips.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.base_cost", new Object[]{String.format("%.0f", Float.valueOf(baseCostCount * (float)levels + 1.0f)), String.format("%.2f", Float.valueOf(baseCostCount)), levels}).m_130940_(ChatFormatting.GRAY));
            recoveryCost.getStackCost().forEach(t -> purchaseButtonTooltips.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.item_cost", new Object[]{t.m_14419_(), ((ItemStack)t.m_14418_()).m_41786_()}).m_130940_(ChatFormatting.GRAY)));
            int debt = ((SpiritExtractorContainer)this.m_6262_()).getDebt();
            if (debt > 0) {
                purchaseButtonTooltips.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.debt", new Object[]{debt}).m_130940_(ChatFormatting.RED));
            }
            if ((rescuedBonus = ((SpiritExtractorContainer)this.m_6262_()).getRescuedBonus()) > 0.0f) {
                purchaseButtonTooltips.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.rescued_bonus", new Object[]{String.format("%.0f%%", Float.valueOf(rescuedBonus * 100.0f))}).m_130940_(ChatFormatting.GRAY));
            }
        }
        return purchaseButtonTooltips;
    }

    private List<Component> getDebtButtonTooltipLines() {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (!((SpiritExtractorContainer)this.m_6262_()).isLockerEnabled()) {
            lines.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.locker_disabled").m_130940_(ChatFormatting.RED));
            return lines;
        }
        if (((SpiritExtractorContainer)this.m_6262_()).hasSpirit()) {
            int totalCost = ((SpiritExtractorContainer)this.m_6262_()).getRecoveryCost().getTotalCost().m_41613_();
            int totalDebt = ((SpiritExtractorContainer)this.m_6262_()).getDebt();
            lines.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.debt_warning").m_130940_(ChatFormatting.RED));
            lines.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.debt", new Object[]{totalCost - totalDebt}).m_130940_(ChatFormatting.RED));
            lines.add(TextComponent.f_131282_);
            lines.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.debt_info").m_130940_(ChatFormatting.RED));
        } else {
            lines.add((Component)new TextComponent("Pay your debt"));
            lines.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.debt", new Object[]{((SpiritExtractorContainer)this.m_6262_()).getDebt()}).m_130940_(ChatFormatting.YELLOW));
        }
        return lines;
    }

    private class RecycleLockButton
    extends ButtonElement<RecycleLockButton> {
        public RecycleLockButton(IPosition position, Runnable onClick) {
            super(position, ScreenTextures.BUTTON_TOGGLE_OFF_TEXTURES, onClick);
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            ButtonElement.ButtonTextures textures = ((SpiritExtractorContainer)SpiritExtractorScreen.this.m_6262_()).isRecycleUnlocked() ? ScreenTextures.BUTTON_TOGGLE_ON_TEXTURES : ScreenTextures.BUTTON_TOGGLE_OFF_TEXTURES;
            TextureAtlasRegion texture = textures.selectTexture(this.isDisabled(), this.containsMouse(mouseX, mouseY), false);
            renderer.render(texture, poseStack, (IPosition)this.worldSpatial);
        }
    }

    private class DynamicLabel
    extends LabelElement<DynamicLabel> {
        private final Supplier<Component> textSupplier;

        public DynamicLabel(IPosition position, Supplier<Component> textSupplier, LabelTextStyle.Builder labelTextStyle, TextComponent defaultText) {
            super(position, (Component)defaultText, labelTextStyle);
            this.textSupplier = textSupplier;
        }

        @Override
        public Component getComponent() {
            return this.textSupplier.get();
        }
    }

    private static class ItemSelectorWithTooltipEntry
    extends ScrollableItemStackSelectorElement.ItemSelectorEntry {
        public ItemSelectorWithTooltipEntry(ItemStack displayStack) {
            super(displayStack, false);
        }

        @Override
        public void adjustSlot(FakeItemSlotElement<?> slot) {
            slot.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
                if (!this.getDisplayStack().m_41619_()) {
                    tooltipRenderer.renderTooltip(poseStack, this.getDisplayStack(), mouseX, mouseY, TooltipDirection.RIGHT);
                }
                return true;
            });
            slot.setLabelStackCount();
        }
    }
}

