/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.DynamicLabelElement;
import iskallia.vault.client.gui.framework.element.ItemStackDisplayElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.ModificationButtonElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.element.VerticalTextTabElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.container.VaultArtisanStationContainer;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.gear.modification.GearModificationAction;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.CoinPouchItem;
import iskallia.vault.network.message.VaultArtisanRequestModificationMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class VaultArtisanStationScreen
extends AbstractElementContainerScreen<VaultArtisanStationContainer> {
    private final Inventory playerInventory;
    private final Map<VaultArtisanStationContainer.Tab, List<ButtonElement<?>>> tabElements = new HashMap();

    public VaultArtisanStationScreen(VaultArtisanStationContainer container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.playerInventory = inventory;
        this.setGuiSize(Spatials.size(176, 230));
        this.addElement((NineSliceElement)new NineSliceElement(this.getGuiSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((SlotsElement)new SlotsElement((MenuAccess<?>)this).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 7), (Component)((VaultArtisanStationContainer)this.m_6262_()).getTileEntity().m_5446_().m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        MutableComponent inventoryName = inventory.m_5446_().m_6881_();
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 137), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.createActionButtons();
        ArrayList<VerticalTextTabElement.TabInfo> tabList = new ArrayList<VerticalTextTabElement.TabInfo>();
        for (VaultArtisanStationContainer.Tab tab : VaultArtisanStationContainer.Tab.values()) {
            tabList.add(new VerticalTextTabElement.TabInfo(tab.getName(), () -> this.selectTab(tab), () -> {}));
        }
        this.addElement((VerticalTextTabElement)new VerticalTextTabElement(Spatials.copyPosition(this.getGuiSpatial()).translateXY(-7, 5), tabList, ScreenTextures.TAB_BACKGROUND_LEFT_9, ScreenTextures.TAB_BACKGROUND_LEFT_9_DISABLED).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        IMutableSpatial iMutableSpatial = Spatials.positionXYZ(20, -10, 200);
        Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
        this.addElement((CoinCountElement)new CoinCountElement((IPosition)iMutableSpatial, (ISize)Spatials.size(100, 9), () -> CoinPouchItem.getTotalBronzeValue((Player)Minecraft.m_91087_().f_91074_), LabelTextStyle.shadow()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui.x(), gui.y())));
        this.addElement((TextureAtlasElement)((TextureAtlasElement)new TextureAtlasElement(Spatials.positionXY(0, -ScreenTextures.TAB_SOULSHARD_BACKGROUND.height()), ScreenTextures.TAB_SOULSHARD_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui))).tooltip(Tooltips.multi(() -> List.of(new TextComponent("Vault Bronze")))));
        ItemStackDisplayElement itemStackDisplayElement = (ItemStackDisplayElement)new ItemStackDisplayElement(Spatials.positionXY(5, -ScreenTextures.TAB_COUNTDOWN_BACKGROUND.height() + 3), new ItemStack((ItemLike)ModBlocks.VAULT_BRONZE, 64)).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        itemStackDisplayElement.setScale(0.72f);
        this.addElement(itemStackDisplayElement);
    }

    private void createActionButtons() {
        this.tabElements.clear();
        for (GearModificationAction action : ((VaultArtisanStationContainer)this.m_6262_()).getModificationActions()) {
            Slot slot = action.getCorrespondingSlot((VaultArtisanStationContainer)this.m_6262_());
            if (slot == null) continue;
            IMutableSpatial btnPosition = Spatials.positionXY(slot.f_40220_ - 1, slot.f_40221_ - 1).translateX(action.side().getXShift());
            ModificationButtonElement button = (ModificationButtonElement)new ModificationButtonElement(btnPosition, () -> this.attemptCraft(action), (VaultArtisanStationContainer)this.m_6262_(), action.modification()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
            button.setDisabled(() -> !action.canApply((VaultArtisanStationContainer)this.m_6262_(), this.playerInventory.f_35978_));
            this.addElement(button);
            this.tabElements.computeIfAbsent(action.tab(), tab -> new ArrayList()).add(button);
        }
    }

    public void selectTab(VaultArtisanStationContainer.Tab tab) {
        this.tabElements.values().forEach(buttons -> buttons.forEach(btn -> {
            btn.setVisible(false);
            btn.setEnabled(false);
        }));
        this.tabElements.getOrDefault((Object)tab, Collections.emptyList()).forEach(btn -> {
            btn.setVisible(true);
            btn.setEnabled(true);
        });
        VaultArtisanStationContainer container = (VaultArtisanStationContainer)this.m_6262_();
        for (GearModificationAction action : container.getModificationActions()) {
            Slot slot = action.getCorrespondingSlot(container);
            if (!(slot instanceof TabSlot)) continue;
            TabSlot tabSlot = (TabSlot)slot;
            tabSlot.setActive(tab == action.tab());
        }
    }

    private void attemptCraft(GearModificationAction action) {
        if (!action.canApply((VaultArtisanStationContainer)this.m_6262_(), this.playerInventory.f_35978_)) {
            return;
        }
        VaultArtisanRequestModificationMessage msg = new VaultArtisanRequestModificationMessage(action.modification().getRegistryName());
        ModNetwork.CHANNEL.sendToServer((Object)msg);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (pKeyCode == 256 || Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public static final class CoinCountElement
    extends DynamicLabelElement<Integer, CoinCountElement> {
        public CoinCountElement(IPosition position, ISize size, Supplier<Integer> valueSupplier, LabelTextStyle.Builder labelTextStyle) {
            super(position, size, valueSupplier, labelTextStyle);
        }

        @Override
        protected void onValueChanged(Integer value) {
            TextComponent shardText = new TextComponent(String.valueOf(value));
            this.set((Component)shardText);
        }
    }
}

