/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.EnchantBookElement;
import iskallia.vault.client.gui.framework.element.EnchanterEnchantSelectorElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.TextInputElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.container.VaultEnchanterContainer;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.VaultEnchanterEnchantMessage;
import iskallia.vault.util.EnchantmentEntry;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.util.RomanNumber;
import iskallia.vault.util.function.ObservableSupplier;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class VaultEnchanterScreen
extends AbstractElementContainerScreen<VaultEnchanterContainer> {
    public static ResourceLocation VAULT_ENCHANTER_BOOK_TEXTURE = VaultMod.id("textures/entity/vault_enchanter_book.png");
    private final Inventory playerInventory;
    private final EnchanterEnchantSelectorElement<?, ?> selectorElement;
    private final TextInputElement<?> searchInput;
    private final EnchantBookElement<?> bookElement;
    private ObservableSupplier<ItemStack> inputItemStack;
    private EnchantmentEntry selectedEnchantmentEntry;

    public VaultEnchanterScreen(VaultEnchanterContainer container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.playerInventory = inventory;
        this.setGuiSize(Spatials.size(176, 212));
        this.inputItemStack = ObservableSupplier.of(container::getInput, Objects::equals);
        this.addElement((NineSliceElement)new NineSliceElement(this.getGuiSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).size(Spatials.copy(gui))));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 7), (Component)((VaultEnchanterContainer)this.m_6262_()).getTileEntity().m_5446_().m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        MutableComponent inventoryName = inventory.m_5446_().m_6881_();
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 120), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((SlotsElement)new SlotsElement((MenuAccess<?>)this).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        this.searchInput = (TextInputElement)new TextInputElement(Spatials.positionXY(110, 5).size(60, 12), Minecraft.m_91087_().f_91062_).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        this.addElement(this.searchInput);
        this.selectorElement = (EnchanterEnchantSelectorElement)new EnchanterEnchantSelectorElement(Spatials.positionXY(8, 19).height(97), ObservableSupplier.ofIdentity(() -> ((VaultEnchanterContainer)this.m_6262_()).getInput()), ((VaultEnchanterContainer)this.m_6262_()).getTileEntity(), this.searchInput::getInput).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        this.addElement(this.selectorElement);
        ButtonElement craftButton = (ButtonElement)new ButtonElement(Spatials.positionXY(145, 98), ScreenTextures.BUTTON_CRAFT_TEXTURES, this::tryCraft).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        this.addElement(craftButton);
        craftButton.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
            if (this.selectedEnchantmentEntry == null) {
                return false;
            }
            ItemStack gear = ((VaultEnchanterContainer)this.m_6262_()).getInput();
            if (gear.m_41619_()) {
                return false;
            }
            List<ItemStack> itemCost = this.selectedEnchantmentEntry.getCost().getItems();
            List<ItemStack> missing = InventoryUtil.getMissingInputs(itemCost, this.playerInventory, ((VaultEnchanterContainer)this.m_6262_()).getTileEntity().getEmeraldInventory());
            int levelCost = this.selectedEnchantmentEntry.getCost().getLevels();
            boolean playerHasLevels = this.playerInventory.f_35978_.f_36078_ >= levelCost;
            LinkedList<Component> tooltip = new LinkedList<Component>();
            if (!missing.isEmpty() || !playerHasLevels) {
                tooltip.add((Component)new TextComponent("Missing ingredients.").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)new TextComponent(""));
                for (ItemStack costStack : this.selectedEnchantmentEntry.getCost().getItems()) {
                    tooltip.add((Component)new TextComponent(costStack.m_41613_() + "x ").m_7220_((Component)costStack.m_41786_().m_6881_()).m_130940_(missing.contains(costStack) ? ChatFormatting.RED : ChatFormatting.GREEN));
                }
                if (levelCost != 0) {
                    tooltip.add((Component)new TextComponent(levelCost + " EXP Levels").m_130940_(playerHasLevels ? ChatFormatting.GREEN : ChatFormatting.RED));
                }
            } else {
                tooltip.add((Component)new TextComponent("Enchant ").m_7220_((Component)gear.m_41786_().m_6881_()));
                tooltip.add((Component)new TextComponent("with ").m_7220_((Component)new TranslatableComponent(this.selectedEnchantmentEntry.getEnchantment().m_44704_()).m_130946_(" " + RomanNumber.toRoman(this.selectedEnchantmentEntry.getLevel())).m_130940_(ChatFormatting.LIGHT_PURPLE)).m_130946_(" !"));
            }
            tooltipRenderer.renderTooltip(poseStack, tooltip, mouseX, mouseY, ItemStack.f_41583_, TooltipDirection.RIGHT);
            return true;
        });
        craftButton.setDisabled(() -> {
            ItemStack gear = ((VaultEnchanterContainer)this.m_6262_()).getInput();
            if (gear.m_41619_()) {
                return true;
            }
            if (this.selectedEnchantmentEntry != null) {
                if (this.playerInventory.f_35978_.m_7500_()) {
                    return false;
                }
                List<ItemStack> inputs = this.selectedEnchantmentEntry.getCost().getItems();
                List<ItemStack> missing = InventoryUtil.getMissingInputs(inputs, this.playerInventory, ((VaultEnchanterContainer)this.m_6262_()).getTileEntity().getEmeraldInventory());
                int levelCost = this.selectedEnchantmentEntry.getCost().getLevels();
                return !missing.isEmpty() || this.playerInventory.f_35978_.f_36078_ < levelCost;
            }
            return true;
        });
        this.bookElement = this.addElement((EnchantBookElement)new EnchantBookElement(Spatials.zero(), Spatials.size(100, 100), () -> this.selectedEnchantmentEntry == null ? 0 : this.selectedEnchantmentEntry.getCost().getLevels(), () -> !container.getInput().m_41619_() && this.selectedEnchantmentEntry != null).withCustomTexture(VAULT_ENCHANTER_BOOK_TEXTURE).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXYZ(gui).translateX(149).translateY(45)));
        this.selectorElement.onSelect(option -> {
            this.selectedEnchantmentEntry = option;
        });
        this.searchInput.onTextChanged(text -> this.selectorElement.refreshElements());
    }

    private void tryCraft() {
        if (this.selectedEnchantmentEntry == null) {
            return;
        }
        ItemStack gear = ((VaultEnchanterContainer)this.m_6262_()).getInput();
        if (gear.m_41619_()) {
            return;
        }
        ModNetwork.CHANNEL.sendToServer((Object)new VaultEnchanterEnchantMessage(((VaultEnchanterContainer)this.m_6262_()).getTilePos(), this.selectedEnchantmentEntry));
    }

    @Override
    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.inputItemStack.ifChanged(inputStack -> {
            this.selectedEnchantmentEntry = null;
        });
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        this.searchInput.tickEditBox();
        this.bookElement.tickBook();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.searchInput.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            if (!this.searchInput.isFocused()) {
                this.m_7379_();
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchInput.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }
}

