/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.block.entity.VaultEnhancementAltarTileEntity;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.container.VaultEnhancementAltarContainer;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.VaultEnhancementRequestMessage;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class VaultEnhancementAltarScreen
extends AbstractElementContainerScreen<VaultEnhancementAltarContainer> {
    private final Inventory playerInventory;

    public VaultEnhancementAltarScreen(VaultEnhancementAltarContainer container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.playerInventory = inventory;
        this.setGuiSize(Spatials.size(176, 156));
        this.addElement((NineSliceElement)new NineSliceElement(this.getGuiSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).size(Spatials.copy(gui))));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 7), (Component)((VaultEnhancementAltarContainer)this.m_6262_()).getTileEntity().m_5446_().m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        MutableComponent inventoryName = inventory.m_5446_().m_6881_();
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 63), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((SlotsElement)new SlotsElement((MenuAccess<?>)this).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        ButtonElement button = this.addElement((ButtonElement)new ButtonElement(Spatials.positionXY(64, 42), ScreenTextures.BUTTON_EMPTY_16_48_TEXTURES, this::tryCraft).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        button.setDisabled(() -> {
            VaultEnhancementAltarTileEntity tile = ((VaultEnhancementAltarContainer)this.m_6262_()).getTileEntity();
            return !tile.canBeUsed(this.playerInventory.f_35978_);
        });
        IMutableSpatial iMutableSpatial = Spatials.positionXY(64, 42);
        int n = button.height() / 2;
        Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
        this.addElement((LabelElement)new LabelElement((IPosition)iMutableSpatial.translateY(n - 9 / 2), (ISize)button, (Component)new TranslatableComponent("screen.the_vault.enhancement_altar.button"), LabelTextStyle.center()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
    }

    private void tryCraft() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        VaultEnhancementAltarTileEntity altarTile = ((VaultEnhancementAltarContainer)this.m_6262_()).getTileEntity();
        if (!altarTile.canBeUsed((Player)player)) {
            return;
        }
        ItemStack gearItem = altarTile.getInventory().m_8020_(0);
        if (!AttributeGearData.hasData(gearItem) || !((AttributeGearData)AttributeGearData.read(gearItem)).isModifiable()) {
            return;
        }
        ModNetwork.CHANNEL.sendToServer((Object)new VaultEnhancementRequestMessage(((VaultEnhancementAltarContainer)this.m_6262_()).getTilePos()));
        altarTile.setUsedByPlayer((Player)player);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (pKeyCode == 256 || Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }
}

