/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import iskallia.vault.block.entity.VaultForgeTileEntity;
import iskallia.vault.client.ClientProficiencyData;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.CraftingSelectorElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.LimitedSliderElement;
import iskallia.vault.client.gui.framework.element.ScalableSliderElement;
import iskallia.vault.client.gui.framework.element.VerticalSegmentedBarElement;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.block.base.ForgeRecipeContainerScreen;
import iskallia.vault.config.gear.VaultGearCraftingConfig;
import iskallia.vault.config.gear.VaultGearTypeConfig;
import iskallia.vault.container.VaultForgeContainer;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ProficiencyForgeMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Inventory;

public class VaultForgeScreen
extends ForgeRecipeContainerScreen<VaultForgeTileEntity, VaultForgeContainer> {
    private final ScalableSliderElement levelSlider;
    private final VerticalSegmentedBarElement<?, ProficiencySegment> proficiencyBar;
    private boolean updatingLevelSelection = false;

    public VaultForgeScreen(VaultForgeContainer container, Inventory inventory, Component title) {
        super(container, inventory, title, 206);
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 24), (Component)new TextComponent("Level: ").m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        int maxCraftable = Math.min(VaultBarOverlay.vaultLevel, VaultBarOverlay.maxLevel);
        this.levelSlider = this.addElement((ScalableSliderElement)new LimitedSliderElement(Spatials.positionXY(8, 38).size(129, 6), 0.0f, (float)maxCraftable / 100.0f, this::updateInput).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.setLevelInputVisible(true);
        this.updateInput((float)maxCraftable / 100.0f);
        this.updateSlider(String.valueOf(maxCraftable));
        this.levelInput.onTextChanged(this::updateSlider);
        ((ButtonElement)this.addElement((ButtonElement)new ButtonElement(Spatials.positionXY(123, 6), ScreenTextures.BUTTON_PROFICIENCY__TEXTURES, () -> ModNetwork.CHANNEL.sendToServer((Object)ProficiencyForgeMessage.INSTANCE)).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui))).tooltip(() -> new TextComponent("Add Proficiency").m_130940_(ChatFormatting.GRAY))).setDisabled(() -> {
            VaultForgeTileEntity tile = (VaultForgeTileEntity)((VaultForgeContainer)this.m_6262_()).getTile();
            if (tile == null) {
                return true;
            }
            return tile.getOtherInputInventory().m_8020_(0).m_41619_();
        });
        this.proficiencyBar = new VerticalSegmentedBarElement(Spatials.positionXY(147, 6).size(22, 50), () -> ScreenTextures.VAULT_FORGE_PROFICIENCY_BAR, () -> {
            int absProficiency = ClientProficiencyData.getProficiency();
            return Float.valueOf(VaultGearCraftingConfig.calculateRelativeProficiency(absProficiency, this.getCraftedLevel()));
        });
        this.addElement(this.proficiencyBar).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        ModConfigs.VAULT_GEAR_CRAFTING_CONFIG.getProficiencySteps().forEach(step -> this.proficiencyBar.addSegment(step.getMinProficiency(), new ProficiencySegment((VaultGearCraftingConfig.ProficiencyStep)step)));
    }

    private void updateInput(float sliderValue) {
        if (this.updatingLevelSelection) {
            return;
        }
        this.updatingLevelSelection = true;
        int level = Math.round(sliderValue * 100.0f);
        this.levelInput.setInput(String.valueOf(level));
        this.updatingLevelSelection = false;
    }

    private void updateSlider(String inputValue) {
        try {
            if (this.updatingLevelSelection) {
                return;
            }
            this.updatingLevelSelection = true;
            if (inputValue.isEmpty()) {
                this.levelSlider.setValue(0.0f);
                return;
            }
            try {
                int level = Integer.parseInt(inputValue);
                this.levelSlider.setValue((float)level / 100.0f);
            }
            catch (NumberFormatException e) {
                this.levelSlider.setValue(0.0f);
            }
        }
        finally {
            this.updatingLevelSelection = false;
        }
    }

    @Override
    protected ISpatial getLevelInputOffset() {
        return Spatials.positionXY(58, 22);
    }

    @Override
    protected void onRecipeSelect(VaultForgeRecipe recipe, boolean canCraft) {
        this.craftButton.setDisabled(!canCraft);
        this.selectedRecipe = recipe;
        this.setLevelInputVisible(true);
    }

    @Override
    @Nonnull
    protected CraftingSelectorElement<?> createCraftingSelector() {
        return this.makeCraftingSelector();
    }

    public static class ProficiencySegment
    extends VerticalSegmentedBarElement.BarSegment {
        private final VaultGearCraftingConfig.ProficiencyStep step;

        public ProficiencySegment(VaultGearCraftingConfig.ProficiencyStep step) {
            super(step.getColor());
            this.step = step;
        }

        @Override
        protected List<Component> getTooltipComponents() {
            ChatFormatting potentialStyle = this.step.getCraftingPotentialMultiplier() >= 1.0f ? ChatFormatting.GREEN : (this.step.getCraftingPotentialMultiplier() >= 0.5f ? ChatFormatting.YELLOW : ChatFormatting.RED);
            Style poolStyle = ModConfigs.VAULT_GEAR_TYPE_CONFIG.getRollPool(this.step.getPool()).map(VaultGearTypeConfig.RollType::getColor).map(arg_0 -> ((Style)Style.f_131099_).m_178520_(arg_0)).orElse(Style.f_131099_.m_131140_(ChatFormatting.WHITE));
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add((Component)new TextComponent("Proficiency: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(this.step.getProficiencyName()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)this.step.getColor())))));
            tooltip.add((Component)new TextComponent("Durability: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(this.step.getDurabilityOutcomeName()).m_130940_(ChatFormatting.WHITE)));
            tooltip.add((Component)new TextComponent("Crafting Potential: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(Math.round(this.step.getCraftingPotentialMultiplier() * 100.0f) + "%").m_130940_(potentialStyle)));
            tooltip.add((Component)new TextComponent("Rarity Pool: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(this.step.getPool()).m_130948_(poolStyle)));
            tooltip.add((Component)new TextComponent("Maximum Repair Slots: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.valueOf(this.step.getMaximumRepairSlots())).m_130940_(ChatFormatting.WHITE)));
            tooltip.add((Component)new TextComponent("Soulbound Chance: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(Math.round(this.step.getSoulboundChance() * 100.0f) + "%").m_130940_(ChatFormatting.WHITE)));
            if (this.step.getGreaterModifierChance() > 0.0f) {
                tooltip.add((Component)new TextComponent("Greater Modifier Chance: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(Math.round(this.step.getGreaterModifierChance() * 100.0f) + "%").m_130948_(Style.f_131099_.m_178520_(-10890730))));
            }
            return tooltip;
        }
    }
}

