/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block.base;

import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.block.entity.base.ForgeRecipeTileEntity;
import iskallia.vault.client.ClientForgeRecipesData;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.CraftingSelectorElement;
import iskallia.vault.client.gui.framework.element.ItemStackDisplayElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.OutputSlotElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.TextInputElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.CatalystInfusionTableScreen;
import iskallia.vault.client.gui.screen.block.ToolStationScreen;
import iskallia.vault.client.gui.screen.block.VaultArtisanStationScreen;
import iskallia.vault.client.gui.screen.block.VaultForgeScreen;
import iskallia.vault.container.slot.RecipeOutputSlot;
import iskallia.vault.container.spi.ForgeRecipeContainer;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.CoinPouchItem;
import iskallia.vault.network.message.VaultForgeRequestCraftMessage;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.util.function.ObservableSupplier;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class ForgeRecipeContainerScreen<V extends ForgeRecipeTileEntity, T extends ForgeRecipeContainer<V>>
extends AbstractElementContainerScreen<T> {
    protected final ButtonElement<?> craftButton;
    protected final Inventory playerInventory;
    protected final CraftingSelectorElement<?> craftingSelectorElement;
    protected final TextInputElement<?> levelInput;
    protected VaultForgeRecipe selectedRecipe = null;

    public ForgeRecipeContainerScreen(T container, Inventory inventory, Component title, int height) {
        this(container, inventory, title, height, 176);
    }

    public ForgeRecipeContainerScreen(T container, Inventory inventory, Component title, int height, int width) {
        super(container, inventory, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.playerInventory = inventory;
        this.setGuiSize(Spatials.size(width, height));
        Object tile = ((ForgeRecipeContainer)this.m_6262_()).getTile();
        if (tile == null) {
            this.craftButton = null;
            this.craftingSelectorElement = null;
            this.levelInput = null;
            return;
        }
        this.addBackgroundElement();
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 7), (Component)((ForgeRecipeTileEntity)tile).m_5446_().m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        MutableComponent inventoryName = inventory.m_5446_().m_6881_();
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(((ForgeRecipeContainer)this.m_6262_()).getPlayerInventoryOffset().x, height - 93), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        NonNullList allSlots = ((ForgeRecipeContainer)this.m_6262_()).f_38839_;
        List<Slot> normalSlots = allSlots.stream().filter(slot -> !(slot instanceof RecipeOutputSlot)).collect(Collectors.toList());
        this.addElement((SlotsElement)new SlotsElement((IPosition)Spatials.zero(), normalSlots, ScreenTextures.INSET_ITEM_SLOT_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        allSlots.forEach(slot -> {
            if (slot instanceof RecipeOutputSlot) {
                this.addElement((OutputSlotElement)new OutputSlotElement(Spatials.zero(), (Slot)slot, ScreenTextures.INSET_CRAFTING_RESULT_SLOT_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
            }
        });
        this.craftingSelectorElement = this.addElement(this.createCraftingSelector());
        int offsetX = ((ForgeRecipeContainer)this.m_6262_()).getOffset().x;
        int offsetY = ((ForgeRecipeContainer)this.m_6262_()).getOffset().y;
        this.craftButton = (ButtonElement)new ButtonElement(Spatials.positionXY(this.craftingSelectorElement.right() + (this instanceof VaultForgeScreen ? 7 : 0) + 3, offsetY + 17), ScreenTextures.BUTTON_CRAFT_TEXTURES, this::onCraftClick).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        this.addElement(this.craftButton);
        this.craftButton.setDisabled(true);
        this.levelInput = this.addElement((TextInputElement)new TextInputElement(Spatials.copy(this.getLevelInputOffset()).size(26, 12), Minecraft.m_91087_().f_91062_).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui))).adjustEditBox(editBox -> {
            editBox.m_94153_(input -> {
                int parsedLevel;
                if (input.isEmpty()) {
                    return true;
                }
                try {
                    parsedLevel = Integer.parseInt(input);
                }
                catch (NumberFormatException exc) {
                    return false;
                }
                return parsedLevel <= VaultBarOverlay.vaultLevel && parsedLevel <= VaultBarOverlay.maxLevel;
            });
            editBox.m_94199_(3);
            editBox.m_94144_(String.valueOf(VaultBarOverlay.vaultLevel));
        });
        this.levelInput.setVisible(false);
        this.levelInput.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
            if (!this.levelInput.isVisible()) {
                return false;
            }
            TextComponent cmp = new TextComponent("Level of crafted gear");
            tooltipRenderer.renderTooltip(poseStack, (Component)cmp, mouseX, mouseY, TooltipDirection.RIGHT);
            return true;
        });
        if (!(this instanceof ToolStationScreen) && !(this instanceof CatalystInfusionTableScreen)) {
            IMutableSpatial iMutableSpatial = Spatials.positionXYZ(20, -10, 200);
            Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
            this.addElement((VaultArtisanStationScreen.CoinCountElement)new VaultArtisanStationScreen.CoinCountElement((IPosition)iMutableSpatial, (ISize)Spatials.size(100, 9), () -> CoinPouchItem.getGoldAmount(Minecraft.m_91087_().f_91074_.m_150109_()), LabelTextStyle.shadow()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui.x(), gui.y())));
            this.addElement((TextureAtlasElement)((TextureAtlasElement)new TextureAtlasElement(Spatials.positionXY(0, -ScreenTextures.TAB_SOULSHARD_BACKGROUND.height()), ScreenTextures.TAB_SOULSHARD_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui))).tooltip(Tooltips.multi(() -> List.of(new TextComponent("Vault Gold")))));
            ItemStackDisplayElement itemStackDisplayElement = (ItemStackDisplayElement)new ItemStackDisplayElement(Spatials.positionXY(5, -ScreenTextures.TAB_COUNTDOWN_BACKGROUND.height() + 3), new ItemStack((ItemLike)ModBlocks.VAULT_GOLD, 64)).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
            itemStackDisplayElement.setScale(0.72f);
            this.addElement(itemStackDisplayElement);
        }
    }

    protected ISpatial getLevelInputOffset() {
        int offsetY = ((ForgeRecipeContainer)this.m_6262_()).getOffset().y;
        return Spatials.positionXY(143, offsetY - 1);
    }

    protected void addBackgroundElement() {
        this.addElement((NineSliceElement)new NineSliceElement(this.getGuiSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).size(Spatials.copy(gui))));
    }

    @Nonnull
    protected abstract CraftingSelectorElement<?> createCraftingSelector();

    protected void setLevelInputVisible(boolean visible) {
        if (this.levelInput != null) {
            boolean changed = this.levelInput.isVisible() != visible;
            this.levelInput.setVisible(visible);
            if (changed && !visible) {
                this.levelInput.setInput(String.valueOf(VaultBarOverlay.vaultLevel));
            }
        }
    }

    protected int getCraftedLevel() {
        String input;
        int requestedLevel = VaultBarOverlay.vaultLevel;
        if (this.levelInput != null && !(input = this.levelInput.getInput()).isEmpty()) {
            try {
                requestedLevel = Mth.m_14045_((int)Integer.parseInt(input), (int)0, (int)Math.min(VaultBarOverlay.vaultLevel, VaultBarOverlay.maxLevel));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return requestedLevel;
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        if (this.craftingSelectorElement != null) {
            this.craftButton.setDisabled(!this.craftingSelectorElement.canCraftSelectedEntry());
        }
        if (this.levelInput != null) {
            this.levelInput.tickEditBox();
        }
    }

    protected CraftingSelectorElement<?> makeCraftingSelector() {
        return this.makeCraftingSelector(ObservableSupplier.empty());
    }

    protected CraftingSelectorElement<?> makeCraftingSelector(ObservableSupplier<Set<ResourceLocation>> discoveredRecipes) {
        if (this.craftingSelectorElement != null) {
            return this.craftingSelectorElement;
        }
        int slotWidth = 0;
        List<VaultForgeRecipe> recipes = Collections.emptyList();
        Object tile = ((ForgeRecipeContainer)this.m_6262_()).getTile();
        if (tile != null) {
            recipes = ClientForgeRecipesData.getRecipes(((ForgeRecipeTileEntity)tile).getSupportedRecipeTypes());
            slotWidth = Mth.m_14167_((float)((float)((ForgeRecipeTileEntity)tile).getInventory().m_6643_() / 3.0f));
        }
        int offsetX = ((ForgeRecipeContainer)this.m_6262_()).getOffset().x;
        int offsetY = ((ForgeRecipeContainer)this.m_6262_()).getOffset().y;
        return (CraftingSelectorElement)new CraftingSelectorElement((ISpatial)Spatials.positionXY(offsetX + (this instanceof VaultForgeScreen ? 5 : 0) + slotWidth * 18 + 3, offsetY - 1).height(54), 3, recipes, discoveredRecipes, this::onRecipeSelect, this::getMissingRecipeInputs).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
    }

    public Inventory getPlayerInventory() {
        return this.playerInventory;
    }

    private void onCraftClick() {
        if (this.selectedRecipe != null) {
            ModNetwork.CHANNEL.sendToServer((Object)new VaultForgeRequestCraftMessage(this.selectedRecipe.getId(), this.getCraftedLevel(), Screen.m_96638_()));
        }
    }

    protected void onRecipeSelect(VaultForgeRecipe recipe, boolean canCraft) {
        this.craftButton.setDisabled(!canCraft);
        this.selectedRecipe = recipe;
        this.setLevelInputVisible(recipe.usesLevel());
    }

    protected List<ItemStack> getMissingRecipeInputs(List<ItemStack> inputs) {
        Object tile = ((ForgeRecipeContainer)this.f_97732_).getTile();
        if (tile == null) {
            return inputs;
        }
        return InventoryUtil.getMissingInputs(inputs, this.getPlayerInventory(), ((ForgeRecipeTileEntity)tile).getInventory());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.levelInput != null && this.levelInput.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            if (this.levelInput == null || !this.levelInput.isFocused()) {
                this.m_7379_();
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.levelInput != null && this.levelInput.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }
}

