/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.bounty.element;

import com.mojang.datafixers.util.Pair;
import iskallia.vault.bounty.Bounty;
import iskallia.vault.bounty.task.properties.TaskProperties;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.ColorHollowRectElement;
import iskallia.vault.client.gui.framework.element.ContainerElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.element.spi.IElement;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderFunction;
import iskallia.vault.client.gui.framework.screen.layout.ScreenLayout;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.screen.bounty.BountyScreen;
import iskallia.vault.client.gui.screen.bounty.element.BountyElement;
import iskallia.vault.client.gui.screen.bounty.element.HeaderElement;
import iskallia.vault.container.BountyContainer;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.bounty.ServerboundRerollMessage;
import iskallia.vault.util.TextUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class BountyTableContainerElement
extends ContainerElement<BountyTableContainerElement> {
    private final int marginLeft = 7;
    private final int marginTop = 7;
    private final BountyContainer container;
    BountyElement bountyElement;
    final List<Pair<ButtonElement<?>, TextureAtlasElement<?>>> buttons = new ArrayList();
    final List<ColorHollowRectElement> rarityOutlines = new ArrayList<ColorHollowRectElement>();
    final List<UUID> oldBountyIDs = new ArrayList<UUID>();

    public BountyTableContainerElement(ISpatial spatial, BountyContainer container) {
        super(spatial);
        this.container = container;
        this.createBaseElements();
        this.createBountySelection();
        this.createRerollButton();
        this.refreshBountyElement();
    }

    private void createBaseElements() {
        this.addElement(new NineSliceElement(Spatials.positionXYZ(0, 0, -50).size(this.getWorldSpatial().width(), this.getWorldSpatial().height()), ScreenTextures.DEFAULT_WINDOW_BACKGROUND));
        this.addElement(this.createLabel(7, 7, "Bounty Table"));
        this.addElement(new NineSliceElement(Spatials.positionXY(this.getBountyElementStart() - 1, 1).width(3).height(this.getWorldSpatial().height() - 2), ScreenTextures.INSET_VERTICAL_SEPARATOR));
    }

    private void createRerollButton() {
        this.addElement(((ButtonElement)new ButtonElement(Spatials.positionXY(95, 117), ScreenTextures.BUTTON_BUTTON_REROLL_TEXTURES, this::handleReroll).tooltip(this.createRerollButtonTooltip())).setDisabled(() -> {
            if (this.bountyElement.getSelectedBounty() == null) {
                return true;
            }
            if (this.bountyElement.getStatus() != BountyElement.Status.AVAILABLE) {
                return true;
            }
            Bounty bounty = this.bountyElement.getSelectedBounty();
            ItemStack bronze = this.container.getBountyPearlSlot().m_7993_();
            int amount = bronze.m_41613_();
            int cost = ModConfigs.BOUNTY_CONFIG.getCost(this.container.getVaultLevel());
            return cost > amount;
        }));
    }

    @NotNull
    private ITooltipRenderFunction createRerollButtonTooltip() {
        return (tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
            Bounty bounty = this.bountyElement.getSelectedBounty();
            if (bounty == null) {
                tooltipRenderer.renderTooltip(poseStack, (Component)new TextComponent("Select a bounty to see the cost of reroll"), mouseX, mouseY, TooltipDirection.LEFT);
                return true;
            }
            if (this.bountyElement.getStatus() != BountyElement.Status.AVAILABLE) {
                tooltipRenderer.renderTooltip(poseStack, (Component)new TextComponent("Only \"Available\" bounties can be rerolled."), mouseX, mouseY, TooltipDirection.LEFT);
                return true;
            }
            if (Screen.m_96638_()) {
                return false;
            }
            ArrayList<Component> tooltips = new ArrayList<Component>();
            tooltips.add((Component)new TextComponent("Reroll Selected Bounty"));
            ItemStack pearl = this.container.getBountyPearlSlot().m_7993_();
            int amount = pearl.m_41613_();
            int cost = ModConfigs.BOUNTY_CONFIG.getCost(this.container.getVaultLevel());
            tooltips.add((Component)new TextComponent(""));
            tooltips.add((Component)new TextComponent("Current Cost: ").m_7220_(new ItemStack((ItemLike)ModItems.BOUNTY_PEARL).m_41786_()).m_130946_(" x" + cost).m_130946_(" [%s]".formatted(pearl.m_41613_())).m_130940_(cost > amount ? ChatFormatting.RED : ChatFormatting.GREEN));
            tooltipRenderer.renderComponentTooltip(poseStack, tooltips, mouseX, mouseY, TooltipDirection.LEFT);
            return true;
        };
    }

    private void handleReroll() {
        this.oldBountyIDs.clear();
        this.container.getAvailable().forEach(bounty -> this.oldBountyIDs.add(bounty.getId()));
        Bounty bounty2 = this.bountyElement.getSelectedBounty();
        if (bounty2 == null) {
            return;
        }
        ItemStack pearl = this.container.getBountyPearlSlot().m_7993_();
        int amount = pearl.m_41613_();
        int index = this.container.getAvailable().indexOf(bounty2);
        int cost = ModConfigs.BOUNTY_CONFIG.getCost(this.container.getVaultLevel());
        if (amount >= cost) {
            ModNetwork.CHANNEL.sendToServer((Object)new ServerboundRerollMessage(bounty2.getId()));
            Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_12490_, 0.7f, 1.0f);
        }
    }

    public void refreshBountySelection() {
        for (Pair<ButtonElement<?>, TextureAtlasElement<?>> pair : this.buttons) {
            ButtonElement button = (ButtonElement)pair.getFirst();
            if (!(button instanceof BountyButtonElement)) continue;
            BountyButtonElement bountyButton = (BountyButtonElement)button;
            this.elementStore.removeElement(bountyButton);
            this.elementStore.removeElement((IElement)pair.getSecond());
        }
        this.buttons.clear();
        this.refreshBountyElement();
        this.createBountySelection();
        ScreenLayout.requestLayout();
        for (Bounty bounty : this.container.getAvailable()) {
            if (this.oldBountyIDs.contains(bounty.getId())) continue;
            this.bountyElement.setBounty(bounty.getId(), BountyElement.Status.AVAILABLE);
        }
    }

    private void refreshBountyElement() {
        if (this.bountyElement != null) {
            this.elementStore.removeElement(this.bountyElement);
        }
        this.bountyElement = this.addElement((BountyElement)((BountyElement)new BountyElement(this, Spatials.positionXY(this.getBountyElementStart() + 5, 7).width(this.getBountyElementStart() - 10).height(this.getWorldSpatial().height() - 5), this.container).layout((screen, gui, parent, world) -> {
            world.width(this.getBountyElementStart() - 10);
            world.height(world.height() - 5);
        })).enableSpatialDebugRender(false, true));
    }

    private void createBountySelection() {
        this.clearOutlines();
        int buttonWidth = 18;
        int labelX = 7;
        int labelY = 23;
        int buttonX = this.getWorldSpatial().width() / 2 - 14 - buttonWidth * 3 - 54;
        int buttonY = labelY + 25;
        int activeRow = 0;
        int availableRow = 1;
        int completeRow = 2;
        this.addElement(new HeaderElement((ISpatial)Spatials.positionXY(labelX, labelY).width(this.getWorldSpatial().width() / 2 - 14 + 1).height(14 + buttonWidth * 3 - 3), (Component)new TextComponent("Bounty Selection"), true));
        this.createButton(buttonX + buttonWidth * 3 + 11, buttonY + 11, this.container.getLegendary().size() > 0 ? (Bounty)this.container.getLegendary().get(0) : null, BountyElement.Status.LEGENDARY);
        for (int row = 0; row < 3; ++row) {
            if (row == activeRow) {
                BountyElement.Status active = BountyElement.Status.ACTIVE;
                this.addElement(new LabelElement((IPosition)Spatials.positionXY(buttonX - 4 - active.getWidth(), buttonY + 4).positionZ(100).width(active.getWidth()).height(buttonWidth + 7), (Component)active.getDisplay(), LabelTextStyle.shadow()));
            } else if (row == availableRow) {
                BountyElement.Status available = BountyElement.Status.AVAILABLE;
                this.addElement(new LabelElement((IPosition)Spatials.positionXY(buttonX - 4 - available.getWidth(), buttonY + 4).positionZ(100).width(available.getWidth()).height(buttonWidth + 7), (Component)available.getDisplay(), LabelTextStyle.shadow()));
            } else {
                BountyElement.Status complete = BountyElement.Status.COMPLETE;
                this.addElement(new LabelElement((IPosition)Spatials.positionXY(buttonX - 4 - complete.getWidth(), buttonY + 4).positionZ(100).width(complete.getWidth()).height(buttonWidth + 7), (Component)complete.getDisplay(), LabelTextStyle.shadow()));
            }
            int activeBountyCount = this.container.getActive().size();
            for (int column = 0; column < 3; ++column) {
                if (row == activeRow && column < activeBountyCount) {
                    this.createButton(buttonX, buttonY, (Bounty)this.container.getActive().get(column), BountyElement.Status.ACTIVE);
                } else if (row == availableRow) {
                    this.createButton(buttonX, buttonY, this.container.getAvailable().size() > column ? (Bounty)this.container.getAvailable().get(column) : null, BountyElement.Status.AVAILABLE);
                } else if (row == completeRow) {
                    this.createButton(buttonX, buttonY, this.container.getComplete().size() > column ? (Bounty)this.container.getComplete().get(column) : null, BountyElement.Status.COMPLETE);
                }
                buttonX += buttonWidth;
            }
            labelX += 58;
            buttonX = this.getWorldSpatial().width() / 2 - 14 - buttonWidth * 3 - 54;
            buttonY += buttonWidth + 3;
        }
    }

    private void clearOutlines() {
        if (!this.rarityOutlines.isEmpty()) {
            for (ColorHollowRectElement rarityOutline : this.rarityOutlines) {
                this.removeElement(rarityOutline);
            }
        }
        this.rarityOutlines.clear();
    }

    @NotNull
    private LabelElement<?> createLabel(int labelX, int labelY, String pText) {
        return new LabelElement((IPosition)Spatials.positionXY(labelX, labelY), (Component)new TextComponent(pText).m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle());
    }

    private void createButton(int buttonX, int buttonY, Bounty bounty, BountyElement.Status status) {
        if (bounty == null) {
            this.buttons.add(Pair.of(this.addElement(((BountyButtonElement)new BountyButtonElement(null, Spatials.positionXY(buttonX, buttonY), status == BountyElement.Status.LEGENDARY ? ScreenTextures.BUTTON_EMPTY_LEGENDARY_TEXTURES : ScreenTextures.BUTTON_EMPTY_16_TEXTURES).tooltip(Tooltips.multi(() -> {
                if (status == BountyElement.Status.LEGENDARY) {
                    return List.of(new TextComponent("Legendary:"), new TextComponent("Find Legendary Bounties"), new TextComponent("in Treasure Rooms!"));
                }
                return new ArrayList();
            }))).setDisabled(true)), new TextureAtlasElement(Spatials.zero(), ScreenTextures.EMPTY)));
            return;
        }
        if (status != BountyElement.Status.LEGENDARY) {
            TextColor textColor = ModConfigs.COLORS.getColor(((TaskProperties)bounty.getTask().getProperties()).getRewardPool());
            ColorHollowRectElement rarityOutline = new ColorHollowRectElement(Spatials.positionXYZ(buttonX, buttonY, 100).size(18, 18), () -> {
                Color color = new Color(textColor.m_131265_());
                return new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
            });
            this.rarityOutlines.add(rarityOutline);
            this.addElement(rarityOutline);
        }
        this.buttons.add(Pair.of((Object)this.addElement((BountyButtonElement)((BountyButtonElement)new BountyButtonElement(bounty.getId(), Spatials.positionXY(buttonX, buttonY), status == BountyElement.Status.LEGENDARY ? ScreenTextures.BUTTON_EMPTY_LEGENDARY_TEXTURES : ScreenTextures.BUTTON_EMPTY_16_TEXTURES, () -> {
            this.bountyElement.setBounty(bounty.getId(), status);
            Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_12490_, 0.7f, 1.0f);
        }).tooltip(Tooltips.shift(Tooltips.single(() -> TextUtil.formatLocationPathAsProperNoun(bounty.getTask().getTaskType())), Tooltips.single(() -> new TextComponent(bounty.getTask().getBountyId().toString()))))).enableSpatialDebugRender(false, true)), this.addElement(new TextureAtlasElement(Spatials.positionXYZ(status == BountyElement.Status.LEGENDARY ? buttonX : buttonX + 1, status == BountyElement.Status.LEGENDARY ? buttonY : buttonY + 1, 10), status == BountyElement.Status.LEGENDARY ? BountyScreen.TASK_ICON_MAP_LEGENDARY.get(bounty.getTask().getTaskType()) : BountyScreen.TASK_ICON_MAP.get(bounty.getTask().getTaskType())))));
    }

    private int getBountyElementStart() {
        return this.getWorldSpatial().width() / 2;
    }

    private static class BountyButtonElement
    extends ButtonElement<BountyButtonElement> {
        private final UUID bountyId;

        public BountyButtonElement(UUID bountyId, IPosition position, ButtonElement.ButtonTextures textures, Runnable onClick) {
            super(position, textures, onClick);
            this.bountyId = bountyId;
        }

        public BountyButtonElement(UUID bountyId, IPosition position, ButtonElement.ButtonTextures textures) {
            super(position, textures, () -> {});
            this.bountyId = bountyId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BountyButtonElement that = (BountyButtonElement)o;
            if (this.bountyId == null || that.bountyId == null) {
                return true;
            }
            return this.bountyId.equals(that.bountyId);
        }

        public int hashCode() {
            return this.bountyId != null ? this.bountyId.hashCode() : 0;
        }
    }
}

