/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.bounty.element.task;

import iskallia.vault.bounty.TaskRegistry;
import iskallia.vault.bounty.TaskReward;
import iskallia.vault.bounty.task.CompletionTask;
import iskallia.vault.bounty.task.DamageTask;
import iskallia.vault.bounty.task.ItemDiscoveryTask;
import iskallia.vault.bounty.task.ItemSubmissionTask;
import iskallia.vault.bounty.task.KillEntityTask;
import iskallia.vault.bounty.task.MiningTask;
import iskallia.vault.bounty.task.Task;
import iskallia.vault.bounty.task.properties.KillEntityProperties;
import iskallia.vault.bounty.task.properties.TaskProperties;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ClickableLabelElement;
import iskallia.vault.client.gui.framework.element.DynamicProgressElement;
import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.element.FakeOversizedItemSlotElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.screen.bestiary.BestiaryScreen;
import iskallia.vault.client.gui.screen.bounty.element.BountyElement;
import iskallia.vault.client.gui.screen.bounty.element.task.CompletionTaskElement;
import iskallia.vault.client.gui.screen.bounty.element.task.DamageEntityTaskElement;
import iskallia.vault.client.gui.screen.bounty.element.task.ItemDiscoveryTaskElement;
import iskallia.vault.client.gui.screen.bounty.element.task.ItemSubmissionTaskElement;
import iskallia.vault.client.gui.screen.bounty.element.task.KillEntityTaskElement;
import iskallia.vault.client.gui.screen.bounty.element.task.MiningTaskElement;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.TextUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;

public abstract class AbstractTaskElement<T extends Task<?>>
extends ElasticContainerElement<AbstractTaskElement<T>> {
    private T task;
    private TaskReward taskReward;
    final int marginY = 7;
    final int marginX = 2;
    final DynamicProgressElement<?> progressBar;
    private final LabelElement<?> description;

    protected AbstractTaskElement(ISpatial spatial, T task, BountyElement.Status status) {
        super(spatial);
        this.task = task;
        this.taskReward = ((Task)task).getTaskReward();
        LabelElement statusLabel = new LabelElement((IPosition)Spatials.positionXY(2, 5), (Component)new TextComponent("Status: ").m_130940_(ChatFormatting.BLACK).m_7220_((Component)status.getDisplay()), LabelTextStyle.defaultStyle());
        LabelElement descriptionLabel = new LabelElement((IPosition)Spatials.positionXY(2, 20), (Component)new TextComponent("Description:").m_130940_(ChatFormatting.BLACK), LabelTextStyle.defaultStyle());
        LabelElement descriptionElement = (LabelElement)new LabelElement((IPosition)Spatials.positionXY(2, descriptionLabel.bottom() + 1).width(this.getWorldSpatial().width() - 4), (Component)TextUtil.listToComponent(this.getDescription()), LabelTextStyle.wrap()).tooltip(Tooltips.shift(Tooltips.single(this::getTargetDisplayName), Tooltips.multi(this::getExtendedDisplay)));
        if (task instanceof KillEntityTask) {
            KillEntityTask killEntityTask = (KillEntityTask)task;
            this.addElement(new ClickableLabelElement((IPosition)Spatials.positionXYZ(2, descriptionLabel.bottom() + 1, 1).width(this.getWorldSpatial().width() - 4).height(20), Component.m_130674_((String)""), LabelTextStyle.defaultStyle(), () -> Minecraft.m_91087_().m_91152_((Screen)new BestiaryScreen(((KillEntityProperties)killEntityTask.getProperties()).getFilter())))).layout((screen, gui, parent, world) -> {
                world.width(this.width() - 4);
                world.height(20);
            });
        }
        this.description = (LabelElement)this.addElement(descriptionElement).layout((screen, gui, parent, world) -> world.width(this.width() - 4));
        int descriptionHeight = this.description.getTextStyle().getLabelHeight(this.description.getComponent(), this.description.width() - this.marginX / 2);
        LabelElement progressLabel = new LabelElement((IPosition)Spatials.positionXY(2, descriptionHeight + 18 + 15), (Component)new TextComponent("Progress:").m_130940_(ChatFormatting.BLACK), LabelTextStyle.defaultStyle());
        int barWidth = this.getWorldSpatial().width() - 4;
        this.progressBar = new DynamicProgressElement(Spatials.positionXY(2, progressLabel.bottom()), Spatials.size(barWidth, 8), ScreenTextures.BOUNTY_PROGRESS_BAR, this::getProgressPercentage);
        DecimalFormat df = new DecimalFormat("0");
        TextComponent progressComponent = new TextComponent(df.format(this.getAmountObtained()) + "/" + df.format(this.getAmountRequired()));
        LabelElement progressText = (LabelElement)new LabelElement((IPosition)Spatials.positionXYZ(2, this.progressBar.y(), 5).width(this.getWorldSpatial().width() - 4), (Component)progressComponent.m_130940_(ChatFormatting.WHITE), LabelTextStyle.center().shadow()).layout((screen, gui, parent, world) -> world.width(this.getWorldSpatial().width() - 2));
        String rewardPool = ((TaskProperties)((Task)task).getProperties()).getRewardPool();
        TextColor textColor = ModConfigs.COLORS.getColor(rewardPool);
        LabelElement rewardText = new LabelElement((IPosition)Spatials.positionXY(2, progressText.y() + progressText.height() + 7), (Component)new TextComponent("Rewards: (").m_130940_(ChatFormatting.BLACK).m_7220_((Component)new TextComponent(rewardPool).m_130948_(Style.f_131099_.m_131148_(textColor))).m_7220_((Component)new TextComponent(")").m_130940_(ChatFormatting.BLACK)), LabelTextStyle.defaultStyle());
        int vaultExp = this.taskReward.getVaultExp();
        boolean hasVaultExp = vaultExp > 0;
        LabelElement vaultExpLabel = null;
        if (hasVaultExp) {
            vaultExpLabel = new LabelElement((IPosition)Spatials.positionXYZ(2, rewardText.bottom(), 1), (Component)new TextComponent("+" + vaultExp + " Vault XP").m_130940_(ChatFormatting.YELLOW), LabelTextStyle.shadow());
        }
        int stackX = 2;
        int stackY = hasVaultExp ? vaultExpLabel.y() + vaultExpLabel.height() + 1 : rewardText.bottom();
        List<OverSizedItemStack> stacks = this.taskReward.getRewardItems();
        for (OverSizedItemStack stack : stacks) {
            this.addElement((FakeOversizedItemSlotElement)new FakeOversizedItemSlotElement((ISpatial)Spatials.positionXY(stackX, stackY), () -> stack, () -> false).setLabelStackCount().tooltip(Tooltips.shift(Tooltips.multi(() -> {
                List tooltipLines = stack.stack().m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL);
                if (stack.stack().m_41720_() instanceof VaultGearItem) {
                    tooltipLines.add(new TextComponent(" "));
                    tooltipLines.add(new TextComponent("Vault Gear level is locked to your Vault Level at the time of Bounty generation.").m_130940_(ChatFormatting.DARK_GRAY));
                }
                return tooltipLines;
            }), Tooltips.multi(() -> {
                List tooltipLines = stack.stack().m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.ADVANCED);
                if (stack.stack().m_41720_() instanceof VaultGearItem) {
                    tooltipLines.add(new TextComponent(" "));
                    tooltipLines.add(new TextComponent("Vault Gear level is locked to your Vault Level at the time of Bounty generation.").m_130940_(ChatFormatting.DARK_GRAY));
                }
                return tooltipLines;
            }))));
            if ((stackX += 18) + 18 <= this.getWorldSpatial().width() - 1) continue;
            stackY += 18;
            stackX = 2;
        }
        this.addElements(statusLabel, descriptionLabel, this.description, progressLabel, this.progressBar, progressText, rewardText, vaultExpLabel);
    }

    private int getLabelHeight(LabelElement<?> label) {
        int n = label.getTextStyle().calculateLines(label.getComponent(), label.width() - 1);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return n * 9;
    }

    private int getCenteredTextStartX(int width, TextComponent component) {
        return width / 2 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component) / 2;
    }

    protected abstract float getProgressPercentage();

    protected abstract double getAmountRequired();

    protected abstract double getAmountObtained();

    protected abstract List<MutableComponent> getDescription();

    protected abstract MutableComponent getTargetDisplayName();

    protected abstract List<Component> getExtendedDisplay();

    protected List<MutableComponent> getDimensionsForDescription() {
        ArrayList<MutableComponent> dimensionComponents = new ArrayList<MutableComponent>();
        List<TextComponent> names = ((TaskProperties)((Task)this.task).getProperties()).getValidDimensions().stream().map(TextUtil::formatLocationPathAsProperNoun).toList();
        if (((TaskProperties)((Task)this.task).getProperties()).isVaultOnly()) {
            dimensionComponents.add((MutableComponent)new TextComponent(" - The Vault"));
        } else if (names.isEmpty()) {
            dimensionComponents.add((MutableComponent)new TextComponent(" - Any Dimension"));
        } else {
            names.forEach(name -> dimensionComponents.add(new TextComponent(" - ").m_7220_((Component)name)));
        }
        return dimensionComponents;
    }

    public T getTask() {
        return this.task;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTaskElement that = (AbstractTaskElement)o;
        return this.task != null ? ((Task)this.task).getBountyId().equals(((Task)that.task).getBountyId()) : that.task == null;
    }

    public static <E extends AbstractTaskElement<T>, T extends Task<?>> E create(ResourceLocation taskId, ISpatial spatial, T task, BountyElement.Status status) {
        if (taskId.equals((Object)TaskRegistry.KILL_ENTITY)) {
            return (E)new KillEntityTaskElement(spatial, (KillEntityTask)task, status);
        }
        if (taskId.equals((Object)TaskRegistry.DAMAGE_ENTITY)) {
            return (E)new DamageEntityTaskElement(spatial, (DamageTask)task, status);
        }
        if (taskId.equals((Object)TaskRegistry.COMPLETION)) {
            return (E)new CompletionTaskElement(spatial, (CompletionTask)task, status);
        }
        if (taskId.equals((Object)TaskRegistry.ITEM_SUBMISSION)) {
            return (E)new ItemSubmissionTaskElement(spatial, (ItemSubmissionTask)task, status);
        }
        if (taskId.equals((Object)TaskRegistry.ITEM_DISCOVERY)) {
            return (E)new ItemDiscoveryTaskElement(spatial, (ItemDiscoveryTask)task, status);
        }
        if (taskId.equals((Object)TaskRegistry.MINING)) {
            return (E)new MiningTaskElement(spatial, (MiningTask)task, status);
        }
        throw new IllegalArgumentException("No Task Element defined for " + String.valueOf(taskId));
    }
}

