/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.VaultAbilityKeyBinding;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.screen.player.legacy.LegacySkillTreeElementContainerScreen;
import iskallia.vault.client.gui.screen.player.legacy.SplitTabContent;
import iskallia.vault.client.gui.screen.player.legacy.TabContent;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.dialog.AbilityDialog;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.pan.AbilityPanRegion;
import iskallia.vault.container.NBTElementContainer;
import iskallia.vault.skill.tree.AbilityTree;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class AbilitiesElementContainerScreen
extends LegacySkillTreeElementContainerScreen<AbilityTree> {
    public static final int TAB_INDEX = 1;

    public AbilitiesElementContainerScreen(NBTElementContainer<AbilityTree> container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getImmediate());
        this.addElement((AbilityKeybindLock)((AbilityKeybindLock)new AbilityKeybindLock(Spatials.positionXY(-10, 25), () -> {
            VaultAbilityKeyBinding.isEnabled = !VaultAbilityKeyBinding.isEnabled;
        }).tooltip(() -> new TextComponent("Toggle Quick Ability Keybind").m_130940_(VaultAbilityKeyBinding.isEnabled ? ChatFormatting.GREEN : ChatFormatting.RED))).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(this.getTabContentSpatial())));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(-15, 20, -50).size(20, 28), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(this.getTabContentSpatial())));
    }

    public AbilityTree getAbilityTree() {
        return (AbilityTree)((NBTElementContainer)this.f_97732_).getData();
    }

    @Override
    public int getTabIndex() {
        return 1;
    }

    @Override
    public MutableComponent getTabTitle() {
        return new TextComponent("Abilities");
    }

    @Override
    public TabContent getTabContent() {
        AbilityDialog abilityDialog = new AbilityDialog(this.getAbilityTree(), this);
        AbilityPanRegion abilityPanningContent = new AbilityPanRegion(abilityDialog, this);
        return new SplitTabContent(this, abilityDialog, abilityPanningContent);
    }

    @Override
    protected void renderPointOverlay(PoseStack matrixStack) {
        this.renderSkillPointOverlay(matrixStack);
        this.renderRegretPointOverlay(matrixStack);
    }

    private class AbilityKeybindLock
    extends ButtonElement<AbilityKeybindLock> {
        public AbilityKeybindLock(IPosition position, Runnable onClick) {
            super(position, ScreenTextures.BUTTON_TOGGLE_OFF_TEXTURES, onClick);
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            ButtonElement.ButtonTextures textures = VaultAbilityKeyBinding.isEnabled ? ScreenTextures.BUTTON_TOGGLE_ON_TEXTURES : ScreenTextures.BUTTON_TOGGLE_OFF_TEXTURES;
            TextureAtlasRegion texture = textures.selectTexture(this.isDisabled(), this.containsMouse(mouseX, mouseY), false);
            renderer.render(texture, poseStack, (IPosition)this.worldSpatial);
        }
    }
}

