/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.tab.split.dialog;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.component.ScrollableContainer;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.helper.FontHelper;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.player.PrestigePowersElementContainerScreen;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.dialog.SkillDialog;
import iskallia.vault.client.gui.screen.player.legacy.widget.PrestigePowerWidget;
import iskallia.vault.config.entry.SkillStyle;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.PrestigePowerLevelMessage;
import iskallia.vault.skill.base.GroupedSkill;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.prestige.core.PrestigePower;
import iskallia.vault.skill.tree.PrestigeTree;
import java.awt.Rectangle;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class PrestigePowersDialog
extends SkillDialog<PrestigeTree, PrestigePowersElementContainerScreen> {
    public PrestigePowersDialog(PrestigeTree prestigeTree, PrestigePowersElementContainerScreen skillTreeScreen) {
        super(prestigeTree, skillTreeScreen);
    }

    @Override
    protected int getUnspentSkillPoints() {
        return VaultBarOverlay.unspentPrestigePoints;
    }

    @Override
    public void renderDescriptions(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Rectangle renderableBounds = this.descriptionComponent.getRenderableBounds();
        TextComponent text = new TextComponent("");
        text.m_7220_((Component)ModConfigs.SKILL_DESCRIPTIONS.getDescriptionFor(this.skillGroup.getId()));
        text.m_130946_("\n\n").m_7220_(this.getAdditionalDescription(this.skillGroup));
        int renderedLineCount = UIHelper.renderWrappedText(matrixStack, (Component)text, renderableBounds.width, 10);
        this.descriptionComponent.setInnerHeight(renderedLineCount * 10 + 20);
        RenderSystem.m_69482_();
    }

    @Override
    protected Component getAdditionalDescription(TieredSkill skillGroup) {
        int lvl;
        String arrow = String.valueOf('\u25b6');
        MutableComponent costArrowTxt = new TextComponent(" " + arrow + " ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x484847)));
        MutableComponent lvlReqArrowTxt = new TextComponent(" " + arrow + " ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x484847)));
        MutableComponent txt = new TextComponent("Prestige Point Cost: ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x484847)));
        for (int lvl2 = 1; lvl2 <= skillGroup.getMaxLearnableTier(); ++lvl2) {
            if (lvl2 > 1) {
                txt.m_7220_((Component)costArrowTxt);
            }
            int cost = skillGroup.getChild(lvl2).getLearnPointCost();
            txt.m_7220_((Component)new TextComponent(String.valueOf(cost)).m_130940_(ChatFormatting.WHITE));
        }
        MutableComponent knowledgeTxt = new TextComponent("\nKnowledge Cost: ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x484847)));
        for (int lvl3 = 1; lvl3 <= skillGroup.getMaxLearnableTier(); ++lvl3) {
            if (lvl3 > 1) {
                knowledgeTxt.m_7220_((Component)costArrowTxt);
            }
            int knowledgeCost = 0;
            LearnableSkill learnableSkill = skillGroup.getChild(lvl3);
            if (learnableSkill instanceof PrestigePower) {
                PrestigePower prestigePower = (PrestigePower)learnableSkill;
                knowledgeCost = prestigePower.getLearnKnowledgeCost();
            }
            knowledgeTxt.m_7220_((Component)new TextComponent(String.valueOf(knowledgeCost)).m_130940_(ChatFormatting.WHITE));
        }
        txt.m_7220_((Component)knowledgeTxt);
        MutableComponent tierTxt = new TextComponent("\nTier: ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x484847)));
        for (lvl = 1; lvl <= skillGroup.getMaxLearnableTier(); ++lvl) {
            if (lvl > 1) {
                tierTxt.m_7220_((Component)costArrowTxt);
            }
            int tier = 0;
            LearnableSkill learnableSkill = skillGroup.getChild(lvl);
            if (learnableSkill instanceof PrestigePower) {
                PrestigePower prestigePower = (PrestigePower)learnableSkill;
                tier = prestigePower.getTier();
            }
            tierTxt.m_7220_((Component)new TextComponent(String.valueOf(tier)).m_130940_(ChatFormatting.WHITE));
        }
        txt.m_7220_((Component)tierTxt);
        for (lvl = 1; lvl <= skillGroup.getMaxLearnableTier(); ++lvl) {
            if (lvl > 1) {
                tierTxt.m_7220_((Component)costArrowTxt);
            }
            int tierRequiredLevel = 0;
            int previousTierCost = 0;
            LearnableSkill learnableSkill = skillGroup.getChild(lvl);
            if (learnableSkill instanceof PrestigePower) {
                PrestigePower prestigePower = (PrestigePower)learnableSkill;
                tierRequiredLevel = prestigePower.getTierLock() + this.getSpentPrestigeInTier((PrestigeTree)this.skillTree, prestigePower.getTier() - 1);
                for (PrestigePower power : ((PrestigeTree)this.skillTree).getAll(PrestigePower.class, Skill::isUnlocked)) {
                    if (power.getTier() != prestigePower.getTier() - 1 || power.getLearnPointCost() <= 0 || previousTierCost != 0) continue;
                    previousTierCost = power.getLearnPointCost();
                }
            }
            if (tierRequiredLevel > 0 && previousTierCost > 0) {
                tierRequiredLevel -= previousTierCost;
            }
            MutableComponent requiredPrestigeInPreviousTierTxt = new TextComponent("\nRequires that you have spent %s points in the previous tier".formatted(tierRequiredLevel)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x484847)));
            txt.m_7220_((Component)requiredPrestigeInPreviousTierTxt);
        }
        boolean displayRequirements = false;
        TextComponent lvlReq = new TextComponent("\n\nLevel requirement: ");
        for (int lvl4 = 1; lvl4 <= skillGroup.getMaxLearnableTier(); ++lvl4) {
            if (lvl4 > 1) {
                lvlReq.m_7220_((Component)lvlReqArrowTxt);
            }
            int levelRequirement = skillGroup.getChild(lvl4).getUnlockLevel();
            TextComponent lvlReqPart = new TextComponent(String.valueOf(levelRequirement));
            if (VaultBarOverlay.vaultLevel < levelRequirement) {
                lvlReqPart.m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x7E0000)));
            } else {
                lvlReqPart.m_130940_(ChatFormatting.WHITE);
            }
            lvlReq.m_7220_((Component)lvlReqPart);
            if (levelRequirement <= 0) continue;
            displayRequirements = true;
        }
        if (displayRequirements) {
            txt.m_7220_((Component)lvlReq);
        } else {
            txt.m_7220_((Component)new TextComponent("\n\nNo Level requirements"));
        }
        return txt;
    }

    protected int getSpentPrestigeInTier(PrestigeTree tree, int tier) {
        int spent = 0;
        for (PrestigePower power : tree.getAll(PrestigePower.class, Skill::isUnlocked)) {
            if (power.getTier() != tier) continue;
            spent += power.getLearnPointCost();
        }
        return spent;
    }

    @Override
    public void update() {
        if (this.skillGroup != null) {
            SkillStyle abilityStyle = this.getStyles().get(this.skillGroup.getId());
            this.skillWidget = new PrestigePowerWidget(this.skillGroup, (PrestigeTree)this.skillTree, new SkillStyle(abilityStyle.x, abilityStyle.y, abilityStyle.icon, abilityStyle.frameType));
            this.skillWidget.setRenderPips(false);
            int cost = this.skillGroup.getLearnPointCost();
            String levelUpText = !this.skillGroup.isUnlocked() ? "Learn" : (this.skillGroup.getUnmodifiedTier() >= this.skillGroup.getMaxLearnableTier() ? "Learned" : "Upgrade");
            this.learnButton = new Button(0, 0, 0, 0, (Component)new TextComponent(levelUpText), button -> this.upgradeSkill(), Button.f_93716_);
            this.descriptionComponent = new ScrollableContainer(this::renderDescriptions);
            boolean isLocked = this.isSkillLocked();
            boolean fulfillsRequirements = VaultBarOverlay.vaultLevel >= this.skillGroup.getUnlockLevel();
            Skill skill = this.skillGroup.getParent();
            if (skill instanceof GroupedSkill) {
                GroupedSkill grouped = (GroupedSkill)skill;
                grouped.select(this.skillGroup.getId());
                fulfillsRequirements &= grouped.canLearn(SkillContext.ofPrestigeClient());
            }
            SkillContext context = this.getSkillContext();
            boolean canAffordSkill = this.skillGroup.canLearn(context);
            this.learnButton.f_93623_ = cost <= this.getUnspentSkillPoints() && fulfillsRequirements && !isLocked && canAffordSkill && this.skillGroup.getUnmodifiedTier() < this.skillGroup.getMaxLearnableTier();
            this.updateRegretButton();
        }
    }

    @Override
    protected void updateRegretButton() {
        this.regretButton = null;
    }

    @Override
    protected HashMap<String, SkillStyle> getStyles() {
        return ModConfigs.PRESTIGE_POWERS_GUI.getStyles();
    }

    @Override
    protected SkillContext getSkillContext() {
        return SkillContext.ofPrestigeClient();
    }

    @Override
    protected void sendUpgradeMessage() {
        ModNetwork.CHANNEL.sendToServer((Object)new PrestigePowerLevelMessage(this.skillGroup.getId(), true));
    }

    @Override
    protected void renderHeading(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ScreenTextures.UI_RESOURCE);
        SkillStyle style = this.getStyles().get(this.skillGroup.getId());
        Rectangle widgetBounds = this.skillWidget.getClickableBounds();
        UIHelper.renderContainerBorder(this, matrixStack, this.getHeadingBounds(), 14, 44, 2, 2, 2, 2, -7631989);
        String abilityName = this.skillGroup.getName();
        String subText = !this.skillGroup.isUnlocked() ? "Not Learned Yet" : "Claimed";
        int gap = 0;
        matrixStack.m_85836_();
        matrixStack.m_85837_(10.0, 0.0, 0.0);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(widgetBounds.width + gap), 13.0, 0.0);
        FontHelper.drawTextComponent(matrixStack, (Component)new TextComponent(abilityName).m_130948_(Style.f_131099_.m_131148_(!this.skillGroup.isUnlocked() ? TextColor.m_131266_((int)0xFFFFFF) : TextColor.m_131266_((int)16775367))), false);
        matrixStack.m_85837_(0.0, 10.0, 0.0);
        FontHelper.drawTextComponent(matrixStack, (Component)new TextComponent(subText).m_130948_(Style.f_131099_.m_131148_(!this.skillGroup.isUnlocked() ? TextColor.m_131266_((int)0xC4C4C4) : TextColor.m_131266_((int)16775367))), false);
        matrixStack.m_85849_();
        matrixStack.m_85837_((double)(-style.x), (double)(-style.y), 0.0);
        matrixStack.m_85837_(widgetBounds.getWidth() / 2.0, 0.0, 0.0);
        matrixStack.m_85837_(0.0, 23.0, 0.0);
        this.skillWidget.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85849_();
    }
}

