/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.tab.split.dialog;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.player.TalentsElementContainerScreen;
import iskallia.vault.client.gui.screen.player.element.RegretButton;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.dialog.SkillDialog;
import iskallia.vault.config.entry.SkillStyle;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.TalentLevelMessage;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.util.CoinDefinition;
import iskallia.vault.util.InventoryUtil;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TalentDialog
extends SkillDialog<TalentTree, TalentsElementContainerScreen> {
    public TalentDialog(TalentTree talentTree, TalentsElementContainerScreen skillTreeScreen) {
        super(talentTree, skillTreeScreen);
    }

    @Override
    protected int getUnspentSkillPoints() {
        return VaultBarOverlay.unspentSkillPoints;
    }

    @Override
    protected void updateRegretButton() {
        int regretCost = this.skillGroup.getRegretCost();
        boolean hasDependants = false;
        if (this.skillGroup.getUnmodifiedTier() == 1) {
            List<String> dependentNodes = ModConfigs.SKILL_GATES.getGates().getSkillsDependingOn(this.skillGroup.getId(), this.skillTree);
            for (String dependent : dependentNodes) {
                if (!((TalentTree)this.skillTree).getForId(dependent).map(Skill::isUnlocked).orElse(false).booleanValue()) continue;
                hasDependants = true;
                break;
            }
        }
        this.regretButton = new RegretButton(this.bounds.x, this.bounds.y, 0, 0, this.bounds.x, this.bounds.y, regretCost, button -> this.unlearnTalent());
        boolean bl = this.regretButton.f_93623_ = this.skillGroup.isUnlocked() && !this.isSkillLocked() && !hasDependants;
        if (this.regretButton.m_142518_()) {
            List<InventoryUtil.ItemAccess> items = InventoryUtil.findAllItems((Player)Minecraft.m_91087_().f_91074_);
            boolean hasEnoughCurrency = CoinDefinition.hasEnoughCurrency(items, new ItemStack((ItemLike)ModBlocks.VAULT_GOLD, regretCost));
            if (!hasEnoughCurrency) {
                this.regretButton.f_93623_ = false;
            }
            if (ClientVaults.getActive().isPresent()) {
                this.regretButton.f_93623_ = false;
            }
        }
    }

    @Override
    protected HashMap<String, SkillStyle> getStyles() {
        return ModConfigs.TALENTS_GUI.getStyles();
    }

    @Override
    protected SkillContext getSkillContext() {
        return SkillContext.ofClient();
    }

    private void unlearnTalent() {
        if (!this.skillGroup.isUnlocked()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null) {
            minecraft.f_91074_.m_5496_(ModSounds.SKILL_TREE_UPGRADE_SFX, 1.0f, 1.0f);
        }
        this.skillGroup.regret(SkillContext.ofClient());
        this.update();
        ModNetwork.CHANNEL.sendToServer((Object)new TalentLevelMessage(this.skillGroup.getId(), false));
    }

    @Override
    protected void renderRegretButton(PoseStack matrixStack, float partialTicks, int containerX, int containerY) {
        this.regretButton.m_6305_(matrixStack, containerX, containerY, partialTicks);
    }

    @Override
    protected void sendUpgradeMessage() {
        ModNetwork.CHANNEL.sendToServer((Object)new TalentLevelMessage(this.skillGroup.getId(), true));
    }
}

