/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.tab.split.pan;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.screen.player.ResearchesElementContainerScreen;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.dialog.ResearchDialog;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.spi.AbstractPanRegion;
import iskallia.vault.client.gui.screen.player.legacy.widget.ResearchGroupWidget;
import iskallia.vault.client.gui.screen.player.legacy.widget.ResearchWidget;
import iskallia.vault.client.gui.screen.player.legacy.widget.connect.ConnectorWidget;
import iskallia.vault.config.entry.ResearchGroupStyle;
import iskallia.vault.config.entry.SkillStyle;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.util.MiscUtils;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class ResearchPanRegion
extends AbstractPanRegion<ResearchesElementContainerScreen> {
    private final List<ResearchGroupWidget> researchGroups = new LinkedList<ResearchGroupWidget>();
    private final Map<String, ResearchWidget> researchWidgets = new HashMap<String, ResearchWidget>();
    private final List<ConnectorWidget> researchConnectors = new LinkedList<ConnectorWidget>();
    private final ResearchDialog researchDialog;
    private ResearchWidget selectedWidget;

    public ResearchPanRegion(ResearchDialog researchDialog, ResearchesElementContainerScreen parentScreen) {
        super(parentScreen, (Component)new TextComponent("Researches Tab"));
        this.researchDialog = researchDialog;
    }

    @Override
    protected Collection<? extends AbstractWidget> getWidgets() {
        return this.researchWidgets.values();
    }

    @Override
    public void update() {
        this.researchGroups.clear();
        this.researchWidgets.clear();
        this.researchConnectors.clear();
        ResearchTree researchTree = ((ResearchesElementContainerScreen)this.parentScreen).getResearchTree();
        ModConfigs.RESEARCH_GROUPS.getGroups().forEach((groupId, group) -> {
            ResearchGroupStyle style = ModConfigs.RESEARCH_GROUP_STYLES.getStyle((String)groupId);
            if (style != null) {
                this.researchGroups.add(new ResearchGroupWidget(style, researchTree, () -> this.selectedWidget));
            }
        });
        ModConfigs.RESEARCHES_GUI.getStyles().forEach((researchName, style) -> this.researchWidgets.put((String)researchName, new ResearchWidget((String)researchName, researchTree, (SkillStyle)style)));
        ModConfigs.RESEARCHES_GUI.getStyles().forEach((researchName, style) -> {
            ResearchWidget target = this.researchWidgets.get(researchName);
            if (target == null) {
                return;
            }
            ModConfigs.SKILL_GATES.getGates().getDependencyResearches((String)researchName).forEach(dependentOn -> {
                ResearchWidget source = this.researchWidgets.get(dependentOn.getName());
                if (source == null) {
                    return;
                }
                if (!ModConfigs.SKILL_GATES.getGates().shouldDrawArrow((String)researchName, dependentOn.getName())) {
                    return;
                }
                this.researchConnectors.add(new ConnectorWidget(source, target, ConnectorWidget.ConnectorType.ARROW));
            });
            ModConfigs.SKILL_GATES.getGates().getLockedByResearches((String)researchName).forEach(dependentOn -> {
                ResearchWidget source = this.researchWidgets.get(dependentOn.getName());
                if (source == null) {
                    return;
                }
                if (!ModConfigs.SKILL_GATES.getGates().shouldDrawArrow((String)researchName, dependentOn.getName())) {
                    return;
                }
                this.researchConnectors.add(new ConnectorWidget(source, target, ConnectorWidget.ConnectorType.DOUBLE_ARROW));
            });
        });
        this.loadViewportTransforms(false);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        Point2D.Float midpoint = MiscUtils.getMidpoint(this.getBounds());
        int containerMouseX = (int)((mouseX - (double)midpoint.x) / (double)this.viewportScale - (double)this.viewportTranslation.f_82470_);
        int containerMouseY = (int)((mouseY - (double)midpoint.y) / (double)this.viewportScale - (double)this.viewportTranslation.f_82471_);
        boolean researchWidgetClicked = false;
        for (ResearchWidget researchWidget : this.researchWidgets.values()) {
            if (!researchWidget.m_5953_(containerMouseX, containerMouseY) || !researchWidget.m_6375_(containerMouseX, containerMouseY, button)) continue;
            if (this.selectedWidget != null) {
                this.selectedWidget.deselect();
            }
            this.selectedWidget = researchWidget;
            this.selectedWidget.select();
            this.researchDialog.setResearchName(this.selectedWidget.getResearchName());
            researchWidgetClicked = true;
            break;
        }
        return researchWidgetClicked;
    }

    @Override
    public void renderTabForeground(PoseStack renderStack, Rectangle containerBounds, int mouseX, int mouseY, float pTicks, List<Runnable> postContainerRender) {
        RenderSystem.m_69478_();
        Point2D.Float midpoint = MiscUtils.getMidpoint(this.getBounds());
        renderStack.m_85836_();
        renderStack.m_85837_((double)midpoint.x, (double)midpoint.y, 0.0);
        renderStack.m_85841_(this.viewportScale, this.viewportScale, 1.0f);
        renderStack.m_85837_((double)this.viewportTranslation.f_82470_, (double)this.viewportTranslation.f_82471_, 0.0);
        int containerMouseX = (int)(((float)mouseX - midpoint.x) / this.viewportScale - this.viewportTranslation.f_82470_);
        int containerMouseY = (int)(((float)mouseY - midpoint.y) / this.viewportScale - this.viewportTranslation.f_82471_);
        for (ResearchGroupWidget researchGroupWidget : this.researchGroups) {
            researchGroupWidget.m_6305_(renderStack, containerMouseX, containerMouseY, pTicks);
        }
        for (ConnectorWidget researchConnector : this.researchConnectors) {
            researchConnector.renderConnection(renderStack);
        }
        for (ResearchWidget researchWidget : this.researchWidgets.values()) {
            researchWidget.renderWidget(renderStack, containerBounds, mouseX, mouseY, containerMouseX, containerMouseY, pTicks, postContainerRender);
        }
        renderStack.m_85849_();
    }
}

