/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.tab.split.pan;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.screen.player.SkillsElementContainerScreen;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.dialog.SkillDialog;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.spi.AbstractPanRegion;
import iskallia.vault.client.gui.screen.player.legacy.widget.SkillWidget;
import iskallia.vault.client.gui.screen.player.legacy.widget.TalentGroupWidget;
import iskallia.vault.client.gui.screen.player.legacy.widget.connect.ConnectorWidget;
import iskallia.vault.config.entry.SkillStyle;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.tree.SkillTree;
import iskallia.vault.util.MiscUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public abstract class SkillPanRegion<T extends SkillTree, S extends SkillsElementContainerScreen<T>, W extends SkillWidget<T>>
extends AbstractPanRegion<S> {
    protected final Map<String, W> skillWidgets = new HashMap<String, W>();
    protected final List<TalentGroupWidget> groupWidgets = new ArrayList<TalentGroupWidget>();
    protected final List<ConnectorWidget> skillConnectors = new LinkedList<ConnectorWidget>();
    protected final SkillDialog<T, S> skillDialog;
    protected W selectedWidget;

    protected SkillPanRegion(S parentScreen, Component title, SkillDialog<T, S> skillDialog) {
        super(parentScreen, title);
        this.skillDialog = skillDialog;
    }

    @Override
    public void update() {
        this.skillWidgets.clear();
        this.groupWidgets.clear();
        Object skillTree = ((SkillsElementContainerScreen)this.parentScreen).getSkillTree();
        this.getStyles().forEach((skillName, style) -> this.initSkillWidget(skillTree, (String)skillName, (SkillStyle)style, this.skillWidgets, this.groupWidgets));
        this.getStyles().forEach((skillName, style) -> {
            SkillWidget target = (SkillWidget)this.skillWidgets.get(skillName);
            if (target == null) {
                return;
            }
            ModConfigs.SKILL_GATES.getGates().getDependencySkills((String)skillName).forEach(dependentOn -> {
                SkillWidget source = (SkillWidget)this.skillWidgets.get(dependentOn);
                if (source == null) {
                    return;
                }
                if (!ModConfigs.SKILL_GATES.getGates().shouldDrawArrow((String)skillName, (String)dependentOn)) {
                    return;
                }
                this.skillConnectors.add(new ConnectorWidget(source, target, ConnectorWidget.ConnectorType.ARROW));
            });
            ModConfigs.SKILL_GATES.getGates().getLockedBySkills((String)skillName).forEach(dependentOn -> {
                SkillWidget source = (SkillWidget)this.skillWidgets.get(dependentOn);
                if (source == null) {
                    return;
                }
                if (!ModConfigs.SKILL_GATES.getGates().shouldDrawArrow((String)skillName, (String)dependentOn)) {
                    return;
                }
                ConnectorWidget widget = new ConnectorWidget(source, target, ConnectorWidget.ConnectorType.DOUBLE_ARROW);
                widget.setColor(new Color(0xAC0000));
                this.skillConnectors.add(widget);
            });
        });
        this.loadViewportTransforms(false);
    }

    @Override
    protected Collection<? extends AbstractWidget> getWidgets() {
        return this.skillWidgets.values();
    }

    protected abstract void initSkillWidget(T var1, String var2, SkillStyle var3, Map<String, W> var4, List<TalentGroupWidget> var5);

    protected abstract HashMap<String, SkillStyle> getStyles();

    protected void m_6057_(PoseStack pPoseStack, ItemStack pItemStack, int pMouseX, int pMouseY) {
        super.m_6057_(pPoseStack, pItemStack, pMouseX, pMouseY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        Point2D.Float midpoint = MiscUtils.getMidpoint(this.getBounds());
        int containerMouseX = (int)((mouseX - (double)midpoint.x) / (double)this.viewportScale - (double)this.viewportTranslation.f_82470_);
        int containerMouseY = (int)((mouseY - (double)midpoint.y) / (double)this.viewportScale - (double)this.viewportTranslation.f_82471_);
        boolean skillWidgetClicked = false;
        for (SkillWidget skillWidget : this.skillWidgets.values()) {
            if (!skillWidget.m_5953_(containerMouseX, containerMouseY) || !skillWidget.m_6375_(containerMouseX, containerMouseY, button)) continue;
            if (this.selectedWidget != null) {
                ((SkillWidget)this.selectedWidget).deselect();
            }
            this.selectedWidget = skillWidget;
            ((SkillWidget)this.selectedWidget).select();
            this.skillDialog.setSkillGroup(((SkillWidget)this.selectedWidget).getSkill());
            skillWidgetClicked = true;
            break;
        }
        return skillWidgetClicked;
    }

    @Override
    public void renderTabForeground(PoseStack renderStack, Rectangle containerBounds, int mouseX, int mouseY, float pTicks, List<Runnable> postContainerRender) {
        RenderSystem.m_69478_();
        Point2D.Float midpoint = MiscUtils.getMidpoint(this.getBounds());
        renderStack.m_85836_();
        renderStack.m_85837_((double)midpoint.x, (double)midpoint.y, 0.0);
        renderStack.m_85841_(this.viewportScale, this.viewportScale, 1.0f);
        renderStack.m_85837_((double)this.viewportTranslation.f_82470_, (double)this.viewportTranslation.f_82471_, 0.0);
        int containerMouseX = (int)(((float)mouseX - midpoint.x) / this.viewportScale - this.viewportTranslation.f_82470_);
        int containerMouseY = (int)(((float)mouseY - midpoint.y) / this.viewportScale - this.viewportTranslation.f_82471_);
        for (TalentGroupWidget groupWidget : this.groupWidgets) {
            groupWidget.renderWidget(renderStack, containerBounds, mouseX, mouseY, containerMouseX, containerMouseY, pTicks, postContainerRender);
        }
        for (ConnectorWidget skillConnector : this.skillConnectors) {
            skillConnector.renderConnection(renderStack);
        }
        for (SkillWidget skillWidget : this.skillWidgets.values()) {
            skillWidget.renderWidget(renderStack, containerBounds, mouseX, mouseY, containerMouseX, containerMouseY, pTicks, postContainerRender);
        }
        renderStack.m_85849_();
    }
}

