/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import iskallia.vault.client.VaultAbilityKeyBinding;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.player.legacy.widget.AbilityNodeTextures;
import iskallia.vault.client.gui.screen.player.legacy.widget.AbilityWidget;
import iskallia.vault.client.gui.screen.player.legacy.widget.NodeState;
import iskallia.vault.client.gui.widget.ComponentWidget;
import iskallia.vault.client.util.LineRenderUtil;
import iskallia.vault.client.util.TooltipUtil;
import iskallia.vault.config.AbilitiesGUIConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModKeybinds;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.tree.AbilityTree;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;

public class AbilityWidgetSelectable
extends AbilityWidget
implements ComponentWidget {
    private boolean selected = false;
    private boolean keybindConflict = false;

    public AbilityWidgetSelectable(String abilityName, AbilityTree abilityTree, int x, int y, Map<NodeState, TextureAtlasRegion> background, TextureAtlasRegion icon) {
        super(abilityName, abilityTree, x, y, background, icon);
        if (!this.isSpecialization()) {
            SpecializedSkill node = this.makeAbilityNode();
            KeyMapping keyMapping = ModKeybinds.abilityQuickfireKey.get(node.getId());
            for (KeyMapping km : Minecraft.m_91087_().f_91066_.f_92059_) {
                if (km == keyMapping || keyMapping == null || !keyMapping.m_90850_(km)) continue;
                this.keybindConflict = true;
                break;
            }
        }
    }

    public int getClickableWidth() {
        return this.f_93618_;
    }

    public int getClickableHeight() {
        return this.f_93619_;
    }

    @Override
    public Rectangle getClickableBounds() {
        return new Rectangle(this.f_93620_ - this.getClickableWidth() / 2, this.f_93621_ - this.getClickableHeight() / 2, this.getClickableWidth(), this.getClickableHeight());
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.getClickableBounds().contains(mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.selected) {
            return false;
        }
        this.m_7435_(Minecraft.m_91087_().m_91106_());
        return true;
    }

    public void select() {
        this.selected = true;
    }

    public void deselect() {
        this.selected = false;
    }

    @Override
    public void renderWidget(PoseStack matrixStack, Rectangle containerBounds, int mouseX, int mouseY, int containerMouseX, int containerMouseY, float partialTicks, List<Runnable> postContainerRender) {
        this.m_6305_(matrixStack, containerMouseX, containerMouseY, partialTicks);
        if (containerBounds.contains(mouseX, mouseY)) {
            Matrix4f current = matrixStack.m_85850_().m_85861_().m_27658_();
            postContainerRender.add(() -> {
                matrixStack.m_85836_();
                matrixStack.m_166854_(current);
                this.renderHover(matrixStack, containerMouseX, containerMouseY, partialTicks);
                matrixStack.m_85849_();
            });
        }
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        AbilitiesGUIConfig.AbilityStyle abilityStyle;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        RenderSystem.m_69478_();
        SpecializedSkill abilityNode = this.getAbilityGroup();
        int abilityLevel = ((TieredSkill)abilityNode.getSpecialization()).getUnmodifiedTier();
        int actualAbilityLevel = ((TieredSkill)abilityNode.getSpecialization()).getActualTier();
        int addedLevelDiff = actualAbilityLevel - abilityLevel;
        int abilityLevelMax = ((TieredSkill)abilityNode.getSpecialization()).getMaxLearnableTier();
        boolean isSpecialization = this.isSpecialization();
        NodeState state = isSpecialization && abilityNode.isUnlocked() && this.abilityName.equals(abilityNode.getSpecialization().getId()) ? NodeState.SELECTED : (this.isLocked() && (isSpecialization || !abilityNode.isUnlocked()) ? NodeState.DISABLED : (this.selected || this.getClickableBounds().contains(mouseX, mouseY) ? NodeState.HOVERED : (isSpecialization ? (this.abilityName.equals(abilityNode.getSpecialization().getId()) ? NodeState.SELECTED : NodeState.DEFAULT) : (abilityLevel >= 1 ? NodeState.SELECTED : NodeState.DEFAULT))));
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 1.0);
        if (!isSpecialization && (abilityStyle = ModConfigs.ABILITIES_GUI.getStyles().get(this.getAbilityGroup().getId())) != null) {
            boolean hasSpecialization;
            int specializationCount = abilityStyle.getSpecializationStyles().size() - 1;
            boolean bl = hasSpecialization = this.getAbilityGroup().getIndex() != 0;
            if (specializationCount > 0) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                matrixStack.m_85836_();
                BufferBuilder builder = Tesselator.m_85913_().m_85915_();
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                matrixStack.m_85837_(0.0, 0.0, -1.0);
                int secondaryNodeHeight = AbilityNodeTextures.SECONDARY_NODE.get((Object)NodeState.DEFAULT).height();
                float lineY1 = (float)this.f_93621_ + (float)this.f_93619_ / 2.0f + 3.0f + (float)secondaryNodeHeight / 2.0f + (float)(secondaryNodeHeight * (specializationCount - 1));
                LineRenderUtil.getInstance().drawLine((VertexConsumer)builder, matrixStack, this.f_93620_, this.f_93621_, this.f_93620_, lineY1, 5.0, -16777216);
                if (hasSpecialization) {
                    LineRenderUtil.getInstance().drawLine((VertexConsumer)builder, matrixStack, this.f_93620_, this.f_93621_, this.f_93620_, lineY1, 4.0, -3755746);
                    LineRenderUtil.getInstance().drawLine((VertexConsumer)builder, matrixStack, this.f_93620_, this.f_93621_, this.f_93620_, lineY1, 3.0, -7130);
                    LineRenderUtil.getInstance().drawLine((VertexConsumer)builder, matrixStack, this.f_93620_, this.f_93621_, this.f_93620_, lineY1, 2.0, -5016);
                } else {
                    LineRenderUtil.getInstance().drawLine((VertexConsumer)builder, matrixStack, this.f_93620_, this.f_93621_, this.f_93620_, lineY1, 4.0, -11184811);
                }
                builder.m_85721_();
                RenderSystem.m_157427_(GameRenderer::m_172811_);
                BufferUploader.m_85761_((BufferBuilder)builder);
                matrixStack.m_85849_();
            }
        }
        if (!isSpecialization && this.getAbilityGroup().isUnlocked()) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.m_85836_();
            TextureAtlasRegion region = AbilityNodeTextures.NODE_BACKGROUND_LEVEL;
            matrixStack.m_85837_((double)((float)(-region.width()) / 2.0f), (double)((float)(-this.f_93619_) / 2.0f + (float)(2 - region.height())), 0.0);
            region.blit(matrixStack, this.f_93620_, this.f_93621_);
            Font font = Minecraft.m_91087_().f_91062_;
            Object text = String.valueOf(abilityLevel);
            if (addedLevelDiff != 0) {
                text = (String)text + (addedLevelDiff > 0 ? "+" : "") + addedLevelDiff;
            }
            font.m_92883_(matrixStack, (String)text, (float)this.f_93620_ + (float)region.width() / 2.0f - (float)font.m_92895_((String)text) / 2.0f, (float)(this.f_93621_ + 2), abilityLevel >= abilityLevelMax ? -16711936 : -1);
            RenderSystem.m_69482_();
            matrixStack.m_85849_();
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)((float)(-this.f_93618_) / 2.0f), (double)((float)(-this.f_93619_) / 2.0f), 0.0);
        ((TextureAtlasRegion)this.background.get((Object)state)).blit(matrixStack, this.f_93620_, this.f_93621_);
        matrixStack.m_85849_();
        if (state == NodeState.DISABLED) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(-8.0, -8.0, 0.0);
        this.icon.blit(matrixStack, this.f_93620_, this.f_93621_);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderHover(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        KeyMapping keyMapping;
        int levelRequirement;
        if (!this.getClickableBounds().contains(mouseX, mouseY)) {
            return;
        }
        SpecializedSkill node = this.makeAbilityNode();
        TieredSkill existing = this.getAbility();
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
        tooltip.add(FormattedCharSequence.m_13714_((String)node.getSpecialization().getName(), (Style)Style.f_131099_));
        boolean specialization = this.isSpecialization();
        if (specialization) {
            tooltip.add(FormattedCharSequence.m_13714_((String)node.getName(), (Style)Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GOLD)));
        }
        if (this.isLocked() && specialization && this.getAbilityGroup().getIndex() != 0 && this.getAbilityGroup().getIndex() != node.getIndex()) {
            tooltip.add(FormattedCharSequence.m_13714_((String)("Already using " + this.getAbilityGroup().getSpecialization().getName()), (Style)Style.f_131099_.m_131140_(ChatFormatting.RED)));
        }
        if ((levelRequirement = this.getAbility().getUnlockLevel()) > 0) {
            ChatFormatting color = VaultBarOverlay.vaultLevel < levelRequirement ? ChatFormatting.RED : ChatFormatting.GREEN;
            tooltip.add(FormattedCharSequence.m_13714_((String)("Requires level: " + levelRequirement), (Style)Style.f_131099_.m_131140_(color)));
        }
        if ((keyMapping = ModKeybinds.abilityQuickfireKey.get(node.getId())) != null && !specialization) {
            int color = keyMapping.m_90862_() ? 0x666666 : (this.keybindConflict ? 0xFF5555 : 0x55FF55);
            TextComponent translatedKeyMessage = keyMapping.m_90862_() ? new TextComponent("[NONE]") : new TextComponent("").m_7220_(keyMapping.m_90863_());
            MutableComponent keybindComponent = new TextComponent("Keybind: ").m_130948_(Style.f_131099_.m_178520_(0x999999)).m_7220_((Component)translatedKeyMessage.m_130948_(Style.f_131099_.m_178520_(color)));
            tooltip.add(keybindComponent.m_7532_());
        }
        TooltipUtil.renderTooltip(matrixStack, tooltip, mouseX, mouseY, Integer.MAX_VALUE, Integer.MAX_VALUE);
        RenderSystem.m_69478_();
        if (!this.getClickableBounds().contains(mouseX, mouseY)) {
            return;
        }
        VaultAbilityKeyBinding.abilityHovering = true;
        VaultAbilityKeyBinding.skill = this.makeAbilityNode();
        VaultAbilityKeyBinding.keyMapping = ModKeybinds.abilityQuickfireKey.get(VaultAbilityKeyBinding.skill.getId());
        VaultAbilityKeyBinding.refresh();
    }
}

