/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.ITextureAtlas;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.player.legacy.widget.SkillWidget;
import iskallia.vault.client.util.TooltipUtil;
import iskallia.vault.config.entry.SkillStyle;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.prestige.core.PrestigePower;
import iskallia.vault.skill.tree.PrestigeTree;
import iskallia.vault.util.ResourceBoundary;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class PrestigePowerWidget
extends SkillWidget<PrestigeTree> {
    public PrestigePowerWidget(TieredSkill skill, PrestigeTree prestigeTree, SkillStyle style) {
        super(prestigeTree, (Component)new TextComponent("the_vault.widgets.prestige"), skill, style);
    }

    @Override
    protected ITextureAtlas getIconTextureAtlas() {
        return ModTextureAtlases.PRESTIGE.get();
    }

    @Override
    protected boolean isLocked() {
        return super.isLocked();
    }

    @Override
    protected void renderHover(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int levelRequirement;
        List<String> conflicts;
        List<String> preconditions;
        if (!this.m_5953_(mouseX, mouseY)) {
            return;
        }
        ArrayList<FormattedCharSequence> tTip = new ArrayList<FormattedCharSequence>();
        LearnableSkill learnableSkill = this.skill.getChild(1);
        if (learnableSkill instanceof PrestigePower) {
            PrestigePower pp = (PrestigePower)learnableSkill;
            boolean canLearn = pp.canLearn(SkillContext.ofPrestigeClient());
            tTip.add(FormattedCharSequence.m_13714_((String)this.skill.getName(), (Style)Style.f_131099_.m_131140_(canLearn || pp.isUnlocked() ? ChatFormatting.GREEN : ChatFormatting.RED)));
            tTip.add(FormattedCharSequence.m_13714_((String)("Tier: " + pp.getTier()), (Style)Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
            int spent = 0;
            int previousTierCost = 0;
            for (PrestigePower power : ((PrestigeTree)this.skillTree).getAll(PrestigePower.class, Skill::isUnlocked)) {
                if (power.getTier() == pp.getTier() - 1) {
                    spent += power.getLearnPointCost();
                }
                if (power.getTier() != pp.getTier() - 1 || power.getLearnPointCost() <= 0 || previousTierCost != 0) continue;
                previousTierCost = power.getLearnPointCost();
            }
            int required = pp.getTierLock() + spent;
            if (canLearn) {
                required -= previousTierCost;
            }
            if (required > 0 && !canLearn && !pp.isUnlocked()) {
                tTip.add(FormattedCharSequence.m_13714_((String)"Requires that you have spent %s points in the previous tier".formatted(required), (Style)Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
            }
        }
        if (this.locked && !(preconditions = ModConfigs.SKILL_GATES.getGates().getDependencySkills(this.skill.getId())).isEmpty()) {
            tTip.add(FormattedCharSequence.m_13714_((String)"Requires:", (Style)Style.f_131099_.m_131140_(ChatFormatting.RED)));
            preconditions.forEach(skillName -> ((PrestigeTree)this.getSkillTree()).getForId((String)skillName).ifPresent(skill -> tTip.add(FormattedCharSequence.m_13714_((String)("- " + skill.getName()), (Style)Style.f_131099_.m_131140_(ChatFormatting.RED)))));
        }
        if (!(conflicts = ModConfigs.SKILL_GATES.getGates().getLockedBySkills(this.skill.getId())).isEmpty()) {
            tTip.add(FormattedCharSequence.m_13714_((String)"Cannot be unlocked alongside:", (Style)Style.f_131099_.m_131140_(ChatFormatting.RED)));
            conflicts.forEach(skillName -> ((PrestigeTree)this.getSkillTree()).getForId((String)skillName).ifPresent(skill -> tTip.add(FormattedCharSequence.m_13714_((String)("- " + skill.getName()), (Style)Style.f_131099_.m_131140_(ChatFormatting.RED)))));
        }
        if (this.skill.getUnmodifiedTier() < this.skill.getMaxLearnableTier() && VaultBarOverlay.vaultLevel < (levelRequirement = this.skill.getUnlockLevel())) {
            tTip.add(FormattedCharSequence.m_13714_((String)("Requires level: " + levelRequirement), (Style)Style.f_131099_.m_131140_(ChatFormatting.RED)));
        }
        TooltipUtil.renderTooltip(matrixStack, tTip, mouseX, mouseY, Integer.MAX_VALUE, Integer.MAX_VALUE);
        RenderSystem.m_69478_();
    }

    @Override
    protected int getIconSize() {
        return 24;
    }

    @Override
    public void renderIcon(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        PrestigePower pp;
        ResourceBoundary resourceBoundary = this.style.frameType.getResourceBoundary();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)((float)(-this.getIconSize()) / 2.0f), (double)((float)(-this.getIconSize()) / 2.0f), 0.0);
        TextureAtlasRegion texture = this.locked ? ScreenTextures.PRESTIGE_EMPTY : (this.selected || this.m_5953_(mouseX, mouseY) ? ScreenTextures.PRESTIGE_HOVERED : (this.skill.isUnlocked() ? ScreenTextures.PRESTIGE_UNLOCKED : ScreenTextures.PRESTIGE_EMPTY));
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture.atlas().get().getAtlasResourceLocation());
        ITextureAtlas frameAtlas = texture.atlas().get();
        GuiComponent.m_93200_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (int)0, (int)texture.width(), (int)texture.height(), (TextureAtlasSprite)frameAtlas.getSprite(texture.resourceLocation()));
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-8.0, -8.0, 0.0);
        ITextureAtlas atlas = this.getIconTextureAtlas();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)atlas.getAtlasResourceLocation());
        LearnableSkill learnableSkill = this.skill.getChild(1);
        GuiComponent.m_93200_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (int)0, (int)16, (int)16, (TextureAtlasSprite)((learnableSkill instanceof PrestigePower ? !(pp = (PrestigePower)learnableSkill).canUnlockTier(SkillContext.ofPrestigeClient()) : !this.skill.canLearn(SkillContext.ofPrestigeClient())) && this.style.inactiveIcon != null ? atlas.getSprite(this.style.inactiveIcon) : atlas.getSprite(this.style.icon)));
        matrixStack.m_85849_();
    }
}

