/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.client.atlas.ITextureAtlas;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.client.gui.helper.SkillFrame;
import iskallia.vault.client.gui.screen.player.legacy.widget.ResearchWidget;
import iskallia.vault.config.entry.ResearchGroupStyle;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.research.group.ResearchGroup;
import iskallia.vault.util.ResourceBoundary;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ResearchGroupWidget
extends AbstractWidget {
    private static final int CONTENT_SPACER = 5;
    private static final int CONTAINER_CORNER_WH = 3;
    private static final int CONTAINER_HEADER_WIDTH = 3;
    private static final int CONTAINER_HEADER_HEIGHT = 20;
    private static final int CONTAINER_HEADER_ICON_FRAME_WH = 30;
    private static final int CONTAINER_HEADER_ICON_WH = 16;
    private final ResearchGroupStyle groupStyle;
    private final ResearchTree researchTree;
    private final Supplier<ResearchWidget> selectedResearchSupplier;

    public ResearchGroupWidget(ResearchGroupStyle style, ResearchTree researchTree, Supplier<ResearchWidget> selectedResearchSupplier) {
        super(style.getX(), style.getY(), ResearchGroupWidget.getGroupWidth(style), ResearchGroupWidget.getGroupHeight(style), (Component)new TextComponent("the_vault.widgets.research_group"));
        this.groupStyle = style;
        this.researchTree = researchTree;
        this.selectedResearchSupplier = selectedResearchSupplier;
    }

    private static int getGroupWidth(ResearchGroupStyle style) {
        Font fr = Minecraft.m_91087_().f_91062_;
        ResearchGroup group = ModConfigs.RESEARCH_GROUPS.getResearchGroupById(style.getGroup());
        int iconWidth = style.getIcon() == null ? 0 : 35;
        int costWidth = fr.m_92895_("XXXXXXXX") + 15 + 5;
        return Math.max(5 + iconWidth + costWidth, style.getBoxWidth());
    }

    private static int getGroupHeight(ResearchGroupStyle style) {
        int minHeight = 24;
        return Math.max(minHeight, style.getBoxHeight());
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)ScreenTextures.UI_RESOURCE);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)this.groupStyle.getX(), (double)this.groupStyle.getY(), 0.0);
        this.renderContainerBox(matrixStack, mouseX, mouseY, partialTicks);
        this.renderHeaderBox(matrixStack, mouseX, mouseY, partialTicks);
        this.renderHeaderIcon(matrixStack, mouseX, mouseY, partialTicks);
        this.renderHeaderInformation(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85849_();
    }

    private void renderHeaderInformation(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        String selectedResearch;
        Font fr = Minecraft.m_91087_().f_91062_;
        int titleOffset = 5;
        if (this.groupStyle.getIcon() != null) {
            titleOffset += 35;
        }
        int costRightOffset = this.f_93618_ - 5;
        ResearchGroup group = ModConfigs.RESEARCH_GROUPS.getResearchGroupById(this.groupStyle.getGroup());
        if (group != null) {
            String title = group.getTitle();
            title = title == null ? "" : title;
            FormattedCharSequence bidiTitle = Language.m_128107_().m_5536_((FormattedText)new TextComponent(title));
            MultiBufferSource.BufferSource renderBuf = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            fr.m_92733_(bidiTitle, (float)titleOffset, 6.0f, this.groupStyle.getHeaderTextColor(), true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)renderBuf, false, 0, LightmapHelper.getPackedFullbrightCoords());
            renderBuf.m_109911_();
            RenderSystem.m_69482_();
            RenderSystem.m_69478_();
        }
        float currentAdditional = 0.0f;
        for (String research : this.researchTree.getResearchesDone()) {
            ResearchGroup resGroup = ModConfigs.RESEARCH_GROUPS.getResearchGroup(research);
            if (resGroup == null) continue;
            currentAdditional += resGroup.getGroupIncreasedResearchCost(this.groupStyle.getGroup());
        }
        int currentAdditionalDisplay = Math.round(currentAdditional);
        boolean displayAdditional = false;
        float selectedAdditional = 0.0f;
        ResearchWidget selectedWidget = this.selectedResearchSupplier.get();
        if (selectedWidget != null && (selectedResearch = selectedWidget.getResearchName()) != null && !this.researchTree.isResearched(selectedResearch)) {
            displayAdditional = currentAdditionalDisplay != 0;
            ResearchGroup selectedGroup = ModConfigs.RESEARCH_GROUPS.getResearchGroup(selectedResearch);
            if (selectedGroup != null) {
                displayAdditional |= (selectedAdditional += selectedGroup.getGroupIncreasedResearchCost(this.groupStyle.getGroup())) != 0.0f;
            }
        }
        int selectedAdditionalDisplay = Math.round(currentAdditional + selectedAdditional) - currentAdditionalDisplay;
        if (currentAdditionalDisplay == 0 && !displayAdditional) {
            return;
        }
        Object displayStr = currentAdditionalDisplay >= 0 ? "+" + currentAdditionalDisplay : String.valueOf(currentAdditionalDisplay);
        TextComponent costDisplay = new TextComponent((String)displayStr);
        if (displayAdditional) {
            Object selectedStr = selectedAdditionalDisplay >= 0 ? "+" + selectedAdditionalDisplay : String.valueOf(selectedAdditionalDisplay);
            costDisplay.m_130946_(String.format(" (%s)", selectedStr));
        }
        FormattedCharSequence bidiCost = Language.m_128107_().m_5536_((FormattedText)costDisplay);
        MultiBufferSource.BufferSource renderBuf = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        fr.m_92733_(bidiCost, (float)(costRightOffset -= fr.m_92724_(bidiCost)), 6.0f, this.groupStyle.getHeaderTextColor(), true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)renderBuf, false, 0, LightmapHelper.getPackedFullbrightCoords());
        renderBuf.m_109911_();
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
    }

    private void renderHeaderIcon(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.groupStyle.getIcon() == null) {
            return;
        }
        ResourceBoundary iconFrame = SkillFrame.RECTANGULAR.getResourceBoundary();
        RenderSystem.m_157456_((int)0, (ResourceLocation)iconFrame.getResource());
        float iconFrameX = 5.0f;
        float iconFrameY = -5.0f;
        ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_, buf -> ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, iconFrameX, iconFrameY, 0.0f, 30.0f, 30.0f).texVanilla(iconFrame.getU(), iconFrame.getV(), iconFrame.getWidth(), iconFrame.getHeight()).draw());
        ITextureAtlas atlas = ModTextureAtlases.RESEARCH_GROUPS.get();
        TextureAtlasSprite sprite = atlas.getSprite(this.groupStyle.getIcon());
        RenderSystem.m_157456_((int)0, (ResourceLocation)atlas.getAtlasResourceLocation());
        float iconX = 12.0f;
        float iconY = 2.0f;
        ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_, buf -> ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, iconX, iconY, 0.0f, 16.0f, 16.0f).tex(sprite).draw());
    }

    private void renderHeaderBox(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int headerColor = this.groupStyle.getHeaderColor();
        ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_, buf -> {
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, 20.0f).texVanilla(166.0f, 0.0f, 3.0f, 20.0f).color(headerColor).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, this.f_93618_ - 6, 20.0f).at(3.0f, 0.0f).texVanilla(169.0f, 0.0f, 1.0f, 20.0f).color(headerColor).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, 20.0f).at(this.f_93618_ - 3, 0.0f).texVanilla(170.0f, 0.0f, 3.0f, 20.0f).color(headerColor).draw();
        });
    }

    private void renderContainerBox(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_, buf -> {
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, 3.0f).texVanilla(166.0f, 20.0f, 3.0f, 3.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, this.f_93618_ - 6, 3.0f).at(3.0f, 0.0f).texVanilla(169.0f, 20.0f, 1.0f, 3.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, 3.0f).at(this.f_93618_ - 3, 0.0f).texVanilla(170.0f, 20.0f, 3.0f, 3.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, this.f_93619_ - 6).at(0.0f, 3.0f).texVanilla(166.0f, 23.0f, 3.0f, 1.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, this.f_93619_ - 6).at(this.f_93618_ - 3, 3.0f).texVanilla(170.0f, 23.0f, 3.0f, 1.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, 3.0f).at(0.0f, this.f_93619_ - 3).texVanilla(166.0f, 24.0f, 3.0f, 3.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, this.f_93618_ - 6, 3.0f).at(3.0f, this.f_93619_ - 3).texVanilla(169.0f, 24.0f, 1.0f, 3.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, 3.0f).at(this.f_93618_ - 3, this.f_93619_ - 3).texVanilla(170.0f, 24.0f, 3.0f, 3.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, this.f_93618_ - 6, this.f_93619_ - 6).at(3.0f, 3.0f).texVanilla(169.0f, 23.0f, 1.0f, 1.0f).draw();
        });
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

