/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import iskallia.vault.client.atlas.ITextureAtlas;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.player.legacy.widget.TalentWidget;
import iskallia.vault.client.gui.screen.player.legacy.widget.connect.ConnectableWidget;
import iskallia.vault.client.gui.widget.ComponentWidget;
import iskallia.vault.client.util.TooltipUtil;
import iskallia.vault.config.entry.SkillStyle;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.tree.SkillTree;
import iskallia.vault.util.ResourceBoundary;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class SkillWidget<T extends SkillTree>
extends AbstractWidget
implements ConnectableWidget,
ComponentWidget {
    protected static final int PIP_SIZE = 8;
    protected static final int GAP_SIZE = 2;
    protected static final int ICON_SIZE = 30;
    protected static final int MAX_PIPs_INLINE = 4;
    protected static final ResourceLocation SKILL_WIDGET_RESOURCE = new ResourceLocation("the_vault", "textures/gui/skill_widget.png");
    protected final T skillTree;
    protected boolean renderPips = true;
    TieredSkill skill;
    boolean locked;
    SkillStyle style;
    boolean selected;

    public SkillWidget(T skillTree, Component pMessage, TieredSkill skill, SkillStyle style) {
        super(style.x, style.y, 48, 0, pMessage);
        this.skillTree = skillTree;
        this.skill = skill;
        this.locked = ModConfigs.SKILL_GATES.getGates().isLocked(skill.getId(), (SkillTree)skillTree) || VaultBarOverlay.vaultLevel < skill.getUnlockLevel();
        this.style = style;
        this.selected = false;
        this.f_93619_ = SkillWidget.pipRowCount(skill.getUnmodifiedTier()) * 10 - 2;
    }

    protected boolean isLocked() {
        return this.locked;
    }

    protected void setLocked(boolean locked) {
        this.locked = locked;
    }

    protected void resetLocked() {
        this.locked = ModConfigs.SKILL_GATES.getGates().isLocked(this.skill.getId(), (SkillTree)this.skillTree) || VaultBarOverlay.vaultLevel < this.skill.getUnlockLevel();
    }

    public TieredSkill getSkill() {
        return this.skill;
    }

    public T getSkillTree() {
        return this.skillTree;
    }

    public int getClickableWidth() {
        int onlyIconWidth = this.getIconSize() + 4;
        int pipLineWidth = Math.min(this.skill.getMaxLearnableTier(), 4) * 10;
        return this.hasPips() ? Math.max(pipLineWidth, onlyIconWidth) : onlyIconWidth;
    }

    public int getClickableHeight() {
        int height = 4 + this.getIconSize();
        if (this.hasPips()) {
            int lines = TalentWidget.pipRowCount(this.skill.getMaxLearnableTier());
            height += 2;
            height += lines * 8 + (lines - 1) * 2;
        }
        return height;
    }

    public boolean hasPips() {
        return this.renderPips && this.skill.getMaxLearnableTier() > 1;
    }

    public static int pipRowCount(int level) {
        return (int)Math.ceil((float)level / 4.0f);
    }

    public void m_142291_(@Nonnull NarrationElementOutput narrationElementOutput) {
    }

    @Override
    public Point2D.Double getRenderPosition() {
        return new Point2D.Double((double)this.f_93620_ - this.getRenderWidth() / 2.0, (double)this.f_93621_ - this.getRenderHeight() / 2.0);
    }

    @Override
    public double getRenderWidth() {
        return (float)this.getIconSize() - 8.0f;
    }

    @Override
    public double getRenderHeight() {
        return (float)this.getIconSize() - 8.0f;
    }

    @Override
    public Rectangle getClickableBounds() {
        return new Rectangle(this.f_93620_ - this.getClickableWidth() / 2, this.f_93621_ - this.getIconSize() / 2 - 2, this.getClickableWidth(), this.getClickableHeight());
    }

    public void setRenderPips(boolean renderPips) {
        this.renderPips = renderPips;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.getClickableBounds().contains(mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.selected) {
            return false;
        }
        this.m_7435_(Minecraft.m_91087_().m_91106_());
        return true;
    }

    public void select() {
        this.selected = true;
    }

    public void deselect() {
        this.selected = false;
    }

    public void renderWidget(PoseStack matrixStack, Rectangle containerBounds, int mouseX, int mouseY, int containerMouseX, int containerMouseY, float partialTicks, List<Runnable> postContainerRender) {
        this.m_6305_(matrixStack, containerMouseX, containerMouseY, partialTicks);
        if (containerBounds.contains(mouseX, mouseY)) {
            Matrix4f current = matrixStack.m_85850_().m_85861_().m_27658_();
            postContainerRender.add(() -> {
                matrixStack.m_85836_();
                matrixStack.m_166854_(current);
                this.renderHover(matrixStack, containerMouseX, containerMouseY, partialTicks);
                matrixStack.m_85849_();
            });
        }
    }

    protected void renderHover(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int levelRequirement;
        List<String> conflicts;
        List<String> preconditions;
        if (!this.m_5953_(mouseX, mouseY)) {
            return;
        }
        ArrayList<FormattedCharSequence> tTip = new ArrayList<FormattedCharSequence>();
        tTip.add(FormattedCharSequence.m_13714_((String)this.skill.getName(), (Style)Style.f_131099_));
        if (this.locked && !(preconditions = ModConfigs.SKILL_GATES.getGates().getDependencySkills(this.skill.getId())).isEmpty()) {
            tTip.add(FormattedCharSequence.m_13714_((String)"Requires:", (Style)Style.f_131099_.m_131140_(ChatFormatting.RED)));
            preconditions.forEach(skillName -> ((SkillTree)this.getSkillTree()).getForId((String)skillName).ifPresent(skill -> tTip.add(FormattedCharSequence.m_13714_((String)("- " + skill.getName()), (Style)Style.f_131099_.m_131140_(ChatFormatting.RED)))));
        }
        if (!(conflicts = ModConfigs.SKILL_GATES.getGates().getLockedBySkills(this.skill.getId())).isEmpty()) {
            tTip.add(FormattedCharSequence.m_13714_((String)"Cannot be unlocked alongside:", (Style)Style.f_131099_.m_131140_(ChatFormatting.RED)));
            conflicts.forEach(skillName -> ((SkillTree)this.getSkillTree()).getForId((String)skillName).ifPresent(skill -> tTip.add(FormattedCharSequence.m_13714_((String)("- " + skill.getName()), (Style)Style.f_131099_.m_131140_(ChatFormatting.RED)))));
        }
        if (this.skill.getUnmodifiedTier() < this.skill.getMaxLearnableTier() && VaultBarOverlay.vaultLevel < (levelRequirement = this.skill.getUnlockLevel())) {
            tTip.add(FormattedCharSequence.m_13714_((String)("Requires level: " + levelRequirement), (Style)Style.f_131099_.m_131140_(ChatFormatting.RED)));
        }
        TooltipUtil.renderTooltip(matrixStack, tTip, mouseX, mouseY, Integer.MAX_VALUE, Integer.MAX_VALUE);
        RenderSystem.m_69478_();
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderIcon(matrixStack, mouseX, mouseY, partialTicks);
        if (this.hasPips()) {
            this.renderPips(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public void renderIcon(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ResourceBoundary resourceBoundary = this.style.frameType.getResourceBoundary();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)((float)(-this.getIconSize()) / 2.0f), (double)((float)(-this.getIconSize()) / 2.0f), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)resourceBoundary.getResource());
        int vOffset = this.locked ? 62 : (this.selected || this.m_5953_(mouseX, mouseY) ? -31 : (this.skill.isUnlocked() ? 31 : 0));
        this.m_93228_(matrixStack, this.f_93620_, this.f_93621_, resourceBoundary.getU(), resourceBoundary.getV() + vOffset, resourceBoundary.getWidth(), resourceBoundary.getHeight());
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-8.0, -8.0, 0.0);
        ITextureAtlas atlas = this.getIconTextureAtlas();
        RenderSystem.m_157456_((int)0, (ResourceLocation)atlas.getAtlasResourceLocation());
        GuiComponent.m_93200_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (int)0, (int)16, (int)16, (TextureAtlasSprite)(this.locked && this.style.inactiveIcon != null ? atlas.getSprite(this.style.inactiveIcon) : atlas.getSprite(this.style.icon)));
        matrixStack.m_85849_();
    }

    protected ITextureAtlas getIconTextureAtlas() {
        return ModTextureAtlases.SKILLS.get();
    }

    public void renderPips(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)SKILL_WIDGET_RESOURCE);
        int rowCount = SkillWidget.pipRowCount(this.skill.getMaxLearnableTier());
        int remainingPips = this.skill.getMaxLearnableTier();
        int remainingFilledPips = this.skill.getUnmodifiedTier();
        for (int r = 0; r < rowCount; ++r) {
            this.renderPipLine(matrixStack, this.f_93620_, this.f_93621_ + this.getIconSize() / 2 + 4 + r * 10, Math.min(4, remainingPips), Math.min(4, remainingFilledPips));
            remainingPips -= 4;
            remainingFilledPips -= 4;
        }
    }

    public void renderPipLine(PoseStack matrixStack, int x, int y, int count, int filledCount) {
        int lineWidth = count * 8 + (count - 1) * 2;
        int remainingFilled = filledCount;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        matrixStack.m_85837_((double)((float)(-lineWidth) / 2.0f), -4.0, 0.0);
        for (int i = 0; i < count; ++i) {
            if (remainingFilled > 0) {
                this.m_93228_(matrixStack, 0, 0, 1, 133, 8, 8);
                --remainingFilled;
            } else {
                this.m_93228_(matrixStack, 0, 0, 1, 124, 8, 8);
            }
            matrixStack.m_85837_(10.0, 0.0, 0.0);
        }
        matrixStack.m_85849_();
    }

    protected int getIconSize() {
        return 30;
    }
}

