/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.client.gui.screen.player.legacy.widget.TalentGroupStyle;
import iskallia.vault.client.util.TooltipUtil;
import iskallia.vault.skill.base.GroupedSkill;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class TalentGroupWidget
extends AbstractWidget {
    private static final int CONTAINER_CORNER_WH = 3;
    private static final int CONTAINER_HEADER_WIDTH = 3;
    private static final int CONTAINER_HEADER_HEIGHT = 20;
    private final TalentGroupStyle style;
    private final GroupedSkill groupedSkill;

    public TalentGroupWidget(GroupedSkill groupedSkill, TalentGroupStyle style) {
        super(style.getX(), style.getY(), style.getBoxWidth(), style.getBoxHeight(), (Component)new TextComponent("the_vault.widgets.talent_group"));
        this.style = style;
        this.groupedSkill = groupedSkill;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)ScreenTextures.UI_RESOURCE);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)this.style.getX(), (double)this.style.getY(), 0.0);
        this.renderContainerBox(matrixStack, mouseX, mouseY, partialTicks);
        this.renderHeaderBox(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, (double)(this.style.getBoxHeight() - 20), 0.0);
        this.renderFooterBox(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85849_();
        this.renderHeaderInformation(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85849_();
    }

    public void renderWidget(PoseStack matrixStack, Rectangle containerBounds, int mouseX, int mouseY, int containerMouseX, int containerMouseY, float partialTicks, List<Runnable> postContainerRender) {
        this.m_6305_(matrixStack, containerMouseX, containerMouseY, partialTicks);
        if (containerBounds.contains(mouseX, mouseY)) {
            Matrix4f current = matrixStack.m_85850_().m_85861_().m_27658_();
            postContainerRender.add(() -> {
                matrixStack.m_85836_();
                matrixStack.m_166854_(current);
                this.renderHover(matrixStack, containerMouseX, containerMouseY, partialTicks);
                matrixStack.m_85849_();
            });
        }
    }

    public boolean isMouseOverHeader(double pMouseX, double pMouseY) {
        return this.f_93623_ && this.f_93624_ && pMouseX >= (double)this.f_93620_ && pMouseY >= (double)this.f_93621_ && pMouseX < (double)(this.f_93620_ + this.f_93618_) && pMouseY < (double)(this.f_93621_ + 20);
    }

    private void renderHover(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.isMouseOverHeader(mouseX, mouseY)) {
            return;
        }
        ArrayList<FormattedCharSequence> tTip = new ArrayList<FormattedCharSequence>();
        tTip.add(Language.m_128107_().m_5536_((FormattedText)new TextComponent("Grouped talents have a max amount of skill points")));
        tTip.add(Language.m_128107_().m_5536_((FormattedText)new TextComponent("that can be spent per group")));
        TooltipUtil.renderTooltip(matrixStack, tTip, mouseX, mouseY, Integer.MAX_VALUE, Integer.MAX_VALUE);
        RenderSystem.m_69478_();
    }

    private void renderHeaderInformation(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Font fr = Minecraft.m_91087_().f_91062_;
        String title = this.style.getGroup();
        FormattedCharSequence bidiTitle = Language.m_128107_().m_5536_((FormattedText)new TextComponent(title));
        MultiBufferSource.BufferSource renderBuf = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        fr.m_92733_(bidiTitle, (float)this.m_5711_() / 2.0f - (float)fr.m_92724_(bidiTitle) / 2.0f, 6.0f, this.style.getHeaderTextColor(), true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)renderBuf, false, 0, LightmapHelper.getPackedFullbrightCoords());
        bidiTitle = Language.m_128107_().m_5536_((FormattedText)new TextComponent(this.groupedSkill.getSpentLearnPoints() + " / " + this.groupedSkill.getMaxSpentLearnPoints()));
        float f = (float)this.m_5711_() / 2.0f - (float)fr.m_92724_(bidiTitle) / 2.0f;
        Objects.requireNonNull(fr);
        fr.m_92733_(bidiTitle, f, (float)(this.f_93619_ - 5 - 9), this.style.getHeaderTextColor(), true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)renderBuf, false, 0, LightmapHelper.getPackedFullbrightCoords());
        renderBuf.m_109911_();
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
    }

    private void renderHeaderBox(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int headerColor = this.style.getHeaderColor();
        ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_, buf -> {
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, 20.0f).texVanilla(166.0f, 0.0f, 3.0f, 20.0f).color(headerColor).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, this.f_93618_ - 6, 20.0f).at(3.0f, 0.0f).texVanilla(169.0f, 0.0f, 1.0f, 20.0f).color(headerColor).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, 20.0f).at(this.f_93618_ - 3, 0.0f).texVanilla(170.0f, 0.0f, 3.0f, 20.0f).color(headerColor).draw();
        });
    }

    private void renderFooterBox(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int headerColor = this.style.getHeaderColor();
        ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_, buf -> {
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, 20.0f).texVanilla(166.0f, 0.0f, 3.0f, 20.0f).color(headerColor).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, this.f_93618_ - 6, 20.0f).at(3.0f, 0.0f).texVanilla(169.0f, 0.0f, 1.0f, 20.0f).color(headerColor).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, 20.0f).at(this.f_93618_ - 3, 0.0f).texVanilla(170.0f, 0.0f, 3.0f, 20.0f).color(headerColor).draw();
        });
    }

    private void renderContainerBox(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_, buf -> {
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, 3.0f).texVanilla(166.0f, 20.0f, 3.0f, 3.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, this.f_93618_ - 6, 3.0f).at(3.0f, 0.0f).texVanilla(169.0f, 20.0f, 1.0f, 3.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, 3.0f).at(this.f_93618_ - 3, 0.0f).texVanilla(170.0f, 20.0f, 3.0f, 3.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, this.f_93619_ - 6).at(0.0f, 3.0f).texVanilla(166.0f, 23.0f, 3.0f, 1.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, this.f_93619_ - 6).at(this.f_93618_ - 3, 3.0f).texVanilla(170.0f, 23.0f, 3.0f, 1.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, 3.0f).at(0.0f, this.f_93619_ - 3).texVanilla(166.0f, 24.0f, 3.0f, 3.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, this.f_93618_ - 6, 3.0f).at(3.0f, this.f_93619_ - 3).texVanilla(169.0f, 24.0f, 1.0f, 3.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, 3.0f, 3.0f).at(this.f_93618_ - 3, this.f_93619_ - 3).texVanilla(170.0f, 24.0f, 3.0f, 3.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, this.f_93618_ - 6, this.f_93619_ - 6).at(3.0f, 3.0f).texVanilla(169.0f, 23.0f, 1.0f, 1.0f).draw();
        });
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

