/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.widget.connect;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public interface ConnectableWidget {
    public Point2D.Double getRenderPosition();

    public double getRenderWidth();

    public double getRenderHeight();

    default public Rectangle2D.Double getRenderBox() {
        return new Rectangle2D.Double(this.getRenderPosition().x, this.getRenderPosition().y, this.getRenderWidth(), this.getRenderHeight());
    }

    default public Point2D.Double getPointOnEdge(double angleDeg) {
        double theta;
        double twoPI = Math.PI * 2;
        for (theta = angleDeg * Math.PI / 180.0; theta < -Math.PI; theta += twoPI) {
        }
        while (theta > Math.PI) {
            theta -= twoPI;
        }
        double width = this.getRenderWidth();
        double height = this.getRenderHeight();
        double rectAtan = Math.atan2(height, width);
        double tanTheta = Math.tan(theta);
        double xFactor = 1.0;
        double yFactor = 1.0;
        boolean horizontal = false;
        if (theta > -rectAtan && theta <= rectAtan) {
            horizontal = true;
            yFactor = -1.0;
        } else if (theta > rectAtan && theta <= Math.PI - rectAtan) {
            yFactor = -1.0;
        } else if (theta > Math.PI - rectAtan || theta <= -(Math.PI - rectAtan)) {
            horizontal = true;
            xFactor = -1.0;
        } else {
            xFactor = -1.0;
        }
        Point2D.Double pos = this.getRenderPosition();
        if (horizontal) {
            return new Point2D.Double(pos.x + xFactor * (width / 2.0), pos.y + yFactor * (width / 2.0) * tanTheta);
        }
        return new Point2D.Double(pos.x + xFactor * (height / (2.0 * tanTheta)), pos.y + yFactor * (height / 2.0));
    }
}

