/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.widget.connect;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.client.gui.screen.player.legacy.widget.connect.ConnectableWidget;
import iskallia.vault.client.util.LineRenderUtil;
import iskallia.vault.util.VectorHelper;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class ConnectorWidget
extends AbstractWidget {
    private final ConnectorType type;
    private final Connector connector;
    private Color color = new Color(0xAAAAAA);

    public ConnectorWidget(ConnectableWidget source, ConnectableWidget target, ConnectorType type) {
        this(ConnectorWidget.buildWidgetBox(source, target), type);
    }

    private ConnectorWidget(Connector connector, ConnectorType type) {
        super(connector.rectangle.x, connector.rectangle.y, connector.rectangle.width, connector.rectangle.height, (Component)new TextComponent("Connector"));
        this.type = type;
        this.connector = connector;
    }

    public ConnectorWidget setColor(Color color) {
        this.color = color;
        return this;
    }

    private static Connector buildWidgetBox(ConnectableWidget source, ConnectableWidget target) {
        Point2D.Double from = source.getRenderPosition();
        Point2D.Double to = target.getRenderPosition();
        Vec2 dir = new Vec2((float)(to.x - from.x), (float)(to.y - from.y));
        float angle = (float)Math.atan2(dir.f_82470_, dir.f_82471_);
        double angleDeg = Math.toDegrees(angle) - 90.0;
        from = source.getPointOnEdge(angleDeg);
        from.x += source.getRenderWidth() / 2.0;
        from.y += source.getRenderHeight() / 2.0;
        Vec2 fromV = new Vec2((float)from.x, (float)from.y);
        to = target.getPointOnEdge(angleDeg - 180.0);
        to.x += source.getRenderWidth() / 2.0;
        to.y += source.getRenderHeight() / 2.0;
        Vec2 toV = new Vec2((float)to.x, (float)to.y);
        return new Connector(fromV, toV, new Rectangle(Mth.m_14107_((double)Math.min(from.x, to.x)), Mth.m_14107_((double)Math.min(from.y, to.y)), Mth.m_14165_((double)Math.max(from.x, to.x)), Mth.m_14165_((double)Math.max(from.y, to.y))));
    }

    public void renderConnection(PoseStack matrixStack) {
        int drawColor = this.color.getRGB();
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, buffer -> {
            Vec2 arrowP2;
            Vec2 arrowP1;
            LineRenderUtil.getInstance().drawLine((VertexConsumer)buffer, matrixStack, this.connector.from.f_82470_, this.connector.from.f_82471_, this.connector.to.f_82470_, this.connector.to.f_82471_, 1.0, drawColor);
            if (this.type == ConnectorType.ARROW || this.type == ConnectorType.DOUBLE_ARROW) {
                arrowP1 = VectorHelper.rotateDegrees(this.connector.dir, 35.0f);
                LineRenderUtil.getInstance().drawLine((VertexConsumer)buffer, matrixStack, -arrowP1.f_82470_ * 10.0f + this.connector.to.f_82470_, -arrowP1.f_82471_ * 10.0f + this.connector.to.f_82471_, this.connector.to.f_82470_, this.connector.to.f_82471_, 1.0, drawColor);
                arrowP2 = VectorHelper.rotateDegrees(this.connector.dir, -35.0f);
                LineRenderUtil.getInstance().drawLine((VertexConsumer)buffer, matrixStack, -arrowP2.f_82470_ * 10.0f + this.connector.to.f_82470_, -arrowP2.f_82471_ * 10.0f + this.connector.to.f_82471_, this.connector.to.f_82470_, this.connector.to.f_82471_, 1.0, drawColor);
            }
            if (this.type == ConnectorType.DOUBLE_ARROW) {
                arrowP1 = VectorHelper.rotateDegrees(this.connector.dir, 35.0f);
                LineRenderUtil.getInstance().drawLine((VertexConsumer)buffer, matrixStack, this.connector.from.f_82470_, this.connector.from.f_82471_, arrowP1.f_82470_ * 10.0f + this.connector.from.f_82470_, arrowP1.f_82471_ * 10.0f + this.connector.from.f_82471_, 1.0, drawColor);
                arrowP2 = VectorHelper.rotateDegrees(this.connector.dir, -35.0f);
                LineRenderUtil.getInstance().drawLine((VertexConsumer)buffer, matrixStack, this.connector.from.f_82470_, this.connector.from.f_82471_, arrowP2.f_82470_ * 10.0f + this.connector.from.f_82470_, arrowP2.f_82471_ * 10.0f + this.connector.from.f_82471_, 1.0, drawColor);
            }
        });
        RenderSystem.m_69493_();
    }

    public void m_142291_(@Nonnull NarrationElementOutput narrationElementOutput) {
    }

    private static class Connector {
        private final Vec2 from;
        private final Vec2 to;
        private final Vec2 dir;
        private final Rectangle rectangle;

        private Connector(Vec2 from, Vec2 to, Rectangle rectangle) {
            this.from = from;
            this.to = to;
            this.rectangle = rectangle;
            this.dir = new Vec2(this.to.f_82470_ - this.from.f_82470_, this.to.f_82471_ - this.from.f_82471_).m_165902_();
        }
    }

    public static enum ConnectorType {
        LINE,
        ARROW,
        DOUBLE_ARROW;

    }
}

