/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.quest;

import iskallia.vault.client.gui.framework.element.CheckButtonElement;
import iskallia.vault.client.gui.framework.element.FakeItemSlotElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceButtonElement;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.screen.quest.QuestOverviewElementScreen;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.quest.QuestProgressMessage;
import iskallia.vault.quest.QuestState;
import iskallia.vault.quest.base.Quest;
import iskallia.vault.quest.client.ClientQuestState;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class QuestDisplayContainer
extends VerticalScrollClipContainer<QuestDisplayContainer> {
    private final QuestOverviewElementScreen parent;

    public QuestDisplayContainer(ISpatial spatial, QuestOverviewElementScreen parent) {
        super(spatial);
        this.parent = parent;
        Quest selectedQuest = this.parent.getSelectedQuest();
        if (selectedQuest != null) {
            List<ItemStack> items;
            int skillPoints;
            Quest.QuestReward reward;
            int vaultExp;
            boolean hasRewards;
            int padding;
            int y = padding = 5;
            int marginX = 9;
            LabelElement descriptionTitle = new LabelElement((IPosition)Spatials.positionXYZ(marginX, y, 5).width(this.innerWidth() - marginX).height(15), (Component)new TextComponent("Description:"), LabelTextStyle.wrap().shadow());
            this.addElement(descriptionTitle);
            int descriptionWidth = this.innerWidth() - 18;
            LabelElement description = new LabelElement((IPosition)Spatials.positionXY(marginX, y += padding + descriptionTitle.height()).width(descriptionWidth), (Component)selectedQuest.getDescription(), LabelTextStyle.wrap());
            int descriptionHeight = description.getTextStyle().getLabelHeight(description.getComponent(), descriptionWidth);
            this.addElement(description).layout((screen, gui, parent1, world) -> world.width(descriptionWidth).height(descriptionHeight));
            y += padding + descriptionHeight;
            if (selectedQuest.getType().equals("checkmark")) {
                int buttonXY = 20;
                QuestState state = ClientQuestState.INSTANCE.getState();
                CheckButtonElement checkBox = (CheckButtonElement)((NineSliceButtonElement)new CheckButtonElement(Spatials.positionXY(this.innerWidth() / 2 - buttonXY / 2, y).size(buttonXY, buttonXY), () -> ModNetwork.CHANNEL.sendToServer((Object)new QuestProgressMessage(selectedQuest.getId()))).setDisabled(() -> !state.getInProgress().contains((Object)selectedQuest.getId()))).setRenderButtonHeld(() -> state.getCompleted().contains((Object)selectedQuest.getId()));
                this.addElement(checkBox);
                y += padding + checkBox.height();
            }
            boolean bl = hasRewards = selectedQuest.getReward() != null && !selectedQuest.getReward().getItems().isEmpty() || selectedQuest.getReward() != null && selectedQuest.getReward().getVaultExp() > 0 || selectedQuest.getReward() != null && selectedQuest.getReward().getSkillPoints() > 0;
            if (hasRewards) {
                LabelElement rewardTitle = new LabelElement((IPosition)Spatials.positionXYZ(marginX, y, 5).width(this.innerWidth() - marginX).height(15), (Component)new TextComponent("Reward:"), LabelTextStyle.wrap().shadow());
                this.addElement(rewardTitle);
                y += padding + rewardTitle.height();
            }
            if ((vaultExp = (reward = selectedQuest.getReward()).getVaultExp()) > 0) {
                LabelElement vaultExpLabel = new LabelElement((IPosition)Spatials.positionXYZ(marginX, y, 1), (Component)new TextComponent("+" + vaultExp + " Vault XP").m_130940_(ChatFormatting.YELLOW), LabelTextStyle.shadow());
                this.addElement(vaultExpLabel);
                y += padding + vaultExpLabel.height();
            }
            if ((skillPoints = reward.getSkillPoints()) > 0) {
                String text = skillPoints == 1 ? " Skill Point" : " Skill Points";
                LabelElement skillPointLabel = new LabelElement((IPosition)Spatials.positionXYZ(marginX, y, 1), (Component)new TextComponent("+" + skillPoints).m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TextComponent(text).m_130940_(ChatFormatting.WHITE)), LabelTextStyle.shadow());
                this.addElement(skillPointLabel);
                y += padding + skillPointLabel.height();
            }
            if (!(items = reward.getItems()).isEmpty()) {
                int stackX = marginX;
                int stackY = y;
                for (ItemStack stack : items) {
                    FakeItemSlotElement stackElement = (FakeItemSlotElement)new FakeItemSlotElement(Spatials.positionXY(stackX, stackY), () -> stack, () -> false).setLabelStackCount().tooltip(Tooltips.shift(Tooltips.multi(() -> stack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL)), Tooltips.multi(() -> stack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.ADVANCED))));
                    this.addElement(stackElement);
                    if ((stackX += 18) + 18 <= this.innerWidth() - 1) continue;
                    y += 18;
                    stackY += 18;
                    stackX = marginX;
                }
            }
            this.addElement(new LabelElement(Spatials.positionXY(marginX, y += padding + 18), LabelTextStyle.defaultStyle()));
        }
    }
}

