/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.quest;

import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.spatial.Padding;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.screen.quest.QuestButtonElement;
import iskallia.vault.client.gui.screen.quest.QuestOverviewElementScreen;
import iskallia.vault.config.quest.QuestConfig;
import iskallia.vault.quest.QuestState;
import iskallia.vault.quest.base.Quest;
import iskallia.vault.quest.client.ClientQuestState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.NotNull;

public class QuestListElement
extends VerticalScrollClipContainer<QuestListElement> {
    private final QuestOverviewElementScreen parent;

    public QuestListElement(ISpatial spatial, QuestOverviewElementScreen parent) {
        super(spatial, Padding.ZERO, ScreenTextures.INSET_BLACK_BACKGROUND);
        this.parent = parent;
        this.initializeQuests();
    }

    private void initializeQuests() {
        int buttonWidth = this.innerWidth();
        int buttonHeight = 20;
        int x = 0;
        int y = 0;
        QuestState state = ClientQuestState.INSTANCE.getState();
        List<Quest> sorted = this.splitCompleted(state);
        boolean debug = ClientQuestState.debugMode;
        for (Quest quest : sorted) {
            QuestButtonElement button = (QuestButtonElement)((AbstractSpatialElement)new QuestButtonElement((ISpatial)Spatials.positionXY(x, y).size(buttonWidth, buttonHeight), quest, this.selectQuest(quest)).setDisabled(() -> {
                if (debug) {
                    return false;
                }
                return !state.getCompleted().contains((Object)quest.getId()) && !state.getInProgress().contains((Object)quest.getId()) && !state.getReadyToComplete().contains((Object)quest.getId());
            })).tooltip(Tooltips.shift(Tooltips.empty(), Tooltips.multi(() -> Minecraft.m_91087_().f_91062_.m_92865_().m_92432_(quest.getTypeDescription().m_6111_(), 140, Style.f_131099_).stream().map(formattedText -> new TextComponent(formattedText.getString())).toList())));
            this.addElement(button).enableSpatialDebugRender(false, QuestOverviewElementScreen.DEBUG);
            y += buttonHeight;
        }
    }

    @NotNull
    private List<Quest> splitCompleted(QuestState state) {
        ArrayList<Quest> quests = new ArrayList<Quest>(((QuestConfig)ClientQuestState.INSTANCE.getConfig()).getQuests());
        ArrayList<Quest> sorted = new ArrayList<Quest>();
        ArrayList<Quest> incomplete = new ArrayList<Quest>();
        ArrayList<Quest> complete = new ArrayList<Quest>();
        for (Quest q : quests) {
            if (!state.getCompleted().contains((Object)q.getId())) {
                incomplete.add(q);
                continue;
            }
            complete.add(q);
        }
        sorted.addAll(incomplete);
        sorted.addAll(complete);
        return sorted;
    }

    @NotNull
    private Runnable selectQuest(Quest quest) {
        return () -> this.parent.selectQuest(quest);
    }
}

