/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.rules;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.NineSliceButtonElement;
import iskallia.vault.client.gui.framework.element.SliderElement;
import iskallia.vault.client.gui.framework.element.ToggleButtonElement;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutStrategy;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.VaultRulesRequestMessage;
import iskallia.vault.network.message.VaultRulesUpdateMessage;
import iskallia.vault.world.SpectatorMode;
import iskallia.vault.world.VaultCrystalMode;
import iskallia.vault.world.VaultCrystalRecipeScaling;
import iskallia.vault.world.VaultExperience;
import iskallia.vault.world.VaultLoot;
import iskallia.vault.world.VaultMode;
import iskallia.vault.world.VaultPartyExpSharing;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class VaultRulesScreen
extends AbstractElementScreen {
    public static VaultRulesScreen currentScreen;
    private final Screen lastScreen;
    private boolean joinRequireParty = false;
    private int vaultTimer = 25;
    private int vaultLock = 100;
    private boolean allowWaypoints = true;
    private VaultMode vaultMode = VaultMode.NORMAL;
    private VaultLoot vaultLoot = VaultLoot.NORMAL;
    private VaultExperience vaultExperience = VaultExperience.NORMAL;
    private VaultCrystalMode vaultCrystalMode = VaultCrystalMode.NORMAL;
    private VaultPartyExpSharing vaultPartyExpSharing = VaultPartyExpSharing.DISABLED;
    private VaultCrystalRecipeScaling vaultCrystalRecipeScaling = VaultCrystalRecipeScaling.NORMAL;
    private boolean noResearchTeamPenalty = false;
    private boolean allowMentorBrew = true;
    private boolean allowKnowledgeBrew = true;
    private boolean boostPenalty = false;
    private SpectatorMode spectatorMode = SpectatorMode.PLAYER;
    private boolean spectatorPartyOnly = false;
    private boolean partyMapSharing = false;
    private boolean locker = true;
    private int page = 0;

    public VaultRulesScreen(Screen lastScreen) {
        super((Component)new TranslatableComponent("Vault Hunters Game Rules"), ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        Window window = Minecraft.m_91087_().m_91268_();
        this.setGuiSize(Spatials.size(window.m_85445_(), window.m_85446_()));
        this.lastScreen = lastScreen;
        currentScreen = this;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            GameRules gameRules = server.m_129900_();
            this.joinRequireParty = gameRules.m_46207_(ModGameRules.JOIN_REQUIRE_PARTY);
            this.vaultTimer = gameRules.m_46215_(ModGameRules.VAULT_TIMER);
            this.allowWaypoints = gameRules.m_46207_(ModGameRules.ALLOW_WAYPOINTS);
            this.vaultMode = ((VaultMode.GameRuleValue)gameRules.m_46170_(ModGameRules.MODE)).get();
            this.vaultLoot = ((VaultLoot.GameRuleValue)gameRules.m_46170_(ModGameRules.LOOT)).get();
            this.vaultExperience = ((VaultExperience.GameRuleValue)gameRules.m_46170_(ModGameRules.EXPERIENCE)).get();
            this.vaultCrystalMode = ((VaultCrystalMode.GameRuleValue)gameRules.m_46170_(ModGameRules.CRYSTAL_MODE)).get();
            this.noResearchTeamPenalty = gameRules.m_46207_(ModGameRules.NO_RESEARCH_TEAM_PENALTY);
            this.allowMentorBrew = gameRules.m_46207_(ModGameRules.ALLOW_MENTOR_BREW);
            this.allowKnowledgeBrew = gameRules.m_46207_(ModGameRules.ALLOW_KNOWLEDGE_BREW);
            this.boostPenalty = gameRules.m_46207_(ModGameRules.BOOST_PENALTY);
            this.vaultPartyExpSharing = ((VaultPartyExpSharing.GameRuleValue)gameRules.m_46170_(ModGameRules.PARTY_EXP_SHARING)).get();
            this.vaultCrystalRecipeScaling = ((VaultCrystalRecipeScaling.GameRuleValue)gameRules.m_46170_(ModGameRules.CRYSTAL_RECIPE_SCALING)).get();
            this.vaultLock = ((GameRules.IntegerValue)gameRules.m_46170_(ModGameRules.LEVEL_LOCK)).m_46288_();
            this.spectatorMode = ((SpectatorMode.GameRuleValue)gameRules.m_46170_(ModGameRules.SPECTATOR_MODE)).get();
            this.spectatorPartyOnly = gameRules.m_46207_(ModGameRules.SPECTATOR_PARTY_ONLY);
            this.partyMapSharing = gameRules.m_46207_(ModGameRules.PARTY_MAP_SHARING);
            this.locker = gameRules.m_46207_(ModGameRules.LOCKER);
        } else {
            ModNetwork.CHANNEL.sendToServer((Object)new VaultRulesRequestMessage());
        }
        this.setupUI();
    }

    public void updateRules(boolean joinRequireParty, int vaultTimer, boolean allowWaypoints, VaultMode vaultMode, VaultLoot vaultLoot, VaultExperience vaultExperience, VaultCrystalMode vaultCrystalMode, boolean noResearchTeamPenalty, boolean allowMentorBrew, boolean allowKnowledgeBrew, boolean boostPenalty, int vaultLock, VaultPartyExpSharing vaultPartyExpSharing, VaultCrystalRecipeScaling vaultCrystalRecipeScaling, SpectatorMode spectatorMode, boolean spectatorPartyOnly, boolean partyMapSharing, boolean locker) {
        this.joinRequireParty = joinRequireParty;
        this.vaultTimer = vaultTimer;
        this.allowWaypoints = allowWaypoints;
        this.vaultMode = vaultMode;
        this.vaultLoot = vaultLoot;
        this.vaultExperience = vaultExperience;
        this.vaultCrystalMode = vaultCrystalMode;
        this.noResearchTeamPenalty = noResearchTeamPenalty;
        this.allowMentorBrew = allowMentorBrew;
        this.allowKnowledgeBrew = allowKnowledgeBrew;
        this.boostPenalty = boostPenalty;
        this.vaultLock = vaultLock;
        this.vaultPartyExpSharing = vaultPartyExpSharing;
        this.vaultCrystalRecipeScaling = vaultCrystalRecipeScaling;
        this.spectatorMode = spectatorMode;
        this.spectatorPartyOnly = spectatorPartyOnly;
        this.partyMapSharing = partyMapSharing;
        this.locker = locker;
        this.removeAllElements();
        this.setupUI();
    }

    private void setupUI() {
        if (this.page == 0) {
            this.setupPageOne();
        } else {
            this.setupPageTwo();
        }
    }

    private void setupPageOne() {
        int padding = 4;
        int widgetWidth = 150;
        int widgetHeight = 20;
        int startX = 0;
        int startY = 0;
        int x = startX;
        int y = startY;
        this.addElement(((SliderElement)((SliderElement)new SliderElement(Spatials.positionXY(x, y).size(widgetWidth, widgetHeight), () -> {
            if (this.vaultTimer == 0) {
                return new TextComponent("Vault Timer: No Limit");
            }
            if (this.vaultTimer == 1) {
                return new TextComponent("Vault Timer: 1 minute");
            }
            return new TextComponent("Vault Timer: " + this.vaultTimer + " minutes");
        }, () -> Float.valueOf((float)this.vaultTimer / 120.0f), value -> {
            this.vaultTimer = Math.max(0, Math.round(value.floatValue() * 120.0f));
            this.sendSettingsToServer();
        }).tooltip(Tooltips.multi(() -> List.of(new TextComponent("Change the timer on all vaults"), new TextComponent("Set to 0 for no limit"))))).layout(this.translateWorldSpatial())).hidePercentage(true));
        this.addElement(((SliderElement)((SliderElement)new SliderElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), () -> new TextComponent("Level Lock: " + this.vaultLock), () -> Float.valueOf((float)this.vaultLock / 100.0f), value -> {
            this.vaultLock = Math.max(0, Math.round(value.floatValue() * 100.0f));
            this.sendSettingsToServer();
        }).tooltip(() -> new TextComponent("Maximum Vault Level players can reach"))).layout(this.translateWorldSpatial())).hidePercentage(true));
        x = startX;
        this.addElement((ToggleButtonElement)((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Vault Mode"), () -> this.vaultMode.m_7912_().toUpperCase(), () -> {
            VaultMode[] modes = VaultMode.values();
            int nextIndex = (this.vaultMode.ordinal() + 1) % modes.length;
            this.vaultMode = modes[nextIndex];
            this.sendSettingsToServer();
        }).tooltip(this::getVaultModeTooltip)).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("Allow Waypoints"), () -> this.allowWaypoints ? "ON" : "OFF", () -> {
            this.allowWaypoints = !this.allowWaypoints;
            this.sendSettingsToServer();
        }).tooltip(Tooltips.multi(() -> List.of(new TextComponent("Allow players to set and use waypoints from"), new TextComponent("Xaero's minimap mod inside vaults"))))).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Loot Amount"), () -> this.vaultLoot.m_7912_().toUpperCase(), () -> {
            VaultLoot[] loots = VaultLoot.values();
            int nextIndex = (this.vaultLoot.ordinal() + 1) % loots.length;
            this.vaultLoot = loots[nextIndex];
            this.sendSettingsToServer();
        }).tooltip(Tooltips.multi(() -> List.of(new TextComponent("Multiplies the Vault Loot gained when completing vaults"), TextComponent.f_131282_, new TextComponent("Loot Multiplier: " + this.vaultLoot.getMultiplier() + "x"))))).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("XP Amount"), () -> this.vaultExperience.m_7912_().toUpperCase(), () -> {
            VaultExperience[] experiences = VaultExperience.values();
            int nextIndex = (this.vaultExperience.ordinal() + 1) % experiences.length;
            this.vaultExperience = experiences[nextIndex];
            this.sendSettingsToServer();
        }).tooltip(Tooltips.multi(() -> List.of(new TextComponent("Multiplies the Vault Experience gained when completing vaults"), new TextComponent("Does not affect experience gain from other sources"), TextComponent.f_131282_, new TextComponent("XP Multiplier: " + this.vaultExperience.getMultiplier() + "x"))))).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Crystal Cost"), () -> this.vaultCrystalMode.m_7912_().toUpperCase(), () -> {
            VaultCrystalMode[] crystalModes = VaultCrystalMode.values();
            int nextIndex = (this.vaultCrystalMode.ordinal() + 1) % crystalModes.length;
            this.vaultCrystalMode = crystalModes[nextIndex];
            this.sendSettingsToServer();
        }).tooltip(Tooltips.multi(() -> List.of(new TextComponent("Determines how much materials are required to craft Vault Crystals"), TextComponent.f_131282_, new TextComponent(this.getVaultCrystalModeTooltip().getString()))))).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("Recipe Scaling"), () -> this.vaultCrystalRecipeScaling.m_7912_().toUpperCase(), () -> {
            VaultCrystalRecipeScaling[] scalingModes = VaultCrystalRecipeScaling.values();
            int nextIndex = (this.vaultCrystalRecipeScaling.ordinal() + 1) % scalingModes.length;
            this.vaultCrystalRecipeScaling = scalingModes[nextIndex];
            this.sendSettingsToServer();
        }).tooltip(Tooltips.multi(() -> List.of(new TextComponent("Determines how quickly the Crystal recipe scales to require higher amounts of materials"), new TextComponent("SLOW: Crystal recipes scale slower (0.5x)"), new TextComponent("NORMAL: Crystal recipes scale normal (1.0x)"), new TextComponent("FAST: Crystal recipes scale faster (2.0x)"), new TextComponent("EXTREME: Crystal recipes scale extremely fast (5.0x)"))))).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Join Require Party"), () -> this.joinRequireParty ? "ON" : "OFF", () -> {
            this.joinRequireParty = !this.joinRequireParty;
            this.sendSettingsToServer();
        }).tooltip(() -> new TextComponent("Players must be in a party to join co-op vaults"))).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("XP Sharing"), () -> this.vaultPartyExpSharing.m_7912_().toUpperCase(), () -> {
            VaultPartyExpSharing[] sharingModes = VaultPartyExpSharing.values();
            int nextIndex = (this.vaultPartyExpSharing.ordinal() + 1) % sharingModes.length;
            this.vaultPartyExpSharing = sharingModes[nextIndex];
            this.sendSettingsToServer();
        }).tooltip(this::getVaultPartyExpSharingTooltip)).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Boost Penalty"), () -> this.boostPenalty ? "ON" : "OFF", () -> {
            this.boostPenalty = !this.boostPenalty;
            this.sendSettingsToServer();
        }).tooltip(Tooltips.multi(() -> List.of(new TextComponent("Determines if the player should get full rewards"), new TextComponent("(loot and experience) when running vaults lower than their level"))))).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("Research Penalty"), () -> this.noResearchTeamPenalty ? "OFF" : "ON", () -> {
            this.noResearchTeamPenalty = !this.noResearchTeamPenalty;
            this.sendSettingsToServer();
        }).tooltip(Tooltips.multi(() -> List.of(new TextComponent("Determines if each member of a Research Team"), new TextComponent("increases the cost of researches or not"))))).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Knowledge Brew"), () -> this.allowKnowledgeBrew ? "ON" : "OFF", () -> {
            this.allowKnowledgeBrew = !this.allowKnowledgeBrew;
            this.sendSettingsToServer();
        }).tooltip(() -> new TextComponent("Allow drinking Knowledge Brews"))).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("Mentor Brew"), () -> this.allowMentorBrew ? "ON" : "OFF", () -> {
            this.allowMentorBrew = !this.allowMentorBrew;
            this.sendSettingsToServer();
        }).tooltip(() -> new TextComponent("Allow drinking Mentor Brews"))).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((NineSliceButtonElement)((AbstractSpatialElement)new NineSliceButtonElement(Spatials.positionXY(x, y += widgetHeight + padding * 3).size(widgetWidth, widgetHeight), ScreenTextures.BUTTON_EMPTY_TEXTURES, () -> Minecraft.m_91087_().m_91152_(this.lastScreen)).label(() -> new TextComponent("Done"), LabelTextStyle.shadow().center())).layout(this.translateWorldSpatial()));
        this.addElement((NineSliceButtonElement)((AbstractSpatialElement)new NineSliceButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), ScreenTextures.BUTTON_EMPTY_TEXTURES, this::nextPage).label(() -> new TextComponent("Next Page"), LabelTextStyle.shadow().center())).layout(this.translateWorldSpatial()));
    }

    private void setupPageTwo() {
        int padding = 4;
        int widgetWidth = 150;
        int widgetHeight = 20;
        int startX = 0;
        int startY = 0;
        int x = startX;
        int y = startY;
        this.addElement((ToggleButtonElement)((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("Spectator Mode"), () -> this.spectatorMode.m_7912_().toUpperCase(), () -> {
            SpectatorMode[] modes = SpectatorMode.values();
            int nextIndex = (this.spectatorMode.ordinal() + 1) % modes.length;
            this.spectatorMode = modes[nextIndex];
            this.sendSettingsToServer();
        }).tooltip(this::getSpectatorModeTooltip)).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("Spectate Party Only"), () -> this.spectatorPartyOnly ? "ON" : "OFF", () -> {
            this.spectatorPartyOnly = !this.spectatorPartyOnly;
            this.sendSettingsToServer();
        }).tooltip(() -> new TextComponent("Restrict spectating to party members"))).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Map Sharing"), () -> this.partyMapSharing ? "ON" : "OFF", () -> {
            this.partyMapSharing = !this.partyMapSharing;
            this.sendSettingsToServer();
        }).tooltip(() -> new TextComponent("Share discovered rooms with party"))).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("Spirit Locker"), () -> this.locker ? "ON" : "OFF", () -> {
            this.locker = !this.locker;
            this.sendSettingsToServer();
        }).tooltip(() -> new TextComponent("Allow users to retrieve their spirit and go into debt"))).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((NineSliceButtonElement)((AbstractSpatialElement)new NineSliceButtonElement(Spatials.positionXY(x, y += widgetHeight + padding * 3).size(widgetWidth, widgetHeight), ScreenTextures.BUTTON_EMPTY_TEXTURES, this::previousPage).label(() -> new TextComponent("Previous Page"), LabelTextStyle.shadow().center())).layout(this.translateWorldSpatial()));
        this.addElement((NineSliceButtonElement)((AbstractSpatialElement)new NineSliceButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), ScreenTextures.BUTTON_EMPTY_TEXTURES, () -> Minecraft.m_91087_().m_91152_(this.lastScreen)).label(() -> new TextComponent("Done"), LabelTextStyle.shadow().center())).layout(this.translateWorldSpatial()));
    }

    private Component getVaultModeTooltip() {
        return switch (this.vaultMode) {
            default -> throw new IncompatibleClassChangeError();
            case VaultMode.NORMAL -> new TextComponent("When dying, items will be kept in the player's spirit");
            case VaultMode.CASUAL -> new TextComponent("When dying, all items will be kept, and no progress will be lost. Companions lose no hearts.");
            case VaultMode.HARDCORE -> new TextComponent("When dying, all items will be voided and no spirit will spawn");
        };
    }

    private Component getVaultCrystalModeTooltip() {
        return switch (this.vaultCrystalMode) {
            case VaultCrystalMode.INFINITY -> new TextComponent("Crystals are free");
            default -> new TextComponent("Multiplier: " + this.vaultCrystalMode.getMultiplier() + "x");
        };
    }

    private Component getVaultPartyExpSharingTooltip() {
        return switch (this.vaultPartyExpSharing) {
            default -> throw new IncompatibleClassChangeError();
            case VaultPartyExpSharing.DISABLED -> new TextComponent("Party members do not share XP");
            case VaultPartyExpSharing.HIGHEST -> new TextComponent("Highest XP earned is distributed to all members");
            case VaultPartyExpSharing.LOWEST -> new TextComponent("Lowest XP earned is distributed to all members");
            case VaultPartyExpSharing.AVERAGE -> new TextComponent("Average XP earned is distributed to all members");
        };
    }

    private void sendSettingsToServer() {
        VaultRulesUpdateMessage message = new VaultRulesUpdateMessage(this.joinRequireParty, this.vaultTimer, this.allowWaypoints, this.vaultMode.m_7912_(), this.vaultLoot.m_7912_(), this.vaultExperience.m_7912_(), this.vaultCrystalMode.m_7912_(), this.noResearchTeamPenalty, this.allowMentorBrew, this.allowKnowledgeBrew, this.boostPenalty, this.vaultLock, this.vaultPartyExpSharing.m_7912_(), this.vaultCrystalRecipeScaling.m_7912_(), this.spectatorMode.m_7912_(), this.spectatorPartyOnly, this.partyMapSharing, this.locker);
        ModNetwork.CHANNEL.sendToServer((Object)message);
    }

    private Component getSpectatorModeTooltip() {
        return switch (this.spectatorMode) {
            default -> throw new IncompatibleClassChangeError();
            case SpectatorMode.OFF -> new TextComponent("Spectator mode disabled");
            case SpectatorMode.PLAYER -> new TextComponent("Spectate specific players");
            case SpectatorMode.FREEROAM -> new TextComponent("Free roaming spectator");
        };
    }

    private void nextPage() {
        this.page = Math.min(1, this.page + 1);
        this.removeAllElements();
        this.setupUI();
    }

    private void previousPage() {
        this.page = Math.max(0, this.page - 1);
        this.removeAllElements();
        this.setupUI();
    }

    @Override
    @NotNull
    protected ILayoutStrategy translateWorldSpatial() {
        return (screen, gui, parent, world) -> {
            Window window = Minecraft.m_91087_().m_91268_();
            world.translateXY(window.m_85445_() / 2 - 150 - 4, 36);
        };
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        VaultRulesScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderBackgroundFill(@NotNull PoseStack poseStack) {
    }

    public void m_7379_() {
        super.m_7379_();
        if (currentScreen == this) {
            currentScreen = null;
        }
    }
}

