/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.ScalableItemElement;
import iskallia.vault.client.gui.framework.element.TitleElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.client.gui.screen.player.element.PointLabelContainerElement;
import iskallia.vault.client.gui.screen.summary.VaultExitContainerScreenData;
import iskallia.vault.client.gui.screen.summary.element.CombatStatsContainerElement;
import iskallia.vault.client.gui.screen.summary.element.CoopStatsElement;
import iskallia.vault.client.gui.screen.summary.element.CrystalStatsContainerElement;
import iskallia.vault.client.gui.screen.summary.element.LootStatsContainerElement;
import iskallia.vault.client.gui.screen.summary.element.OverviewContainerElement;
import iskallia.vault.client.gui.screen.summary.element.VaultExitTabContainerElement;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.VaultSnapshot;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.ServerboundOpenHistoricMessage;
import iskallia.vault.network.message.VaultPlayerStatsMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;

public class VaultEndScreen
extends AbstractElementScreen {
    public static final int TITLE_WIDTH = 128;
    public static final int BUTTON_WIDTH = 52;
    public static final int BUTTON_HEIGHT = 19;
    public static final int COLUMN_WIDTH = 160;
    public static final int COLUMN_2_X = 180;
    protected ButtonElement<?> closeButton;
    private static final boolean DEBUG = false;
    public static final TextColor XP_COLOR = TextColor.m_131268_((String)"#FFE637");
    private final VaultSnapshot snapshot;
    private final boolean isHistory;
    private final boolean fromLink;
    private final UUID asPlayer;

    public VaultEndScreen(VaultSnapshot snapshot, Component title, UUID asPlayer) {
        this(snapshot, title, asPlayer, false);
    }

    public VaultEndScreen(VaultSnapshot snapshot, Component title, UUID asPlayer, boolean isHistory) {
        this(snapshot, title, asPlayer, isHistory, false);
    }

    public VaultEndScreen(VaultSnapshot snapshot, Component title, UUID asPlayer, boolean isHistory, boolean fromLink) {
        super(title, ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        this.isHistory = isHistory;
        this.asPlayer = asPlayer;
        this.snapshot = snapshot;
        this.fromLink = fromLink;
        this.setGuiSize(Spatials.size(350, 186));
        VaultExitContainerScreenData screenData = new VaultExitContainerScreenData(snapshot, asPlayer);
        Vault vault = screenData.snapshot.getEnd();
        int numOfPlayers = vault.get(Vault.STATS).getMap().size();
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionY(-4).positionZ(-12).positionY(6), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.width(128).height(32).translateX((gui.right() - gui.left()) / 2 + gui.left() - 64)));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXY(0, 42).size(this.f_96543_, 19).height(this.getTabContentSpatial()), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.left() - 8 - 26 + 7).size(gui.width() + 16 + 26, this.getTabContentSpatial().height())));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionY(-4).positionZ(-10), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.x() - 26 + 7).translateY(this.getTabContentSpatial().bottom()).size(gui.width() + 26, gui.height() - 10)));
        this.addElement((PointLabelContainerElement)new PointLabelContainerElement(Spatials.positionXY(-6, 18), screenData::getUnspentSkillPoints, screenData::getUnspentKnowledgePoints).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.width(screen)));
        OverviewContainerElement overviewContainerElement = this.addElement((OverviewContainerElement)new OverviewContainerElement((ISpatial)Spatials.positionX(4).width(-7).height(-16), screenData).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.left() + 2 - 26 + 7).translateY(this.getTabContentSpatial().bottom()).width(world.width() + gui.right() - world.x() + 7).height(world.height() + gui.height() - 22)));
        LootStatsContainerElement lootStatsContainerElement = this.addElement((LootStatsContainerElement)new LootStatsContainerElement((ISpatial)Spatials.positionX(4).width(-7).height(-16), screenData).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.left() + 2 - 26 + 7).translateY(this.getTabContentSpatial().bottom()).width(world.width() + gui.right() - world.x() + 7).height(world.height() + gui.height() - 22)));
        CrystalStatsContainerElement crystalStatsContainerElement = this.addElement((CrystalStatsContainerElement)new CrystalStatsContainerElement(Spatials.positionX(4).width(-7).height(-16), vault, screenData.getModifiers(), screenData.getStatsCollector()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.left() + 2 - 26 + 7).translateY(this.getTabContentSpatial().bottom()).width(world.width() + gui.right() - world.x() + 7).height(world.height() + gui.height() - 22)));
        CombatStatsContainerElement combatStatsContainerElement = this.addElement((CombatStatsContainerElement)new CombatStatsContainerElement((ISpatial)Spatials.positionX(4).width(-7).height(-16), screenData.getStatsCollector()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.left() + 2 - 26 + 7).translateY(this.getTabContentSpatial().bottom()).width(world.width() + gui.right() - world.x() + 7).height(world.height() + gui.height() - 22)));
        CoopStatsElement coopStatsElement = this.addElement((CoopStatsElement)new CoopStatsElement((ISpatial)Spatials.positionX(4).width(-7).height(-16), screenData).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.left() + 2 - 26 + 7).translateY(this.getTabContentSpatial().bottom()).width(world.width() + gui.right() - world.x() + 7).height(world.height() + gui.height() - 22)));
        LabelElement overviewLabel = this.addElement((LabelElement)new LabelElement((IPosition)Spatials.zero(), (Component)new TextComponent("Overview").m_130940_(ChatFormatting.BLACK), LabelTextStyle.left()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.left() - 8 - 26 + 13).translateY(48).translateZ(2)));
        LabelElement crystalLabel = this.addElement((LabelElement)new LabelElement((IPosition)Spatials.zero(), (Component)new TextComponent("Vault Information").m_130940_(ChatFormatting.BLACK), LabelTextStyle.left()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.left() - 8 - 26 + 13).translateY(48).translateZ(2)));
        LabelElement lootLabel = this.addElement((LabelElement)new LabelElement((IPosition)Spatials.zero(), (Component)new TextComponent("Loot").m_130940_(ChatFormatting.BLACK), LabelTextStyle.left()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.left() - 8 - 26 + 13).translateY(48).translateZ(2)));
        LabelElement mobsLabel = this.addElement((LabelElement)new LabelElement((IPosition)Spatials.zero(), (Component)new TextComponent("Combat Stats").m_130940_(ChatFormatting.BLACK), LabelTextStyle.left()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.left() - 8 - 26 + 13).translateY(48).translateZ(2)));
        LabelElement coopLabel = this.addElement((LabelElement)new LabelElement((IPosition)Spatials.zero(), (Component)new TextComponent("Coop").m_130940_(ChatFormatting.BLACK), LabelTextStyle.left()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.left() - 8 - 26 + 13).translateY(48).translateZ(2)));
        boolean isCoop = numOfPlayers > 1;
        this.addElement((VaultExitTabContainerElement)new VaultExitTabContainerElement(Spatials.positionXY(-3, 3), index -> {
            overviewContainerElement.setEnabled(index == 0);
            overviewContainerElement.setVisible(index == 0);
            overviewLabel.setEnabled(index == 0);
            overviewLabel.setVisible(index == 0);
            crystalStatsContainerElement.setEnabled(index == 1);
            crystalStatsContainerElement.setVisible(index == 1);
            crystalLabel.setEnabled(index == 1);
            crystalLabel.setVisible(index == 1);
            lootStatsContainerElement.setEnabled(index == 2);
            lootStatsContainerElement.setVisible(index == 2);
            lootLabel.setEnabled(index == 2);
            lootLabel.setVisible(index == 2);
            combatStatsContainerElement.setEnabled(index == 3);
            combatStatsContainerElement.setVisible(index == 3);
            mobsLabel.setEnabled(index == 3);
            mobsLabel.setVisible(index == 3);
            coopStatsElement.setEnabled(index == 4);
            coopStatsElement.setVisible(index == 4);
            coopLabel.setEnabled(index == 4);
            coopLabel.setVisible(index == 4);
        }, isCoop).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.right() + 7).translateY(this.getTabContentSpatial().bottom())));
        this.addElement((TitleElement)new TitleElement((IPosition)Spatials.positionY(16), (Component)new TranslatableComponent(screenData.getCompletionTranslationString()).m_130940_(ChatFormatting.BLACK), LabelTextStyle.left()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX((gui.right() - gui.left()) / 2 + gui.left() - TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)new TranslatableComponent(screenData.getCompletionTranslationString())))));
        MutableComponent buttonText = new TextComponent("Claim").m_130940_(ChatFormatting.WHITE);
        if (this.isHistory) {
            buttonText = new TextComponent("Back").m_130940_(ChatFormatting.WHITE);
        }
        if (this.fromLink) {
            buttonText = new TextComponent("Close").m_130940_(ChatFormatting.WHITE);
        }
        MutableComponent finalComponent = buttonText;
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.zero(), (Component)finalComponent, LabelTextStyle.border4(ChatFormatting.BLACK).center()).layout((arg_0, arg_1, arg_2, arg_3) -> this.lambda$new$17((Component)finalComponent, arg_0, arg_1, arg_2, arg_3)));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.zero(), (Component)new TextComponent("Rewards: ").m_130940_(ChatFormatting.BLACK), LabelTextStyle.right()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateZ(2).translateX(gui.left() - 8).translateY(this.getTabContentSpatial().bottom() + gui.height() - 31)));
        List<ItemStack> list = screenData.getStatsCollector().getReward();
        int increment = 0;
        for (ItemStack stack : list) {
            int finalIncrement = increment++;
            this.addElement((ScalableItemElement)((ScalableItemElement)new ScalableItemElement(Spatials.zero(), () -> stack, 1.0f).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateZ(2).translateX(gui.left() - 8 + TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)new TextComponent("Rewards: ")) + 18 * finalIncrement).translateY(this.getTabContentSpatial().bottom() + gui.height() - 36).size(16, 16))).tooltip(Tooltips.multi(() -> this.m_96555_(stack))));
        }
        MutableComponent xpGainedComponent = new TextComponent("+ " + screenData.getStatsCollector().getExperience(vault) + " xp").m_130948_(Style.f_131099_.m_131148_(XP_COLOR));
        int finalIncrement1 = increment;
        this.addElement((LabelElement)((LabelElement)new LabelElement((IPosition)Spatials.zero(), (Component)xpGainedComponent, LabelTextStyle.shadow(ChatFormatting.BLACK)).layout((arg_0, arg_1, arg_2, arg_3) -> this.lambda$new$22(finalIncrement1, (Component)xpGainedComponent, arg_0, arg_1, arg_2, arg_3))).tooltip(Tooltips.multi(() -> {
            StatCollector statCollector = screenData.getStatsCollector();
            long window = Minecraft.m_91087_().m_91268_().m_85439_();
            boolean shiftDown = InputConstants.m_84830_((long)window, (int)340) || InputConstants.m_84830_((long)window, (int)344);
            float xpMultiplier = statCollector.getExpMultiplier();
            List<Component> xpReceipt = VaultExitContainerScreenData.getXpReceipt(vault, screenData.getStatsCollector(), shiftDown, xpMultiplier);
            int maxWidth = 0;
            int spaceWidth = TextBorder.DEFAULT_FONT.get().m_92895_(" ");
            for (Component component : xpReceipt) {
                maxWidth = Math.max(TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)component), maxWidth);
            }
            MutableComponent titleText = new TextComponent("Vault Xp").m_130948_(Style.f_131099_.m_131148_(XP_COLOR));
            TextComponent spacer = new TextComponent("");
            String totalXpString = shiftDown ? String.format("(x%.1f) %s xp", Float.valueOf(xpMultiplier), ModConfigs.VAULT_STATS.getExperience(vault, statCollector)) : String.format("%s xp", statCollector.getExperience(vault));
            for (int i = 0; i < maxWidth / spaceWidth - 10 - TextBorder.DEFAULT_FONT.get().m_92895_(totalXpString) / spaceWidth; ++i) {
                spacer.m_130946_(" ");
            }
            xpReceipt.add(0, (Component)titleText.m_7220_((Component)spacer).m_130946_(totalXpString));
            return xpReceipt;
        })));
        this.closeButton = this.addElement((ButtonElement)((ButtonElement)new ButtonElement(Spatials.zero(), ScreenTextures.BUTTON_CLOSE_TEXTURES, () -> {
            if (!this.isHistory) {
                this.m_7379_();
                ModNetwork.CHANNEL.sendToServer((Object)new VaultPlayerStatsMessage.C2S(this.snapshot.getEnd().get(Vault.ID)));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)ModSounds.VAULT_CHEST_RARE_OPEN, (float)1.25f));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            } else if (!this.fromLink) {
                ModNetwork.CHANNEL.sendToServer((Object)ServerboundOpenHistoricMessage.INSTANCE);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            } else {
                this.m_7379_();
            }
        }).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.width(52).height(19).translateX(gui.right() - gui.left() + gui.left() - 52).translateY(this.getTabContentSpatial().bottom() + gui.height() - 37))).tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
            ArrayList<MutableComponent> xpComponentList = new ArrayList<MutableComponent>(List.of(new TextComponent("Claim Rewards").m_130948_(Style.f_131099_.m_178520_(-6710887)).m_130940_(ChatFormatting.GREEN), new TextComponent("  " + screenData.getStatsCollector().getExperience(vault) + " xp").m_130948_(Style.f_131099_.m_131148_(XP_COLOR))));
            for (ItemStack stack : list) {
                xpComponentList.add(new TextComponent("  " + stack.m_41613_() + "x ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TranslatableComponent(stack.m_41778_()).m_130940_(ChatFormatting.WHITE)));
            }
            if (!this.isHistory) {
                tooltipRenderer.renderTooltip(poseStack, xpComponentList, mouseX, mouseY, ItemStack.f_41583_, TooltipDirection.RIGHT);
            } else if (this.fromLink) {
                tooltipRenderer.renderTooltip(poseStack, List.of(new TextComponent("Close")), mouseX, mouseY, ItemStack.f_41583_, TooltipDirection.RIGHT);
            } else {
                tooltipRenderer.renderTooltip(poseStack, List.of(new TextComponent("Back to History")), mouseX, mouseY, ItemStack.f_41583_, TooltipDirection.RIGHT);
            }
            return false;
        }));
    }

    @Override
    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        if (!this.isHistory) {
            ModNetwork.CHANNEL.sendToServer((Object)new VaultPlayerStatsMessage.C2S(this.snapshot.getEnd().get(Vault.ID)));
        }
        super.m_7379_();
    }

    public ISpatial getTabContentSpatial() {
        int padLeft = 21;
        int padTop = 42;
        int width = this.f_96543_ - padLeft * 2;
        int height = 19;
        return Spatials.positionXY(padLeft, padTop).size(width, height);
    }

    @Override
    protected void layout(ISpatial parent) {
        super.layout(parent);
    }

    private static /* synthetic */ void lambda$new$27(ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) {
        world.width(screen).positionY(10);
    }

    private /* synthetic */ void lambda$new$22(int finalIncrement1, Component xpGainedComponent, ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) {
        IMutableSpatial iMutableSpatial = world.translateZ(2).translateX(gui.left() - 8 + TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)new TextComponent("Rewards: ")) + 5 + 18 * finalIncrement1).translateY(this.getTabContentSpatial().bottom() + gui.height() - 31).width(TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)xpGainedComponent));
        Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
        iMutableSpatial.height(9);
    }

    private /* synthetic */ void lambda$new$17(Component finalComponent, ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) {
        world.translateZ(2).translateX(gui.right() - gui.left() + gui.left() - 26 - 1 - TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)finalComponent) / 2).translateY(this.getTabContentSpatial().bottom() + gui.height() - 31);
    }
}

