/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary.element;

import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.spatial.Padding;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.screen.summary.element.StatLabelElement;
import iskallia.vault.client.gui.screen.summary.element.StatLabelListElement;
import iskallia.vault.client.gui.screen.summary.element.StringStatDisplayElement;
import iskallia.vault.config.EntityGroupDefinitionsConfig;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModTextureAtlases;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class CombatStatsContainerElement
extends VerticalScrollClipContainer<CombatStatsContainerElement> {
    public CombatStatsContainerElement(ISpatial spatial, StatCollector statCollector) {
        super(spatial, Padding.of(0, 0));
        List<String> displayGroups = ModConfigs.ENTITY_GROUP_DEFINITIONS.getGroupIds();
        ArrayList mobGroupStats = new ArrayList();
        int totalMobsKilled = this.getTotalMobsKilled(statCollector);
        mobGroupStats.add(StatLabelListElement.Stat.builder().name("Mobs Unalived").description("Total number of mobs you defeated").value(totalMobsKilled).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        Object2IntMap<ResourceLocation> entitiesKilled = statCollector.getEntitiesKilled();
        HashMap mobsByGroup = new HashMap();
        HashMap championsByGroup = new HashMap();
        displayGroups.forEach(group -> {
            mobsByGroup.put(group, new ArrayList());
            championsByGroup.put(group, new ArrayList());
        });
        entitiesKilled.object2IntEntrySet().forEach(entry -> {
            ResourceLocation mobId = (ResourceLocation)entry.getKey();
            int count = entry.getIntValue();
            displayGroups.stream().filter(group -> this.isInMobGroup(mobId, (String)group)).findFirst().ifPresent(group -> ((List)mobsByGroup.get(group)).add(Map.entry(mobId, count)));
        });
        Object2IntMap<ResourceLocation> championsKilled = statCollector.getChampionsKilled();
        for (Object2IntMap.Entry entry2 : championsKilled.object2IntEntrySet()) {
            ResourceLocation mobId = (ResourceLocation)entry2.getKey();
            int count = entry2.getIntValue();
            displayGroups.stream().filter(group -> this.isInMobGroup(mobId, (String)group)).findFirst().ifPresent(group -> championsByGroup.computeIfAbsent(group, k -> new ArrayList()).add(Map.entry(mobId, count)));
        }
        for (int i = 0; i < displayGroups.size(); ++i) {
            String group2 = displayGroups.get(i);
            int groupKills = this.getTotalKills(statCollector, group2);
            int groupChampions = this.getTotalChampions(statCollector, group2);
            String groupName = this.getMobGroupName(group2);
            if (groupName.equalsIgnoreCase("Champions")) {
                groupKills = statCollector.getChampionsKilled().object2IntEntrySet().stream().mapToInt(Object2IntMap.Entry::getIntValue).sum();
            }
            if (groupKills > 0) {
                ArrayList<String> descriptionList = new ArrayList<String>();
                for (Map.Entry mobEntry : (List)mobsByGroup.get(group2)) {
                    String mobName = this.formatMobName(((ResourceLocation)mobEntry.getKey()).toString());
                    descriptionList.add(mobName + ": " + String.valueOf(mobEntry.getValue()));
                }
                if (groupChampions > 0) {
                    descriptionList.add("");
                    descriptionList.add("Champions:");
                    for (Map.Entry champEntry : (List)championsByGroup.get(group2)) {
                        String champName = this.formatMobName(((ResourceLocation)champEntry.getKey()).toString());
                        descriptionList.add(champName + ": " + String.valueOf(champEntry.getValue()));
                    }
                }
                mobGroupStats.add(StatLabelListElement.Stat.builder().name(groupName).description(descriptionList).value(groupKills).valueFormatter(StatLabelElement.INTEGER_FORMATTER).iconAtlas(TextureAtlasRegion.of(ModTextureAtlases.MOB_GROUPS, ModConfigs.ENTITY_GROUP_DEFINITIONS.getGroup((String)group2).get().icon)).nameOffset(Spatials.positionX(15)).iconScale(0.5f).iconOffset(Spatials.positionXY(8, 4)).onClick(() -> {}).build());
                continue;
            }
            mobGroupStats.add(StatLabelListElement.Stat.builder().name(this.getMobGroupName(group2)).description("No mobs killed in this group").value(0).valueFormatter(StatLabelElement.INTEGER_FORMATTER).iconAtlas(TextureAtlasRegion.of(ModTextureAtlases.MOB_GROUPS, ModConfigs.ENTITY_GROUP_DEFINITIONS.getGroup((String)group2).get().icon)).nameOffset(Spatials.positionX(15)).iconScale(0.5f).iconOffset(Spatials.positionXY(8, 4)).build());
        }
        this.addElement(StringStatDisplayElement.builder().position(Spatials.positionY(7).positionX(8)).width(160).height(Math.max(70, 20 + mobGroupStats.size() * 12)).addStats(mobGroupStats).verticalGap(2).build());
        Object2FloatMap<ResourceLocation> damageDealt = statCollector.getDamageDealt();
        float totalDamageDealt = 0.0f;
        for (Object2FloatMap.Entry entry3 : damageDealt.object2FloatEntrySet()) {
            totalDamageDealt += entry3.getFloatValue();
        }
        Object2FloatMap<ResourceLocation> damageReceived = statCollector.getDamageReceived();
        float totalDamageReceived = 0.0f;
        for (Object2FloatMap.Entry entry4 : damageReceived.object2FloatEntrySet()) {
            totalDamageReceived += entry4.getFloatValue();
        }
        ArrayList combatStats = new ArrayList();
        combatStats.add(StatLabelListElement.Stat.builder().name("Damage Dealt").description("Total damage you dealt to mobs").value(Float.valueOf(totalDamageDealt)).valueFormatter(StatLabelElement.FLOAT_FORMATTER).build());
        combatStats.add(StatLabelListElement.Stat.builder().name("Damage Received").description("Total damage you took from mobs").value(Float.valueOf(totalDamageReceived)).valueFormatter(StatLabelElement.FLOAT_FORMATTER).build());
        this.addElement(StringStatDisplayElement.builder().position(Spatials.positionY(7).positionX(190)).width(160).height(85).addStats(combatStats).build());
        this.addElement(new NineSliceElement(Spatials.positionXY(170, 5).size(3, 135), ScreenTextures.VAULT_EXIT_ELEMENT_VERTICAL_SPLITTER));
    }

    private int getTotalMobsKilled(StatCollector statCollector) {
        List<String> displayGroups = ModConfigs.ENTITY_GROUP_DEFINITIONS.getGroupIds();
        Object2IntMap<ResourceLocation> entitiesKilled = statCollector.getEntitiesKilled();
        HashMap mobsByGroup = new HashMap();
        HashMap<String, Integer> totalKillsByGroup = new HashMap<String, Integer>();
        int totalMobsKilled = 0;
        for (String group : displayGroups) {
            mobsByGroup.put(group, new ArrayList());
            totalKillsByGroup.put(group, 0);
        }
        block1: for (Object2IntMap.Entry entry : entitiesKilled.object2IntEntrySet()) {
            ResourceLocation mobId = (ResourceLocation)entry.getKey();
            int count = entry.getIntValue();
            totalMobsKilled += count;
            for (String group : displayGroups) {
                if (!this.isInMobGroup(mobId, group)) continue;
                ((List)mobsByGroup.get(group)).add(Map.entry(mobId, count));
                totalKillsByGroup.put(group, (Integer)totalKillsByGroup.get(group) + count);
                continue block1;
            }
        }
        return totalMobsKilled;
    }

    private int getTotalKills(StatCollector statCollector, String groupName) {
        List<String> displayGroups = ModConfigs.ENTITY_GROUP_DEFINITIONS.getGroupIds();
        Object2IntMap<ResourceLocation> entitiesKilled = statCollector.getEntitiesKilled();
        HashMap<String, Integer> totalKillsByGroup = new HashMap<String, Integer>();
        int totalKills = 0;
        for (String group : displayGroups) {
            totalKillsByGroup.put(group, 0);
        }
        for (Object2IntMap.Entry entry : entitiesKilled.object2IntEntrySet()) {
            ResourceLocation mobId = (ResourceLocation)entry.getKey();
            int count = entry.getIntValue();
            if (!this.isInMobGroup(mobId, groupName)) continue;
            totalKills += count;
            totalKillsByGroup.put(groupName, (Integer)totalKillsByGroup.get(groupName) + count);
        }
        return totalKills;
    }

    private int getTotalChampions(StatCollector statCollector, String groupName) {
        Object2IntMap<ResourceLocation> championsKilled = statCollector.getChampionsKilled();
        int totalChampions = 0;
        for (Object2IntMap.Entry entry : championsKilled.object2IntEntrySet()) {
            ResourceLocation mobId = (ResourceLocation)entry.getKey();
            int count = entry.getIntValue();
            if (!this.isInMobGroup(mobId, groupName)) continue;
            totalChampions += count;
        }
        return totalChampions;
    }

    private boolean isInMobGroup(ResourceLocation mobId, String groupName) {
        return ModConfigs.ENTITY_GROUPS.isInGroup(new ResourceLocation(groupName.substring(1)), PartialEntity.of(null, null, mobId, PartialCompoundNbt.empty()));
    }

    private String getMobGroupName(String groupName) {
        return ModConfigs.ENTITY_GROUP_DEFINITIONS.getGroup(groupName).map(EntityGroupDefinitionsConfig.EntityGroupDefinition::getDisplayName).orElse("Unknown");
    }

    private String formatMobName(String fullId) {
        String[] parts = fullId.split(":");
        if (parts.length < 2) {
            return fullId;
        }
        String name = parts[1];
        name = name.replace("_", " ");
        String[] words = name.split(" ");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (word.length() <= 0) continue;
            formatted.append(word.substring(0, 1).toUpperCase());
            if (word.length() > 1) {
                formatted.append(word.substring(1));
            }
            formatted.append(" ");
        }
        return formatted.toString().trim();
    }
}

