/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary.element;

import iskallia.vault.block.DungeonDoorBlock;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.spatial.Padding;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.screen.summary.element.IndentLevel;
import iskallia.vault.client.gui.screen.summary.element.StatLabelElement;
import iskallia.vault.client.gui.screen.summary.element.StatLabelListElement;
import iskallia.vault.client.gui.screen.summary.element.StringStatDisplayElement;
import iskallia.vault.config.ThemeAugmentLoreConfig;
import iskallia.vault.config.entry.DescriptionData;
import iskallia.vault.core.data.key.ThemeKey;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModTextureAtlases;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class CrystalStatsContainerElement
extends VerticalScrollClipContainer<CrystalStatsContainerElement> {
    public CrystalStatsContainerElement(ISpatial spatial, Vault vault, Modifiers modifiers, StatCollector statCollector) {
        super(spatial, Padding.of(0, 0));
        String pool;
        ArrayList vaultinfo = new ArrayList();
        vaultinfo.add(StatLabelListElement.Stat.builder().name("Vault Level").value(vault.get(Vault.LEVEL).get()).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        AtomicReference<String> theme = new AtomicReference<String>("Unknown");
        AtomicReference themeReg = new AtomicReference();
        vault.ifPresent(Vault.WORLD, world -> {
            ResourceLocation themeObj = world.get(WorldManager.THEME);
            if (themeObj != null) {
                themeReg.set(VaultRegistry.THEME.getKey(themeObj));
                if (themeReg.get() != null) {
                    theme.set(((ThemeKey)themeReg.get()).getName());
                }
            }
        });
        if (theme.get().length() > 12) {
            theme.set(theme.get().substring(0, 12) + "...");
        }
        vaultinfo.add(StatLabelListElement.Stat.builder().name("Theme").value(theme.get()).valueFormatter(StatLabelElement.STRING_FORMATTER).description(() -> {
            if (themeReg.get() == null) {
                return new ArrayList<TextComponent>(){
                    {
                        this.add(new TextComponent("Unable to find a theme for this vault."));
                    }
                };
            }
            DescriptionData[] data = ModConfigs.THEME_AUGMENT_LORE.getAugmentLore(((ThemeKey)themeReg.get()).getId()).map(lore -> lore.description).orElse(new DescriptionData[0]);
            ArrayList<TextComponent> cheese = new ArrayList<TextComponent>();
            cheese.add(new TextComponent((String)theme.get()));
            for (DescriptionData descriptionData : data) {
                MutableComponent patt3903$temp = descriptionData.getComponent();
                if (!(patt3903$temp instanceof TextComponent)) continue;
                TextComponent textComponent = (TextComponent)patt3903$temp;
                cheese.add(textComponent);
            }
            return cheese;
        }).build());
        if (themeReg.get() != null) {
            vaultinfo.add(StatLabelListElement.Stat.builder().name("Series").value(ModConfigs.THEME_AUGMENT_LORE.getAugmentLore((ResourceLocation)((ThemeKey)themeReg.get()).getId()).orElse((ThemeAugmentLoreConfig.AugmentLore)ThemeAugmentLoreConfig.AugmentLore.empty()).displayName).valueFormatter(StatLabelElement.STRING_FORMATTER).build());
        }
        Object objective = "";
        objective = vault.has(Vault.OBJECTIVES) ? ((pool = vault.getOptional(Vault.OBJECTIVES).flatMap(objectives -> objectives.getOptional(Objectives.KEY)).orElse("default")).equals("monolith") ? "Light the Braziers" : pool.substring(0, 1).toUpperCase() + pool.substring(1).toLowerCase()) : "None";
        vaultinfo.add(StatLabelListElement.Stat.builder().name("Objective").value((String)objective).description("The objective of this vault").valueFormatter(StatLabelElement.STRING_FORMATTER).build());
        this.addElement(StringStatDisplayElement.builder().position(Spatials.positionY(7).positionX(8)).width(156).height(Math.max(90, 56)).addStats(vaultinfo).build());
        ArrayList modifierStats = new ArrayList();
        boolean i = false;
        for (Object2IntMap.Entry entry : modifiers.getDisplayGroup().object2IntEntrySet()) {
            VaultModifier modifier = (VaultModifier)entry.getKey();
            int n = entry.getIntValue();
            Optional<ResourceLocation> icon = modifier.getIcon();
            if (icon.isEmpty()) continue;
            String modifierName = modifier.getDisplayName();
            ArrayList<String> description = new ArrayList<String>();
            description.add(modifier.getDisplayDescription());
            modifierStats.add(StatLabelListElement.Stat.builder().name(modifierName).description(description).value(n).valueFormatter(StatLabelElement.INTEGER_FORMATTER).iconAtlas(TextureAtlasRegion.of(ModTextureAtlases.MODIFIERS, icon.get())).nameOffset(Spatials.positionX(8)).iconScale(0.5f).iconOffset(Spatials.positionXY(2, 4)).build());
        }
        if (!modifierStats.isEmpty()) {
            this.addElement(StringStatDisplayElement.builder().position(Spatials.positionY(45).positionX(0)).width(156).name("Modifiers").height(Math.max(90, 20 + modifierStats.size() * 12)).addStats(modifierStats).titleOffset(Spatials.positionY(6)).build());
        } else {
            ArrayList<StatLabelListElement.Stat<String>> noModifiersStats = new ArrayList<StatLabelListElement.Stat<String>>();
            noModifiersStats.add(StatLabelListElement.Stat.builder().name("No Modifiers").description("This crystal has no modifiers applied").value((String)null).valueFormatter(v -> "").build());
        }
        ArrayList vaultCrystalStats = new ArrayList();
        vaultCrystalStats.add(StatLabelListElement.Stat.builder().name("Treasure Rooms Opened").description("Total number of treasure rooms opened").value(statCollector::getTreasureRoomsOpened).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        vaultCrystalStats.add(StatLabelListElement.Stat.builder().name("Vendoors Opened").description("Total number of treasure rooms opened").value(statCollector::getVendoorRoomsOpened).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        vaultCrystalStats.add(StatLabelListElement.Stat.builder().name("Gold Spent").description("Total amount of vault gold spent in the vault").indentLevel(IndentLevel.MEDIUM).value(statCollector::getGoldSpent).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        vaultCrystalStats.add(StatLabelListElement.Stat.builder().name("Dungeons Opened").description(() -> {
            Map<String, Map<DungeonDoorBlock.Type, Integer>> opened = statCollector.getDungeonsOpened();
            ArrayList<TextComponent> description = new ArrayList<TextComponent>();
            for (Map.Entry<String, Map<DungeonDoorBlock.Type, Integer>> entry : opened.entrySet()) {
                String difficulty = entry.getKey();
                description.add(new TextComponent("Difficulty: " + difficulty));
                Map<DungeonDoorBlock.Type, Integer> types = entry.getValue();
                for (Map.Entry<DungeonDoorBlock.Type, Integer> typeEntry : types.entrySet()) {
                    DungeonDoorBlock.Type type = typeEntry.getKey();
                    int amount = typeEntry.getValue();
                    description.add(new TextComponent("  " + type.name() + ": " + amount));
                }
            }
            return description;
        }).value(statCollector::getTotalDungeonsOpened).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        vaultCrystalStats.add(StatLabelListElement.Stat.builder().name("Archives Found").description("Total number of modifier archives found in dungeons").value(statCollector::getDungeonAltarsFound).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        vaultCrystalStats.add(StatLabelListElement.Stat.builder().name("Pylons Used").description("Number of pylons used in the vault").value(statCollector::getPylonsUsed).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        vaultCrystalStats.add(StatLabelListElement.Stat.builder().name("Pylons Broken").description("Number of pylons broken in the vault").value(statCollector::getPylonsBroken).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        vaultCrystalStats.add(StatLabelListElement.Stat.builder().name("Rooms Discovered").description("Total number of rooms discovered").value(statCollector::getTotalDiscoveredRoomsExcludingStart).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        HashMap<String, Integer> roomCount = new HashMap<String, Integer>();
        for (Map.Entry<BlockPos, ResourceLocation> entry : statCollector.getRoomsDiscovered().entrySet()) {
            ResourceLocation roomId = entry.getValue();
            String roomName = roomId.m_135815_();
            if (roomName.contains("common") || roomName.contains("raw")) {
                roomCount.put("Common", roomCount.getOrDefault("Common", 0) + 1);
                continue;
            }
            if (roomName.contains("omega")) {
                roomCount.put("Omega", roomCount.getOrDefault("Omega", 0) + 1);
                continue;
            }
            if (roomName.contains("challenge")) {
                roomCount.put("Challenge", roomCount.getOrDefault("Challenge", 0) + 1);
                continue;
            }
            if (roomName.contains("start")) continue;
            roomCount.put("Other", roomCount.getOrDefault("Other", 0) + 1);
        }
        for (Map.Entry<Object, Object> entry : roomCount.entrySet()) {
            vaultCrystalStats.add(StatLabelListElement.Stat.builder().name((String)entry.getKey()).description("Number of " + ((String)entry.getKey()).toLowerCase() + " rooms discovered").value((Integer)entry.getValue()).valueFormatter(StatLabelElement.INTEGER_FORMATTER).indentLevel(IndentLevel.MEDIUM).build());
        }
        vaultCrystalStats.add(StatLabelListElement.Stat.builder().name("God Tasks Completed").description("Total number of god tasks completed").value(statCollector.has(StatCollector.GOD_ALTAR_COMPLETIONS) ? statCollector.get(StatCollector.GOD_ALTAR_COMPLETIONS) : Integer.valueOf(0)).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        vaultCrystalStats.add(StatLabelListElement.Stat.builder().name("God Tasks Failed").description("Total number of god tasks failed").value(statCollector.has(StatCollector.GOD_ALTAR_FAILS) ? statCollector.get(StatCollector.GOD_ALTAR_FAILS) : Integer.valueOf(0)).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        this.addElement(StringStatDisplayElement.builder().position(Spatials.positionY(7).positionX(190)).width(160).height(60).addStats(vaultCrystalStats).build());
        this.addElement(new NineSliceElement(Spatials.positionXY(170, 5).size(3, 135), ScreenTextures.VAULT_EXIT_ELEMENT_VERTICAL_SPLITTER));
    }
}

