/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.init.ModShaders;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class HeadTextureElement<E extends HeadTextureElement<E>>
extends AbstractSpatialElement<E>
implements IRenderedElement {
    private ResourceLocation skin;
    private boolean visible;

    public HeadTextureElement(ResourceLocation skin) {
        this(IPosition.ZERO, skin);
    }

    public HeadTextureElement(IPosition position, ResourceLocation skin) {
        this(position, Spatials.size(16, 16), skin);
    }

    public HeadTextureElement(IPosition position, ISize size, ResourceLocation skin) {
        super(Spatials.positionXYZ(position).size(size));
        this.skin = skin;
        this.setVisible(true);
    }

    public void setSkin(ResourceLocation skin) {
        this.skin = skin;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.worldSpatial.x(), (double)this.worldSpatial.y(), (double)this.worldSpatial.z());
        HeadTextureElement.render2DHead(poseStack, this.skin, 16, false);
        poseStack.m_85849_();
    }

    private static void render2DHead(PoseStack matrixStack, ResourceLocation skin, int size, boolean grayscaled) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)skin);
        int u1 = 8;
        int v1 = 8;
        int u2 = 40;
        int v2 = 8;
        int w = 8;
        int h = 8;
        if (grayscaled) {
            ModShaders.getGrayscalePositionTexShader().withGrayscale(1.0f).withBrightness(1.0f).enable();
        } else {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
        }
        GuiComponent.m_93160_((PoseStack)matrixStack, (int)0, (int)0, (int)size, (int)size, (float)u1, (float)v1, (int)w, (int)h, (int)64, (int)64);
        GuiComponent.m_93160_((PoseStack)matrixStack, (int)0, (int)0, (int)size, (int)size, (float)u2, (float)v2, (int)w, (int)h, (int)64, (int)64);
    }
}

