/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary.element;

import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.element.spi.IElement;
import iskallia.vault.client.gui.framework.spatial.Padding;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.screen.summary.VaultExitContainerScreenData;
import iskallia.vault.client.gui.screen.summary.element.StatLabelElement;
import iskallia.vault.client.gui.screen.summary.element.StatLabelListElement;
import iskallia.vault.client.gui.screen.summary.element.StringStatDisplayElement;
import iskallia.vault.core.Version;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.VaultChestType;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.VaultRarity;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class LootStatsContainerElement
extends VerticalScrollClipContainer<LootStatsContainerElement> {
    public static int COLUMN_WIDTH = 160;
    public static int SECTION_SPACING = 10;
    private float scale = 1.0f;

    @OnlyIn(value=Dist.CLIENT)
    public LootStatsContainerElement(ISpatial spatial, VaultExitContainerScreenData screenData) {
        super(spatial, Padding.of(0, 0));
        StatCollector statCollector = screenData.getStatsCollector();
        LinkedHashMap chestCounts = new LinkedHashMap();
        HashMap<Object, Integer> trappedCounts = new HashMap<Object, Integer>();
        HashMap<Object, Integer> totalCounts = new HashMap<Object, Integer>();
        for (VaultChestType chestType : VaultChestType.values()) {
            HashMap<VaultRarity, Integer> hashMap = new HashMap<VaultRarity, Integer>();
            for (VaultRarity rarity : VaultRarity.values()) {
                hashMap.put(rarity, VaultExitContainerScreenData.getChestCount(statCollector, chestType, rarity));
            }
            chestCounts.put((Object)((Object)chestType), hashMap);
            trappedCounts.put((Object)chestType, VaultExitContainerScreenData.getTrappedChestCount(statCollector, chestType));
            int total = (Integer)trappedCounts.get((Object)chestType);
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                int count = (Integer)((Object)iterator.next());
                total += count;
            }
            totalCounts.put((Object)chestType, total);
        }
        int totalChests = totalCounts.values().stream().mapToInt(Integer::intValue).sum();
        ArrayList chestStats = new ArrayList();
        HashMap<VaultRarity, Integer> totalRarityMap = new HashMap<VaultRarity, Integer>();
        for (Map.Entry entry : chestCounts.entrySet()) {
            Map rarityMap = (Map)entry.getValue();
            for (Map.Entry rarityEntry : rarityMap.entrySet()) {
                VaultRarity rarity;
                rarity = (VaultRarity)((Object)rarityEntry.getKey());
                int count = (Integer)rarityEntry.getValue();
                totalRarityMap.put(rarity, totalRarityMap.getOrDefault((Object)rarity, 0) + count);
            }
        }
        int totalCommon = totalRarityMap.getOrDefault((Object)VaultRarity.COMMON, 0);
        int n = totalRarityMap.getOrDefault((Object)VaultRarity.RARE, 0);
        int totalEpic = totalRarityMap.getOrDefault((Object)VaultRarity.EPIC, 0);
        int totalOmega = totalRarityMap.getOrDefault((Object)VaultRarity.OMEGA, 0);
        int totalTrapped = trappedCounts.values().stream().mapToInt(Integer::intValue).sum();
        ArrayList<String> description = new ArrayList<String>();
        description.add("Common: " + totalCommon);
        description.add("Rare: " + n);
        description.add("Epic: " + totalEpic);
        description.add("Omega: " + totalOmega);
        description.add("Trapped: " + totalTrapped);
        float totalTotalXp = VaultExitContainerScreenData.getTotalChestsXp(statCollector);
        description.add("");
        description.add("Total XP: " + String.format("%.0f", Float.valueOf(totalTotalXp)));
        chestStats.add(StatLabelListElement.Stat.builder().name("Total Chests Looted").description(description).value(totalChests).valueFormatter(StatLabelElement.INTEGER_FORMATTER).onClick(() -> {}).build());
        for (VaultChestType chestType : VaultChestType.values()) {
            if (chestType.equals((Object)VaultChestType.ENIGMA) || chestType.equals((Object)VaultChestType.ALTAR) || chestType.equals((Object)VaultChestType.TREASURE) || chestType.equals((Object)VaultChestType.HARDENED) || chestType.equals((Object)VaultChestType.FLESH)) continue;
            VaultChestType type = chestType;
            ArrayList<String> typeDescription = new ArrayList<String>();
            Map rarityMap = (Map)chestCounts.get((Object)type);
            int common = rarityMap.getOrDefault((Object)VaultRarity.COMMON, 0);
            float f = VaultExitContainerScreenData.getXp(type, common, 0, 0, 0);
            int rare = rarityMap.getOrDefault((Object)VaultRarity.RARE, 0);
            float rareXP = VaultExitContainerScreenData.getXp(type, 0, rare, 0, 0);
            int epic = rarityMap.getOrDefault((Object)VaultRarity.EPIC, 0);
            float epicXP = VaultExitContainerScreenData.getXp(type, 0, 0, epic, 0);
            int omega = rarityMap.getOrDefault((Object)VaultRarity.OMEGA, 0);
            float omegaXP = VaultExitContainerScreenData.getXp(type, 0, 0, 0, omega);
            int trapped = (Integer)trappedCounts.get((Object)type);
            typeDescription.add("Common: " + common + " (" + String.format("%.0f", Float.valueOf(f)) + " xp)");
            typeDescription.add("Rare: " + rare + " (" + String.format("%.0f", Float.valueOf(rareXP)) + " xp)");
            typeDescription.add("Epic: " + epic + " (" + String.format("%.0f", Float.valueOf(epicXP)) + " xp)");
            typeDescription.add("Omega: " + omega + " (" + String.format("%.0f", Float.valueOf(omegaXP)) + " xp)");
            typeDescription.add("Trapped: " + trapped);
            float xpTotal = VaultExitContainerScreenData.getXp(type, common, rare, epic, omega);
            typeDescription.add("");
            typeDescription.add("Total XP: " + String.format("%.0f", Float.valueOf(xpTotal)));
            TextureAtlasRegion icon = type.getIcon();
            chestStats.add(StatLabelListElement.Stat.builder().name(type.getName()).description(typeDescription).value((Integer)totalCounts.get((Object)type)).valueFormatter(StatLabelElement.INTEGER_FORMATTER).onClick(() -> {}).iconAtlas(icon).iconOffset(Spatials.positionY(-2)).nameOffset(Spatials.positionX(15)).build());
        }
        this.addElements((IElement)StringStatDisplayElement.builder().position(Spatials.positionY(7).positionX(8)).icon(ScreenTextures.EMPTY).width(160).height(10 + chestStats.size() * 11).addStats(chestStats).verticalGap(2).build(), new IElement[0]);
        ArrayList otherLooted = new ArrayList();
        otherLooted.add(StatLabelListElement.Stat.builder().name("Coin Piles").description("Total Number of coin piles looted in the vault").value(() -> VaultExitContainerScreenData.getCoinPile(statCollector)).valueFormatter(StatLabelElement.INTEGER_FORMATTER).iconItem(new ItemStack((ItemLike)ModBlocks.VAULT_GOLD, 64)).nameOffset(Spatials.positionX(12)).build());
        otherLooted.add(StatLabelListElement.Stat.builder().name("Soul Shards").description("Total number of soul shards collected from entities").value(statCollector::getCollectedSoulShards).valueFormatter(StatLabelElement.INTEGER_FORMATTER).iconItem(new ItemStack((ItemLike)ModItems.SOUL_SHARD)).nameOffset(Spatials.positionX(12)).build());
        otherLooted.add(StatLabelListElement.Stat.builder().name("Treasure Sand").description("Total number of treasure sand looted in the vault").value(() -> VaultExitContainerScreenData.getTreasureSand(statCollector)).valueFormatter(StatLabelElement.INTEGER_FORMATTER).iconItem(new ItemStack((ItemLike)ModBlocks.TREASURE_SAND)).nameOffset(Spatials.positionX(12)).build());
        this.addElement(StringStatDisplayElement.builder().position(Spatials.positionY(75).positionX(2)).name("Other Loot").titleOffset(Spatials.positionY(6)).width(160).height(10 + chestStats.size() * 11).addStats(otherLooted).build());
        LinkedHashMap<ResourceLocation, Integer> oresMined = new LinkedHashMap<ResourceLocation, Integer>();
        Map<ResourceLocation, Float> oreXpMap = ModConfigs.VAULT_STATS.getBlocksMined();
        Object2IntMap<ResourceLocation> minedBlocks = statCollector.getMinedBlocks();
        for (Object2IntMap.Entry entry : minedBlocks.object2IntEntrySet()) {
            ResourceLocation loc = (ResourceLocation)entry.getKey();
            if (loc.m_135815_().equals("coin_pile") || loc.m_135815_().equals("treasure_sand") || !screenData.getSnapshot().getVersion().isNewerThan(Version.v1_32) || loc.m_135815_().equals("ore_wutodie") || loc.m_135815_().equals("ore_puffium")) continue;
            oresMined.put(loc, entry.getIntValue());
        }
        int totalOres = oresMined.values().stream().mapToInt(Integer::intValue).sum();
        ArrayList oreStats = new ArrayList();
        oreStats.add(StatLabelListElement.Stat.builder().name("Total Ores").description("Total number of vault ores mined in the vault").value(totalOres).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        ArrayList sortedOres = new ArrayList(oresMined.entrySet());
        sortedOres.sort((a, b) -> {
            if (Objects.equals(a.getValue(), b.getValue())) {
                Block blockA = (Block)ForgeRegistries.BLOCKS.getValue((ResourceLocation)a.getKey());
                Block blockB = (Block)ForgeRegistries.BLOCKS.getValue((ResourceLocation)b.getKey());
                if (blockA == null || blockB == null) {
                    return 0;
                }
                return blockA.m_49954_().getString().compareTo(blockB.m_49954_().getString());
            }
            return Integer.compare((Integer)b.getValue(), (Integer)a.getValue());
        });
        for (Map.Entry entry : sortedOres) {
            ResourceLocation loc = (ResourceLocation)entry.getKey();
            int amount = (Integer)entry.getValue();
            ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(loc));
            if (stack.m_150930_(Items.f_41852_)) continue;
            float xpMul = oreXpMap.getOrDefault(loc, Float.valueOf(0.0f)).floatValue();
            String itemName = stack.m_41786_().getString().replace(" - Vault Stone", "").replace("Ore", "");
            ArrayList<String> oreDescription = new ArrayList<String>();
            oreDescription.add("XP Gained: " + String.format("%.0f", Float.valueOf(xpMul)));
            ItemStack iconStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(loc));
            if (!iconStack.m_150930_(Items.f_41852_)) {
                iconStack.m_41784_().m_128359_("type", "vault_stone");
                oreStats.add(StatLabelListElement.Stat.builder().name(itemName).description(oreDescription).value(amount).valueFormatter(StatLabelElement.INTEGER_FORMATTER).iconItem(iconStack).nameOffset(Spatials.positionX(12)).iconOffset(Spatials.positionX(0)).build());
                continue;
            }
            oreStats.add(StatLabelListElement.Stat.builder().name(itemName).description(oreDescription).value(amount).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        }
        this.addElements((IElement)StringStatDisplayElement.builder().position(Spatials.positionY(7).positionX(190)).icon(ScreenTextures.EMPTY).width(160).height(10 + oreStats.size() * 11).addStats(oreStats).build(), new IElement[0]);
        this.addElement(new NineSliceElement(Spatials.positionXY(COLUMN_WIDTH + 10, 5).size(3, 14 + oreStats.size() * 11), ScreenTextures.VAULT_EXIT_ELEMENT_VERTICAL_SPLITTER));
    }
}

