/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary.element;

import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.element.spi.IElement;
import iskallia.vault.client.gui.framework.spatial.Padding;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.screen.summary.VaultExitContainerScreenData;
import iskallia.vault.client.gui.screen.summary.element.StatLabelElement;
import iskallia.vault.client.gui.screen.summary.element.StatLabelListElement;
import iskallia.vault.client.gui.screen.summary.element.StringStatDisplayElement;
import iskallia.vault.client.gui.screen.summary.element.VaultLevelBarWithRewardElement;
import iskallia.vault.client.gui.screen.summary.element.VaultMapElement;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.VaultSnapshot;
import iskallia.vault.core.vault.time.TickClock;
import java.util.ArrayList;
import org.lwjgl.glfw.GLFW;

public class OverviewContainerElement
extends VerticalScrollClipContainer<OverviewContainerElement> {
    private VaultMapElement<?> mapElement;

    public OverviewContainerElement(ISpatial spatial, VaultExitContainerScreenData screenData) {
        super(spatial, Padding.of(0, 0));
        int width = 160;
        VaultSnapshot snapshot = screenData.getSnapshot();
        Vault startVault = snapshot.getStart();
        Vault endVault = snapshot.getEnd();
        StatCollector statCollector = screenData.getStatsCollector();
        int endTime = endVault.get(Vault.CLOCK).get(TickClock.LOGICAL_TIME);
        int startTime = startVault.get(Vault.CLOCK).get(TickClock.LOGICAL_TIME);
        ArrayList genericStats = new ArrayList();
        genericStats.add(StatLabelListElement.Stat.builder().name("Seed").description("The random seed of this vault run").value(endVault.get(Vault.SEED) & 0xFFFFFFFFFFFFL).valueFormatter(StatLabelElement.LONG_FORMATTER).onClick(() -> {
            String seed = String.valueOf(endVault.get(Vault.SEED) & 0xFFFFFFFFFFFFL);
            GLFW.glfwSetClipboardString((long)GLFW.glfwGetCurrentContext(), (CharSequence)seed);
        }).build());
        genericStats.add(StatLabelListElement.Stat.builder().name("Level").description("Vault level of the vault").value(endVault.get(Vault.LEVEL).get()).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        genericStats.add(StatLabelListElement.Stat.builder().name("Rooms Discovered").description("Total number of rooms you entered in the vault").value(statCollector::getTotalDiscoveredRoomsExcludingStart).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        genericStats.add(StatLabelListElement.Stat.builder().name("Time Left").description("Time remaining when you exited the vault").value(endVault.get(Vault.CLOCK).get(TickClock.DISPLAY_TIME) / 20).valueFormatter(StatLabelElement.SECONDS_TO_HOURS_MINUTES_SECONDS_FORMATTER).build());
        genericStats.add(StatLabelListElement.Stat.builder().name("Time Spent").description("Total time spent in the vault").value((endTime - startTime) / 20).valueFormatter(StatLabelElement.SECONDS_TO_HOURS_MINUTES_SECONDS_FORMATTER).build());
        int xp = statCollector.getExperienceWithoutMultiplier(endVault);
        genericStats.add(StatLabelListElement.Stat.builder().name("Score").description("Your score based on this vault.").value((int)Math.floor((float)xp / 12.0f)).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        this.addElements((IElement)StringStatDisplayElement.builder().position(Spatials.positionY(0).positionX(0)).name("Generic Info").width(width - 4).height(105).addStats(genericStats).titleOffset(Spatials.positionY(6)).build(), new IElement[0]);
        float experienceMultiplier = statCollector.getExpMultiplier();
        ArrayList experienceStats = new ArrayList();
        experienceStats.add(StatLabelListElement.Stat.builder().name("Experience Multiplier").description("Experience multiplier for this vault run").value(Float.valueOf(experienceMultiplier)).valueFormatter(StatLabelElement.FLOAT_FORMATTER).onClick(() -> {
            String multiplier = String.valueOf(experienceMultiplier);
            GLFW.glfwSetClipboardString((long)GLFW.glfwGetCurrentContext(), (CharSequence)multiplier);
        }).build());
        experienceStats.add(StatLabelListElement.Stat.builder().name("Experience Gained").description("Total experience you gained in the vault").value(() -> screenData.getStatsCollector().getExperience(screenData.getSnapshot().getEnd())).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build());
        this.addElements((IElement)StringStatDisplayElement.builder().position(Spatials.positionY(84).positionX(0)).name("Experience").titleOffset(Spatials.positionY(6)).width(width - 4).height(50).addStats(experienceStats).build(), new IElement[0]);
        this.addElement(new VaultLevelBarWithRewardElement(Spatials.positionY(126).positionX(0), width - 4, screenData));
        this.addElement(new NineSliceElement(Spatials.positionXY(width + 10, 5).size(3, 135), ScreenTextures.VAULT_EXIT_ELEMENT_VERTICAL_SPLITTER));
        this.mapElement = new VaultMapElement(Spatials.positionXY(width + 21, 6), Spatials.size(width - 2, 128), snapshot.getEnd(), statCollector.get(StatCollector.ROOMS_DISCOVERED), statCollector.get(StatCollector.DISCOVERED_TUNNELS));
        this.addElement(this.mapElement);
        this.addElement(new NineSliceElement(Spatials.positionXYZ(width + 20, 5, 0).size(width, 130), ScreenTextures.INSET_DARK_GREY_BACKGROUND));
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        if (this.mapElement != null && this.mapElement.m_5953_(mouseX, mouseY)) {
            this.mapElement.onMouseScrolled(mouseX, mouseY, delta);
            return true;
        }
        return super.onMouseScrolled(mouseX, mouseY, delta);
    }
}

