/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary.element;

import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.element.DynamicLabelElement;
import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.element.ItemStackDisplayElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.text.LabelAutoResize;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.screen.summary.element.IndentLevel;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;

public class StatLabelElement<V>
extends ElasticContainerElement<StatLabelElement<V>> {
    public static final Function<Float, String> FLOAT_FORMATTER = value -> String.format("%.01f", value);
    public static final Function<Double, String> DOUBLE_FORMATTER = value -> String.format("%.01f", value);
    public static final Function<Integer, String> INTEGER_FORMATTER = String::valueOf;
    public static final Function<Long, String> LONG_FORMATTER = String::valueOf;
    public static final Function<Float, String> FLOAT_PERCENT_FORMATTER = value -> String.format("%.00f%%", Float.valueOf(value.floatValue() * 100.0f));
    public static final Function<Double, String> DOUBLE_PERCENT_FORMATTER = value -> String.format("%.00f%%", value * 100.0);
    public static final Function<Boolean, String> BOOLEAN_FORMATTER = value -> value != false ? "Yes" : "No";
    public static final Function<String, String> STRING_FORMATTER = value -> value;
    public static final Function<Integer, String> SECONDS_TO_HOURS_MINUTES_SECONDS_FORMATTER = value -> {
        int hours = value / 3600;
        int minutes = value % 3600 / 60;
        int seconds = value % 60;
        return hours > 0 ? "%02d:%02d:%02d".formatted(hours, minutes, seconds) : "%02d:%02d".formatted(minutes, seconds);
    };
    private final Supplier<String> labelSupplier;
    private final Runnable onClick;
    private final IndentLevel indentLevel;
    private final float nameLabelScale;
    private final float valueLabelScale;
    private final IPosition nameOffset;
    private final IPosition valueOffset;
    private NameElement nameElement;
    private ValueElement<V> valueElement;
    private TextureAtlasRegion icon;
    private ItemStack itemIcon;
    private float iconScale;
    private IPosition iconOffset;
    private LabelTextStyle.Builder nameStyle;
    private LabelTextStyle.Builder valueStyle;

    private StatLabelElement(Builder<V> builder) {
        super(Spatials.positionXYZ(builder.position));
        this.labelSupplier = builder.labelSupplier;
        this.onClick = builder.onClick;
        this.indentLevel = builder.indentLevel;
        this.nameLabelScale = builder.nameLabelScale;
        this.valueLabelScale = builder.valueLabelScale;
        this.nameOffset = builder.nameOffset;
        this.valueOffset = builder.valueOffset;
        this.icon = builder.icon;
        this.itemIcon = builder.itemIcon;
        this.iconScale = builder.iconScale;
        this.iconOffset = builder.iconOffset;
        this.nameStyle = builder.nameStyle;
        this.valueStyle = builder.valueStyle;
        this.setupElements(builder);
    }

    private void setupElements(Builder<V> builder) {
        int indentPixels = this.indentLevel.getPixels();
        this.nameElement = this.addElement((NameElement)new NameElement(Spatials.positionXYZ(indentPixels + this.nameOffset.x(), this.nameOffset.y(), this.nameOffset.z()), builder.size, this.labelSupplier, builder.textColor, builder.nameStyle).layout((screen, gui, parent, world) -> world.width(parent)));
        this.valueElement = this.addElement((ValueElement)new ValueElement(Spatials.positionXYZ(this.valueOffset.x(), this.valueOffset.y(), this.valueOffset.z()), builder.size, builder.valueSupplier, builder.valueFormatter, builder.valueStyle, builder.textColor, this.onClick).layout((screen, gui, parent, world) -> world.width(parent)));
        if (this.icon != null) {
            int iconW = this.icon.getSprite().m_118405_();
            int iconH = this.icon.getSprite().m_118408_();
            int scaleX = indentPixels + this.iconOffset.x() - (int)((float)iconW * (1.0f - this.iconScale) / 2.0f);
            int scaleY = this.iconOffset.y() - (int)((float)iconH * (1.0f - this.iconScale) / 2.0f);
            this.addElement(new TextureAtlasElement(Spatials.positionXYZ(scaleX, scaleY, this.iconOffset.z()).size(8, 8), this.icon).scale(this.iconScale, this.iconScale));
        } else if (this.itemIcon != null) {
            ItemStackDisplayElement itemStackDisplayElement = new ItemStackDisplayElement(Spatials.positionXYZ(indentPixels + this.iconOffset.x(), this.iconOffset.y(), this.iconOffset.z()).size(10, 10), this.itemIcon);
            itemStackDisplayElement.setScale(0.5f * this.iconScale);
            this.addElement(itemStackDisplayElement);
        }
    }

    public String getLabelText() {
        return this.labelSupplier.get();
    }

    public boolean isIndented(IndentLevel level) {
        return this.indentLevel == level;
    }

    public IndentLevel getIndentLevel() {
        return this.indentLevel;
    }

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    public static class Builder<V> {
        private IPosition position = IPosition.ZERO;
        private ISize size = Spatials.size(100, 11);
        private Supplier<String> labelSupplier = () -> "";
        private Supplier<V> valueSupplier = () -> null;
        private Function<V, String> valueFormatter = v -> "";
        private LabelTextStyle.Builder labelTextStyle = LabelTextStyle.defaultStyle();
        private TextColor textColor = TextColor.m_131266_((int)0xFFFFFF);
        private Runnable onClick = () -> {};
        private IndentLevel indentLevel = IndentLevel.NONE;
        private float nameLabelScale = 1.0f;
        private float valueLabelScale = 1.0f;
        private IPosition nameOffset = IPosition.ZERO;
        private IPosition valueOffset = IPosition.ZERO;
        private TextureAtlasRegion icon = null;
        private ItemStack itemIcon = null;
        private float iconScale = 1.0f;
        private IPosition iconOffset = IPosition.ZERO;
        private LabelTextStyle.Builder nameStyle = LabelTextStyle.defaultStyle().left();
        private LabelTextStyle.Builder valueStyle = LabelTextStyle.defaultStyle().right();

        public Builder<V> position(IPosition position) {
            this.position = position;
            return this;
        }

        public Builder<V> size(ISize size) {
            this.size = size;
            return this;
        }

        public Builder<V> size(int width, int height) {
            this.size = Spatials.size(width, height);
            return this;
        }

        public Builder<V> label(Supplier<String> labelSupplier) {
            this.labelSupplier = labelSupplier;
            return this;
        }

        public Builder<V> label(String label) {
            this.labelSupplier = () -> label;
            return this;
        }

        public Builder<V> value(Supplier<V> valueSupplier) {
            this.valueSupplier = valueSupplier;
            return this;
        }

        public Builder<V> value(V value) {
            this.valueSupplier = () -> value;
            return this;
        }

        public Builder<V> valueFormatter(Function<V, String> valueFormatter) {
            this.valueFormatter = valueFormatter;
            return this;
        }

        public Builder<V> textStyle(LabelTextStyle.Builder labelTextStyle) {
            this.labelTextStyle = labelTextStyle;
            return this;
        }

        public Builder<V> textColor(TextColor textColor) {
            this.textColor = textColor;
            return this;
        }

        public Builder<V> onClick(Runnable onClick) {
            this.onClick = onClick;
            return this;
        }

        public Builder<V> indentLevel(IndentLevel indentLevel) {
            this.indentLevel = indentLevel;
            return this;
        }

        public Builder<V> nameLabelScale(float scale) {
            this.nameLabelScale = scale;
            return this;
        }

        public Builder<V> valueLabelScale(float scale) {
            this.valueLabelScale = scale;
            return this;
        }

        public Builder<V> nameOffset(IPosition offset) {
            this.nameOffset = offset;
            return this;
        }

        public Builder<V> valueOffset(IPosition offset) {
            this.valueOffset = offset;
            return this;
        }

        public Builder<V> iconAtlas(TextureAtlasRegion icon) {
            this.icon = icon;
            this.itemIcon = null;
            return this;
        }

        public Builder<V> iconItem(ItemStack itemIcon) {
            this.itemIcon = itemIcon;
            this.icon = null;
            return this;
        }

        public Builder<V> iconScale(float scale) {
            this.iconScale = scale;
            return this;
        }

        public Builder<V> iconOffset(IPosition offset) {
            this.iconOffset = offset;
            return this;
        }

        public Builder<V> nameStyle(LabelTextStyle.Builder nameStyle) {
            this.nameStyle = nameStyle;
            return this;
        }

        public Builder<V> valueStyle(LabelTextStyle.Builder valueStyle) {
            this.valueStyle = valueStyle;
            return this;
        }

        public StatLabelElement<V> build() {
            return new StatLabelElement(this);
        }
    }

    private static class NameElement
    extends DynamicLabelElement<String, NameElement> {
        private final TextColor textColor;

        public NameElement(IPosition position, ISize size, Supplier<String> valueSupplier, TextColor textColor, LabelTextStyle.Builder labelTextStyle) {
            super(position, size, valueSupplier, labelTextStyle);
            this.textColor = textColor;
            this.setAutoResize(LabelAutoResize.NONE);
        }

        @Override
        protected void onValueChanged(String value) {
            this.set((Component)new TextComponent(value).m_130948_(Style.f_131099_.m_131148_(this.textColor)));
        }
    }

    private static class ValueElement<T>
    extends DynamicLabelElement<T, ValueElement<T>>
    implements IGuiEventElement {
        private final Function<T, String> valueFormatter;
        private final TextColor textColor;
        private final Runnable onClick;

        public ValueElement(IPosition position, ISize size, Supplier<T> valueSupplier, Function<T, String> valueFormatter, LabelTextStyle.Builder labelTextStyle, TextColor textColor, Runnable onClick) {
            super(position, size, valueSupplier, labelTextStyle);
            this.valueFormatter = valueFormatter;
            this.textColor = textColor;
            this.setAutoResize(LabelAutoResize.NONE);
            this.onClick = onClick;
        }

        @Override
        protected void onValueChanged(T value) {
            this.set((Component)new TextComponent(this.valueFormatter.apply(value)).m_130948_(Style.f_131099_.m_131148_(this.textColor)));
        }

        @Override
        public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
            if (buttonIndex == 0) {
                this.onClick.run();
                return true;
            }
            return IGuiEventElement.super.onMouseClicked(mouseX, mouseY, buttonIndex);
        }
    }
}

