/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary.element;

import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.screen.summary.element.IndentLevel;
import iskallia.vault.client.gui.screen.summary.element.StatLabelElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;

public class StatLabelListElement<E extends StatLabelListElement<E>>
extends ElasticContainerElement<E> {
    public static final int LABEL_HEIGHT = 11;
    private final List<StatLabelElement<?>> statElements = new ArrayList();
    private final TextColor textColor;
    private final int verticalGap;
    private final ISpatial spatial;

    private StatLabelListElement(Builder<E> builder) {
        super(builder.spatial);
        this.textColor = builder.textColor;
        this.verticalGap = builder.verticalGap;
        this.spatial = builder.spatial;
        for (int i = 0; i < builder.stats.size(); ++i) {
            int yPos = i * (11 + this.verticalGap);
            StatLabelElement<?> element = this.createStatElement(builder.stats.get(i), i, yPos);
            this.statElements.add(element);
            this.addElement(element);
        }
    }

    public boolean hasIndentedElements(IndentLevel level) {
        return this.statElements.stream().anyMatch(element -> element.isIndented(level));
    }

    public List<StatLabelElement<?>> getElementsWithIndentLevel(IndentLevel level) {
        return this.statElements.stream().filter(element -> element.isIndented(level)).toList();
    }

    protected <V> StatLabelElement<V> createStatElement(Stat<V> stat, int index, int yPos) {
        ArrayList shiftTooltips = new ArrayList(stat.name.get().isEmpty() || stat.name.get() == null ? List.of() : List.of(new TextComponent(stat.name.get())));
        shiftTooltips.addAll(stat.description.get().stream().toList());
        StatLabelElement element = StatLabelElement.builder().position(Spatials.positionY(yPos)).size(this.spatial.width(), 11).label(stat.name).value(stat.value).valueFormatter(stat.valueFormatter).textStyle(LabelTextStyle.defaultStyle()).textColor(this.textColor).onClick(stat.onClick).indentLevel(stat.indentLevel).nameLabelScale(stat.nameLabelScale).valueLabelScale(stat.valueLabelScale).nameOffset(stat.nameOffset).valueOffset(stat.valueOffset).iconScale(stat.iconScale).iconOffset(stat.iconOffset).nameStyle(stat.nameStyle).valueStyle(stat.valueStyle).build();
        if (stat.icon != null) {
            element = StatLabelElement.builder().position(Spatials.positionY(yPos)).size(this.spatial.width(), 11).label(stat.name).value(stat.value).valueFormatter(stat.valueFormatter).textStyle(LabelTextStyle.defaultStyle()).textColor(this.textColor).onClick(stat.onClick).indentLevel(stat.indentLevel).nameLabelScale(stat.nameLabelScale).valueLabelScale(stat.valueLabelScale).nameOffset(stat.nameOffset).valueOffset(stat.valueOffset).iconAtlas(stat.icon).iconScale(stat.iconScale).iconOffset(stat.iconOffset).nameStyle(stat.nameStyle).valueStyle(stat.valueStyle).build();
        } else if (stat.itemIcon != null) {
            element = StatLabelElement.builder().position(Spatials.positionY(yPos)).size(this.spatial.width(), 11).label(stat.name).value(stat.value).valueFormatter(stat.valueFormatter).textStyle(LabelTextStyle.defaultStyle()).textColor(this.textColor).onClick(stat.onClick).indentLevel(stat.indentLevel).nameLabelScale(stat.nameLabelScale).valueLabelScale(stat.valueLabelScale).nameOffset(stat.nameOffset).valueOffset(stat.valueOffset).iconItem(stat.itemIcon).iconScale(stat.iconScale).iconOffset(stat.iconOffset).nameStyle(stat.nameStyle).valueStyle(stat.valueStyle).build();
        }
        ((StatLabelElement)element.layout((screen, gui, parent, world) -> world.width(parent))).tooltip(stat.description.get().isEmpty() ? Tooltips.empty() : Tooltips.shift(Tooltips.multi(() -> !stat.name.get().isEmpty() && stat.name.get() != null ? List.of(new TextComponent(stat.name.get()), Tooltips.DEFAULT_HOLD_SHIFT_COMPONENT) : List.of(Tooltips.DEFAULT_HOLD_SHIFT_COMPONENT)), Tooltips.multi(() -> shiftTooltips)));
        return element;
    }

    public static <E extends StatLabelListElement<E>> Builder<E> builder() {
        return new Builder();
    }

    public static class Builder<E extends StatLabelListElement<E>> {
        private ISpatial spatial;
        private TextColor textColor = TextColor.m_131266_((int)0xFFFFFF);
        private final List<Stat<?>> stats = new ArrayList();
        private int verticalGap = 0;

        public Builder<E> spatial(ISpatial spatial) {
            this.spatial = spatial;
            return this;
        }

        public Builder<E> textColor(TextColor textColor) {
            this.textColor = textColor;
            return this;
        }

        public Builder<E> addStat(Stat<?> stat) {
            this.stats.add(stat);
            return this;
        }

        public Builder<E> addStats(List<Stat<?>> stats) {
            this.stats.addAll(stats);
            return this;
        }

        public Builder<E> verticalGap(int gap) {
            this.verticalGap = gap;
            return this;
        }

        public E build() {
            return (E)new StatLabelListElement(this);
        }
    }

    public static class Stat<V> {
        public final Supplier<String> name;
        public final Supplier<List<TextComponent>> description;
        public final Supplier<V> value;
        public final Function<V, String> valueFormatter;
        public final Runnable onClick;
        public final TextureAtlasRegion icon;
        public final ItemStack itemIcon;
        public final IndentLevel indentLevel;
        public final float nameLabelScale;
        public final float valueLabelScale;
        public final float iconScale;
        public final IPosition nameOffset;
        public final IPosition valueOffset;
        public final IPosition iconOffset;
        public final LabelTextStyle.Builder nameStyle;
        public final LabelTextStyle.Builder valueStyle;

        private Stat(Builder<V> builder) {
            this.name = builder.name;
            this.description = builder.description;
            this.value = builder.value;
            this.valueFormatter = builder.valueFormatter;
            this.onClick = builder.onClick;
            this.icon = builder.icon;
            this.itemIcon = builder.itemIcon;
            this.indentLevel = builder.indentLevel;
            this.nameLabelScale = builder.nameLabelScale;
            this.valueLabelScale = builder.valueLabelScale;
            this.iconScale = builder.iconScale;
            this.nameOffset = builder.nameOffset;
            this.valueOffset = builder.valueOffset;
            this.iconOffset = builder.iconOffset;
            this.nameStyle = builder.nameStyle;
            this.valueStyle = builder.valueStyle;
        }

        public static <V> Builder<V> builder() {
            return new Builder();
        }

        public static Stat<Integer> ofInteger(String name, String description, int value) {
            return Stat.builder().name(name).description(description).value(value).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build();
        }

        public static Stat<Integer> ofInteger(String name, String description, Supplier<Integer> value) {
            return Stat.builder().name(name).description(description).value(value).valueFormatter(StatLabelElement.INTEGER_FORMATTER).build();
        }

        public static Stat<Long> ofLong(String name, String description, long value) {
            return Stat.builder().name(name).description(description).value(value).valueFormatter(StatLabelElement.LONG_FORMATTER).build();
        }

        public static Stat<Long> ofLong(String name, String description, Supplier<Long> value) {
            return Stat.builder().name(name).description(description).value(value).valueFormatter(StatLabelElement.LONG_FORMATTER).build();
        }

        public static Stat<Float> ofFloat(String name, String description, float value) {
            return Stat.builder().name(name).description(description).value(Float.valueOf(value)).valueFormatter(StatLabelElement.FLOAT_FORMATTER).build();
        }

        public static Stat<Float> ofFloat(String name, String description, Supplier<Float> value) {
            return Stat.builder().name(name).description(description).value(value).valueFormatter(StatLabelElement.FLOAT_FORMATTER).build();
        }

        public static Stat<Double> ofDouble(String name, String description, double value) {
            return Stat.builder().name(name).description(description).value(value).valueFormatter(StatLabelElement.DOUBLE_FORMATTER).build();
        }

        public static Stat<Double> ofDouble(String name, String description, Supplier<Double> value) {
            return Stat.builder().name(name).description(description).value(value).valueFormatter(StatLabelElement.DOUBLE_FORMATTER).build();
        }

        public static Stat<Boolean> ofBoolean(String name, String description, boolean value) {
            return Stat.builder().name(name).description(description).value(value).valueFormatter(StatLabelElement.BOOLEAN_FORMATTER).build();
        }

        public static Stat<Boolean> ofBoolean(String name, String description, Supplier<Boolean> value) {
            return Stat.builder().name(name).description(description).value(value).valueFormatter(StatLabelElement.BOOLEAN_FORMATTER).build();
        }

        public static Stat<Integer> ofSeconds(String name, String description, int seconds) {
            return Stat.builder().name(name).description(description).value(seconds).valueFormatter(StatLabelElement.SECONDS_TO_HOURS_MINUTES_SECONDS_FORMATTER).build();
        }

        public static Stat<Integer> ofSeconds(String name, String description, Supplier<Integer> seconds) {
            return Stat.builder().name(name).description(description).value(seconds).valueFormatter(StatLabelElement.SECONDS_TO_HOURS_MINUTES_SECONDS_FORMATTER).build();
        }

        public static Stat<String> ofString(String name, String description, String value) {
            return Stat.builder().name(name).description(description).value(value).valueFormatter(StatLabelElement.STRING_FORMATTER).build();
        }

        public static Stat<String> ofString(String name, String description, Supplier<String> value) {
            return Stat.builder().name(name).description(description).value(value).valueFormatter(StatLabelElement.STRING_FORMATTER).build();
        }

        public static <V> Stat<V> ofEmpty(String name, String description) {
            return Stat.builder().name(name).description(description).value((Object)null).valueFormatter(v -> "").build();
        }

        public static class Builder<V> {
            private Supplier<String> name = () -> "";
            private Supplier<List<TextComponent>> description = List::of;
            private Supplier<V> value = () -> null;
            private Function<V, String> valueFormatter = v -> "";
            private Runnable onClick = () -> {};
            private TextureAtlasRegion icon = null;
            private ItemStack itemIcon = null;
            private IndentLevel indentLevel = IndentLevel.NONE;
            private float nameLabelScale = 1.0f;
            private float valueLabelScale = 1.0f;
            private float iconScale = 1.0f;
            private IPosition nameOffset = IPosition.ZERO;
            private IPosition valueOffset = IPosition.ZERO;
            private IPosition iconOffset = IPosition.ZERO;
            private LabelTextStyle.Builder nameStyle = LabelTextStyle.defaultStyle().left();
            private LabelTextStyle.Builder valueStyle = LabelTextStyle.defaultStyle().right();

            public Builder<V> name(Supplier<String> name) {
                this.name = name;
                return this;
            }

            public Builder<V> name(String name) {
                this.name = () -> name;
                return this;
            }

            public Builder<V> description(Supplier<List<TextComponent>> description) {
                this.description = description;
                return this;
            }

            public Builder<V> description(String description) {
                this.description = () -> List.of(new TextComponent(description));
                return this;
            }

            public Builder<V> description(List<String> description) {
                this.description = () -> description.stream().map(TextComponent::new).toList();
                return this;
            }

            public Builder<V> value(Supplier<V> value) {
                this.value = value;
                return this;
            }

            public Builder<V> value(V value) {
                this.value = () -> value;
                return this;
            }

            public Builder<V> valueFormatter(Function<V, String> formatter) {
                this.valueFormatter = formatter;
                return this;
            }

            public Builder<V> onClick(Runnable onClick) {
                this.onClick = onClick;
                return this;
            }

            public Builder<V> iconAtlas(TextureAtlasRegion icon) {
                this.icon = icon;
                this.itemIcon = null;
                return this;
            }

            public Builder<V> iconItem(ItemStack itemIcon) {
                this.itemIcon = itemIcon;
                this.icon = null;
                return this;
            }

            public Builder<V> indentLevel(IndentLevel level) {
                this.indentLevel = level;
                return this;
            }

            public Builder<V> nameLabelScale(float scale) {
                this.nameLabelScale = scale;
                return this;
            }

            public Builder<V> valueLabelScale(float scale) {
                this.valueLabelScale = scale;
                return this;
            }

            public Builder<V> iconScale(float scale) {
                this.iconScale = scale;
                return this;
            }

            public Builder<V> nameOffset(IPosition offset) {
                this.nameOffset = offset;
                return this;
            }

            public Builder<V> valueOffset(IPosition offset) {
                this.valueOffset = offset;
                return this;
            }

            public Builder<V> iconOffset(IPosition offset) {
                this.iconOffset = offset;
                return this;
            }

            public Builder<V> nameStyle(LabelTextStyle.Builder style) {
                this.nameStyle = style;
                return this;
            }

            public Builder<V> valueStyle(LabelTextStyle.Builder style) {
                this.valueStyle = style;
                return this;
            }

            public Stat<V> build() {
                return new Stat(this);
            }
        }
    }
}

