/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary.element;

import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.element.ContainerElement;
import iskallia.vault.client.gui.framework.element.DynamicLabelElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.client.gui.screen.summary.element.IndentLevel;
import iskallia.vault.client.gui.screen.summary.element.StatLabelListElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;

public class StringStatDisplayElement<E extends StringStatDisplayElement<E>>
extends ContainerElement<E> {
    private final Component name;
    private final TextureAtlasRegion icon;
    private final float iconScale;
    private final IPosition iconOffset;
    private final float titleScale;
    private final IPosition titleOffset;
    private final IndentLevel titleIndentLevel;
    private final TextColor titleColor;
    private final int width;

    private StringStatDisplayElement(Builder<E> builder) {
        super(Spatials.positionXYZ(builder.position).size(builder.width, Math.max(builder.height, 20 + builder.statList.size() * (11 + builder.verticalGap))));
        this.name = builder.name;
        this.icon = builder.icon;
        this.iconScale = builder.iconScale;
        this.iconOffset = builder.iconOffset;
        this.titleScale = builder.titleScale;
        this.titleOffset = builder.titleOffset;
        this.titleIndentLevel = builder.titleIndentLevel;
        this.titleColor = builder.titleColor;
        this.width = builder.width;
        if (this.icon != null) {
            this.addElement(new TextureAtlasElement(Spatials.positionXYZ(this.iconOffset.x(), this.iconOffset.y(), this.iconOffset.z()).size(12, 12), this.icon).scale(this.iconScale, this.iconScale));
        }
        if (this.name != null) {
            StringElement titleElement = new StringElement((IPosition)Spatials.positionXYZ(this.titleIndentLevel.getPixels() + this.titleOffset.x() + (this.icon == null ? 8 : 15), this.titleOffset.y() + 2, this.titleOffset.z() + 1), (ISize)Spatials.size(builder.width - 15, 12), () -> new TextComponent(this.name.getString()).m_130940_(this.titleColor != null ? (ChatFormatting.BLACK.m_126665_() != null ? ChatFormatting.BLACK : ChatFormatting.WHITE) : ChatFormatting.BLACK), LabelTextStyle.left());
            this.addElement(titleElement);
        }
        Object statListElement = StatLabelListElement.builder().spatial(Spatials.positionY(builder.name != null ? 20 - builder.verticalGap : 0).positionX(this.name != null ? 8 : 0).positionZ(2).width(builder.width - 16)).textColor(builder.textColor).addStats(builder.statList).verticalGap(builder.verticalGap).build();
        ((AbstractSpatialElement)statListElement).layout((screen, gui, parent, world) -> {
            IMutableSpatial iMutableSpatial = world.width(builder.width - 16);
            int n = builder.statList.size();
            Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
            iMutableSpatial.height(n * 9);
        });
        this.addElement(statListElement);
    }

    public static <E extends StringStatDisplayElement<E>> Builder<E> builder() {
        return new Builder();
    }

    public static <E extends StringStatDisplayElement<E>> StringStatDisplayElement<E> fromMap(IPosition position, TextureAtlasRegion icon, Component name, int width, int height, Map<String, String> stringMap) {
        Builder builder = StringStatDisplayElement.builder();
        builder.position(position).icon(icon).name(name).width(width).height(height);
        stringMap.forEach((key, value) -> builder.addStat(StatLabelListElement.Stat.ofString(key, "", value)));
        return builder.build();
    }

    public static class Builder<E extends StringStatDisplayElement<E>> {
        private IPosition position = IPosition.ZERO;
        private Component name = null;
        private TextureAtlasRegion icon = null;
        private int width = 150;
        private int height = 0;
        private final List<StatLabelListElement.Stat<?>> statList = new ArrayList();
        private int verticalGap = 0;
        private float iconScale = 1.0f;
        private IPosition iconOffset = IPosition.ZERO;
        private float titleScale = 1.0f;
        private IPosition titleOffset = IPosition.ZERO;
        private IndentLevel titleIndentLevel = IndentLevel.NONE;
        private TextColor titleColor = null;
        private TextColor textColor = TextColor.m_131266_((int)0);

        public Builder<E> position(IPosition position) {
            this.position = position;
            return this;
        }

        public Builder<E> name(Component name) {
            this.name = name;
            return this;
        }

        public Builder<E> name(String name) {
            this.name = new TextComponent(name);
            return this;
        }

        public Builder<E> icon(TextureAtlasRegion icon) {
            this.icon = icon;
            return this;
        }

        public Builder<E> width(int width) {
            this.width = width;
            return this;
        }

        public Builder<E> height(int height) {
            this.height = height;
            return this;
        }

        public Builder<E> addStat(StatLabelListElement.Stat<?> stat) {
            this.statList.add(stat);
            return this;
        }

        public Builder<E> addStats(List<StatLabelListElement.Stat<?>> stats) {
            this.statList.addAll(stats);
            return this;
        }

        public Builder<E> verticalGap(int gap) {
            this.verticalGap = gap;
            return this;
        }

        public Builder<E> iconScale(float scale) {
            this.iconScale = scale;
            return this;
        }

        public Builder<E> iconOffset(IPosition offset) {
            this.iconOffset = offset;
            return this;
        }

        public Builder<E> titleScale(float scale) {
            this.titleScale = scale;
            return this;
        }

        public Builder<E> titleOffset(IPosition offset) {
            this.titleOffset = offset;
            return this;
        }

        public Builder<E> titleIndentLevel(IndentLevel level) {
            this.titleIndentLevel = level;
            return this;
        }

        public Builder<E> titleColor(TextColor color) {
            this.titleColor = color;
            return this;
        }

        public Builder<E> textColor(TextColor color) {
            this.textColor = color;
            return this;
        }

        public E build() {
            return (E)new StringStatDisplayElement(this);
        }
    }

    private static final class StringElement
    extends DynamicLabelElement<Component, StringElement> {
        private StringElement(IPosition position, ISize size, Supplier<Component> valueSupplier, LabelTextStyle.Builder labelTextStyle) {
            super(position, size, valueSupplier, labelTextStyle);
        }

        @Override
        protected void onValueChanged(Component value) {
            this.set(value);
        }
    }
}

