/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.ClientGreedData;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ContainerElement;
import iskallia.vault.client.gui.framework.element.DynamicLabelElement;
import iskallia.vault.client.gui.framework.element.HorizontalProgressBarElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.screen.summary.VaultExitContainerScreenData;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.NotNull;

public class VaultLevelBarWithRewardElement<E extends VaultLevelBarWithRewardElement<E>>
extends ContainerElement<E> {
    public static final TextureAtlasRegion BLANK = ScreenTextures.BLANK;
    public static final TextureAtlasRegion BACKGROUND = ScreenTextures.VAULT_LEVEL_BAR_BACKGROUND;
    public static final TextureAtlasRegion FOREGROUND = ScreenTextures.VAULT_LEVEL_BAR;
    public static final TextureAtlasRegion FOREGROUND_GAINED_XP = ScreenTextures.VAULT_LEVEL_BAR_GAINED_XP;
    public static final TextureAtlasRegion PRESTIGE_BACKGROUND = ScreenTextures.PRESTIGE_VAULT_LEVEL_BAR_BACKGROUND;
    public static final TextureAtlasRegion PRESTIGE_FOREGROUND = ScreenTextures.PRESTIGE_VAULT_LEVEL_BAR;
    public static final TextureAtlasRegion PRESTIGE_FOREGROUND_GAINED_XP = ScreenTextures.PRESTIGE_VAULT_LEVEL_BAR_GAINED_XP;

    private static boolean isPrestige(int vaultLevel) {
        return vaultLevel > 100 && ClientGreedData.isCompletedHerald();
    }

    public VaultLevelBarWithRewardElement(IPosition position, int width, VaultExitContainerScreenData screenData) {
        super(Spatials.positionXYZ(position).size(width, 15));
        this.addElement(new StringElement((IPosition)Spatials.positionXYZ(8, 0, 2), (ISize)Spatials.size(30, 10), () -> new TextComponent("LVL " + screenData.getVaultLevel()).m_130940_(ChatFormatting.BLACK), LabelTextStyle.left()));
        int barWidth = width - 75;
        int barX = width - barWidth - 8;
        this.addElement((HorizontalProgressBarElement)new HorizontalProgressBarElement(Spatials.positionXYZ(barX, 1, 1), VaultLevelBarWithRewardElement.isPrestige(screenData.getVaultLevel()) ? PRESTIGE_BACKGROUND : BACKGROUND, VaultLevelBarWithRewardElement.isPrestige(screenData.getVaultLevel()) ? PRESTIGE_FOREGROUND_GAINED_XP : FOREGROUND_GAINED_XP, () -> Float.valueOf(screenData.getVaultLevelPercentageWithReward(screenData.getSnapshot().getEnd())), HorizontalProgressBarElement.Direction.LEFT_TO_RIGHT).layout((screen, gui, parent, world) -> world.width(barWidth)));
        this.addElement((HorizontalProgressBarElement)new HorizontalProgressBarElement(Spatials.positionXYZ(barX, 1, 2), BLANK, VaultLevelBarWithRewardElement.isPrestige(screenData.getVaultLevel()) ? PRESTIGE_FOREGROUND : FOREGROUND, screenData::getVaultLevelPercentage, HorizontalProgressBarElement.Direction.LEFT_TO_RIGHT).layout((screen, gui, parent, world) -> world.width(barWidth)));
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
    }

    private static final class StringElement
    extends DynamicLabelElement<Component, StringElement> {
        private StringElement(IPosition position, ISize size, Supplier<Component> valueSupplier, LabelTextStyle.Builder labelTextStyle) {
            super(position, size, valueSupplier, labelTextStyle);
        }

        @Override
        protected void onValueChanged(Component value) {
            this.set(value);
        }
    }
}

