/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ClipContainerElement;
import iskallia.vault.client.gui.framework.element.ContainerElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.element.spi.ITooltipElement;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderer;
import iskallia.vault.client.gui.framework.screen.layout.ScreenLayout;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.overlay.VaultMapOverlay;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.stat.DiscoveredRoomStat;
import iskallia.vault.core.vault.stat.DiscoveredTunnelStat;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.util.VectorHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;

public class VaultMapElement<E extends VaultMapElement<E>>
extends AbstractSpatialElement<E>
implements IRenderedElement,
IGuiEventElement,
ITooltipElement {
    private static final Map<Class<?>, Vec2> persistedTranslations = new HashMap();
    private static final Map<Class<?>, Float> persistedScales = new HashMap();
    private final Vault vault;
    private final Map<BlockPos, ResourceLocation> discovered;
    private final List<RoomIcon> roomIcons = new ArrayList<RoomIcon>();
    private final List<TunnelIcon> tunnelIcons = new ArrayList<TunnelIcon>();
    private final CenterButton centerButton;
    private final ClipContainerElement<?> clipContainer;
    private final ContainerElement<?> innerContainer;
    private Vec2 viewportTranslation;
    private float viewportScale;
    private boolean dragging;
    private Vec2 lastMousePos;
    private boolean visible = true;
    private boolean needsRebuild = true;

    public VaultMapElement(ISpatial position, ISpatial size, Vault vault, DiscoveredRoomStat rooms, DiscoveredTunnelStat tunnels) {
        super(Spatials.positionXYZ(position).size(size.width(), size.height()));
        this.vault = vault;
        this.discovered = new HashMap<BlockPos, ResourceLocation>();
        if (rooms != null) {
            this.discovered.putAll(rooms);
        }
        if (tunnels != null) {
            this.discovered.putAll(tunnels);
        }
        this.viewportScale = ((IVaultOptions)Minecraft.m_91087_().f_91066_).getMapZoom();
        this.viewportTranslation = new Vec2(0.0f, 0.0f);
        this.dragging = false;
        this.lastMousePos = new Vec2(0.0f, 0.0f);
        this.loadViewportTransforms();
        this.centerButton = new CenterButton(0, 0, 18, 16, TextComponent.f_131282_, button -> this.resetViewport());
        this.clipContainer = new ClipContainerElement(Spatials.positionXYZ(0, 0, 0).size(this.width(), this.height()));
        this.innerContainer = new ContainerElement(Spatials.positionXYZ(0, 0, 0).size(this.width(), this.height()));
        this.clipContainer.getElementStore().addElement(this.innerContainer);
    }

    private void resetViewport() {
        this.viewportTranslation = new Vec2(0.0f, 0.0f);
        this.viewportScale = ((IVaultOptions)Minecraft.m_91087_().f_91066_).getMapZoom();
        this.saveViewportTransforms();
        this.needsRebuild = true;
        ScreenLayout.requestLayout();
    }

    private void loadViewportTransforms() {
        Class<?> cls = this.getClass();
        if (persistedTranslations.containsKey(cls)) {
            this.viewportTranslation = persistedTranslations.get(cls);
            this.viewportScale = persistedScales.getOrDefault(cls, Float.valueOf(((IVaultOptions)Minecraft.m_91087_().f_91066_).getMapZoom())).floatValue();
        } else {
            this.viewportTranslation = new Vec2(0.0f, 0.0f);
            this.viewportScale = ((IVaultOptions)Minecraft.m_91087_().f_91066_).getMapZoom();
            this.saveViewportTransforms();
        }
        this.viewportScale = Mth.m_14036_((float)this.viewportScale, (float)0.5f, (float)5.0f);
    }

    private void saveViewportTransforms() {
        persistedTranslations.put(this.getClass(), this.viewportTranslation);
        persistedScales.put(this.getClass(), Float.valueOf(this.viewportScale));
    }

    @Override
    public void onLayout(ISize screen, ISpatial gui, ISpatial parent) {
        super.onLayout(screen, gui, parent);
        this.clipContainer.onLayout(screen, gui, this.worldSpatial);
        if (this.needsRebuild) {
            this.rebuildMapContent();
        }
    }

    private void rebuildMapContent() {
        float f;
        float centerX;
        this.roomIcons.clear();
        this.tunnelIcons.clear();
        if (this.discovered == null || this.discovered.isEmpty()) {
            this.needsRebuild = false;
            return;
        }
        HashMap<BlockPos, ResourceLocation> rooms = new HashMap<BlockPos, ResourceLocation>();
        HashMap<BlockPos, ResourceLocation> tunnels = new HashMap<BlockPos, ResourceLocation>();
        for (Map.Entry<BlockPos, ResourceLocation> entry : this.discovered.entrySet()) {
            if (entry.getValue().m_135815_().contains("tunnel")) {
                tunnels.put((BlockPos)entry.getKey(), (ResourceLocation)entry.getValue());
                continue;
            }
            rooms.put((BlockPos)entry.getKey(), (ResourceLocation)entry.getValue());
        }
        BlockPos startPos = null;
        for (Map.Entry entry : this.discovered.entrySet()) {
            ResourceLocation roomId = (ResourceLocation)entry.getValue();
            if (!roomId.m_135815_().contains("start")) continue;
            startPos = (BlockPos)entry.getKey();
            break;
        }
        if (startPos != null) {
            centerX = startPos.m_123341_();
            f = startPos.m_123343_();
        } else {
            int n;
            int minX = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int n2 = Integer.MAX_VALUE;
            int maxZ = Integer.MIN_VALUE;
            for (BlockPos pos : this.discovered.keySet()) {
                minX = Math.min(minX, pos.m_123341_());
                maxX = Math.max(maxX, pos.m_123341_());
                n = Math.min(n, pos.m_123343_());
                maxZ = Math.max(maxZ, pos.m_123343_());
            }
            centerX = (float)(minX + maxX) / 2.0f;
            f = (float)(n + maxZ) / 2.0f;
        }
        float scaleFactor = 8.0f;
        for (Map.Entry<BlockPos, ResourceLocation> entry : this.discovered.entrySet()) {
            BlockPos pos = entry.getKey();
            ResourceLocation roomId = entry.getValue();
            if (roomId.m_135815_().contains("tunnel")) continue;
            float relX = ((float)pos.m_123341_() - centerX) * scaleFactor;
            float relZ = ((float)pos.m_123343_() - f) * scaleFactor;
            RoomIcon icon = new RoomIcon(roomId, pos, relX, relZ);
            this.roomIcons.add(icon);
        }
        for (Map.Entry<Object, Object> entry : tunnels.entrySet()) {
            this.tunnelIcons.add(new TunnelIcon((ResourceLocation)entry.getValue(), (BlockPos)entry.getKey(), scaleFactor, centerX, f));
        }
        this.needsRebuild = false;
    }

    private TextureAtlasElement<?> createRoomIconElement(int x, int y, int size, ResourceLocation roomId) {
        Optional<ResourceLocation> customIcon;
        String path = roomId.m_135815_();
        TextureAtlasRegion icon = path.contains("start") ? ScreenTextures.MAP_ROOM_START : ((customIcon = ModConfigs.VAULT_MAP_ICONS.getIconForRoom(roomId)).isPresent() ? TextureAtlasRegion.of(ModTextureAtlases.VAULT_MAP, customIcon.get()) : (path.contains("omega") ? ScreenTextures.MAP_ROOM_OMEGA : (path.contains("challenge") ? ScreenTextures.MAP_ROOM_CHALLENGE : (path.contains("raw") ? ScreenTextures.MAP_ROOM_RAW : (path.contains("boss") ? ScreenTextures.MAP_ROOM_BOSS : (path.contains("ore") ? ScreenTextures.MAP_ROOM_ORE : ScreenTextures.MAP_ROOM_COMMON))))));
        return (TextureAtlasElement)new TextureAtlasElement(Spatials.positionXYZ(x, y, 1).size(size, size), icon).tooltip(() -> new TextComponent(VaultMapElement.formatRoomName(path)));
    }

    private static String formatRoomName(String path) {
        String roomName = path;
        if (roomName.contains("/")) {
            roomName = roomName.substring(roomName.lastIndexOf(47) + 1);
        }
        if (roomName.contains("start")) {
            return "Starting Room";
        }
        if (path.contains("omega")) {
            String specificName = roomName.replaceAll("\\d+$", "");
            specificName = specificName.replace('_', ' ');
            return VaultMapElement.capitalizeWords(specificName);
        }
        if (path.contains("/challenge/")) {
            Object specificName = roomName.replaceAll("\\d+$", "");
            specificName = ((String)specificName).replace('_', ' ');
            specificName = (String)specificName + " Room";
            return VaultMapElement.capitalizeWords((String)specificName);
        }
        if (path.contains("/raw/")) {
            return "Raw Room";
        }
        if (path.contains("/special/")) {
            return "Boss Room";
        }
        if (path.contains("/common/")) {
            if (path.contains("/ore")) {
                return "Ore Room";
            }
            return "Common Room";
        }
        roomName = roomName.replace('_', ' ');
        return VaultMapElement.capitalizeWords(roomName);
    }

    private static String capitalizeWords(String text) {
        StringBuilder formattedName = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : text.toCharArray()) {
            if (c == ' ') {
                formattedName.append(c);
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                formattedName.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            formattedName.append(c);
        }
        return formattedName.toString().trim();
    }

    private static String getTooltipText(String path, boolean isShiftPressed) {
        if (isShiftPressed && (path.contains("/common/") || path.contains("/raw/"))) {
            String roomName = path;
            if (roomName.contains("/")) {
                roomName = roomName.substring(roomName.lastIndexOf(47) + 1);
            }
            roomName = roomName.replace('_', ' ');
            if (path.contains("/common/")) {
                return "Common Room (" + VaultMapElement.capitalizeWords(roomName) + ")";
            }
            return "Raw Room (" + VaultMapElement.capitalizeWords(roomName) + ")";
        }
        return VaultMapElement.formatRoomName(path);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        if (this.centerButton != null && mouseX >= (double)this.centerButton.f_93620_ && mouseX <= (double)(this.centerButton.f_93620_ + this.centerButton.m_5711_()) && mouseY >= (double)this.centerButton.f_93621_ && mouseY <= (double)(this.centerButton.f_93621_ + this.centerButton.m_93694_())) {
            this.centerButton.m_5691_();
            return true;
        }
        if (this.contains(mouseX, mouseY)) {
            this.dragging = true;
            this.lastMousePos = new Vec2((float)mouseX, (float)mouseY);
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        if (this.dragging) {
            this.dragging = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging) {
            float dx = (float)(mouseX - (double)this.lastMousePos.f_82470_);
            float dy = (float)(mouseY - (double)this.lastMousePos.f_82471_);
            this.viewportTranslation = new Vec2(this.viewportTranslation.f_82470_ + dx, this.viewportTranslation.f_82471_ + dy);
            this.lastMousePos = new Vec2((float)mouseX, (float)mouseY);
            this.saveViewportTransforms();
            this.needsRebuild = true;
            ScreenLayout.requestLayout();
            return true;
        }
        return false;
    }

    @Override
    public void onMouseMoved(double mouseX, double mouseY) {
        if (this.dragging && this.contains(mouseX, mouseY)) {
            float dx = (float)(mouseX - (double)this.lastMousePos.f_82470_);
            float dy = (float)(mouseY - (double)this.lastMousePos.f_82471_);
            this.viewportTranslation = new Vec2(this.viewportTranslation.f_82470_ + dx, this.viewportTranslation.f_82471_ + dy);
            this.lastMousePos = new Vec2((float)mouseX, (float)mouseY);
            this.saveViewportTransforms();
            this.needsRebuild = true;
            ScreenLayout.requestLayout();
        } else if (!this.contains(mouseX, mouseY)) {
            this.dragging = false;
        }
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        if (!this.contains(mouseX, mouseY)) {
            return false;
        }
        float mapCenterX = (float)this.x() + (float)this.width() / 2.0f;
        float mapCenterY = (float)this.y() + (float)this.height() / 2.0f;
        float zoomX = (float)mouseX - mapCenterX;
        float zoomY = (float)mouseY - mapCenterY;
        float oldScale = this.viewportScale;
        this.viewportScale += (float)(delta * (double)0.1f * (double)this.viewportScale);
        this.viewportScale = Mth.m_14036_((float)this.viewportScale, (float)0.5f, (float)5.0f);
        float zoomFactor = this.viewportScale / oldScale;
        float newTransX = this.viewportTranslation.f_82470_ + zoomX * (1.0f - zoomFactor);
        float newTransY = this.viewportTranslation.f_82471_ + zoomY * (1.0f - zoomFactor);
        this.viewportTranslation = new Vec2(newTransX, newTransY);
        this.saveViewportTransforms();
        this.needsRebuild = true;
        ScreenLayout.requestLayout();
        return true;
    }

    @Override
    public boolean onHoverTooltip(ITooltipRenderer tooltipRenderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, TooltipFlag tooltipFlag) {
        if (!this.isVisible() || !this.contains(mouseX, mouseY)) {
            return false;
        }
        float mapCenterX = (float)this.x() + (float)this.width() / 2.0f;
        float mapCenterY = (float)this.y() + (float)this.height() / 2.0f;
        float relMouseX = (float)mouseX - mapCenterX;
        float relMouseY = (float)mouseY - mapCenterY;
        relMouseX -= this.viewportTranslation.f_82470_;
        relMouseY -= this.viewportTranslation.f_82471_;
        relMouseX /= this.viewportScale;
        relMouseY /= this.viewportScale;
        Direction facing = this.vault.getOptional(Vault.WORLD).map(manager -> manager.getOr(WorldManager.FACING, Direction.NORTH)).orElse(Direction.NORTH);
        float rotationOffset = 180.0f - facing.m_122435_();
        float iconSize = 8.0f;
        for (RoomIcon icon : this.roomIcons) {
            Vec2 rotatedRoom = VectorHelper.rotateDegrees(new Vec2(icon.x, icon.z), rotationOffset);
            float rotatedX = rotatedRoom.f_82470_;
            float rotatedZ = rotatedRoom.f_82471_;
            if (!((double)relMouseX >= (double)rotatedX + 1.5 - (double)(iconSize / 2.0f)) || !((double)relMouseX <= (double)rotatedX + 5.5 + (double)(iconSize / 2.0f)) || !(relMouseY >= rotatedZ + 2.0f - iconSize / 2.0f) || !(relMouseY <= rotatedZ + 6.0f + iconSize / 2.0f)) continue;
            boolean shiftPressed = Screen.m_96638_();
            String tooltipText = VaultMapElement.getTooltipText(icon.roomId.m_135815_(), shiftPressed);
            List<TextComponent> tooltip = Collections.singletonList(new TextComponent(tooltipText));
            tooltipRenderer.renderComponentTooltip(poseStack, tooltip, mouseX, mouseY, TooltipDirection.RIGHT);
            return true;
        }
        return false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.clipContainer.setVisible(visible);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (!this.isVisible()) {
            return;
        }
        poseStack.m_85836_();
        renderer.beginClipRegion(this.worldSpatial);
        float centerX = (float)this.x() + (float)this.width() / 2.0f;
        float centerY = (float)this.y() + (float)this.height() / 2.0f;
        poseStack.m_85837_((double)centerX, (double)centerY, 0.0);
        poseStack.m_85837_((double)this.viewportTranslation.f_82470_, (double)this.viewportTranslation.f_82471_, 1.0);
        poseStack.m_85841_(this.viewportScale, this.viewportScale, 1.0f);
        Direction facing = this.vault.getOptional(Vault.WORLD).map(manager -> manager.getOr(WorldManager.FACING, Direction.NORTH)).orElse(Direction.NORTH);
        float rotationOffset = 180.0f - facing.m_122435_();
        for (RoomIcon roomIcon : this.roomIcons) {
            TextureAtlasRegion atlasRegion;
            String path = roomIcon.roomId.m_135815_();
            if (path.contains("start")) {
                int rotationSteps = Math.round(rotationOffset / 90.0f) % 4;
                if (rotationSteps < 0) {
                    rotationSteps += 4;
                }
                Direction effectiveFacing = facing;
                for (int i = 0; i < rotationSteps; ++i) {
                    effectiveFacing = effectiveFacing.m_122427_();
                }
                switch (effectiveFacing) {
                    case NORTH: {
                        atlasRegion = ScreenTextures.MAP_ROOM_START_NORTH;
                        break;
                    }
                    case SOUTH: {
                        atlasRegion = ScreenTextures.MAP_ROOM_START_SOUTH;
                        break;
                    }
                    case WEST: {
                        atlasRegion = ScreenTextures.MAP_ROOM_START_WEST;
                        break;
                    }
                    case EAST: {
                        atlasRegion = ScreenTextures.MAP_ROOM_START_EAST;
                        break;
                    }
                    default: {
                        atlasRegion = ScreenTextures.MAP_ROOM_START;
                        break;
                    }
                }
            } else {
                Optional<ResourceLocation> customIcon = ModConfigs.VAULT_MAP_ICONS.getIconForRoom(roomIcon.roomId);
                atlasRegion = customIcon.isPresent() ? TextureAtlasRegion.of(ModTextureAtlases.VAULT_MAP, customIcon.get()) : (path.contains("omega") ? ScreenTextures.MAP_ROOM_OMEGA : (path.contains("challenge") ? ScreenTextures.MAP_ROOM_CHALLENGE : (path.contains("raw") ? ScreenTextures.MAP_ROOM_RAW : (path.contains("special") ? ScreenTextures.MAP_ROOM_BOSS : (path.contains("/ore") ? ScreenTextures.MAP_ROOM_ORE : ScreenTextures.MAP_ROOM_COMMON)))));
            }
            Vec2 rotatedRoom = VectorHelper.rotateDegrees(new Vec2(roomIcon.x, roomIcon.z), rotationOffset);
            float rotatedX = rotatedRoom.f_82470_;
            float rotatedZ = rotatedRoom.f_82471_;
            float iconSize = 8.0f;
            IMutableSpatial iconSpatial = Spatials.positionXYZ((int)(rotatedX - iconSize / 2.0f), (int)(rotatedZ - iconSize / 2.0f), 0).size((int)iconSize, (int)iconSize);
            renderer.render(atlasRegion, poseStack, (IPosition)iconSpatial);
        }
        for (TunnelIcon tunnelIcon : this.tunnelIcons) {
            float relX = tunnelIcon.x;
            float relZ = tunnelIcon.z;
            Vec2 tunnelOffset = VaultMapOverlay.getTunnelOffset(tunnelIcon.id, facing);
            Vec2 rotatedPosition = VectorHelper.rotateDegrees(new Vec2(relX, relZ), rotationOffset);
            Vec2 rotatedOffset = VectorHelper.rotateDegrees(tunnelOffset, rotationOffset);
            relX = rotatedPosition.f_82470_ + rotatedOffset.f_82470_;
            relZ = rotatedPosition.f_82471_ + rotatedOffset.f_82471_;
            boolean xTunnel = tunnelIcon.id.m_135815_().contains("tunnel_x");
            if (Math.abs(Math.round(rotationOffset / 90.0f)) % 2 == 1) {
                xTunnel = !xTunnel;
            }
            TextureAtlasRegion tex = xTunnel ? ScreenTextures.MAP_TUNNEL_X : ScreenTextures.MAP_TUNNEL_Z;
            float iconSize = 8.0f;
            IMutableSpatial s = Spatials.positionXYZ((int)(relX - iconSize / 2.0f), (int)(relZ - iconSize / 2.0f) + (tunnelIcon.id.m_135815_().contains("tunnel_x") ? 1 : 0), 1).size((int)iconSize, (int)iconSize);
            renderer.render(tex, poseStack, (IPosition)s);
        }
        renderer.endClipRegion();
        poseStack.m_85849_();
        if (this.centerButton != null) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 1.0, 2.0);
            this.centerButton.f_93620_ = this.x() + this.width() - 20;
            this.centerButton.f_93621_ = this.y() + this.height() - 17;
            this.centerButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    public static class CenterButton
    extends Button {
        public CenterButton(int pX, int pY, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress) {
            super(pX, pY, pWidth, pHeight, pMessage, pOnPress, Button.f_93716_);
        }

        protected void m_7906_(@Nonnull PoseStack poseStack, @Nonnull Minecraft minecraft, int mouseX, int mouseY) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)ScreenTextures.UI_RESOURCE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.m_93228_(poseStack, this.f_93620_ + 1, this.f_93621_, 192, 0, 16, 16);
        }
    }

    private static class RoomIcon {
        final ResourceLocation roomId;
        final BlockPos pos;
        final float x;
        final float z;
        TextureAtlasElement<?> element;

        RoomIcon(ResourceLocation roomId, BlockPos pos, float x, float z) {
            this.roomId = roomId;
            this.pos = pos;
            this.x = x;
            this.z = z;
        }
    }

    private static class TunnelIcon {
        final ResourceLocation id;
        final BlockPos pos;
        final float x;
        final float z;

        TunnelIcon(ResourceLocation id, BlockPos pos, float scale, float cX, float cZ) {
            this.id = id;
            this.pos = pos;
            this.x = ((float)pos.m_123341_() - cX) * scale;
            this.z = ((float)pos.m_123343_() - cZ) * scale;
        }
    }
}

