/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.vault;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.client.gui.animation.ElementAnimator;
import iskallia.vault.client.gui.animation.IAnimatedElement;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.util.ItemRenderHelper;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.GreedObjective;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ServerboundGreedChoiceMessage;
import iskallia.vault.task.GreedTask;
import iskallia.vault.task.Task;
import iskallia.vault.util.Tween;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GreedContinueScreen
extends AbstractElementScreen {
    private final Vault vault;

    public GreedContinueScreen(Vault vault) {
        super((Component)new TranslatableComponent("screen.the_vault.greed_continue"), ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        Window window = Minecraft.m_91087_().m_91268_();
        this.setGuiSize(Spatials.size(window.m_85445_(), window.m_85446_()));
        this.vault = vault;
        int padding = 0;
        int componentWidth = this.imageWidth / 2 - padding * 1;
        int x = 0;
        this.addElement((Forfeit)new Forfeit(Spatials.positionXY(x, 0).size(componentWidth, window.m_85446_())).layout(this.translateWorldSpatial()));
        this.addElement((Continue)new Continue(Spatials.positionXY(x += componentWidth + padding, 0).size(componentWidth, window.m_85446_())).layout(this.translateWorldSpatial()));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (pKeyCode == 256 || Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    class Forfeit
    extends AbstractSpatialElement<Forfeit>
    implements IGuiEventElement,
    IRenderedElement,
    IAnimatedElement {
        private boolean visible;

        public Forfeit(ISpatial spatial) {
            super(spatial);
            this.visible = true;
        }

        @Override
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public ElementAnimator getAnimation() {
            return new ElementAnimator(false).addFrame(ElementAnimator.Property.OPACITY, 0.0f, 1.0f, Tween.LINEAR).addFrame(ElementAnimator.Property.OPACITY, 20.0f, 0.0f, Tween.EASE_INOUT_QUADRATIC);
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            Task task;
            Optional<GreedObjective> greedObjective = GreedContinueScreen.this.vault.get(Vault.OBJECTIVES).findFirst(GreedObjective.class);
            if (greedObjective.isEmpty()) {
                return;
            }
            float opacity = this.getAnimation().get(ElementAnimator.Property.OPACITY);
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            if (this.m_5953_(mouseX, mouseY) && this.isVisible()) {
                RenderSystem.m_69478_();
                ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, buf -> ScreenDrawHelper.rect((VertexConsumer)buf, poseStack).at(this.getWorldSpatial().x(), this.getWorldSpatial().y()).dim(this.getWorldSpatial().width(), this.getWorldSpatial().height()).color(0x22CCCCCC).drawColored());
            }
            GreedObjective objective = greedObjective.get();
            int tier = objective.get(GreedObjective.TIER);
            TextComponent title = new TextComponent("Forfeit Vault");
            MutableComponent description = new TextComponent("By forfeiting, you will receive a seal with one tier below the current tier (" + Math.max(0, tier - 1) + ").\nYou also exit with all your items and rewards!").m_130940_(ChatFormatting.WHITE);
            ItemStack seal = objective.createSeal();
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)this.getWorldSpatial().x() + (float)this.getWorldSpatial().width() / 2.0f), (double)((float)this.getWorldSpatial().y() + (float)this.getWorldSpatial().height() / 8.0f), 0.0);
            RenderSystem.m_157182_();
            Minecraft.m_91087_().f_91062_.m_92763_(poseStack, (Component)title, (float)(-Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)title)) / 2.0f, 0.0f, 0xFFFFFF);
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 20.0, 0.0);
            poseStack.m_85841_(0.75f, 0.75f, 1.0f);
            UIHelper.renderCenteredWrappedText(poseStack, (Component)description, this.getWorldSpatial().width(), 0);
            poseStack.m_85849_();
            ArrayList<ItemStack> rewards = new ArrayList<ItemStack>();
            Optional<Task> task2 = objective.getOptional(GreedObjective.TASK);
            if (task2.isPresent() && (task = task2.get()) instanceof GreedTask) {
                GreedTask gTask = (GreedTask)task;
                for (int i = 0; i < gTask.getAmount(); ++i) {
                    if (!gTask.isTaskCompleted(i) || !gTask.getReward(i).isPresent()) continue;
                    rewards.add(gTask.getReward(i).get());
                }
            }
            AtomicInteger i = new AtomicInteger(0);
            if (!rewards.isEmpty()) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 40.0, 0.0);
                poseStack.m_85841_(0.75f, 0.75f, 1.0f);
                RenderSystem.m_157191_().m_85836_();
                RenderSystem.m_157191_().m_85837_((double)(this.getWorldSpatial().x() + 10), (double)(this.getWorldSpatial().y() + 10), 0.0);
                RenderSystem.m_157191_().m_85837_(20.0, 80.0, 0.0);
                rewards.forEach(stack -> {
                    if (stack.m_41619_()) {
                        return;
                    }
                    int xOffset = i.getAndIncrement() % 5 * 20;
                    int yOffset = i.get() / 5 * 20;
                    ItemRenderHelper.renderGuiItem(stack, xOffset, yOffset, ps -> {});
                });
                poseStack.m_85849_();
                RenderSystem.m_157191_().m_85849_();
            }
            poseStack.m_85849_();
        }

        @Override
        public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
            if (this.m_5953_(mouseX, mouseY) && this.isVisible()) {
                ModNetwork.CHANNEL.sendToServer((Object)new ServerboundGreedChoiceMessage(true));
                GreedContinueScreen.this.m_7379_();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                GreedContinueScreen.this.elementStore.getRenderedElementOfType(Continue.class).ifPresent(forfeitEl -> forfeitEl.getAnimation().start());
                return true;
            }
            return false;
        }
    }

    class Continue
    extends AbstractSpatialElement<Continue>
    implements IGuiEventElement,
    IRenderedElement,
    IAnimatedElement {
        private boolean visible;

        public Continue(ISpatial spatial) {
            super(spatial);
            this.visible = true;
        }

        @Override
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public ElementAnimator getAnimation() {
            return new ElementAnimator(false).addFrame(ElementAnimator.Property.OPACITY, 0.0f, 1.0f, Tween.LINEAR).addFrame(ElementAnimator.Property.OPACITY, 20.0f, 0.0f, Tween.EASE_INOUT_QUADRATIC);
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            Optional<GreedObjective> greedObjective = GreedContinueScreen.this.vault.get(Vault.OBJECTIVES).findFirst(GreedObjective.class);
            if (greedObjective.isEmpty()) {
                return;
            }
            float opacity = this.getAnimation().get(ElementAnimator.Property.OPACITY);
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            if (this.m_5953_(mouseX, mouseY) && this.isVisible()) {
                RenderSystem.m_69478_();
                ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, buf -> ScreenDrawHelper.rect((VertexConsumer)buf, poseStack).at(this.getWorldSpatial().x(), this.getWorldSpatial().y()).dim(this.getWorldSpatial().width(), this.getWorldSpatial().height()).color(0x22CCCCCC).drawColored());
            }
            GreedObjective objective = greedObjective.get();
            int tier = objective.get(GreedObjective.TIER);
            TextComponent title = new TextComponent("Greed and Continue");
            ItemStack seal = objective.createSeal();
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)this.getWorldSpatial().x() + (float)this.getWorldSpatial().width() / 2.0f), (double)((float)this.getWorldSpatial().y() + (float)this.getWorldSpatial().height() / 8.0f), 0.0);
            RenderSystem.m_157182_();
            Minecraft.m_91087_().f_91062_.m_92763_(poseStack, (Component)title, (float)(-Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)title)) / 2.0f, 0.0f, 0xFFFFFF);
        }

        @Override
        public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
            if (this.m_5953_(mouseX, mouseY) && this.isVisible()) {
                ModNetwork.CHANNEL.sendToServer((Object)new ServerboundGreedChoiceMessage(false));
                GreedContinueScreen.this.m_7379_();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                GreedContinueScreen.this.elementStore.getRenderedElementOfType(Forfeit.class).ifPresent(forfeitEl -> forfeitEl.getAnimation().start());
                return true;
            }
            return false;
        }
    }
}

