/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.void_stone;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Padding;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.container.slot.spi.IGhostSlot;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class JunkSlotsElement
extends VerticalScrollClipContainer<JunkSlotsElement> {
    private final List<Slot> slots;
    private JunkSlotsDisplayElement<?> junkSlotsElement;

    public JunkSlotsElement(ISpatial spatial, List<Slot> slots) {
        super(spatial, Padding.ZERO, ScreenTextures.INSET_GREY_BACKGROUND);
        this.slots = slots;
        this.initialize();
    }

    private void initialize() {
        if (this.junkSlotsElement != null) {
            this.removeElement(this.junkSlotsElement);
        }
        this.junkSlotsElement = new JunkSlotsDisplayElement(Spatials.size(this.innerWidth(), this.innerHeight()), this.slots);
        this.addElement(this.junkSlotsElement);
    }

    public static class JunkSlotsDisplayElement<E extends JunkSlotsDisplayElement<E>>
    extends AbstractSpatialElement<E>
    implements IRenderedElement {
        protected final List<Slot> slots;
        protected final TextureAtlasRegion background;
        protected boolean visible;

        public JunkSlotsDisplayElement(MenuAccess<?> containerScreen) {
            this(Spatials.zero(), (List<Slot>)containerScreen.m_6262_().f_38839_);
        }

        public JunkSlotsDisplayElement(ISpatial position, List<Slot> slots) {
            this(position, slots, ScreenTextures.INSET_ITEM_SLOT_BACKGROUND);
        }

        public JunkSlotsDisplayElement(ISpatial position, List<Slot> slots, TextureAtlasRegion background) {
            super(position);
            this.slots = slots;
            this.background = background;
            this.setVisible(true);
        }

        @Override
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            int containerWidth = this.width();
            int slotWidth = 18;
            int slotHeight = 18;
            int x = 0;
            int y = 0;
            for (Slot slot : this.slots) {
                IGhostSlot ghostSlot;
                ItemStack ghostItemStack;
                if (!slot.m_6659_()) continue;
                renderer.render(this.background, poseStack, x + this.worldSpatial.x() - 1, y + this.worldSpatial.y() - 1, this.worldSpatial.z());
                if (slot instanceof IGhostSlot && (ghostItemStack = (ghostSlot = (IGhostSlot)slot).getGhostItemStack()) != null) {
                    this.renderItemStack(ghostItemStack, poseStack, x + this.worldSpatial.x(), y + this.worldSpatial.y(), this.worldSpatial.z() + 1);
                }
                if ((x += slotWidth) + slotWidth <= containerWidth) continue;
                x = 0;
                y += slotHeight;
            }
        }

        private void renderItemStack(ItemStack itemStack, PoseStack poseStack, float x, float y, float z) {
            Minecraft minecraft = Minecraft.m_91087_();
            BakedModel bakedModel = minecraft.m_91291_().m_174264_(itemStack, null, null, 0);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
            poseStack.m_85836_();
            poseStack.m_85837_((double)x, (double)y, (double)z);
            RenderSystem.m_157182_();
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            Lighting.m_84930_();
            minecraft.m_91291_().m_115143_(itemStack, ItemTransforms.TransformType.GUI, false, poseStack, (MultiBufferSource)bufferSource, LightmapHelper.getPackedLightCoords(5), OverlayTexture.f_118083_, bakedModel);
            bufferSource.m_109911_();
            RenderSystem.m_69482_();
            poseStack.m_85849_();
            RenderSystem.m_157182_();
            Lighting.m_84931_();
        }
    }
}

